# This Makefile.PL for Crypt-OpenSSL-PKCS10 was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.49.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.008;
use ExtUtils::MakeMaker;

use Config;
use Crypt::OpenSSL::Guess qw(openssl_inc_paths openssl_lib_paths);

my $libs = ' -lssl -lcrypto';
if ($Config{osname} eq 'aix') {
  $libs = $libs . ' -lz';
}

my %args = (
  LIBS => [openssl_lib_paths(). $libs],
  INC => openssl_inc_paths(),
);

my $cc_option_flags = " -O2 -g";
my $cc_defines      = '';

if ($Config::Config{cc} =~ /gcc/i) {
  $cc_option_flags .= $ENV{AUTHOR_TESTING} ? ' -Wall -Werror' : ' -Wall';
} else {
  $cc_option_flags .= '';
}

if ($Config{gccversion} =~ /llvm/i) {
  if ( $^O eq 'darwin' && (
    $Config{gccversion} =~ /LLVM 1[2-9].\d.[5-9]/ ||
    $Config{gccversion} =~ /LLVM 1[3-9]/ ))
  {
    $cc_option_flags .= ' -Wno-deprecated-declarations -Wno-compound-token-split-by-macro';
  } else {
    $cc_option_flags .= ' -Wno-deprecated-declarations';
  }

  if ($Config{PERL_VERSION} <= 20) {
    $cc_option_flags .= ' -Wno-error=pointer-bool-conversion';
  }
}

if ($Config{myuname} =~ /sunos|solaris/i) {
  $args{OPTIMIZE} = $cc_option_flags;
} elsif ($Config{myuname} =~ /strawberry-{0,1}perl/i) {
  if ($Config{PERL_VERSION} <= 24) {
    $args{LIBS} = [openssl_lib_paths() . ' -leay32'];
  }
  $cc_defines .= ' -DOPENSSL_NO_SCRYPT';
  $args{DEFINE} = $cc_defines;
} elsif ($Config{myuname} =~ /darwin/ ) {
  $args{LDDLFLAGS} = openssl_lib_paths() . ' ' . $Config{lddlflags};
} else {
  $args{LDDLFLAGS} = openssl_lib_paths() . ' ' . $Config{lddlflags};
  $args{OPTIMIZE} = $cc_option_flags;
}

my %WriteMakefileArgs = (
  "ABSTRACT" => "Perl extension to OpenSSL's PKCS10 API.",
  "AUTHOR" => "JoNO <jonozzz\@yahoo.com>",
  "BUILD_REQUIRES" => {
    "Crypt::OpenSSL::Guess" => "0.11"
  },
  "CONFIGURE_REQUIRES" => {
    "Crypt::OpenSSL::Guess" => "0.11",
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "Crypt-OpenSSL-PKCS10",
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.008",
  "NAME" => "Crypt::OpenSSL::PKCS10",
  "PREREQ_PM" => {
    "Crypt::OpenSSL::RSA" => 0,
    "Exporter" => 0,
    "XSLoader" => 0
  },
  "TEST_REQUIRES" => {
    "Crypt::OpenSSL::Guess" => "0.11",
    "Crypt::OpenSSL::RSA" => 0,
    "File::Slurper" => 0,
    "File::Spec::Functions" => 0,
    "File::Temp" => 0,
    "Import::Into" => 0,
    "Test::Lib" => 0,
    "Test::More" => 0
  },
  "VERSION" => "0.37",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    %args,
);

my %FallbackPrereqs = (
  "Crypt::OpenSSL::Guess" => "0.11",
  "Crypt::OpenSSL::RSA" => 0,
  "Exporter" => 0,
  "File::Slurper" => 0,
  "File::Spec::Functions" => 0,
  "File::Temp" => 0,
  "Import::Into" => 0,
  "Test::Lib" => 0,
  "Test::More" => 0,
  "XSLoader" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
