% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recreg.R
\name{simGLcox}
\alias{simGLcox}
\title{Simulation of two-stage recurrent events data based on Cox/Cox or Cox/Ghosh-Lin structure}
\usage{
simGLcox(
  n,
  base1,
  drcumhaz,
  var.z = 0,
  r1 = NULL,
  rd = NULL,
  rc = NULL,
  fz = NULL,
  fdz = NULL,
  model = c("twostage", "frailty", "shared"),
  type = NULL,
  share = 1,
  cens = NULL,
  nmin = 100,
  nmax = 1000
)
}
\arguments{
\item{n}{number of id's}

\item{base1}{baseline for cox/ghosh-lin models}

\item{drcumhaz}{baseline for terminal event}

\item{var.z}{variance of gamma frailty}

\item{r1}{relative risk term for baseline}

\item{rd}{relative risk term for terminal event}

\item{rc}{relative risk term for censorings}

\item{fz}{possible transformation (function) of frailty term}

\item{fdz}{possible transformation (function) of frailty term for death}

\item{model}{twostage, frailty, shared (partly shared two-stage model)}

\item{type}{type of simulation, default is decided based on model}

\item{share}{to fit patly shared random effects model}

\item{cens}{censoring rate for exponential censoring}

\item{nmin}{default 100, at least nmin or number of rows of the two-baselines max(nmin,nrow(base1),nrow(drcumhaz)) points in time-grid from 0 to maximum time for base1}

\item{nmax}{default 1000, at most nmax points in time-grid}
}
\description{
Simulation of two-stage recurrent events data based on Cox/Cox or Cox/Ghosh-Lin structure. type=3 will generate
Cox/Cox twostage mode, type=2 will generate Ghosh-Lin/Cox model. 
If the variance is var.z=0, then generates data without any dependence or frailty. If model="twostage" then default is to generate data from Ghosh-Lin/Cox model, and
if type=3 then will generate data with marginal Cox models (Cox/Cox). 
Simulation based on linear aproximation of hazard for two-stage models based on grid on time-scale. Must be sufficientyly fine.
}
\details{
Must specify baselines of recurrent events and terminal event and possible covariate effects.
}
\references{
Scheike (2025), Two-stage recurrent events random effects models, LIDA, to appear
}
