% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableau.R
\name{tableau_color_pal}
\alias{tableau_color_pal}
\title{Tableau Color Palettes (discrete)}
\usage{
tableau_color_pal(
  palette = "Tableau 10",
  type = c("regular", "ordered-sequential", "ordered-diverging"),
  direction = 1
)
}
\arguments{
\item{palette}{Palette name. See Details for available palettes.}

\item{type}{Type of palette. One of \code{"regular"}, \code{"ordered-diverging"}, or \code{"ordered-sequential"}.}

\item{direction}{If 1, the default, then use the original order of
colors. If -1, then reverse the order.}
}
\description{
Color palettes used in \href{https://www.tableau.com/}{Tableau}.
}
\details{
Tableau provides three types of color palettes:
\code{"regular"} (discrete, qualitative categories),
\code{"ordered-sequential"}, and \code{"ordered-diverging"}.

\describe{
\item{\code{"regular"}}{\Sexpr[results=rd]{ggthemes:::rd_optlist(names(ggthemes::ggthemes_data$tableau[["color-palettes"]][["regular"]]))}}
\item{\code{"ordered-diverging"}}{\Sexpr[results=rd]{ggthemes:::rd_optlist(names(ggthemes::ggthemes_data$tableau[["color-palettes"]][["ordered-diverging"]]))}}
\item{\code{"ordered-sequential"}}{\Sexpr[results=rd]{ggthemes:::rd_optlist(names(ggthemes::ggthemes_data$tableau[["color-palettes"]][["ordered-sequential"]]))}}
}
}
\examples{
library("scales")

palettes <- ggthemes_data[["tableau"]][["color-palettes"]][["regular"]]
for (palname in names(palettes)) {
  pal <- tableau_color_pal(palname)
  max_n <- attr(pal, "max_n")
  show_col(pal(max_n))
  title(main = palname)
}
}
\references{
\url{http://vis.stanford.edu/color-names/analyzer/}

Maureen Stone, 'Designing Colors for Data' (slides), at the
International Symposium on Computational Aesthetics in Graphics,
Visualization, and Imaging, Banff, AB, Canada, June 22, 2007.

Heer, Jeffrey and Maureen Stone, 2012 'Color Naming Models for
Color Selection, Image Editing and Palette Design', ACM Human
Factors in Computing Systems (CHI)
\url{http://vis.stanford.edu/files/2012-ColorNameModels-CHI.pdf}.
}
\seealso{
Other colour tableau: 
\code{\link{scale_colour_gradient2_tableau}()},
\code{\link{scale_colour_gradient_tableau}()},
\code{\link{scale_colour_tableau}()},
\code{\link{tableau_gradient_pal}()}
}
\concept{colour tableau}
