test_that("ard_tabulate_value() works", {
  expect_error(
    ard_dich <-
      ard_tabulate_value(
        mtcars |> dplyr::mutate(gear = factor(gear), am = as.logical(am)),
        variables = c("cyl", "am", "gear"),
        value = list(cyl = 4)
      ),
    NA
  )
  expect_snapshot(class(ard_dich))

  expect_equal(
    ard_categorical(
      mtcars,
      variables = cyl
    ) |>
      dplyr::filter(variable_level %in% 4) |>
      dplyr::select(-context),
    ard_dich |>
      dplyr::filter(variable %in% "cyl", variable_level %in% 4) |>
      dplyr::select(-context)
  )

  expect_equal(
    ard_categorical(
      mtcars |> dplyr::mutate(am = as.logical(am)),
      variables = am
    ) |>
      dplyr::filter(variable_level %in% TRUE) |>
      dplyr::select(-context),
    ard_dich |>
      dplyr::filter(variable %in% "am", variable_level %in% TRUE) |>
      dplyr::select(-context)
  )

  ## line added to fix failing snapshot test on ubuntu-latest (devel)
  ## TODO: resolve after release of R-devel
  skip_if_not(package_version(paste(R.version$major, R.version$minor, sep = ".")) <= package_version("4.5.0"))

  expect_snapshot(
    ard_dich |>
      dplyr::select(-c(fmt_fun, warning, error)) |>
      as.data.frame()
  )
})


test_that("ard_tabulate_value() errors are correct", {
  expect_snapshot(
    ard_tabulate_value(
      mtcars,
      variables = c("cyl", "am", "gear"),
      value = list(cyl = letters)
    ),
    error = TRUE
  )

  expect_snapshot(
    ard_tabulate_value(
      iris,
      variables = everything(),
      value = list(Species = "not_a_species")
    ),
    error = TRUE
  )

  expect_snapshot(
    ard_tabulate_value(
      mtcars,
      variables = c("cyl", "am", "gear"),
      value = list(cyl = 100)
    ),
    error = TRUE
  )
})


test_that("ard_tabulate_value() with grouped data works", {
  expect_equal(
    mtcars |>
      dplyr::group_by(vs) |>
      ard_tabulate_value(variables = c(cyl, am), value = list(cyl = 4)),
    ard_tabulate_value(
      data = mtcars,
      by = vs,
      variables = c(cyl, am),
      value = list(cyl = 4)
    )
  )
})

test_that("ard_tabulate_value() follows ard structure", {
  expect_silent(
    mtcars |>
      dplyr::group_by(vs) |>
      ard_tabulate_value(variables = c(cyl, am), value = list(cyl = 4)) |>
      check_ard_structure(method = FALSE)
  )
})

test_that("ard_tabulate_value() errors with incomplete factor columns", {
  # Check error when factors have no levels
  expect_snapshot(
    error = TRUE,
    mtcars |>
      dplyr::mutate(am = factor(am, levels = character(0))) |>
      ard_tabulate_value(
        variables = c(cyl, vs),
        by = am,
        value = list(cyl = 4)
      )
  )

  # Check error when factor has NA level
  expect_snapshot(
    error = TRUE,
    mtcars |>
      dplyr::mutate(am = factor(am, levels = c(0, 1, NA), exclude = NULL)) |>
      ard_tabulate_value(
        variables = c(cyl, am),
        value = list(cyl = 4)
      )
  )
})
