/*
 * Copyright (c) 2008-2026 Jonathan Schleifer <js@nil.im>
 *
 * All rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3.0 only,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3.0 along with this program. If not, see
 * <https://www.gnu.org/licenses/>.
 */

#import "NSOFArray.h"
#import "OFArray.h"
#import "OFOFToNSBridging.h"

#import "OFOutOfRangeException.h"

@implementation NSOFArray
- (instancetype)initWithOFArray: (OFArray *)array
{
	if ((self = [super init]) != nil)
		_array = objc_retain(array);

	return self;
}

- (void)dealloc
{
	objc_release(_array);

	[super dealloc];
}

- (id)objectAtIndex: (NSUInteger)idx
{
	id object = [_array objectAtIndex: idx];

	if ([(id <OFObject>)object conformsToProtocol:
	    @protocol(OFOFToNSBridging)])
		return [object NSObject];

	return object;
}

- (NSUInteger)count
{
	size_t count = _array.count;

	if (count > NSUIntegerMax)
		@throw [OFOutOfRangeException exception];

	return (NSUInteger)count;
}
@end
