"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class Box extends _react.PureComponent {
  constructor() {
    super();
    this.nodeRef = _react.default.createRef();
  }

  render() {
    const _this$props = this.props,
          {
      children,
      unstable__transformChildren
    } = _this$props,
          style = _objectWithoutProperties(_this$props, ["children", "unstable__transformChildren"]);

    return _react.default.createElement("div", {
      ref: this.nodeRef,
      style: style,
      unstable__transformChildren: unstable__transformChildren
    }, children);
  }

  unstable__getComputedWidth() {
    return this.nodeRef.current.yogaNode.getComputedWidth();
  }

}

exports.default = Box;

_defineProperty(Box, "propTypes", {
  margin: _propTypes.default.number,
  marginX: _propTypes.default.number,
  marginY: _propTypes.default.number,
  marginTop: _propTypes.default.number,
  marginBottom: _propTypes.default.number,
  marginLeft: _propTypes.default.number,
  marginRight: _propTypes.default.number,
  padding: _propTypes.default.number,
  paddingX: _propTypes.default.number,
  paddingY: _propTypes.default.number,
  paddingTop: _propTypes.default.number,
  paddingBottom: _propTypes.default.number,
  paddingLeft: _propTypes.default.number,
  paddingRight: _propTypes.default.number,
  width: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
  minWidth: _propTypes.default.number,
  height: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
  minHeight: _propTypes.default.number,
  flexGrow: _propTypes.default.number,
  flexShrink: _propTypes.default.number,
  flexDirection: _propTypes.default.oneOf(['row', 'row-reverse', 'column', 'column-reverse']),
  flexBasis: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
  alignItems: _propTypes.default.oneOf(['stretch', 'flex-start', 'center', 'flex-end']),
  justifyContent: _propTypes.default.oneOf(['flex-start', 'center', 'flex-end', 'space-between', 'space-around']),
  textWrap: _propTypes.default.oneOf(['wrap', 'truncate', 'truncate-start', 'truncate-middle', 'truncate-end']),
  unstable__transformChildren: _propTypes.default.func,
  children: _propTypes.default.node
});

_defineProperty(Box, "defaultProps", {
  flexDirection: 'row',
  flexGrow: 0,
  flexShrink: 1
});