# Pretty library change log

## 1.1.3.6 -- 30th January, 2018

* Fix compatability with GHC-8.4/base-4.11 (by Herbert Valerio Riedel).
* Add in benchmarking framework (by Alfredo Di Napoli).

## 1.1.3.5 -- 1st February, 2017

* Fix documentation formatting bug (by Ivan Lazar Miljenovic)
* Fix missing git tag on Github for v1.1.3.4 release.

## 1.1.3.4 -- 3rd June, 2016

* Fix over-zeleaous use of strictness causing stack allocation, fixes part of
  issue #32 (by Neil Mitchell).

## 1.1.3.3 -- 29th February, 2016

* Improve documentation.

## 1.1.3.2 -- 19th March, 2015

* Fix bug with haddock documentation.
* Clean up module intro documentation.

## 1.1.3.1 -- 11th March, 2015

* Add support for annotations in pretty (by Trevor Elliott).

## 1.1.2.1 -- 25th December, 2014

* Fix overly-strict issue preventing use of pretty for very large
  docs (by Eyal Lotem).

## 1.1.2.0 -- 25th December, 2014

* Merge in prettyclass package -- new Text.PrettyPrint.HughesPHClass.
* Add in 'maybe\*' variants of various bracket functins.
* Add Generic instances for appropriate data types.
* Fix compilation under GHC 7.10

## 1.1.1.3 -- 21st December, 2014

* Remove upper bound on `deepseq` package to fix build issues with
  latest GHC.

## 1.1.1.2 -- 18th August, 2014

* Add NFData and Eq instances (by Ivan Lazar Miljenovic).

## 1.1.1.1 -- 27th October, 2013

* Update pretty cabal file and readme.
* Fix tests to work with latest quickcheck.

## Version 3.0, 28 May 1987

* Cured massive performance bug. If you write:

    foldl <> empty (map (text.show) [1..10000])

  You get quadratic behaviour with V2.0. Why? For just the same
  reason as you get quadratic behaviour with left-associated (++)
  chains.

  This is really bad news. One thing a pretty-printer abstraction
  should certainly guarantee is insensitivity to associativity. It
  matters: suddenly GHC's compilation times went up by a factor of
  100 when I switched to the new pretty printer.
  
  I fixed it with a bit of a hack (because I wanted to get GHC back
  on the road). I added two new constructors to the Doc type, Above
  and Beside:
  
    <> = Beside
    $$ = Above
  
  Then, where I need to get to a "TextBeside" or "NilAbove" form I
  "force" the Doc to squeeze out these suspended calls to Beside and
  Above; but in so doing I re-associate. It's quite simple, but I'm
  not satisfied that I've done the best possible job. I'll send you
  the code if you are interested.

* Added new exports:
    punctuate, hang
    int, integer, float, double, rational,
    lparen, rparen, lbrack, rbrack, lbrace, rbrace,

* fullRender's type signature has changed. Rather than producing a
  string it now takes an extra couple of arguments that tells it how
  to glue fragments of output together:

    fullRender :: Mode
               -> Int                       -- Line length
               -> Float                     -- Ribbons per line
               -> (TextDetails -> a -> a)   -- What to do with text
               -> a                         -- What to do at the end
               -> Doc
               -> a                         -- Result

  The "fragments" are encapsulated in the TextDetails data type:

    data TextDetails = Chr  Char
                     | Str  String
                     | PStr FAST_STRING

  The Chr and Str constructors are obvious enough. The PStr
  constructor has a packed string (FAST_STRING) inside it. It's
  generated by using the new "ptext" export.

  An advantage of this new setup is that you can get the renderer to
  do output directly (by passing in a function of type (TextDetails
  -> IO () -> IO ()), rather than producing a string that you then
  print.

## Version 3.0, 28 May 1987

* Made empty into a left unit for <> as well as a right unit;
  it is also now true that
    nest k empty = empty
  which wasn't true before.

* Fixed an obscure bug in sep that occasionally gave very weird behaviour

* Added $+$

* Corrected and tidied up the laws and invariants

## Version 1.0

Relative to John's original paper, there are the following new features:

1. There's an empty document, "empty". It's a left and right unit for
   both <> and $$, and anywhere in the argument list for
   sep, hcat, hsep, vcat, fcat etc.

   It is Really Useful in practice.

2. There is a paragraph-fill combinator, fsep, that's much like sep,
   only it keeps fitting things on one line until it can't fit any more.

3. Some random useful extra combinators are provided.
     <+> puts its arguments beside each other with a space between them,
         unless either argument is empty in which case it returns the other


     hcat is a list version of <>
     hsep is a list version of <+>
     vcat is a list version of $$

     sep (separate) is either like hsep or like vcat, depending on what fits

     cat  behaves like sep,  but it uses <> for horizontal composition
     fcat behaves like fsep, but it uses <> for horizontal composition

     These new ones do the obvious things:
       char, semi, comma, colon, space,
       parens, brackets, braces,
       quotes, doubleQuotes

4. The "above" combinator, $$, now overlaps its two arguments if the
   last line of the top argument stops before the first line of the
   second begins.

     For example:  text "hi" $$ nest 5 (text "there")
     lays out as
                   hi   there
     rather than
                   hi
                        there

   There are two places this is really useful

     a) When making labelled blocks, like this:
            Left ->   code for left
            Right ->  code for right
            LongLongLongLabel ->
                      code for longlonglonglabel
        The block is on the same line as the label if the label is
        short, but on the next line otherwise.

     b) When laying out lists like this:
            [ first
            , second
            , third
            ]
        which some people like. But if the list fits on one line you
        want [first, second, third]. You can't do this with John's
        original combinators, but it's quite easy with the new $$.

   The combinator $+$ gives the original "never-overlap" behaviour.

5. Several different renderers are provided:
     * a standard one
     * one that uses cut-marks to avoid deeply-nested documents
       simply piling up in the right-hand margin
     * one that ignores indentation (fewer chars output; good for machines)
     * one that ignores indentation and newlines (ditto, only more so)

6. Numerous implementation tidy-ups
   Use of unboxed data types to speed up the implementation

