import { Reporter } from "./index";
export declare class RedirectReporter implements Reporter {
    verbosity: number;
    constructor(verbosity: number);
    start(): void;
    end(wrong?: boolean): void;
    targetStart(id: string): void;
    targetSkip(id: string): void;
    targetEnd(id: string): void;
    targetHalt(id: string): void;
    targetUnHalt(id: string): void;
    systemError(e: Error): void;
    targetError(name: string, e: Error): void;
    redirectStdout(line: string | Buffer): void;
    redirectStderr(line: string | Buffer): void;
    private static unescapeActionTerm;
    actions(lines: any[][], style?: string): void;
    debug(...line: any[]): void;
    info(...line: any[]): void;
    echo(...line: any[]): void;
    note(...line: any[]): void;
    warn(...line: any[]): void;
    success(...line: any[]): void;
    fail(...line: any[]): void;
    error(...line: any[]): void;
    fatal(...line: any[]): void;
}
