// NOTE: File has been autogenerated by utils/aarch64_builtins_test_generator.py
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +sve -verify=guard
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +sme2 -target-feature +ssve-fexpa -target-feature +sve -verify
// expected-no-diagnostics

// REQUIRES: aarch64-registered-target

#include <arm_sve.h>

// Properties: guard="sve" streaming_guard="sme,sme2,ssve-fexpa" flags="feature-dependent"

void test(void) {
  svuint16_t svuint16_t_val;
  svuint32_t svuint32_t_val;
  svuint64_t svuint64_t_val;

  svexpa(svuint16_t_val);
  svexpa(svuint32_t_val);
  svexpa(svuint64_t_val);
  svexpa_f16(svuint16_t_val);
  svexpa_f32(svuint32_t_val);
  svexpa_f64(svuint64_t_val);
}

void test_streaming(void) __arm_streaming{
  svuint16_t svuint16_t_val;
  svuint32_t svuint32_t_val;
  svuint64_t svuint64_t_val;

  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svexpa(svuint16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svexpa(svuint32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svexpa(svuint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svexpa_f16(svuint16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svexpa_f32(svuint32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svexpa_f64(svuint64_t_val);
}

void test_streaming_compatible(void) __arm_streaming_compatible{
  svuint16_t svuint16_t_val;
  svuint32_t svuint32_t_val;
  svuint64_t svuint64_t_val;

  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svexpa(svuint16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svexpa(svuint32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svexpa(svuint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svexpa_f16(svuint16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svexpa_f32(svuint32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svexpa_f64(svuint64_t_val);
}
