/*
* Copyright (c) 2024-2026, Intel Corporation
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
* THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
* OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*/
//!
//! \file     nvlMediaKernel_vp9brc_init.h
//! \brief    File holds the Firmware for the media kernels for HuC
//! \details  File holds the Firmware for the media kernels for HuC which is 
//!           a programmable Microcontroller added to the VDBox pipeline.
//!

/* Media Kernel Version - 20240411 */

#pragma once


/*==========================================================================================================================================================
Kernel begins from here. Do not remove this comment.
==========================================================================================================================================================*/

const uint32_t __MediaKernels_vp9brc_init_nvl [] =
{
    0x00002000, 0x000000c0, 0x00002a40, 0x00000040,
    0x00002680, 0x000020c0, 0x000026c0, 0x00000900,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x672efcfa, 0x15010f66, 0x00002a80, 0x66c0200f,
    0x6601c883, 0xffffff25, 0xc0220f9f, 0x00b800eb,
    0xb8c08e00, 0xe88e0028, 0x8e0010b8, 0x0018b8d8,
    0x20b8d08e, 0x66e08e00, 0x000080ea, 0x90000800,
    0x2a90002f, 0x2e660000, 0x00841f0f, 0x00000000,
    0x00000000, 0x00000000, 0x2a402680, 0x00409b00,
    0x000029c0, 0x00409300, 0x00002000, 0x00409300,
    0x0000ffdf, 0x00cf9302, 0x2a402680, 0x00409300,
    0x001ffcbc, 0x0af6e800, 0xb8660000, 0xebf4dead,
    0xccccf4fd, 0x006afacf, 0x2ae9006a, 0xfa000001,
    0x016a006a, 0x000120e9, 0x006afa00, 0x16e9026a,
    0xfa000001, 0x036a006a, 0x00010ce9, 0x006afa00,
    0x02e9046a, 0xfa000001, 0x056a006a, 0x0000f8e9,
    0x006afa00, 0xeee9066a, 0xfa000000, 0x076a006a,
    0x0000e4e9, 0x086afa00, 0x0000dce9, 0x006afa00,
    0xd2e9096a, 0xfa000000, 0xcae90a6a, 0xfa000000,
    0xc2e90b6a, 0xfa000000, 0xbae90c6a, 0xfa000000,
    0xb2e90d6a, 0xfa000000, 0xaae90e6a, 0xfa000000,
    0x0f6a006a, 0x0000a0e9, 0x006afa00, 0x96e9106a,
    0xfa000000, 0x8ee9116a, 0xfa000000, 0x126a006a,
    0x000084e9, 0x006afa00, 0x7deb136a, 0x6a006afa,
    0xfa76eb14, 0x156a006a, 0x6afa6feb, 0xeb166a00,
    0x006afa68, 0x61eb176a, 0x6a006afa, 0xfa5aeb18,
    0x196a006a, 0x6afa53eb, 0xeb1a6a00, 0x006afa4c,
    0x45eb1b6a, 0x6a006afa, 0xfa3eeb1c, 0x1d6a006a,
    0x6afa37eb, 0xeb1e6a00, 0x006afa30, 0x29eb1f6a,
    0xd06860fa, 0xe8000000, 0x00000074, 0x6104c483,
    0x6a60facf, 0x0956e84c, 0xc4830000, 0xfacf6104,
    0xff68006a, 0xeb000000, 0x31e8600b, 0x61000000,
    0xcf08c483, 0x0056e860, 0x83610000, 0xcccf08c4,
    0x83e58955, 0xc76608ec, 0x07fff845, 0xc0fa45c7,
    0x0f000020, 0x83f85d01, 0xc35d08c4, 0xcccccccc,
    0x83e58955, 0x458b08ec, 0x084d8d28, 0xff240c89,
    0x28c08514, 0xc4830000, 0x90c35d08, 0x90909090,
    0x5de58955, 0x909090c3, 0x90909090, 0x90909090,
    0x5de58955, 0xccccccc3, 0xcccccccc, 0xcccccccc,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0xccccccc3, 0xcccccccc,
    0xb0e58955, 0xe6a1e6ff, 0x90c35d21, 0x90909090,
    0xb8e58955, 0x00020000, 0xe00380b9, 0x64c129fe,
    0xffff01c7, 0xe0b900ff, 0x29fee003, 0x01c764c1,
    0x00000001, 0xe00320b9, 0x64c129fe, 0x00d001c7,
    0xc35d0002, 0x90909090, 0x90909090, 0x90909090,
    0xb0e58955, 0xe6a1e6ff, 0x0000b821, 0x30b90002,
    0x29fee000, 0x098b64c1, 0xe000f0b9, 0x64c129fe,
    0x01ff01c7, 0xe0b90000, 0x29fee000, 0x01c764c1,
    0xffffffff, 0xe00080b9, 0x64c129fe, 0x000001c7,
    0x80b90000, 0x29fee003, 0x01c764c1, 0x00ffffff,
    0xe003e0b9, 0x64c129fe, 0x000101c7, 0x20b90000,
    0x29fee003, 0x01c764c1, 0x000200d0, 0xccccc35d,
    0x53e58955, 0x4d8b5657, 0x08458b10, 0x890c558b,
    0x03e783c7, 0x04be4574, 0x29000000, 0x89ce39fe,
    0x890277cf, 0x89f929f7, 0x74ff85c6, 0x90909009,
    0x4f461688, 0xcf89fa75, 0x7502efc1, 0x03e18327,
    0x0010840f, 0x90900000, 0x90909090, 0x90909090,
    0x49461688, 0x5f5efa75, 0x89c35d5b, 0xc1cf89c6,
    0xd97402ef, 0xc1c2b60f, 0xc38918e2, 0x0908e3c1,
    0xc1da09c2, 0xd00910e0, 0x90909090, 0x90909090,
    0xc6830689, 0xf8754f04, 0x8b08458b, 0xe1830c55,
    0xebbd7503, 0x909090c1, 0x90909090, 0x90909090,
    0x53e58955, 0x4d8b5657, 0x0c558b10, 0x8908458b,
    0x03e683d6, 0xe783c789, 0x75fe3903, 0x74f68559,
    0x0004bb6e, 0xf3290000, 0xcf89cb39, 0xdf890277,
    0xc689f929, 0x840fff85, 0x0000000e, 0x90909090,
    0x881ab60f, 0x4f42461e, 0xcf89f675, 0x0f02efc1,
    0x00001884, 0x90909000, 0x90909090, 0x90909090,
    0x1e891a8b, 0x8304c683, 0x754f04c2, 0x03e183f3,
    0x0c75c985, 0xc68914eb, 0x840fc985, 0x0000000a,
    0x881ab60f, 0x4942461e, 0x5f5ef675, 0x89c35d5b,
    0xc1cf89c6, 0xc87502ef, 0x9090d3eb, 0x90909090,
    0x53e58955, 0x4d8b5657, 0x0c558b10, 0x3908458b,
    0x8d7d76d0, 0xd6390834, 0xca017676, 0xe783d789,
    0x83f08903, 0xc73903e0, 0xff854875, 0xcf391e74,
    0x0277c889, 0xc129f889, 0x840fc085, 0x0000000c,
    0xff5ab60f, 0x4eff5e88, 0xf475484a, 0xe8c1c889,
    0x18840f02, 0x90000000, 0x90909090, 0x90909090,
    0x89fc7a8b, 0xc683fc7e, 0xfcc283fc, 0x83f17548,
    0xc98503e1, 0x0012840f, 0x90900000, 0x90909090,
    0xff42b60f, 0x4eff4688, 0xf475494a, 0x7aebf089,
    0xe683d689, 0x83c78903, 0xfe3903e7, 0xf6855875,
    0x04bb6d74, 0x29000000, 0x89cb39f3, 0x890277cf,
    0x89f929df, 0x0fff85c6, 0x00000d84, 0x90909000,
    0x881ab60f, 0x4f42461e, 0xcf89f675, 0x0f02efc1,
    0x00001884, 0x90909000, 0x90909090, 0x90909090,
    0x1e891a8b, 0x8304c683, 0x754f04c2, 0x03e183f3,
    0x0c75c985, 0xc68914eb, 0x840fc985, 0x0000000a,
    0x881ab60f, 0x4942461e, 0x5f5ef675, 0x89c35d5b,
    0xc1cf89c6, 0xc87502ef, 0x9090d3eb, 0x90909090,
    0x53e58955, 0x8b505657, 0xc985084d, 0x000002b8,
    0xdf840f00, 0x8b000000, 0xf6850c75, 0x00d4880f,
    0x558b0000, 0x76f23914, 0x83ca8960, 0x277403e2,
    0x000004bf, 0x39d72900, 0x77f289f7, 0x29fa8902,
    0x0fd285d6, 0x00000e84, 0x90909000, 0x90909090,
    0x410001c6, 0x89f9754a, 0x02eac1f2, 0x90900e74,
    0x000001c7, 0xc1830000, 0xf4754a04, 0x0f03e683,
    0x00008184, 0x90909000, 0x90909090, 0x90909090,
    0x410001c6, 0xebf9754e, 0x105d8b6d, 0xe083c889,
    0xbe237403, 0x00000004, 0xd639c629, 0x0277d089,
    0xc229f089, 0x840fc085, 0x0000000a, 0x90909090,
    0x48411988, 0xd089fa75, 0x0f02e8c1, 0x00002784,
    0xf3b60f00, 0xe7c1df89, 0xf0758918, 0x08f065c1,
    0x7d03f709, 0x10e6c1f0, 0x9090fe09, 0x90909090,
    0xc1833189, 0xf8754804, 0xe283c031, 0x90077403,
    0x4a411988, 0xc483fa75, 0x5b5f5e04, 0x9090c35d,
    0x53e58955, 0x4d8b5657, 0xb8c98508, 0x00000002,
    0x00f1840f, 0x7d8b0000, 0x0fff850c, 0x0000e688,
    0x10758b00, 0x840ff685, 0x00000080, 0x3914558b,
    0x897977fa, 0x03e083f0, 0xe783cf89, 0x75f83903,
    0x74c0854f, 0x0004bf25, 0xc7290000, 0xd089d739,
    0xf8890277, 0xc085c229, 0x000c840f, 0x90900000,
    0x881eb60f, 0x48464119, 0xd089f675, 0x0f02e8c1,
    0x00001884, 0x90909000, 0x90909090, 0x90909090,
    0x39893e8b, 0x8304c183, 0x754804c6, 0x03e283f3,
    0xd285c031, 0x006d840f, 0x90900000, 0x90909090,
    0x881eb60f, 0x4a464119, 0x5bebf675, 0xe283ca89,
    0xbe247403, 0x00000004, 0xfe39d629, 0x0277fa89,
    0xd729f289, 0x840fd285, 0x0000000b, 0x90909090,
    0x410001c6, 0x89f9754a, 0x02eac1fa, 0x90900e74,
    0x000001c7, 0xc1830000, 0xf4754a04, 0x0f03e783,
    0x00001284, 0x90909000, 0x90909090, 0x90909090,
    0x410001c6, 0x5ef9754f, 0xc35d5b5f, 0x90909090,
    0x57e58955, 0x08558b56, 0x02b8d285, 0x0f000000,
    0x00008284, 0x0c4d8b00, 0x7b78c985, 0x8510758b,
    0x8b1974f6, 0xcf39147d, 0xec831277, 0x52565704,
    0xfffc9be8, 0x10c483ff, 0x5bebc031, 0xe683d689,
    0xbf247403, 0x00000004, 0xcf39f729, 0x0277ce89,
    0xf129fe89, 0x840ff685, 0x0000000b, 0x90909090,
    0x420002c6, 0x89f9754e, 0x02eec1ce, 0x90900e74,
    0x000002c7, 0xc2830000, 0xf4754e04, 0x0f03e183,
    0x00001284, 0x90909000, 0x90909090, 0x90909090,
    0x420002c6, 0x5ef97549, 0xccc35d5f, 0xcccccccc,
    0xb8e58955, 0x00020000, 0x100100b9, 0x64c129ff,
    0x000101c7, 0x00b90000, 0x29ff1000, 0x0004bac1,
    0xc229ff10, 0x0002c764, 0x64000200, 0x100001c7,
    0x0cb90002, 0x29ff1000, 0x01c764c1, 0x00000000,
    0x100008b9, 0x64c129ff, 0x000001c7, 0x14b90000,
    0x29ff1000, 0x01c764c1, 0x00000000, 0x100010b9,
    0x64c129ff, 0x000001c7, 0x1cb90000, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100018b9, 0x64c129ff,
    0x000001c7, 0x24b90000, 0x29ff1000, 0x01c764c1,
    0x00000000, 0x100020b9, 0x64c129ff, 0x000001c7,
    0x2cb90000, 0x29ff1000, 0x01c764c1, 0x00000000,
    0x100028b9, 0x64c129ff, 0x000001c7, 0x34b90000,
    0x29ff1000, 0x01c764c1, 0x00000000, 0x100030b9,
    0x64c129ff, 0x000001c7, 0x3cb90000, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100038b9, 0x64c129ff,
    0x000001c7, 0x44b90000, 0x29ff1000, 0x01c764c1,
    0x00000000, 0x100040b9, 0x64c129ff, 0x000001c7,
    0x4cb90000, 0x29ff1000, 0x01c764c1, 0x00000000,
    0x100048b9, 0x64c129ff, 0x000001c7, 0x54b90000,
    0x29ff1000, 0x01c764c1, 0x00000000, 0x100050b9,
    0x64c129ff, 0x000001c7, 0x5cb90000, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100058b9, 0x64c129ff,
    0x000001c7, 0x64b90000, 0x29ff1000, 0x01c764c1,
    0x00000000, 0x100060b9, 0x64c129ff, 0x000001c7,
    0x6cb90000, 0x29ff1000, 0x01c764c1, 0x00000000,
    0x100068b9, 0x64c129ff, 0x000001c7, 0x74b90000,
    0x29ff1000, 0x01c764c1, 0x00000000, 0x100070b9,
    0x64c129ff, 0x000001c7, 0x7cb90000, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100078b9, 0x64c129ff,
    0x000001c7, 0xc35d0000, 0x90909090, 0x90909090,
    0x56e58955, 0x2000a150, 0xf8830000, 0x850b7402,
    0xe80c75c0, 0x00001398, 0x71e805eb, 0x83000003,
    0x758d0cec, 0x6a046af8, 0x006a5604, 0x7de8006a,
    0x83000000, 0x046a20c4, 0x6a006a56, 0x010ee800,
    0xc4830000, 0x6a046a04, 0x006a5604, 0x5de8006a,
    0x83000000, 0x00b820c4, 0xb9000200, 0xfee000b0,
    0xc764c129, 0x00000001, 0x04c48300, 0x90c35d5e,
    0x83e58955, 0x55e808ec, 0xe8fffff6, 0xfffffda0,
    0xfff81be8, 0x0000b8ff, 0xb8b90002, 0x29ffe0d3,
    0x01c764c1, 0x0000004c, 0x90909090, 0x90909090,
    0xfcebf4fb, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0x53e58955, 0x4d8b5657, 0x03cf8918, 0x02b80c7d,
    0x72000000, 0x085d8b7d, 0x770ffb83, 0x107d8375,
    0x3b6f7400, 0x6a77144d, 0x020000be, 0x0000ba00,
    0xf229ff10, 0x809d348b, 0x01000029, 0x368b64d6,
    0x409d1403, 0x64000029, 0xde291a8b, 0x02b80773,
    0xeb000000, 0x00fb813d, 0xb8000200, 0x00000002,
    0xfe393072, 0xc9852c72, 0x0022840f, 0x5d030000,
    0x0000ba0c, 0xd3290002, 0x458bf631, 0x90909010,
    0x6433148d, 0x1489128b, 0x04c68330, 0xf072ce39,
    0x5f5ec031, 0x90c35d5b, 0x90909090, 0x90909090,
    0x53e58955, 0x7d8b5657, 0x0fff8308, 0x000002b8,
    0x8b7f7700, 0xc985104d, 0x558b7874, 0x0c550314,
    0x00be7072, 0xbb000200, 0xff100000, 0x348bf329,
    0x002980bd, 0x64de0100, 0x1c03368b, 0x002940bd,
    0x3b8b6400, 0x0773fe29, 0x000002b8, 0x8143eb00,
    0x020000ff, 0x39f17200, 0x0002b8d6, 0x820f0000,
    0x0000002e, 0x8b138b64, 0xc0851445, 0x001e840f,
    0x55030000, 0x0000be0c, 0xf2290002, 0x9090f631,
    0x8d313c8b, 0x8964321c, 0x04c6833b, 0xf072c639,
    0x5f5ec031, 0x90c35d5b, 0x90909090, 0x90909090,
    0x53e58955, 0x7d8b5657, 0x0c4d8b14, 0x8b08458b,
    0x29408534, 0x00b80000, 0x29000200, 0x00c681c6,
    0x64ff1000, 0xcf01168b, 0x01b81872, 0x31000000,
    0x0fca01db, 0xc385c392, 0x5d8b0875, 0x3fc3f610,
    0x02b80774, 0xeb000000, 0x08458b61, 0x8085048b,
    0xb9000029, 0x00020000, 0x0005c829, 0x64ff1000,
    0x8b64088b, 0x72c12906, 0xb8f939d9, 0x00000002,
    0x090f3872, 0x020000b8, 0xd300b900, 0xc129ffe0,
    0xb9118964, 0xffe0d308, 0x8964c129, 0xd310b919,
    0xc129ffe0, 0x6414558b, 0x14b91189, 0x29ffe0d3,
    0x01c764c1, 0x00000001, 0x5f5ec031, 0x90c35d5b,
    0x53e58955, 0x7d8b5657, 0x0c4d8b14, 0x8b08458b,
    0x29408534, 0x00b80000, 0x29000200, 0x00c681c6,
    0x64ff1000, 0xcf01168b, 0x01b81872, 0x31000000,
    0x0fca01db, 0xc385c392, 0x5d8b0875, 0x3fc3f610,
    0x02b80774, 0xeb000000, 0x08458b61, 0x8085048b,
    0xb9000029, 0x00020000, 0x0005c829, 0x64ff1000,
    0x8b64088b, 0x72c12906, 0xb8f939d9, 0x00000002,
    0x090f3872, 0x020000b8, 0xd300b900, 0xc129ffe0,
    0xb9118964, 0xffe0d308, 0x8964c129, 0xd310b919,
    0xc129ffe0, 0x6414558b, 0x14b91189, 0x29ffe0d3,
    0x01c764c1, 0x00000003, 0x5f5ec031, 0x90c35d5b,
    0xb8e58955, 0x00020000, 0xe0d000b9, 0x64c129ff,
    0x450b018b, 0x01896408, 0x9090c35d, 0x90909090,
    0xb8e58955, 0x00020000, 0xe0d000b9, 0x64c129ff,
    0xff25018b, 0x6400ffff, 0xc35d0189, 0xcccccccc,
    0x56e58955, 0x81c0e483, 0x0004c0ec, 0xffcee800,
    0xe089ffff, 0x00048068, 0x006a5000, 0x3de8006a,
    0x83fffffe, 0xc08510c4, 0xe6893975, 0x6de8f189,
    0x85000000, 0x683e75c0, 0x00000480, 0x6a006a56,
    0xfecae800, 0xc483ffff, 0x75c08510, 0x0cec833a,
    0x00000068, 0xff66e810, 0xc483ffff, 0xfc658d10,
    0x83c35d5e, 0x00680cec, 0xe8040000, 0xffffff50,
    0xeb10c483, 0x0cec83b5, 0x00000068, 0xff3ee801,
    0xc483ffff, 0x83b0eb10, 0x00680cec, 0xe8040000,
    0xffffff2c, 0xeb10c483, 0x909090b4, 0x90909090,
    0x53e58955, 0xec835657, 0xe04d893c, 0x002004a1,
    0x3dd23100, 0x0c000001, 0x0dc4830f, 0x45890000,
    0x1c358bdc, 0x85000020, 0xd8840ff6, 0x8b00000d,
    0x0020203d, 0xff4f8d00, 0x830ff139, 0x00000dc7,
    0x3e0db70f, 0x89000020, 0xec4d89c8, 0xc9b70f49,
    0x00fff981, 0x830f0000, 0x00000dd3, 0x002040a1,
    0x49c18900, 0x81c9b70f, 0x0000fff9, 0xd6830f00,
    0x6600000d, 0x0fec4539, 0x000de887, 0x0db70f00,
    0x00002042, 0x81d04d89, 0x000100f9, 0x02830f00,
    0x0f00000e, 0x203a0db7, 0x4d890000, 0x01f981e8,
    0x0f000040, 0x000e1783, 0xd87d8900, 0x89cc7589,
    0xb70fe455, 0x00203c0d, 0x01f98100, 0x0f000040,
    0x000e1583, 0x7db70f00, 0xd9b70fe8, 0x81dfaf0f,
    0x000001fb, 0xd4458908, 0x0e15830f, 0x10a10000,
    0x85000020, 0x2a840fc0, 0x3d00000e, 0x1e000001,
    0x0e55830f, 0x45890000, 0x083d8bf0, 0x8d000020,
    0xfb81ff5f, 0x1e000000, 0x0e0e830f, 0x0ca10000,
    0x8d000020, 0xfb81ff58, 0x2d000000, 0x830fc389,
    0x00000e0f, 0x8be0558b, 0x45891042, 0xdc458bc4,
    0x7a890289, 0x085a8904, 0x89f07d8b, 0x14a10c7a,
    0x89000020, 0x4289c845, 0x2018a110, 0x42890000,
    0xcc458b14, 0x8b184289, 0x4289d845, 0x05b70f1c,
    0x00002034, 0xb4828966, 0x0f000003, 0x20363db7,
    0x7d890000, 0xba8966bc, 0x000003b6, 0x66e87d8b,
    0x03baba89, 0x89660000, 0x0003bc8a, 0xec4d8b00,
    0xbe8a8966, 0x8b000003, 0x8966d44d, 0x0003c08a,
    0xd04d8b00, 0xc28a8966, 0x8b000003, 0x0020480d,
    0x92518d00, 0x28fa8366, 0x000073ba, 0x89027700,
    0xe04d8bca, 0xe6918966, 0xa8000003, 0xb85d8910,
    0x75c05589, 0xa801b111, 0x660d7520, 0xb101f883,
    0x00d18003, 0xc93102eb, 0x8bdc4d89, 0x8888e045,
    0x00000406, 0x89d8758b, 0xf065f7f0, 0x89cc7d8b,
    0x01ebd1fb, 0x00d283d8, 0x5257006a, 0x1466e850,
    0xc4830000, 0xe8458910, 0x65f7f089, 0x89d801c8,
    0xe07d8bfb, 0x6a00d283, 0x50525300, 0x001447e8,
    0x10c48300, 0x89e84d8b, 0x4789204f, 0x588f8924,
    0x89000001, 0x05b70ffe, 0x00002044, 0x74c08566,
    0x8689660c, 0x000003c8, 0xebd87d8b, 0xd87d8b52,
    0xe9d1f989, 0xd901c031, 0x6ac0920f, 0x51505700,
    0x001403e8, 0x10c48300, 0xc8868966, 0x89000003,
    0x01e183c1, 0x7d80c801, 0x950f00dc, 0xf88366c6,
    0xc2920f1f, 0x0575f220, 0x74c98566, 0xb9d28412,
    0x0000003c, 0xc1890275, 0xc88e8966, 0x89000003,
    0xf7d231d8, 0x1ef883f7, 0x1eb80572, 0x0f000000,
    0x208d0db6, 0xca890000, 0xfa80cafe, 0xe8758b77,
    0xc8890277, 0x85c4558b, 0x890274d2, 0xf0af0fc8,
    0x7d8bd285, 0xacb789e0, 0x89000001, 0x00039087,
    0x8c0d8a00, 0x88000020, 0x0004478f, 0x31850f00,
    0xc7000000, 0x0001a887, 0x00000000, 0x0fc08500,
    0x00001f84, 0xb1d23100, 0x90909001, 0x90909090,
    0xb09784c7, 0x00000001, 0x0f000000, 0xc1fed1b6,
    0xec77d039, 0xc045b70f, 0xc083c931, 0xffd1839c,
    0xaf0fe6f7, 0x6ad101ce, 0x51646a00, 0x1326e850,
    0xc4830000, 0xa4878910, 0x8b000001, 0x8366bc4d,
    0xffb801c1, 0x890000ff, 0x890274fe, 0x868966c8,
    0x000003c4, 0x03dc7d80, 0x458b1e75, 0xc8b70fd0,
    0x04f88366, 0x0a42870f, 0xc8890000, 0x0fd4558b,
    0xd939dab7, 0x18eb1c77, 0x7905b60f, 0x0f000020,
    0x20780db6, 0x558b0000, 0xdab70fd4, 0x0277d939,
    0xb70fca89, 0xd839ec7d, 0xc389057f, 0x39d45d89,
    0xec4d8bf9, 0x72b85d8b, 0x39d1890e, 0x038e88f8,
    0x7d000004, 0x3910eb0c, 0x038e88f8, 0x7c000004,
    0xd4458b06, 0x8bec4589, 0x8688ec45, 0x00000405,
    0x03ff8e88, 0x86880000, 0x00000401, 0x5c05be0f,
    0x89000020, 0x1ff9c1c1, 0x0ff0558b, 0xe2f7caaf,
    0x1132c083, 0x6a006aca, 0xe8505264, 0x00001158,
    0x3d10c483, 0x80000000, 0xd983d189, 0xba057c00,
    0x00000000, 0xffb8057c, 0xbf7fffff, 0x80000000,
    0x45c7c739, 0xffffffec, 0xffffb9ff, 0xd119ffff,
    0x00b8057c, 0x89800000, 0x00010086, 0x05be0f00,
    0x00002054, 0xf9c1c189, 0xf0558b1f, 0xf7caaf0f,
    0x32c083e2, 0x006aca11, 0x5052646a, 0x0010f7e8,
    0x10c48300, 0x0000003d, 0x83d18980, 0x077c00d9,
    0xffb8d231, 0x397fffff, 0xffffb9c7, 0xd119ffff,
    0x00b8057c, 0x89800000, 0x0000e086, 0x05be0f00,
    0x0000205d, 0xf9c1c189, 0xf0558b1f, 0xf7caaf0f,
    0x32c083e2, 0x006aca11, 0x5052646a, 0x0010a7e8,
    0x10c48300, 0x0000003d, 0x83d18980, 0x077c00d9,
    0xffb8d231, 0x397fffff, 0xffffb9c7, 0xd119ffff,
    0x00b8057c, 0x89800000, 0x00010486, 0x05be0f00,
    0x00002055, 0xf9c1c189, 0xf0558b1f, 0xf7caaf0f,
    0x32c083e2, 0x006aca11, 0x5052646a, 0x001057e8,
    0x10c48300, 0x0000003d, 0x83d18980, 0x077c00d9,
    0xffb8d231, 0x397fffff, 0xffffb9c7, 0xd119ffff,
    0x00b8057c, 0x89800000, 0x0000e486, 0x05be0f00,
    0x0000205e, 0xf9c1c189, 0xf0558b1f, 0xf7caaf0f,
    0x32c083e2, 0x006aca11, 0x5052646a, 0x001007e8,
    0x10c48300, 0x0000003d, 0x83d18980, 0x077c00d9,
    0xffb8d231, 0x397fffff, 0xffffb9c7, 0xd119ffff,
    0x00b8057c, 0x89800000, 0x00010886, 0x05be0f00,
    0x00002056, 0xf9c1c189, 0xf0558b1f, 0xf7caaf0f,
    0x32c083e2, 0x006aca11, 0x5052646a, 0x000fb7e8,
    0x10c48300, 0x0000003d, 0x83d18980, 0x077c00d9,
    0xffb8d231, 0x397fffff, 0xffffb9c7, 0xd119ffff,
    0x00b8057c, 0x89800000, 0x0000e886, 0x05be0f00,
    0x0000205f, 0xf9c1c189, 0xf0558b1f, 0xf7caaf0f,
    0x32c083e2, 0x006aca11, 0x5052646a, 0x000f67e8,
    0x10c48300, 0x0000003d, 0x83d18980, 0x077c00d9,
    0xffb8d231, 0x397fffff, 0xffffb9c7, 0xd119ffff,
    0x00b8057c, 0x89800000, 0x00010c86, 0x05be0f00,
    0x00002057, 0xf9c1c189, 0xf0558b1f, 0xf7caaf0f,
    0x32c083e2, 0x006aca11, 0x5052646a, 0x000f17e8,
    0x10c48300, 0x0000003d, 0x83d18980, 0x077c00d9,
    0xffb8d231, 0x397fffff, 0xffffb9c7, 0xd119ffff,
    0x00b8057c, 0x89800000, 0x0000ec86, 0x05be0f00,
    0x00002070, 0xf9c1c189, 0xcbaf0f1f, 0xc083e3f7,
    0x6aca1132, 0x52646a00, 0x0ecae850, 0xc4830000,
    0x00003d10, 0xd1898000, 0x7c00d983, 0xb8d23107,
    0x7fffffff, 0xffb9c739, 0x19ffffff, 0xb8057cd1,
    0x80000000, 0x00c08689, 0xbe0f0000, 0x00206005,
    0xc1c18900, 0xaf0f1ff9, 0x83e3f7cb, 0xca1132c0,
    0x646a006a, 0x7de85052, 0x8300000e, 0x003d10c4,
    0x89800000, 0x00d983d1, 0xd231077c, 0xffffffb8,
    0xb9c7397f, 0xffffffff, 0x057cd119, 0x000000b8,
    0x80868980, 0x0f000000, 0x206805be, 0xc1890000,
    0x0f1ff9c1, 0xe3f7cbaf, 0x1132c083, 0x6a006aca,
    0xe8505264, 0x00000e30, 0x3d10c483, 0x80000000,
    0xd983d189, 0x31077c00, 0xffffb8d2, 0xc7397fff,
    0xffffffb9, 0x7cd119ff, 0x0000b805, 0x86898000,
    0x000000a0, 0x7105be0f, 0x89000020, 0x1ff9c1c1,
    0xf7cbaf0f, 0x32c083e3, 0x006aca11, 0x5052646a,
    0x000de3e8, 0x10c48300, 0x0000003d, 0x83d18980,
    0x077c00d9, 0xffb8d231, 0x397fffff, 0xffffb9c7,
    0xd119ffff, 0x00b8057c, 0x89800000, 0x0000c486,
    0x05be0f00, 0x00002061, 0xf9c1c189, 0xcbaf0f1f,
    0xc083e3f7, 0x6aca1132, 0x52646a00, 0x0d96e850,
    0xc4830000, 0x00003d10, 0xd1898000, 0x7c00d983,
    0xb8d23107, 0x7fffffff, 0xffb9c739, 0x19ffffff,
    0xb8057cd1, 0x80000000, 0x00848689, 0xbe0f0000,
    0x00206905, 0xc1c18900, 0xaf0f1ff9, 0x83e3f7cb,
    0xca1132c0, 0x646a006a, 0x49e85052, 0x8300000d,
    0x003d10c4, 0x89800000, 0x00d983d1, 0xd231077c,
    0xffffffb8, 0xb9c7397f, 0xffffffff, 0x057cd119,
    0x000000b8, 0xa4868980, 0x0f000000, 0x207205be,
    0xc1890000, 0x0f1ff9c1, 0xe3f7cbaf, 0x1132c083,
    0x6a006aca, 0xe8505264, 0x00000cfc, 0x3d10c483,
    0x80000000, 0xd983d189, 0x31077c00, 0xffffb8d2,
    0xc7397fff, 0xffffffb9, 0x7cd119ff, 0x0000b805,
    0x86898000, 0x000000c8, 0x6205be0f, 0x89000020,
    0x1ff9c1c1, 0xf7cbaf0f, 0x32c083e3, 0x006aca11,
    0x5052646a, 0x000cafe8, 0x10c48300, 0x0000003d,
    0x83d18980, 0x077c00d9, 0xffb8d231, 0x397fffff,
    0xffffb9c7, 0xd119ffff, 0x00b8057c, 0x89800000,
    0x00008886, 0x05be0f00, 0x0000206a, 0xf9c1c189,
    0xcbaf0f1f, 0xc083e3f7, 0x6aca1132, 0x52646a00,
    0x0c62e850, 0xc4830000, 0x00003d10, 0xd1898000,
    0x7c00d983, 0xb8d23107, 0x7fffffff, 0xffb9c739,
    0x19ffffff, 0xb8057cd1, 0x80000000, 0x00a88689,
    0xbe0f0000, 0x00207305, 0xc1c18900, 0xaf0f1ff9,
    0x83e3f7cb, 0xca1132c0, 0x646a006a, 0x15e85052,
    0x8300000c, 0x003d10c4, 0x89800000, 0x00d983d1,
    0xd231077c, 0xffffffb8, 0xb9c7397f, 0xffffffff,
    0x057cd119, 0x000000b8, 0xcc868980, 0x0f000000,
    0x206305be, 0xc1890000, 0x0f1ff9c1, 0xe3f7cbaf,
    0x1132c083, 0x6a006aca, 0xe8505264, 0x00000bc8,
    0x3d10c483, 0x80000000, 0xd983d189, 0x31077c00,
    0xffffb8d2, 0xc7397fff, 0xffffffb9, 0x7cd119ff,
    0x0000b805, 0x86898000, 0x0000008c, 0x6b05be0f,
    0x89000020, 0x1ff9c1c1, 0xf7cbaf0f, 0x32c083e3,
    0x006aca11, 0x5052646a, 0x000b7be8, 0x10c48300,
    0x0000003d, 0x83d18980, 0x077c00d9, 0xffb8d231,
    0x397fffff, 0xffffb9c7, 0xd119ffff, 0x00b8057c,
    0x89800000, 0x0000ac86, 0x05be0f00, 0x00002074,
    0xf9c1c189, 0xcbaf0f1f, 0xc083e3f7, 0x6aca1132,
    0x52646a00, 0x0b2ee850, 0xc4830000, 0x00003d10,
    0xd1898000, 0x7c00d983, 0xb8d23107, 0x7fffffff,
    0xffb9c739, 0x19ffffff, 0xb8057cd1, 0x80000000,
    0x00d08689, 0xbe0f0000, 0x00206405, 0xc1c18900,
    0xaf0f1ff9, 0x83e3f7cb, 0xca1132c0, 0x646a006a,
    0xe1e85052, 0x8300000a, 0x003d10c4, 0x89800000,
    0x00d983d1, 0xd231077c, 0xffffffb8, 0xb9c7397f,
    0xffffffff, 0x057cd119, 0x000000b8, 0x90868980,
    0x0f000000, 0x206c05be, 0xc1890000, 0x0f1ff9c1,
    0xe3f7cbaf, 0x1132c083, 0x6a006aca, 0xe8505264,
    0x00000a94, 0x3d10c483, 0x80000000, 0xd983d189,
    0x31077c00, 0xffffb8d2, 0xc7397fff, 0xffffffb9,
    0x7cd119ff, 0x0000b805, 0x86898000, 0x000000b0,
    0x7505be0f, 0x89000020, 0x1ff9c1c1, 0xf7cbaf0f,
    0x32c083e3, 0x006aca11, 0x5052646a, 0x000a47e8,
    0x10c48300, 0x0000003d, 0x83d18980, 0x077c00d9,
    0xffb8d231, 0x397fffff, 0xffffb9c7, 0xd119ffff,
    0x00b8057c, 0x89800000, 0x0000d486, 0x05be0f00,
    0x00002065, 0xf9c1c189, 0xcbaf0f1f, 0xc083e3f7,
    0x6aca1132, 0x52646a00, 0x09fae850, 0xc4830000,
    0x00003d10, 0xd1898000, 0x7c00d983, 0xb8d23107,
    0x7fffffff, 0xffb9c739, 0x19ffffff, 0xb8057cd1,
    0x80000000, 0x00948689, 0xbe0f0000, 0x00206d05,
    0xc1c18900, 0xaf0f1ff9, 0x83e3f7cb, 0xca1132c0,
    0x646a006a, 0xade85052, 0x83000009, 0x003d10c4,
    0x89800000, 0x00d983d1, 0xd231077c, 0xffffffb8,
    0xb9c7397f, 0xffffffff, 0x057cd119, 0x000000b8,
    0xb4868980, 0x0f000000, 0x207605be, 0xc1890000,
    0x0f1ff9c1, 0xe3f7cbaf, 0x1132c083, 0x6a006aca,
    0xe8505264, 0x00000960, 0x3d10c483, 0x80000000,
    0xd983d189, 0x31077c00, 0xffffb8d2, 0xc7397fff,
    0xffffffb9, 0x7cd119ff, 0x0000b805, 0x86898000,
    0x000000d8, 0x6605be0f, 0x89000020, 0x1ff9c1c1,
    0xf7cbaf0f, 0x32c083e3, 0x006aca11, 0x5052646a,
    0x000913e8, 0x10c48300, 0x0000003d, 0x83d18980,
    0x077c00d9, 0xffb8d231, 0x397fffff, 0xffffb9c7,
    0xd119ffff, 0x00b8057c, 0x89800000, 0x00009886,
    0x05be0f00, 0x0000206e, 0xf9c1c189, 0xcbaf0f1f,
    0xc083e3f7, 0x6aca1132, 0x52646a00, 0x08c6e850,
    0xc4830000, 0x00003d10, 0xd1898000, 0x7c00d983,
    0xb8d23107, 0x7fffffff, 0xffb9c739, 0x19ffffff,
    0xb8057cd1, 0x80000000, 0x00b88689, 0xbe0f0000,
    0x00207705, 0xc1c18900, 0xaf0f1ff9, 0x83e3f7cb,
    0xca1132c0, 0x646a006a, 0x79e85052, 0x83000008,
    0x003d10c4, 0x89800000, 0x00d983d1, 0xd231077c,
    0xffffffb8, 0xb9c7397f, 0xffffffff, 0x057cd119,
    0x000000b8, 0xdc868980, 0x0f000000, 0x206705be,
    0xc1890000, 0x0f1ff9c1, 0xe3f7cbaf, 0x1132c083,
    0x6a006aca, 0xe8505264, 0x0000082c, 0x3d10c483,
    0x80000000, 0xd983d189, 0x31077c00, 0xffffb8d2,
    0xc7397fff, 0xffffffb9, 0x7cd119ff, 0x0000b805,
    0x86898000, 0x0000009c, 0x6f05be0f, 0x89000020,
    0x1ff9c1c1, 0xf7cbaf0f, 0x32c083e3, 0x006aca11,
    0x5052646a, 0x0007dfe8, 0x10c48300, 0x0000003d,
    0x83d18980, 0x077c00d9, 0xffb8d231, 0x397fffff,
    0xec5519c7, 0x00b8057c, 0x89800000, 0x0000bc86,
    0xe4458b00, 0x5e3cc483, 0xc35d5b5f, 0x8bfc418d,
    0xb70fd455, 0x0fd939da, 0xfff5d587, 0xf5cee9ff,
    0x05c7ffff, 0x00002004, 0x0c000000, 0x000001ba,
    0x0000b800, 0x45890c00, 0x1c358bdc, 0x85000020,
    0x28850ff6, 0xc7fffff2, 0x00201c05, 0x00001e00,
    0x2005c700, 0x01000020, 0xbe000000, 0x0000001e,
    0x000001bf, 0x0001ba00, 0x11e90000, 0x66fffff2,
    0x203e05c7, 0x00010000, 0x000001ba, 0x01b86600,
    0xec458900, 0xfff213e9, 0x05c766ff, 0x00002040,
    0x01ba00ff, 0x66000000, 0x6600ffb8, 0x0fec4539,
    0xfff21886, 0x3e05c7ff, 0x01000020, 0xba00ff00,
    0x00000001, 0x0001b866, 0x66ec4589, 0x0f00ffb8,
    0x20420db7, 0x4d890000, 0x00f981d0, 0x0f000001,
    0xfff1fe82, 0x05c766ff, 0x00002042, 0x01ba0080,
    0x66000000, 0x890080b9, 0xb70fd04d, 0x00203a0d,
    0xe84d8900, 0x4001f981, 0x820f0000, 0xfffff1e9,
    0x3a05c766, 0x00000020, 0x0001ba40, 0xb9660000,
    0x4d894000, 0xf1cfe9e8, 0xc766ffff, 0x00203c05,
    0xc7400000, 0x0001e445, 0xb9660000, 0xd2e94000,
    0x66fffff1, 0x73e84d39, 0x05c76668, 0x0000203a,
    0x45c72000, 0x000001e4, 0x00b86600, 0xe8458920,
    0xfff1c9e9, 0xa120b8ff, 0x34eb0007, 0xd1f07d8b,
    0x083d89ef, 0xc7000020, 0x0001e445, 0xdbe90000,
    0x8bfffff1, 0x1c8df045, 0x0c1d8900, 0xc7000020,
    0x0001e445, 0xd9e90000, 0xb8fffff1, 0x1e000000,
    0x002010a3, 0xe445c700, 0x00000001, 0xfff195e9,
    0x05c766ff, 0x0000203c, 0x45c72000, 0x000001e4,
    0x00b96600, 0xf164e920, 0x9090ffff, 0x90909090,
    0x53e58955, 0xe4835657, 0x00ec81c0, 0xe8000005,
    0xffffefac, 0x4024748d, 0x00048068, 0x68006a00,
    0x00000480, 0xe796e856, 0xc483ffff, 0xe8f18910,
    0xfffff04c, 0x1875c085, 0x207b358a, 0xfe800000,
    0x88287310, 0x044b24b4, 0xf6840000, 0x42eb2a75,
    0x680cec83, 0x01000000, 0xffef43e8, 0x10c483ff,
    0x207b358a, 0xfe800000, 0xb6d87210, 0x24b48810,
    0x0000044b, 0x1a74f684, 0x31c6b60f, 0x909090c9,
    0x207c918a, 0x94880000, 0x00045f0c, 0xc8394100,
    0x7488ee75, 0x448b2b24, 0x548b4424, 0xc2016424,
    0x4824748b, 0xf329d389, 0x46248c8a, 0x88000004,
    0x802c244c, 0x7c8b01f9, 0x7c896024, 0x00bf3824,
    0x74000000, 0x39df8902, 0x08158bf2, 0x89000020,
    0x03d42494, 0x44890000, 0x00b96824, 0x7c000000,
    0x89f98902, 0x00bc2484, 0x8c890000, 0x0000b824,
    0x84b70f00, 0x0003f624, 0x9cb70f00, 0x00040424,
    0x80048d00, 0x2c808c8d, 0x89000001, 0x2464f7d8,
    0x51006a38, 0xdde85052, 0x83000005, 0xc86910c4,
    0x0000012c, 0xb4248c89, 0x8d000000, 0x048d8004,
    0x24848980, 0x000000ac, 0x98248489, 0x0f000001,
    0x204405b7, 0x85660000, 0x77840fc0, 0x66000002,
    0x08248489, 0x8b000004, 0x03fa2484, 0x84890000,
    0x00040a24, 0x05b70f00, 0x00002046, 0x24848966,
    0x0000040e, 0x7835b60f, 0x0f000020, 0x20790db6,
    0x7c800000, 0x75032c24, 0x94b70f1e, 0x00040224,
    0x89d63900, 0x890272d0, 0x20718df0, 0x0973d639,
    0x89e0c283, 0x8902ebd1, 0x94b70ff0, 0x0003fe24,
    0x24548900, 0xb4b70f2c, 0x00040024, 0x89f03900,
    0xd08e0ff2, 0x39000001, 0x89f789f1, 0x0f302474,
    0x0001d28e, 0x245c8b00, 0x89d9392c, 0xd48d0fd9,
    0x39000001, 0x89027dc8, 0x249488ca, 0x00000443,
    0x45249c88, 0x88000004, 0x043f2494, 0x9c880000,
    0x00044124, 0x2484c600, 0x00000449, 0x2484c6ff,
    0x0000043e, 0x2484c7ff, 0x0000019c, 0x00000001,
    0x4e2484c6, 0xff000004, 0x502484c7, 0xff000001,
    0xc7ffffff, 0x01642484, 0xffff0000, 0x84c7ffff,
    0x00017824, 0xffffff00, 0x2484c7ff, 0x00000154,
    0xffffffff, 0x682484c7, 0xff000001, 0xc7ffffff,
    0x017c2484, 0xffff0000, 0x84c7ffff, 0x00015824,
    0xffffff00, 0x2484c7ff, 0x0000016c, 0xffffffff,
    0x802484c7, 0xff000001, 0xc7ffffff, 0x015c2484,
    0xffff0000, 0x84c7ffff, 0x00017024, 0xffffff00,
    0x2484c7ff, 0x00000184, 0xffffffff, 0x602484c7,
    0xff000001, 0xc7ffffff, 0x01742484, 0xffff0000,
    0x84c7ffff, 0x00018824, 0xffffff00, 0xebfb81ff,
    0x7c000000, 0x00eabb05, 0x7c800000, 0x0f022b24,
    0x00028082, 0x8cb60f00, 0x00045f24, 0x0fc98500,
    0x00027084, 0xb4b60f00, 0x00046024, 0xf6856600,
    0x025f840f, 0x438d0000, 0x2444891a, 0x8bc88934,
    0xf738247c, 0xc2a40fe7, 0x2494891a, 0x0000018c,
    0x8d02e1c1, 0xb70f490c, 0x8be7f7c6, 0x0f34247c,
    0x891ac2a4, 0x06e8c1c8, 0x89f4c083, 0x293c2444,
    0x249489c7, 0x00000190, 0x34244c89, 0xd231c889,
    0x0ff6f766, 0x8366c0b7, 0x408d18f8, 0xa9870ff4,
    0x01000000, 0x244c8bf8, 0x0fc83930, 0x0000af8e,
    0x24548b00, 0x0fd0392c, 0x0000b18c, 0x06c38300,
    0x4f248c88, 0x80000004, 0x032b247c, 0x00b3830f,
    0x8ce90000, 0x89000001, 0x89f139c2, 0x247489f7,
    0x2e8f0f30, 0x89fffffe, 0x245c8bce, 0x89d9392c,
    0x2c8c0fd9, 0x89fffffe, 0x0fc839f3, 0xfffe268c,
    0xfe23e9ff, 0x8366ffff, 0x0e721ffb, 0x082484f6,
    0x01000004, 0xfd7d840f, 0xdb01ffff, 0x249c8966,
    0x00000408, 0x0bfb8366, 0xfd69870f, 0x0cb0ffff,
    0xf6c0b60f, 0xc4b60ff3, 0x00000cb9, 0x66c12900,
    0x08248c89, 0xe9000004, 0xfffffd4b, 0x8302f8c1,
    0xf8010cc0, 0x30244c8b, 0x8f0fc839, 0xffffff51,
    0x548bc189, 0xd0392c24, 0xff4f8d0f, 0xd189ffff,
    0x8806c383, 0x044f248c, 0x7c800000, 0x0f032b24,
    0x0000de82, 0xb4b60f00, 0x00046124, 0xf6856600,
    0x00cd840f, 0xb70f0000, 0x2464f7c6, 0xc2a40f38,
    0x2494891a, 0x00000194, 0x3424448b, 0xf766d231,
    0xd0b70ff6, 0x66f4428d, 0x7718fa83, 0x8bf80125,
    0x39302454, 0x8b2b7ed0, 0x392c244c, 0x882d7cc8,
    0x04502494, 0x7c800000, 0x73042b24, 0x0081e92f,
    0xf8c10000, 0x0cc08302, 0x548bf801, 0xd0393024,
    0xc289d57f, 0x2c244c8b, 0xd37dc839, 0x9488ca89,
    0x00045024, 0x247c8000, 0x5772042b, 0x24b4b60f,
    0x00000462, 0x74f68566, 0xc6b70f4a, 0x382464f7,
    0x1ac2a40f, 0xb8249489, 0x8b000001, 0x31342444,
    0xf6f766d2, 0x8dd0b70f, 0x8366f442, 0x870f18fa,
    0x000000ba, 0x548bf801, 0xd0393024, 0x00c08e0f,
    0x4c8b0000, 0xc8392c24, 0xca89027d, 0x51249488,
    0x2b000004, 0x8b3c245c, 0x39302444, 0x3b687ec7,
    0x8b30245c, 0x7e2c244c, 0x7dcf396a, 0x24448b6e,
    0x88c3392c, 0x0443248c, 0x047c0000, 0x3024448b,
    0x45248488, 0x88000004, 0x043f248c, 0x84880000,
    0x00044124, 0x04806800, 0x448d0000, 0x6a504424,
    0xe8006a00, 0xffffe828, 0x8510c483, 0x836675c0,
    0x00680cec, 0xe8100000, 0xffffea14, 0x8d10c483,
    0x5f5ef465, 0x89c35d5b, 0x245c3bf8, 0x244c8b30,
    0x89967f2c, 0x3930245c, 0x89927ccf, 0x24448bc1,
    0x88c3392c, 0x0443248c, 0x907d0000, 0xf8c192eb,
    0x0cc08302, 0x548bf801, 0xd0393024, 0xff408f0f,
    0xc289ffff, 0x2c244c8b, 0x8c0fc839, 0xffffff3a,
    0xffff37e9, 0x0cec83ff, 0x00000068, 0xe9aee804,
    0xc483ffff, 0xcc88eb10, 0x24548b56, 0x24448b14,
    0xc1d18910, 0xc8311ff9, 0xc829ca31, 0x5489ca19,
    0x44891424, 0xce891024, 0x0c24548b, 0x0824448b,
    0xf9c1d189, 0x31c8311f, 0x19c829ca, 0x245489ca,
    0x2444890c, 0x53ce3108, 0x18245c8b, 0x0fcbbd0f,
    0x00008f84, 0x24448b00, 0xd1e8d314, 0xd3d1f7e8,
    0x8bc309e3, 0x8b102454, 0x390c2444, 0xf73773da,
    0xd1f757f3, 0xe8d3e8d1, 0x64f7c789, 0x5c8b1824,
    0x4c8b1024, 0xc3291424, 0x448bd119, 0xaf0f1c24,
    0x83c129c7, 0xd23100df, 0xf001f889, 0xf031f211,
    0x5b5ff231, 0xda29c35e, 0xf757f3f7, 0x0de8d1d1,
    0x80000000, 0xc789e8d3, 0x182464f7, 0x10245c8b,
    0x14244c8b, 0xd119c329, 0x1c24448b, 0x29c7af0f,
    0x00df83c1, 0xf889d231, 0xf211f001, 0xf231f031,
    0xc35e5b5f, 0x1024448b, 0x14244c8b, 0xf1f7d231,
    0x448bc389, 0xf1f70c24, 0xf001da89, 0xf031f211,
    0x5e5bf231, 0xccccccc3, 0x245c8b53, 0xcbbd0f14,
    0x448b7d74, 0xe8d31024, 0xd1f7e8d1, 0xc309e3d3,
    0x0c24548b, 0x0824448b, 0x2e73da39, 0xf757f3f7,
    0xd3e8d1d1, 0xf7c789e8, 0x8b142464, 0x8b0c245c,
    0x2910244c, 0x8bd119c3, 0x0f182444, 0xc129c7af,
    0x3100df83, 0x5ff889d2, 0xda29c35b, 0xf757f3f7,
    0x0de8d1d1, 0x80000000, 0xc789e8d3, 0x142464f7,
    0x0c245c8b, 0x10244c8b, 0xd119c329, 0x1824448b,
    0x29c7af0f, 0x00df83c1, 0xf889d231, 0x8bc35b5f,
    0x8b0c2444, 0x3110244c, 0x89f1f7d2, 0x24448bc3,
    0x89f1f708, 0xccc35bda, 0xcccccccc, 0xcccccccc,
    0xcccccccc, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0xcccccccc, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0x00080095, 0x00008e00, 0x0008009f, 0x00008e00,
    0x000800a9, 0x00008e00, 0x000800b3, 0x00008e00,
    0x000800bd, 0x00008e00, 0x000800c7, 0x00008e00,
    0x000800d1, 0x00008e00, 0x000800db, 0x00008e00,
    0x000800e5, 0x00008e00, 0x000800ed, 0x00008e00,
    0x000800f7, 0x00008e00, 0x000800ff, 0x00008e00,
    0x00080107, 0x00008e00, 0x0008010f, 0x00008e00,
    0x00080117, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080129, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x000801b1, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x000801a0, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x000801bf, 0x00008e00,
    0x00000250, 0x00000260, 0x00000280, 0x00000270,
    0x00000290, 0x000002a0, 0x000002b0, 0x000002c0,
    0x000002d0, 0x000002e0, 0x000002f0, 0x00000300,
    0x00000310, 0x00000320, 0x00000330, 0x00000080,
    0x00000350, 0x00000080, 0x00000080, 0x00000080,
    0x00000080, 0x00000080, 0x00000080, 0x00000080,
    0x00000080, 0x00000080, 0x00000080, 0x00000080,
    0x00000080, 0x00000080, 0x00000080, 0x00000080,
    0x00000004, 0x0000000c, 0x00000014, 0x0000001c,
    0x00000024, 0x0000002c, 0x00000034, 0x0000003c,
    0x00000044, 0x0000004c, 0x00000054, 0x0000005c,
    0x00000064, 0x0000006c, 0x00000074, 0x0000007c,
    0x00000000, 0x00000008, 0x00000010, 0x00000018,
    0x00000020, 0x00000028, 0x00000030, 0x00000038,
    0x00000040, 0x00000048, 0x00000050, 0x00000058,
    0x00000060, 0x00000068, 0x00000070, 0x00000078,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
};
