/+ D bindings to the GNU gettext runtime library.
   Copyright © 2025-2026 Free Software Foundation, Inc.

   Boost Software License - Version 1.0 - August 17th, 2003

   Permission is hereby granted, free of charge, to any person or organization
   obtaining a copy of the software and accompanying documentation covered by
   this license (the "Software") to use, reproduce, display, distribute,
   execute, and transmit the Software, and to prepare derivative works of the
   Software, and to permit third-parties to whom the Software is furnished to
   do so, all subject to the following:

   The copyright notices in the Software and this entire statement, including
   the above license grant, this restriction and the following disclaimer,
   must be included in all copies of the Software, in whole or in part, and
   all derivative works of the Software, unless such copies or derivative
   works are solely in the form of machine-executable object code generated by
   a source language processor.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
   SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
   FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
   DEALINGS IN THE SOFTWARE.
 +/

/* Written by Bruno Haible.  */

module gnu.libintl.internal.low;

/* <libintl.h> API  */

// On some platforms (glibc, musl libc, NetBSD), the symbols have no prefix at
// the linker level. On other platforms, the symbols exist both prefixed with
// 'libintl_' at the linker level and without prefix (see intl-compat.c).
// We can therefore use the symbols without prefix unconditionally.
  private extern (C) const(char) * gettext (const(char) *msgid);
  private extern (C) const(char) * dgettext (const(char) *domainname, const(char) *msgid);
  private extern (C) const(char) * dcgettext (const(char) *domainname, const(char) *msgid, int category);
  private extern (C) const(char) * ngettext (const(char) *msgid, const(char) *msgid_plural, ulong n);
  private extern (C) const(char) * dngettext (const(char) *domainname, const(char) *msgid, const(char) *msgid_plural, ulong n);
  private extern (C) const(char) * dcngettext (const(char) *domainname, const(char) *msgid, const(char) *msgid_plural, ulong n, int category);
  private extern (C) const(char) * textdomain (const(char) *domainname);
  private extern (C) const(char) * bindtextdomain (const(char) *domainname, const(char) *dirname);
  private extern (C) const(char) * bind_textdomain_codeset (const(char) *domainname, const(char) *codeset);
  alias unsafe_gettext                 = gettext;
  alias unsafe_dgettext                = dgettext;
  alias unsafe_dcgettext               = dcgettext;
  alias unsafe_ngettext                = ngettext;
  alias unsafe_dngettext               = dngettext;
  alias unsafe_dcngettext              = dcngettext;
  alias unsafe_textdomain              = textdomain;
  alias unsafe_bindtextdomain          = bindtextdomain;
  alias unsafe_bind_textdomain_codeset = bind_textdomain_codeset;
/+
  // The symbols are prefixed with 'libintl_' at the linker level.
  private extern (C) const(char) * libintl_gettext (const(char) *msgid);
  private extern (C) const(char) * libintl_dgettext (const(char) *domainname, const(char) *msgid);
  private extern (C) const(char) * libintl_dcgettext (const(char) *domainname, const(char) *msgid, int category);
  private extern (C) const(char) * libintl_ngettext (const(char) *msgid, const(char) *msgid_plural, ulong n);
  private extern (C) const(char) * libintl_dngettext (const(char) *domainname, const(char) *msgid, const(char) *msgid_plural, ulong n);
  private extern (C) const(char) * libintl_dcngettext (const(char) *domainname, const(char) *msgid, const(char) *msgid_plural, ulong n, int category);
  private extern (C) const(char) * libintl_textdomain (const(char) *domainname);
  private extern (C) const(char) * libintl_bindtextdomain (const(char) *domainname, const(char) *dirname);
  private extern (C) const(char) * libintl_bind_textdomain_codeset (const(char) *domainname, const(char) *codeset);
  alias unsafe_gettext                 = libintl_gettext;
  alias unsafe_dgettext                = libintl_dgettext;
  alias unsafe_dcgettext               = libintl_dcgettext;
  alias unsafe_ngettext                = libintl_ngettext;
  alias unsafe_dngettext               = libintl_dngettext;
  alias unsafe_dcngettext              = libintl_dcngettext;
  alias unsafe_textdomain              = libintl_textdomain;
  alias unsafe_bindtextdomain          = libintl_bindtextdomain;
  alias unsafe_bind_textdomain_codeset = libintl_bind_textdomain_codeset;
+/

/* <locale.h> / <libintl.h> API  */

version (OSX)
  version = OverriddenSetlocale;
else version (Windows)
  version = OverriddenSetlocale;
else version (Cygwin)
  version = OverriddenSetlocale;

version (OverriddenSetlocale) {
  /* Support for the locale chosen by the user.  */
  private extern (C) char * libintl_setlocale (int category, const(char) * locale);
  alias unsafe_setlocale = libintl_setlocale;
} else {
  /* <https://dlang.org/library/core/stdc/locale/setlocale.html>.  */
  import core.stdc.locale : setlocale;
  alias unsafe_setlocale = setlocale;
}
