/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf;

import java.io.IOException;
import org.openrdf.sail.nativerdf.btree.RecordIterator;

abstract class RecordCache {
    protected final long maxRecords;
    private long recordCount;

    public RecordCache() throws IOException {
        this(Long.MAX_VALUE);
    }

    public RecordCache(long maxRecords) throws IOException {
        this.maxRecords = maxRecords;
        this.recordCount = 0L;
    }

    public abstract void discard() throws IOException;

    public final boolean isValid() {
        return this.recordCount < this.maxRecords;
    }

    public final void storeRecord(byte[] data) throws IOException {
        if (this.isValid()) {
            this.storeRecordInternal(data);
            ++this.recordCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void storeRecords(RecordCache other) throws IOException {
        if (this.isValid()) {
            RecordIterator recIter = other.getRecords();
            try {
                byte[] record;
                while ((record = recIter.next()) != null) {
                    this.storeRecordInternal(record);
                }
            }
            finally {
                recIter.close();
            }
        }
    }

    public abstract void storeRecordInternal(byte[] var1) throws IOException;

    public final RecordIterator getRecords() {
        if (this.isValid()) {
            return this.getRecordsInternal();
        }
        throw new IllegalStateException();
    }

    public abstract RecordIterator getRecordsInternal();

    public final long getRecordCount() {
        if (this.isValid()) {
            return this.recordCount;
        }
        throw new IllegalStateException();
    }
}

