// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// When writing a match expression against `VideoFormat`, it is important to ensure
/// your code is forward-compatible. That is, if a match arm handles a case for a
/// feature that is supported by the service but has not been represented as an enum
/// variant in a current version of SDK, your code should continue to work when you
/// upgrade SDK to a future version in which the enum does include a variant for that
/// feature.
///
/// Here is an example of how you can make a match expression forward-compatible:
///
/// ```text
/// # let videoformat = unimplemented!();
/// match videoformat {
///     VideoFormat::Flv => { /* ... */ },
///     VideoFormat::Mkv => { /* ... */ },
///     VideoFormat::Mov => { /* ... */ },
///     VideoFormat::Mp4 => { /* ... */ },
///     VideoFormat::Mpeg => { /* ... */ },
///     VideoFormat::Mpg => { /* ... */ },
///     VideoFormat::ThreeGp => { /* ... */ },
///     VideoFormat::Webm => { /* ... */ },
///     VideoFormat::Wmv => { /* ... */ },
///     other @ _ if other.as_str() == "NewFeature" => { /* handles a case for `NewFeature` */ },
///     _ => { /* ... */ },
/// }
/// ```
/// The above code demonstrates that when `videoformat` represents
/// `NewFeature`, the execution path will lead to the second last match arm,
/// even though the enum does not contain a variant `VideoFormat::NewFeature`
/// in the current version of SDK. The reason is that the variable `other`,
/// created by the `@` operator, is bound to
/// `VideoFormat::Unknown(UnknownVariantValue("NewFeature".to_owned()))`
/// and calling `as_str` on it yields `"NewFeature"`.
/// This match expression is forward-compatible when executed with a newer
/// version of SDK where the variant `VideoFormat::NewFeature` is defined.
/// Specifically, when `videoformat` represents `NewFeature`,
/// the execution path will hit the second last match arm as before by virtue of
/// calling `as_str` on `VideoFormat::NewFeature` also yielding `"NewFeature"`.
///
/// Explicitly matching on the `Unknown` variant should
/// be avoided for two reasons:
/// - The inner data `UnknownVariantValue` is opaque, and no further information can be extracted.
/// - It might inadvertently shadow other intended match arms.
///
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    ::std::clone::Clone, ::std::cmp::Eq, ::std::cmp::Ord, ::std::cmp::PartialEq, ::std::cmp::PartialOrd, ::std::fmt::Debug, ::std::hash::Hash,
)]
pub enum VideoFormat {
    #[allow(missing_docs)] // documentation missing in model
    Flv,
    #[allow(missing_docs)] // documentation missing in model
    Mkv,
    #[allow(missing_docs)] // documentation missing in model
    Mov,
    #[allow(missing_docs)] // documentation missing in model
    Mp4,
    #[allow(missing_docs)] // documentation missing in model
    Mpeg,
    #[allow(missing_docs)] // documentation missing in model
    Mpg,
    #[allow(missing_docs)] // documentation missing in model
    ThreeGp,
    #[allow(missing_docs)] // documentation missing in model
    Webm,
    #[allow(missing_docs)] // documentation missing in model
    Wmv,
    /// `Unknown` contains new variants that have been added since this code was generated.
    #[deprecated(note = "Don't directly match on `Unknown`. See the docs on this enum for the correct way to handle unknown variants.")]
    Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue),
}
impl ::std::convert::From<&str> for VideoFormat {
    fn from(s: &str) -> Self {
        match s {
            "flv" => VideoFormat::Flv,
            "mkv" => VideoFormat::Mkv,
            "mov" => VideoFormat::Mov,
            "mp4" => VideoFormat::Mp4,
            "mpeg" => VideoFormat::Mpeg,
            "mpg" => VideoFormat::Mpg,
            "three_gp" => VideoFormat::ThreeGp,
            "webm" => VideoFormat::Webm,
            "wmv" => VideoFormat::Wmv,
            other => VideoFormat::Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue(other.to_owned())),
        }
    }
}
impl ::std::str::FromStr for VideoFormat {
    type Err = ::std::convert::Infallible;

    fn from_str(s: &str) -> ::std::result::Result<Self, <Self as ::std::str::FromStr>::Err> {
        ::std::result::Result::Ok(VideoFormat::from(s))
    }
}
impl VideoFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VideoFormat::Flv => "flv",
            VideoFormat::Mkv => "mkv",
            VideoFormat::Mov => "mov",
            VideoFormat::Mp4 => "mp4",
            VideoFormat::Mpeg => "mpeg",
            VideoFormat::Mpg => "mpg",
            VideoFormat::ThreeGp => "three_gp",
            VideoFormat::Webm => "webm",
            VideoFormat::Wmv => "wmv",
            VideoFormat::Unknown(value) => value.as_str(),
        }
    }
    /// Returns all the `&str` representations of the enum members.
    pub const fn values() -> &'static [&'static str] {
        &["flv", "mkv", "mov", "mp4", "mpeg", "mpg", "three_gp", "webm", "wmv"]
    }
}
impl ::std::convert::AsRef<str> for VideoFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
impl VideoFormat {
    /// Parses the enum value while disallowing unknown variants.
    ///
    /// Unknown variants will result in an error.
    pub fn try_parse(value: &str) -> ::std::result::Result<Self, crate::error::UnknownVariantError> {
        match Self::from(value) {
            #[allow(deprecated)]
            Self::Unknown(_) => ::std::result::Result::Err(crate::error::UnknownVariantError::new(value)),
            known => Ok(known),
        }
    }
}
impl ::std::fmt::Display for VideoFormat {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        match self {
            VideoFormat::Flv => write!(f, "flv"),
            VideoFormat::Mkv => write!(f, "mkv"),
            VideoFormat::Mov => write!(f, "mov"),
            VideoFormat::Mp4 => write!(f, "mp4"),
            VideoFormat::Mpeg => write!(f, "mpeg"),
            VideoFormat::Mpg => write!(f, "mpg"),
            VideoFormat::ThreeGp => write!(f, "three_gp"),
            VideoFormat::Webm => write!(f, "webm"),
            VideoFormat::Wmv => write!(f, "wmv"),
            VideoFormat::Unknown(value) => write!(f, "{value}"),
        }
    }
}
