// Copyright (c) Gianluca Piccirillo
// Copyright (c) Owen Ou
// SPDX-License-Identifier: MIT

package tmux

import (
	"context"
	"errors"
)

// Tmux Socket object.
//
// Reference: https://man.openbsd.org/OpenBSD-current/man1/tmux.1#S
type Socket struct {
	Path string
}

// Creates a new socket object. Verifies its validtity.
func newSocket(path string) (*Socket, error) {
	s := &Socket{}
	if !s.validateSocket(path) {
		return nil, errors.New("invalid socket")
	}
	s.Path = path
	return s, nil
}

// Valides a sockets validity
func (s *Socket) validateSocket(path string) bool {
	_, err := newQuery().
		cmd("-S", path, "list-clients").
		run(context.Background())
	return err == nil
}
