/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.servlet.DispatcherType;
import org.eclipse.jetty.servlet.FilterMapping;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;

public class PaxWebFilterMapping
extends FilterMapping {
    private final FilterModel filterModel;
    private final long timestamp;
    private final boolean after;
    private final int order;

    public PaxWebFilterMapping(FilterModel filterModel, FilterModel.Mapping mapping) {
        this.filterModel = filterModel;
        this.timestamp = filterModel.getTimestamp();
        ArrayList types = new ArrayList();
        Collections.addAll(types, mapping.getDispatcherTypes());
        this.setDispatcherTypes(EnumSet.copyOf(types));
        this.setFilterName(filterModel.getName());
        this.setPathSpecs(mapping.getUrlPatterns());
        this.setServletNames(mapping.getServletNames());
        String[] regexMapping = mapping.getRegexPatterns();
        if (regexMapping != null && regexMapping.length > 0) {
            this.setPathSpecs(new String[]{"/*"});
        }
        this.after = true;
        this.order = mapping.getOrder();
    }

    public PaxWebFilterMapping(FilterModel filterModel, FilterModel.DynamicMapping dynamicMapping) {
        this.filterModel = filterModel;
        this.timestamp = filterModel.getTimestamp();
        if (dynamicMapping.getDispatcherTypes() != null) {
            List<DispatcherType> types = Arrays.asList(dynamicMapping.getDispatcherTypes());
            this.setDispatcherTypes(EnumSet.copyOf(types));
        }
        this.setFilterName(filterModel.getName());
        this.setPathSpecs(dynamicMapping.getUrlPatterns());
        this.setServletNames(dynamicMapping.getServletNames());
        this.after = dynamicMapping.isAfter();
        this.order = 0;
    }

    public FilterModel getFilterModel() {
        return this.filterModel;
    }

    public boolean isAfter() {
        return this.after;
    }

    public int getOrder() {
        return this.order;
    }
}

