/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.component.dsl.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.aries.component.dsl.Publisher;
import org.apache.aries.component.dsl.internal.OSGiImpl;
import org.apache.aries.component.dsl.internal.OSGiResultImpl;
import org.apache.aries.component.dsl.internal.UpdateSupport;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;

public class ConfigurationOSGiImpl
extends OSGiImpl<Dictionary<String, ?>> {
    public ConfigurationOSGiImpl(String pid) {
        super((BundleContext bundleContext, Publisher<T> op) -> {
            Configuration configuration;
            AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
            AtomicReference<Runnable> terminatorAtomicReference = new AtomicReference<Runnable>(() -> {});
            AtomicBoolean closed = new AtomicBoolean();
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ServiceRegistration serviceRegistration = bundleContext.registerService(ConfigurationListener.class, configurationEvent -> {
                if (configurationEvent.getFactoryPid() != null || !configurationEvent.getPid().equals(pid)) {
                    return;
                }
                try {
                    countDownLatch.await(1L, TimeUnit.MINUTES);
                }
                catch (InterruptedException e) {
                    return;
                }
                if (configurationEvent.getType() == 2) {
                    atomicReference.set(null);
                    ConfigurationOSGiImpl.signalLeave(terminatorAtomicReference);
                } else {
                    Configuration configuration = ConfigurationOSGiImpl.getConfiguration(bundleContext, configurationEvent);
                    if (configuration == null) {
                        return;
                    }
                    Configuration old = (Configuration)atomicReference.get();
                    if (old == null || configuration.getChangeCount() != old.getChangeCount()) {
                        atomicReference.set(configuration);
                    }
                    UpdateSupport.runUpdate(() -> {
                        ConfigurationOSGiImpl.signalLeave(terminatorAtomicReference);
                        terminatorAtomicReference.set((Runnable)op.apply(configuration.getProperties()));
                    });
                    if (closed.get()) {
                        ConfigurationOSGiImpl.signalLeave(terminatorAtomicReference);
                    }
                }
            }, new Hashtable());
            ServiceReference serviceReference = bundleContext.getServiceReference(ConfigurationAdmin.class);
            if (serviceReference != null && (configuration = ConfigurationOSGiImpl.getConfiguration(bundleContext, pid, (ServiceReference<ConfigurationAdmin>)serviceReference)) != null) {
                atomicReference.set(configuration);
                terminatorAtomicReference.set((Runnable)op.apply(configuration.getProperties()));
            }
            countDownLatch.countDown();
            return new OSGiResultImpl(() -> {
                closed.set(true);
                serviceRegistration.unregister();
                ConfigurationOSGiImpl.signalLeave(terminatorAtomicReference);
            });
        });
    }

    private static Configuration getConfiguration(BundleContext bundleContext, ConfigurationEvent configurationEvent) {
        String pid = configurationEvent.getPid();
        ServiceReference reference = configurationEvent.getReference();
        return ConfigurationOSGiImpl.getConfiguration(bundleContext, pid, (ServiceReference<ConfigurationAdmin>)reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Configuration getConfiguration(BundleContext bundleContext, String pid, ServiceReference<ConfigurationAdmin> reference) {
        ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)bundleContext.getService(reference);
        try {
            Configuration[] configurations = configurationAdmin.listConfigurations("(&(service.pid=" + pid + ")(!(service.factoryPid=*)))");
            if (configurations == null || configurations.length == 0) {
                Configuration configuration = null;
                return configuration;
            }
            Configuration configuration = configurations[0];
            return configuration;
        }
        catch (Exception e) {
            Configuration configuration = null;
            return configuration;
        }
        finally {
            bundleContext.ungetService(reference);
        }
    }

    private static void signalLeave(AtomicReference<Runnable> terminatorAtomicReference) {
        Runnable old = terminatorAtomicReference.getAndSet(null);
        if (old != null) {
            old.run();
        }
    }
}

