/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_zh extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_type_nu_gong = "马萨拉姆冈德数字";
        final String metaValue_key_nu = "数字";
        final Object[][] data = new Object[][] {
            { "001", "世界" },
            { "002", "非洲" },
            { "003", "北美洲" },
            { "005", "南美洲" },
            { "009", "大洋洲" },
            { "011", "西非" },
            { "013", "中美洲" },
            { "014", "东非" },
            { "015", "北非" },
            { "017", "中非" },
            { "018", "南部非洲" },
            { "019", "美洲" },
            { "021", "美洲北部" },
            { "029", "加勒比地区" },
            { "030", "东亚" },
            { "034", "南亚" },
            { "035", "东南亚" },
            { "039", "南欧" },
            { "053", "澳大拉西亚" },
            { "054", "美拉尼西亚" },
            { "057", "密克罗尼西亚地区" },
            { "061", "玻利尼西亚" },
            { "142", "亚洲" },
            { "143", "中亚" },
            { "145", "西亚" },
            { "150", "欧洲" },
            { "151", "东欧" },
            { "154", "北欧" },
            { "155", "西欧" },
            { "202", "撒哈拉以南非洲" },
            { "419", "拉丁美洲" },
            { "AC", "阿森松岛" },
            { "AD", "安道尔" },
            { "AE", "阿拉伯联合酋长国" },
            { "AF", "阿富汗" },
            { "AG", "安提瓜和巴布达" },
            { "AI", "安圭拉" },
            { "AL", "阿尔巴尼亚" },
            { "AM", "亚美尼亚" },
            { "AO", "安哥拉" },
            { "AQ", "南极洲" },
            { "AR", "阿根廷" },
            { "AS", "美属萨摩亚" },
            { "AT", "奥地利" },
            { "AU", "澳大利亚" },
            { "AW", "阿鲁巴" },
            { "AX", "奥兰群岛" },
            { "AZ", "阿塞拜疆" },
            { "BA", "波斯尼亚和黑塞哥维那" },
            { "BB", "巴巴多斯" },
            { "BD", "孟加拉国" },
            { "BE", "比利时" },
            { "BF", "布基纳法索" },
            { "BG", "保加利亚" },
            { "BH", "巴林" },
            { "BI", "布隆迪" },
            { "BJ", "贝宁" },
            { "BL", "圣巴泰勒米" },
            { "BM", "百慕大" },
            { "BN", "文莱" },
            { "BO", "玻利维亚" },
            { "BQ", "荷属加勒比区" },
            { "BR", "巴西" },
            { "BS", "巴哈马" },
            { "BT", "不丹" },
            { "BV", "布韦岛" },
            { "BW", "博茨瓦纳" },
            { "BY", "白俄罗斯" },
            { "BZ", "伯利兹" },
            { "CA", "加拿大" },
            { "CC", "科科斯（基林）群岛" },
            { "CD", "刚果（金）" },
            { "CF", "中非共和国" },
            { "CG", "刚果（布）" },
            { "CH", "瑞士" },
            { "CI", "科特迪瓦" },
            { "CK", "库克群岛" },
            { "CL", "智利" },
            { "CM", "喀麦隆" },
            { "CN", "中国" },
            { "CO", "哥伦比亚" },
            { "CP", "克利珀顿岛" },
            { "CQ", "萨克岛" },
            { "CR", "哥斯达黎加" },
            { "CU", "古巴" },
            { "CV", "佛得角" },
            { "CW", "库拉索" },
            { "CX", "圣诞岛" },
            { "CY", "塞浦路斯" },
            { "CZ", "捷克" },
            { "DE", "德国" },
            { "DG", "迪戈加西亚岛" },
            { "DJ", "吉布提" },
            { "DK", "丹麦" },
            { "DM", "多米尼克" },
            { "DO", "多米尼加共和国" },
            { "DZ", "阿尔及利亚" },
            { "EA", "休达及梅利利亚" },
            { "EC", "厄瓜多尔" },
            { "EE", "爱沙尼亚" },
            { "EG", "埃及" },
            { "EH", "西撒哈拉" },
            { "ER", "厄立特里亚" },
            { "ES", "西班牙" },
            { "ET", "埃塞俄比亚" },
            { "EU", "欧盟" },
            { "EZ", "欧元区" },
            { "FI", "芬兰" },
            { "FJ", "斐济" },
            { "FK", "福克兰群岛" },
            { "FM", "密克罗尼西亚" },
            { "FO", "法罗群岛" },
            { "FR", "法国" },
            { "GA", "加蓬" },
            { "GB", "英国" },
            { "GD", "格林纳达" },
            { "GE", "格鲁吉亚" },
            { "GF", "法属圭亚那" },
            { "GG", "根西岛" },
            { "GH", "加纳" },
            { "GI", "直布罗陀" },
            { "GL", "格陵兰" },
            { "GM", "冈比亚" },
            { "GN", "几内亚" },
            { "GP", "瓜德罗普" },
            { "GQ", "赤道几内亚" },
            { "GR", "希腊" },
            { "GS", "南乔治亚和南桑威奇群岛" },
            { "GT", "危地马拉" },
            { "GU", "关岛" },
            { "GW", "几内亚比绍" },
            { "GY", "圭亚那" },
            { "HK", "中国香港特别行政区" },
            { "HM", "赫德岛和麦克唐纳群岛" },
            { "HN", "洪都拉斯" },
            { "HR", "克罗地亚" },
            { "HT", "海地" },
            { "HU", "匈牙利" },
            { "IC", "加纳利群岛" },
            { "ID", "印度尼西亚" },
            { "IE", "爱尔兰" },
            { "IL", "以色列" },
            { "IM", "马恩岛" },
            { "IN", "印度" },
            { "IO", "英属印度洋领地" },
            { "IQ", "伊拉克" },
            { "IR", "伊朗" },
            { "IS", "冰岛" },
            { "IT", "意大利" },
            { "JE", "泽西岛" },
            { "JM", "牙买加" },
            { "JO", "约旦" },
            { "JP", "日本" },
            { "KE", "肯尼亚" },
            { "KG", "吉尔吉斯斯坦" },
            { "KH", "柬埔寨" },
            { "KI", "基里巴斯" },
            { "KM", "科摩罗" },
            { "KN", "圣基茨和尼维斯" },
            { "KP", "朝鲜" },
            { "KR", "韩国" },
            { "KW", "科威特" },
            { "KY", "开曼群岛" },
            { "KZ", "哈萨克斯坦" },
            { "LA", "老挝" },
            { "LB", "黎巴嫩" },
            { "LC", "圣卢西亚" },
            { "LI", "列支敦士登" },
            { "LK", "斯里兰卡" },
            { "LR", "利比里亚" },
            { "LS", "莱索托" },
            { "LT", "立陶宛" },
            { "LU", "卢森堡" },
            { "LV", "拉脱维亚" },
            { "LY", "利比亚" },
            { "MA", "摩洛哥" },
            { "MC", "摩纳哥" },
            { "MD", "摩尔多瓦" },
            { "ME", "黑山" },
            { "MF", "法属圣马丁" },
            { "MG", "马达加斯加" },
            { "MH", "马绍尔群岛" },
            { "MK", "北马其顿" },
            { "ML", "马里" },
            { "MM", "缅甸" },
            { "MN", "蒙古" },
            { "MO", "中国澳门特别行政区" },
            { "MP", "北马里亚纳群岛" },
            { "MQ", "马提尼克" },
            { "MR", "毛里塔尼亚" },
            { "MS", "蒙特塞拉特" },
            { "MT", "马耳他" },
            { "MU", "毛里求斯" },
            { "MV", "马尔代夫" },
            { "MW", "马拉维" },
            { "MX", "墨西哥" },
            { "MY", "马来西亚" },
            { "MZ", "莫桑比克" },
            { "NA", "纳米比亚" },
            { "NC", "新喀里多尼亚" },
            { "NE", "尼日尔" },
            { "NF", "诺福克岛" },
            { "NG", "尼日利亚" },
            { "NI", "尼加拉瓜" },
            { "NL", "荷兰" },
            { "NO", "挪威" },
            { "NP", "尼泊尔" },
            { "NR", "瑙鲁" },
            { "NU", "纽埃" },
            { "NZ", "新西兰" },
            { "OM", "阿曼" },
            { "PA", "巴拿马" },
            { "PE", "秘鲁" },
            { "PF", "法属波利尼西亚" },
            { "PG", "巴布亚新几内亚" },
            { "PH", "菲律宾" },
            { "PK", "巴基斯坦" },
            { "PL", "波兰" },
            { "PM", "圣皮埃尔和密克隆群岛" },
            { "PN", "皮特凯恩群岛" },
            { "PR", "波多黎各" },
            { "PS", "巴勒斯坦领土" },
            { "PT", "葡萄牙" },
            { "PW", "帕劳" },
            { "PY", "巴拉圭" },
            { "QA", "卡塔尔" },
            { "QO", "大洋洲边远群岛" },
            { "RE", "留尼汪" },
            { "RO", "罗马尼亚" },
            { "RS", "塞尔维亚" },
            { "RU", "俄罗斯" },
            { "RW", "卢旺达" },
            { "SA", "沙特阿拉伯" },
            { "SB", "所罗门群岛" },
            { "SC", "塞舌尔" },
            { "SD", "苏丹" },
            { "SE", "瑞典" },
            { "SG", "新加坡" },
            { "SH", "圣赫勒拿" },
            { "SI", "斯洛文尼亚" },
            { "SJ", "斯瓦尔巴和扬马延" },
            { "SK", "斯洛伐克" },
            { "SL", "塞拉利昂" },
            { "SM", "圣马力诺" },
            { "SN", "塞内加尔" },
            { "SO", "索马里" },
            { "SR", "苏里南" },
            { "SS", "南苏丹" },
            { "ST", "圣多美和普林西比" },
            { "SV", "萨尔瓦多" },
            { "SX", "荷属圣马丁" },
            { "SY", "叙利亚" },
            { "SZ", "斯威士兰" },
            { "TA", "特里斯坦-达库尼亚群岛" },
            { "TC", "特克斯和凯科斯群岛" },
            { "TD", "乍得" },
            { "TF", "法属南部领地" },
            { "TG", "多哥" },
            { "TH", "泰国" },
            { "TJ", "塔吉克斯坦" },
            { "TK", "托克劳" },
            { "TL", "东帝汶" },
            { "TM", "土库曼斯坦" },
            { "TN", "突尼斯" },
            { "TO", "汤加" },
            { "TR", "土耳其" },
            { "TT", "特立尼达和多巴哥" },
            { "TV", "图瓦卢" },
            { "TW", "台湾" },
            { "TZ", "坦桑尼亚" },
            { "UA", "乌克兰" },
            { "UG", "乌干达" },
            { "UM", "美国本土外小岛屿" },
            { "UN", "联合国" },
            { "US", "美国" },
            { "UY", "乌拉圭" },
            { "UZ", "乌兹别克斯坦" },
            { "VA", "梵蒂冈" },
            { "VC", "圣文森特和格林纳丁斯" },
            { "VE", "委内瑞拉" },
            { "VG", "英属维尔京群岛" },
            { "VI", "美属维尔京群岛" },
            { "VN", "越南" },
            { "VU", "瓦努阿图" },
            { "WF", "瓦利斯和富图纳" },
            { "WS", "萨摩亚" },
            { "XA", "伪地区" },
            { "XB", "伪双向语言地区" },
            { "XK", "科索沃" },
            { "YE", "也门" },
            { "YT", "马约特" },
            { "ZA", "南非" },
            { "ZM", "赞比亚" },
            { "ZW", "津巴布韦" },
            { "ZZ", "未知地区" },
            { "aa", "阿法尔语" },
            { "ab", "阿布哈西亚语" },
            { "ae", "阿维斯塔语" },
            { "af", "南非荷兰语" },
            { "ak", "阿肯语" },
            { "am", "阿姆哈拉语" },
            { "an", "阿拉贡语" },
            { "ar", "阿拉伯语" },
            { "as", "阿萨姆语" },
            { "av", "阿瓦尔语" },
            { "ay", "艾马拉语" },
            { "az", "阿塞拜疆语" },
            { "ba", "巴什基尔语" },
            { "be", "白俄罗斯语" },
            { "bg", "保加利亚语" },
            { "bi", "比斯拉马语" },
            { "bm", "班巴拉语" },
            { "bn", "孟加拉语" },
            { "bo", "藏语" },
            { "br", "布列塔尼语" },
            { "bs", "波斯尼亚语" },
            { "ca", "加泰罗尼亚语" },
            { "ce", "车臣语" },
            { "ch", "查莫罗语" },
            { "co", "科西嘉语" },
            { "cr", "克里语" },
            { "cs", "捷克语" },
            { "cu", "教会斯拉夫语" },
            { "cv", "楚瓦什语" },
            { "cy", "威尔士语" },
            { "da", "丹麦语" },
            { "de", "德语" },
            { "dv", "迪维希语" },
            { "dz", "宗卡语" },
            { "ee", "埃维语" },
            { "el", "希腊语" },
            { "en", "英语" },
            { "eo", "世界语" },
            { "es", "西班牙语" },
            { "et", "爱沙尼亚语" },
            { "eu", "巴斯克语" },
            { "fa", "波斯语" },
            { "ff", "富拉语" },
            { "fi", "芬兰语" },
            { "fj", "斐济语" },
            { "fo", "法罗语" },
            { "fr", "法语" },
            { "fy", "西弗里西亚语" },
            { "ga", "爱尔兰语" },
            { "gd", "苏格兰盖尔语" },
            { "gl", "加利西亚语" },
            { "gn", "瓜拉尼语" },
            { "gu", "古吉拉特语" },
            { "gv", "马恩语" },
            { "ha", "豪萨语" },
            { "he", "希伯来语" },
            { "hi", "印地语" },
            { "ho", "希里莫图语" },
            { "hr", "克罗地亚语" },
            { "ht", "海地克里奥尔语" },
            { "hu", "匈牙利语" },
            { "hy", "亚美尼亚语" },
            { "hz", "赫雷罗语" },
            { "ia", "国际语" },
            { "id", "印度尼西亚语" },
            { "ie", "国际文字（E）" },
            { "ig", "伊博语" },
            { "ii", "凉山彝语" },
            { "ik", "伊努皮克语" },
            { "io", "伊多语" },
            { "is", "冰岛语" },
            { "it", "意大利语" },
            { "iu", "因纽特语" },
            { "ja", "日语" },
            { "jv", "爪哇语" },
            { "ka", "格鲁吉亚语" },
            { "kg", "刚果语" },
            { "ki", "吉库尤语" },
            { "kj", "宽亚玛语" },
            { "kk", "哈萨克语" },
            { "kl", "格陵兰语" },
            { "km", "高棉语" },
            { "kn", "卡纳达语" },
            { "ko", "韩语" },
            { "kr", "卡努里语" },
            { "ks", "克什米尔语" },
            { "ku", "北库尔德语" },
            { "kv", "科米语" },
            { "kw", "康沃尔语" },
            { "ky", "吉尔吉斯语" },
            { "la", "拉丁语" },
            { "lb", "卢森堡语" },
            { "lg", "卢干达语" },
            { "li", "林堡语" },
            { "ln", "林加拉语" },
            { "lo", "老挝语" },
            { "lt", "立陶宛语" },
            { "lu", "鲁巴加丹加语" },
            { "lv", "拉脱维亚语" },
            { "mg", "马拉加斯语" },
            { "mh", "马绍尔语" },
            { "mi", "毛利语" },
            { "mk", "马其顿语" },
            { "ml", "马拉雅拉姆语" },
            { "mn", "蒙古语" },
            { "mr", "马拉地语" },
            { "ms", "马来语" },
            { "mt", "马耳他语" },
            { "my", "缅甸语" },
            { "na", "瑙鲁语" },
            { "nb", "书面挪威语" },
            { "nd", "北恩德贝勒语" },
            { "ne", "尼泊尔语" },
            { "ng", "恩东加语" },
            { "nl", "荷兰语" },
            { "nn", "挪威尼诺斯克语" },
            { "no", "挪威语" },
            { "nr", "南恩德贝勒语" },
            { "nv", "纳瓦霍语" },
            { "ny", "齐切瓦语" },
            { "oc", "奥克语" },
            { "oj", "奥吉布瓦语" },
            { "om", "奥罗莫语" },
            { "or", "奥里亚语" },
            { "os", "奥塞梯语" },
            { "pa", "旁遮普语" },
            { "pi", "巴利语" },
            { "pl", "波兰语" },
            { "ps", "普什图语" },
            { "pt", "葡萄牙语" },
            { "qu", "克丘亚语" },
            { "rm", "罗曼什语" },
            { "rn", "隆迪语" },
            { "ro", "罗马尼亚语" },
            { "ru", "俄语" },
            { "rw", "卢旺达语" },
            { "sa", "梵语" },
            { "sc", "萨丁语" },
            { "sd", "信德语" },
            { "se", "北方萨米语" },
            { "sg", "桑戈语" },
            { "sh", "塞尔维亚-克罗地亚语" },
            { "si", "僧伽罗语" },
            { "sk", "斯洛伐克语" },
            { "sl", "斯洛文尼亚语" },
            { "sm", "萨摩亚语" },
            { "sn", "绍纳语" },
            { "so", "索马里语" },
            { "sq", "阿尔巴尼亚语" },
            { "sr", "塞尔维亚语" },
            { "ss", "斯瓦蒂语" },
            { "st", "南索托语" },
            { "su", "巽他语" },
            { "sv", "瑞典语" },
            { "sw", "斯瓦希里语" },
            { "ta", "泰米尔语" },
            { "te", "泰卢固语" },
            { "tg", "塔吉克语" },
            { "th", "泰语" },
            { "ti", "提格利尼亚语" },
            { "tk", "土库曼语" },
            { "tl", "他加禄语" },
            { "tn", "茨瓦纳语" },
            { "to", "汤加语" },
            { "tr", "土耳其语" },
            { "ts", "聪加语" },
            { "tt", "鞑靼语" },
            { "tw", "契维语" },
            { "ty", "塔希提语" },
            { "ug", "维吾尔语" },
            { "uk", "乌克兰语" },
            { "ur", "乌尔都语" },
            { "uz", "乌兹别克语" },
            { "ve", "文达语" },
            { "vi", "越南语" },
            { "vo", "沃拉普克语" },
            { "wa", "瓦隆语" },
            { "wo", "沃洛夫语" },
            { "xh", "科萨语" },
            { "yi", "意第绪语" },
            { "yo", "约鲁巴语" },
            { "za", "壮语" },
            { "zh", "中文" },
            { "zu", "祖鲁语" },
            { "ace", "亚齐语" },
            { "ach", "阿乔利语" },
            { "ada", "阿当梅语" },
            { "ady", "阿迪格语" },
            { "afh", "阿弗里希利语" },
            { "agq", "亚罕语" },
            { "ain", "阿伊努语" },
            { "akk", "阿卡德语" },
            { "ale", "阿留申语" },
            { "alt", "南阿尔泰语" },
            { "ang", "古英语" },
            { "ann", "奥博洛语" },
            { "anp", "昂加语" },
            { "arc", "阿拉米语" },
            { "arn", "马普切语" },
            { "arp", "阿拉帕霍语" },
            { "ars", "纳吉迪阿拉伯语" },
            { "arw", "阿拉瓦克语" },
            { "asa", "帕雷语" },
            { "ast", "阿斯图里亚斯语" },
            { "atj", "阿提卡米克语" },
            { "awa", "阿瓦德语" },
            { "bal", "俾路支语" },
            { "ban", "巴厘语" },
            { "bas", "巴萨语" },
            { "bax", "巴姆穆语" },
            { "bbj", "戈马拉语" },
            { "bej", "贝沙语" },
            { "bem", "本巴语" },
            { "bez", "贝纳语" },
            { "bfd", "巴非特语" },
            { "bgc", "哈里亚纳语" },
            { "bgn", "西俾路支语" },
            { "bho", "博杰普尔语" },
            { "bik", "比科尔语" },
            { "bin", "比尼语" },
            { "bkm", "科姆语" },
            { "bla", "西克西卡语" },
            { "blo", "阿尼语" },
            { "bra", "布拉杰语" },
            { "brx", "博多语" },
            { "bss", "阿库色语" },
            { "bua", "布里亚特语" },
            { "bug", "布吉语" },
            { "bum", "布鲁语" },
            { "byn", "比林语" },
            { "byv", "梅敦巴语" },
            { "cad", "卡多语" },
            { "car", "加勒比语" },
            { "cay", "卡尤加语" },
            { "cch", "阿灿语" },
            { "ccp", "查克玛语" },
            { "ceb", "宿务语" },
            { "cgg", "奇加语" },
            { "chb", "奇布查语" },
            { "chg", "察合台语" },
            { "chk", "楚克语" },
            { "chm", "马里语" },
            { "chn", "奇努克混合语" },
            { "cho", "乔克托语" },
            { "chp", "奇佩维安语" },
            { "chr", "切罗基语" },
            { "chy", "夏延语" },
            { "ckb", "中库尔德语" },
            { "clc", "奇尔科廷语" },
            { "cop", "科普特语" },
            { "crg", "米其芙语" },
            { "crh", "克里米亚鞑靼语" },
            { "crj", "东南部克里语" },
            { "crk", "平原克里语" },
            { "crl", "东北部克里语" },
            { "crm", "穆斯克里语" },
            { "crr", "卡罗莱纳州阿尔冈昆语" },
            { "crs", "塞舌尔克里奥尔语" },
            { "csb", "卡舒比语" },
            { "csw", "沼泽克里语" },
            { "dak", "达科他语" },
            { "dar", "达尔格瓦语" },
            { "dav", "台塔语" },
            { "del", "特拉华语" },
            { "den", "史拉维语" },
            { "dgr", "多格里布语" },
            { "din", "丁卡语" },
            { "dje", "哲尔马语" },
            { "doi", "多格拉语" },
            { "dsb", "下索布语" },
            { "dua", "杜阿拉语" },
            { "dum", "中古荷兰语" },
            { "dyo", "朱拉语" },
            { "dyu", "迪尤拉语" },
            { "dzg", "达扎葛语" },
            { "ebu", "恩布语" },
            { "efi", "埃菲克语" },
            { "egy", "古埃及语" },
            { "eka", "艾卡朱克语" },
            { "elx", "埃兰语" },
            { "enm", "中古英语" },
            { "ewo", "埃翁多语" },
            { "fan", "芳格语" },
            { "fat", "芳蒂语" },
            { "fil", "菲律宾语" },
            { "fon", "丰语" },
            { "frc", "卡真法语" },
            { "frm", "中古法语" },
            { "fro", "古法语" },
            { "frr", "北弗里西亚语" },
            { "frs", "东弗里西亚语" },
            { "fur", "弗留利语" },
            { "gaa", "加族语" },
            { "gag", "加告兹语" },
            { "gan", "赣语" },
            { "gay", "迦约语" },
            { "gba", "格巴亚语" },
            { "gez", "吉兹语" },
            { "gil", "吉尔伯特语" },
            { "gmh", "中古高地德语" },
            { "goh", "古高地德语" },
            { "gon", "冈德语" },
            { "gor", "哥伦打洛语" },
            { "got", "哥特语" },
            { "grb", "格列博语" },
            { "grc", "古希腊语" },
            { "gsw", "瑞士德语" },
            { "guz", "古西语" },
            { "gwi", "哥威迅语" },
            { "hai", "海达语" },
            { "hak", "客家语" },
            { "haw", "夏威夷语" },
            { "hax", "南海达语" },
            { "hil", "希利盖农语" },
            { "hit", "赫梯语" },
            { "hmn", "苗语" },
            { "hsb", "上索布语" },
            { "hsn", "湘语" },
            { "hup", "胡帕语" },
            { "hur", "哈尔魁梅林语" },
            { "iba", "伊班语" },
            { "ibb", "伊比比奥语" },
            { "ikt", "西加拿大因纽特语" },
            { "ilo", "伊洛卡诺语" },
            { "inh", "印古什语" },
            { "jbo", "逻辑语" },
            { "jgo", "恩艮巴语" },
            { "jmc", "马切姆语" },
            { "jpr", "犹太波斯语" },
            { "jrb", "犹太阿拉伯语" },
            { "kaa", "卡拉卡尔帕克语" },
            { "kab", "卡拜尔语" },
            { "kac", "克钦语" },
            { "kaj", "卡捷语" },
            { "kam", "卡姆巴语" },
            { "kaw", "卡威语" },
            { "kbd", "卡巴尔德语" },
            { "kbl", "加涅姆布语" },
            { "kcg", "卡塔布语" },
            { "kde", "马孔德语" },
            { "kea", "卡布佛得鲁语" },
            { "kfo", "克罗语" },
            { "kgp", "坎刚语" },
            { "kha", "卡西语" },
            { "kho", "和田语" },
            { "khq", "西桑海语" },
            { "kkj", "卡库语" },
            { "kln", "卡伦金语" },
            { "kmb", "金邦杜语" },
            { "koi", "科米-彼尔米亚克语" },
            { "kok", "孔卡尼语" },
            { "kos", "科斯拉伊语" },
            { "kpe", "克佩列语" },
            { "krc", "卡拉恰伊巴尔卡尔语" },
            { "krl", "卡累利阿语" },
            { "kru", "库鲁克语" },
            { "ksb", "香巴拉语" },
            { "ksf", "巴菲亚语" },
            { "ksh", "科隆语" },
            { "kum", "库梅克语" },
            { "kut", "库特奈语" },
            { "kwk", "夸夸瓦拉语" },
            { "kxv", "库维语" },
            { "lad", "拉迪诺语" },
            { "lag", "朗吉语" },
            { "lah", "西旁遮普语" },
            { "lam", "兰巴语" },
            { "lez", "列兹金语" },
            { "lij", "利古里亚语" },
            { "lil", "利洛埃特语" },
            { "lkt", "拉科塔语" },
            { "lmo", "伦巴第语" },
            { "lol", "蒙戈语" },
            { "lou", "路易斯安那克里奥尔语" },
            { "loz", "洛齐语" },
            { "lrc", "北卢尔语" },
            { "lsm", "萨米亚语" },
            { "lua", "卢巴-卢拉语" },
            { "lui", "卢伊塞诺语" },
            { "lun", "隆达语" },
            { "luo", "卢奥语" },
            { "lus", "米佐语" },
            { "luy", "卢雅语" },
            { "mad", "马都拉语" },
            { "maf", "马法语" },
            { "mag", "摩揭陀语" },
            { "mai", "迈蒂利语" },
            { "mak", "望加锡语" },
            { "man", "曼丁哥语" },
            { "mas", "马赛语" },
            { "mde", "马坝语" },
            { "mdf", "莫克沙语" },
            { "mdr", "曼达尔语" },
            { "men", "门德语" },
            { "mer", "梅鲁语" },
            { "mfe", "毛里求斯克里奥尔语" },
            { "mga", "中古爱尔兰语" },
            { "mgh", "马库阿-梅托语" },
            { "mgo", "梅塔语" },
            { "mic", "密克马克语" },
            { "min", "米南佳保语" },
            { "mnc", "满语" },
            { "mni", "曼尼普尔语" },
            { "moe", "因努埃蒙语" },
            { "moh", "摩霍克语" },
            { "mos", "莫西语" },
            { "mua", "蒙当语" },
            { "mul", "多语种" },
            { "mus", "克里克语" },
            { "mwl", "米兰德斯语" },
            { "mwr", "马尔瓦里语" },
            { "mye", "姆耶内语" },
            { "myv", "厄尔兹亚语" },
            { "mzn", "马赞德兰语" },
            { "nan", "闽南语" },
            { "nap", "那不勒斯语" },
            { "naq", "纳马语" },
            { "nds", "低地德语" },
            { "new", "尼瓦尔语" },
            { "nia", "尼亚斯语" },
            { "niu", "纽埃语" },
            { "nmg", "夸西奥语" },
            { "nnh", "恩甘澎语" },
            { "nog", "诺盖语" },
            { "non", "古诺尔斯语" },
            { "nqo", "西非书面文字" },
            { "nso", "北索托语" },
            { "nus", "努埃尔语" },
            { "nwc", "古典尼瓦尔语" },
            { "nym", "尼扬韦齐语" },
            { "nyn", "尼昂科勒语" },
            { "nyo", "尼奥罗语" },
            { "nzi", "恩济马语" },
            { "ojb", "西北部奥吉布瓦语" },
            { "ojc", "中奥吉布瓦语" },
            { "ojs", "欧吉克里语" },
            { "ojw", "西奥吉布瓦语" },
            { "oka", "欧肯那根语" },
            { "osa", "欧塞奇语" },
            { "ota", "奥斯曼土耳其语" },
            { "pag", "邦阿西南语" },
            { "pal", "巴拉维语" },
            { "pam", "邦板牙语" },
            { "pap", "帕皮阿门托语" },
            { "pau", "帕劳语" },
            { "pcm", "尼日利亚皮钦语" },
            { "peo", "古波斯语" },
            { "phn", "腓尼基语" },
            { "pis", "皮京语" },
            { "pon", "波纳佩语" },
            { "pqm", "马利塞-帕萨马科迪语" },
            { "prg", "普鲁士语" },
            { "pro", "古普罗文斯语" },
            { "quc", "基切语" },
            { "raj", "拉贾斯坦语" },
            { "rap", "拉帕努伊语" },
            { "rar", "拉罗汤加语" },
            { "rhg", "罗兴亚语" },
            { "rif", "里夫语" },
            { "rof", "兰博语" },
            { "rom", "吉普赛语" },
            { "rup", "阿罗马尼亚语" },
            { "rwk", "罗瓦语" },
            { "sad", "桑达韦语" },
            { "sah", "萨哈语" },
            { "sam", "萨马利亚阿拉姆语" },
            { "saq", "桑布鲁语" },
            { "sas", "萨萨克语" },
            { "sat", "桑塔利语" },
            { "sba", "甘拜语" },
            { "sbp", "桑古语" },
            { "scn", "西西里语" },
            { "sco", "苏格兰语" },
            { "sdh", "南库尔德语" },
            { "see", "塞内卡语" },
            { "seh", "塞纳语" },
            { "sel", "塞尔库普语" },
            { "ses", "东桑海语" },
            { "sga", "古爱尔兰语" },
            { "shi", "希尔哈语" },
            { "shn", "掸语" },
            { "shu", "乍得阿拉伯语" },
            { "sid", "悉达摩语" },
            { "skr", "色莱基语" },
            { "slh", "南卢舒特种子语" },
            { "sma", "南萨米语" },
            { "smj", "吕勒萨米语" },
            { "smn", "伊纳里萨米语" },
            { "sms", "斯科特萨米语" },
            { "snk", "索宁克语" },
            { "sog", "粟特语" },
            { "srn", "苏里南汤加语" },
            { "srr", "塞雷尔语" },
            { "ssy", "萨霍语" },
            { "str", "海峡萨利希语" },
            { "suk", "苏库马语" },
            { "sus", "苏苏语" },
            { "sux", "苏美尔语" },
            { "swb", "科摩罗语" },
            { "syc", "古典叙利亚语" },
            { "syr", "叙利亚语" },
            { "szl", "西里西亚语" },
            { "tce", "南塔穹语" },
            { "tem", "泰姆奈语" },
            { "teo", "特索语" },
            { "ter", "特伦诺语" },
            { "tet", "德顿语" },
            { "tgx", "塔吉什语" },
            { "tht", "塔尔坦语" },
            { "tig", "提格雷语" },
            { "tiv", "蒂夫语" },
            { "tkl", "托克劳语" },
            { "tlh", "克林贡语" },
            { "tli", "特林吉特语" },
            { "tmh", "塔马奇克语" },
            { "tog", "尼亚萨汤加语" },
            { "tok", "道本语" },
            { "tpi", "托克皮辛语" },
            { "trv", "赛德克语" },
            { "trw", "托尔瓦利语" },
            { "tsi", "钦西安语" },
            { "ttm", "北塔穹语" },
            { "tum", "通布卡语" },
            { "tvl", "图瓦卢语" },
            { "twq", "北桑海语" },
            { "tyv", "图瓦语" },
            { "tzm", "塔马齐格特语" },
            { "udm", "乌德穆尔特语" },
            { "uga", "乌加里特语" },
            { "umb", "翁本杜语" },
            { "und", "未知语言" },
            { "vai", "瓦伊语" },
            { "vec", "威尼斯语" },
            { "vep", "维普森语" },
            { "vmw", "马库阿语" },
            { "vot", "沃提克语" },
            { "vun", "温旧语" },
            { "wae", "瓦尔瑟语" },
            { "wal", "瓦拉莫语" },
            { "war", "瓦瑞语" },
            { "was", "瓦绍语" },
            { "wbp", "瓦尔皮瑞语" },
            { "wuu", "吴语" },
            { "xal", "卡尔梅克语" },
            { "xnr", "康格里语" },
            { "xog", "索加语" },
            { "yao", "尧语" },
            { "yap", "雅浦语" },
            { "yav", "洋卞语" },
            { "ybb", "耶姆巴语" },
            { "yrl", "恩加图语" },
            { "yue", "粤语" },
            { "zap", "萨波蒂克语" },
            { "zbl", "布里斯符号" },
            { "zen", "泽纳加语" },
            { "zgh", "标准摩洛哥塔马塞特语" },
            { "zun", "祖尼语" },
            { "zxx", "无语言内容" },
            { "zza", "扎扎语" },
            { "Adlm", "阿德拉姆文" },
            { "Afak", "阿法卡文" },
            { "Aghb", "高加索阿尔巴尼亚文" },
            { "Ahom", "阿豪姆文" },
            { "Arab", "阿拉伯文" },
            { "Aran", "波斯体" },
            { "Armi", "皇室亚拉姆文" },
            { "Armn", "亚美尼亚文" },
            { "Avst", "阿维斯陀文" },
            { "Bali", "巴厘文" },
            { "Bamu", "巴姆穆文" },
            { "Bass", "巴萨文" },
            { "Batk", "巴塔克文" },
            { "Beng", "孟加拉文" },
            { "Bhks", "拜克舒克文" },
            { "Blis", "布列斯符号" },
            { "Bopo", "注音符号" },
            { "Brah", "婆罗米文字" },
            { "Brai", "布莱叶盲文" },
            { "Bugi", "布吉文" },
            { "Buhd", "布希德文" },
            { "Cakm", "查克马文" },
            { "Cans", "加拿大土著统一音节" },
            { "Cari", "卡里亚文" },
            { "Cham", "占文" },
            { "Cher", "切罗基文" },
            { "Chrs", "花拉子模文" },
            { "Cirt", "色斯文" },
            { "Copt", "克普特文" },
            { "Cpmn", "塞浦路斯米诺斯文" },
            { "Cprt", "塞浦路斯文" },
            { "Cyrl", "西里尔文" },
            { "Cyrs", "西里尔文字（古教会斯拉夫文的变体）" },
            { "Deva", "天城文" },
            { "Diak", "迪维西阿库鲁文" },
            { "Dogr", "多格拉文" },
            { "Dsrt", "德塞莱特文" },
            { "Dupl", "杜普洛伊速记" },
            { "Egyd", "后期埃及文" },
            { "Egyh", "古埃及僧侣书写体" },
            { "Egyp", "古埃及象形文" },
            { "Elba", "爱尔巴桑文" },
            { "Elym", "埃利迈文" },
            { "Ethi", "埃塞俄比亚文" },
            { "Geok", "格鲁吉亚文（教堂体）" },
            { "Geor", "格鲁吉亚文" },
            { "Glag", "格拉哥里文" },
            { "Gong", "贡贾拉贡德文" },
            { "Gonm", "马萨拉姆冈德文" },
            { "Goth", "哥特文" },
            { "Gran", "格兰塔文" },
            { "Grek", "希腊文" },
            { "Gujr", "古吉拉特文" },
            { "Guru", "果鲁穆奇文" },
            { "Hanb", "注音汉字" },
            { "Hang", "谚文" },
            { "Hani", "汉字" },
            { "Hano", "汉奴罗文" },
            { "Hans", "简体" },
            { "Hant", "繁体" },
            { "Hatr", "哈特兰文" },
            { "Hebr", "希伯来文" },
            { "Hira", "平假名" },
            { "Hluw", "安那托利亚象形文字" },
            { "Hmng", "杨松录苗文" },
            { "Hmnp", "尼亚肯蒲丘苗文" },
            { "Hrkt", "假名" },
            { "Hung", "古匈牙利文" },
            { "Inds", "印度河文字" },
            { "Ital", "古意大利文" },
            { "Jamo", "韩文字母" },
            { "Java", "爪哇文" },
            { "Jpan", "日文" },
            { "Jurc", "女真文" },
            { "Kali", "克耶李文字" },
            { "Kana", "片假名" },
            { "Kawi", "卡维文" },
            { "Khar", "卡罗须提文" },
            { "Khmr", "高棉文" },
            { "Khoj", "克吉奇文字" },
            { "Kits", "契丹小字" },
            { "Knda", "卡纳达文" },
            { "Kore", "韩文" },
            { "Kpel", "克佩列文" },
            { "Kthi", "凯提文" },
            { "Lana", "兰拿文" },
            { "Laoo", "老挝文" },
            { "Latf", "拉丁文（哥特式字体变体）" },
            { "Latg", "拉丁文（盖尔文变体）" },
            { "Latn", "拉丁文" },
            { "Lepc", "雷布查文" },
            { "Limb", "林布文" },
            { "Lina", "线形文字（A）" },
            { "Linb", "线形文字（B）" },
            { "Lisu", "傈僳文" },
            { "Loma", "洛马文" },
            { "Lyci", "利西亚文" },
            { "Lydi", "吕底亚文" },
            { "Mahj", "默哈金文" },
            { "Maka", "望加锡文" },
            { "Mand", "阿拉米文" },
            { "Mani", "摩尼教文" },
            { "Marc", "大玛尔文" },
            { "Maya", "玛雅圣符文" },
            { "Medf", "梅德法伊德林文" },
            { "Mend", "门迪文" },
            { "Merc", "麦罗埃草书" },
            { "Mero", "麦若提克文" },
            { "Mlym", "马拉雅拉姆文" },
            { "Modi", "莫迪文" },
            { "Mong", "蒙古文" },
            { "Moon", "穆恩字母" },
            { "Mroo", "谬文" },
            { "Mtei", "曼尼普尔文" },
            { "Mult", "穆尔坦文" },
            { "Mymr", "缅甸文" },
            { "Nand", "楠迪梵文" },
            { "Narb", "古北方阿拉伯文" },
            { "Nbat", "纳巴泰文" },
            { "Newa", "尼瓦文" },
            { "Nkgb", "纳西格巴文" },
            { "Nkoo", "西非书面文字（N’Ko）" },
            { "Nshu", "女书" },
            { "Ogam", "欧甘文" },
            { "Olck", "桑塔利文" },
            { "Orkh", "鄂尔浑文" },
            { "Orya", "奥里亚文" },
            { "Osge", "欧塞奇文" },
            { "Osma", "奥斯曼亚文" },
            { "Ougr", "回鹘文" },
            { "Palm", "帕尔迈拉文" },
            { "Pauc", "包金豪文" },
            { "Perm", "古彼尔姆文" },
            { "Phag", "八思巴文" },
            { "Phli", "巴列维文碑铭体" },
            { "Phlp", "巴列维文（圣诗体）" },
            { "Phlv", "巴列维文（书体）" },
            { "Phnx", "腓尼基文" },
            { "Plrd", "波拉德音标文字" },
            { "Prti", "帕提亚文碑铭体" },
            { "Qaag", "照济文" },
            { "Rjng", "拉让文" },
            { "Rohg", "哈乃斐文" },
            { "Roro", "朗格朗格文" },
            { "Runr", "古代北欧文" },
            { "Samr", "撒马利亚文" },
            { "Sara", "沙拉堤文" },
            { "Sarb", "古南阿拉伯文" },
            { "Saur", "索拉什特拉文" },
            { "Sgnw", "书写符号" },
            { "Shaw", "萧伯纳式文" },
            { "Shrd", "夏拉达文" },
            { "Sidd", "悉昙文" },
            { "Sind", "信德文" },
            { "Sinh", "僧伽罗文" },
            { "Sogd", "粟特文" },
            { "Sogo", "古粟特文" },
            { "Sora", "索朗桑朋文" },
            { "Soyo", "索永布文" },
            { "Sund", "巽他文" },
            { "Sylo", "锡尔赫特文" },
            { "Syrc", "叙利亚文" },
            { "Syre", "福音体叙利亚文" },
            { "Syrj", "西叙利亚文" },
            { "Syrn", "东叙利亚文" },
            { "Tagb", "塔格班瓦文" },
            { "Takr", "泰克里文" },
            { "Tale", "泰乐文" },
            { "Talu", "新傣文" },
            { "Taml", "泰米尔文" },
            { "Tang", "唐古特文" },
            { "Tavt", "越南傣文" },
            { "Telu", "泰卢固文" },
            { "Teng", "腾格瓦文字" },
            { "Tfng", "提非纳文" },
            { "Tglg", "塔加路文" },
            { "Thaa", "塔安那文" },
            { "Thai", "泰文" },
            { "Tibt", "藏文" },
            { "Tirh", "迈蒂利文" },
            { "Tnsa", "坦萨文" },
            { "Toto", "投投文" },
            { "Ugar", "乌加里特文" },
            { "Vaii", "瓦依文" },
            { "Visp", "可见语言" },
            { "Wara", "瓦郎奇蒂文字" },
            { "Wcho", "万秋文" },
            { "Wole", "沃莱艾文" },
            { "Xpeo", "古波斯文" },
            { "Xsux", "苏美尔-阿卡德楔形文字" },
            { "Yezi", "雅兹迪文" },
            { "Yiii", "彝文" },
            { "Zanb", "札那巴札尔方块文字" },
            { "Zinh", "遗传学术语" },
            { "Zmth", "数学符号" },
            { "Zsye", "表情符号" },
            { "Zsym", "符号" },
            { "Zxxx", "非书面文字" },
            { "Zyyy", "通用" },
            { "Zzzz", "未知文字" },
            { "de_AT", "奥地利德语" },
            { "de_CH", "瑞士高地德语" },
            { "en_AU", "澳大利亚英语" },
            { "en_CA", "加拿大英语" },
            { "en_GB", "英国英语" },
            { "en_US", "美国英语" },
            { "es_ES", "欧洲西班牙语" },
            { "es_MX", "墨西哥西班牙语" },
            { "fa_AF", "达里语" },
            { "fr_CA", "加拿大法语" },
            { "fr_CH", "瑞士法语" },
            { "nl_BE", "弗拉芒语" },
            { "pt_BR", "巴西葡萄牙语" },
            { "pt_PT", "欧洲葡萄牙语" },
            { "ro_MD", "摩尔多瓦语" },
            { "sw_CD", "刚果斯瓦希里语" },
            { "%%1901", "传统德文拼字" },
            { "%%1994", "标准雷西亚拼字" },
            { "%%1996", "1996 年德文拼字" },
            { "ar_001", "现代标准阿拉伯语" },
            { "es_419", "拉丁美洲西班牙语" },
            { "key.ca", "日历" },
            { "key.cf", "货币格式" },
            { "key.co", "排序" },
            { "key.cu", "货币" },
            { "key.em", "表情符号表示法" },
            { "key.hc", "小时制（12或24）" },
            { "key.lb", "中文、日文及韩语换行规则" },
            { "key.lw", "词内换行规则" },
            { "key.ms", "度量衡制" },
            { "key.nu", metaValue_key_nu },
            { "key.ss", "在缩写后断句" },
            { "key.tz", "时区" },
            { "key.va", "语言区域别名" },
            { "nds_NL", "低萨克森语" },
            { "%%ALUKU", "阿鲁库方言" },
            { "%%BARLA", "佛得角语向风方言组" },
            { "%%BISKE", "圣乔治/比拉方言" },
            { "%%BOONT", "布恩特林方言" },
            { "%%CORNU", "科尔尼方言" },
            { "%%GALLO", "加洛方言" },
            { "%%JAUER", "米施泰尔方言" },
            { "%%KKCOR", "常用拼字" },
            { "%%KSCOR", "标准正写法" },
            { "%%LIPAW", "雷西亚 Lipovaz 方言" },
            { "%%NEDIS", "纳蒂索内方言" },
            { "%%NJIVA", "Gniva/Njiva 方言" },
            { "%%NULIK", "现代沃拉普克语" },
            { "%%OSOJS", "Oseacco/Osojane 方言" },
            { "%%PEANO", "皮亚诺方言" },
            { "%%POSIX", "电脑" },
            { "%%PUTER", "瑞士普特尔方言" },
            { "%%RIGIK", "古典沃拉普克语" },
            { "%%ROZAJ", "雷西亚文" },
            { "%%RUMGR", "罗曼什文" },
            { "%%SAAHO", "萨霍文" },
            { "%%SOLBA", "Stolvizza/Solbica 方言" },
            { "%%SOTAV", "佛得角语背风方言组" },
            { "%%UCCOR", "统一的拼字" },
            { "az_Arab", "南阿塞拜疆语" },
            { "hi_Latn", "印地语（拉丁字母）" },
            { "zh_Hans", "简体中文" },
            { "zh_Hant", "繁体中文" },
            { "%%AO1990", "1990年葡萄牙语正写法协议" },
            { "%%ARANES", "阿兰方言" },
            { "%%ASANTE", "阿散蒂方言" },
            { "%%AUVERN", "自动钻机" },
            { "%%CISAUP", "西萨普方言" },
            { "%%CREISS", "克雷桑方言" },
            { "%%DAJNKO", "达金科字母" },
            { "%%EKAVSK", "塞尔维亚语伊卡维亚发音" },
            { "%%FONIPA", "国际音标" },
            { "%%FONUPA", "UPA 音标" },
            { "%%GASCON", "加斯科方言" },
            { "%%GRITAL", "格里陶方言" },
            { "%%NDYUKA", "Ndyuka 方言" },
            { "%%NICARD", "尼斯方言" },
            { "%%PAMAKA", "Pamaka 方言" },
            { "%%PINYIN", "拼音罗马字" },
            { "%%SCOUSE", "斯高斯方言" },
            { "%%SIMPLE", "简单英语" },
            { "%%TARASK", "传统正写法" },
            { "%%UCRCOR", "统一和修订的拼字" },
            { "%%ULSTER", "阿尔斯特方言" },
            { "%%UNIFON", "Unifon音位字母" },
            { "%%ABL1943", "1943年正写法构想" },
            { "%%AKUAPEM", "阿夸佩姆方言" },
            { "%%ALALC97", "1997 版 ALA-LC 罗马字" },
            { "%%AREVELA", "东亚美尼亚文" },
            { "%%AREVMDA", "西亚美尼亚文" },
            { "%%ARKAIKA", "阿尔凯亚方言" },
            { "%%BALANKA", "阿尼语Balanka方言" },
            { "%%BAUDDHA", "佛陀梵文" },
            { "%%BOHORIC", "博霍里奇字母" },
            { "%%EMODENG", "近代英语" },
            { "%%FONNAPA", "福纳帕方言" },
            { "%%GRCLASS", "粗粒级" },
            { "%%GRMISTR", "格米斯特方言" },
            { "%%HEPBURN", "赫伯恩罗马字" },
            { "%%ITIHASA", "史诗梵文" },
            { "%%LAUKIKA", "传统梵文" },
            { "%%LEMOSIN", "利姆赞方言" },
            { "%%METELKO", "梅特尔科字母" },
            { "%%MONOTON", "单音字母" },
            { "%%PAHAWH2", "帕哈苗文2代" },
            { "%%PAHAWH3", "帕哈苗文3代" },
            { "%%PAHAWH4", "帕哈苗文4代" },
            { "%%POLYTON", "多音字母" },
            { "%%PROVENC", "普罗旺斯方言" },
            { "%%REVISED", "修订的拼字" },
            { "%%SURSILV", "瑞士苏瑟瓦方言" },
            { "%%SUTSILV", "瑞士苏希瓦方言" },
            { "%%VAIDIKA", "吠陀梵文" },
            { "%%1606NICT", "1606 年前中后期法文" },
            { "%%1694ACAD", "早期现代法文" },
            { "%%1959ACAD", "学术" },
            { "%%BAKU1926", "统一土耳其拉丁字母" },
            { "%%BASICENG", "基本英语" },
            { "%%BISCAYAN", "比斯开方言" },
            { "%%BORNHOLM", "博恩霍尔姆方言" },
            { "%%COLB1945", "1945年葡萄牙-巴西正写法协定" },
            { "%%FONKIRSH", "丰吉什方言" },
            { "%%FONXSAMP", "X-SAMPA 音标" },
            { "%%HOGNORSK", "高地挪威文" },
            { "%%HSISTEMO", "赫西斯特莫方言" },
            { "%%IJEKAVSK", "塞尔维亚语伊吉卡维亚发音" },
            { "%%IVANCHOV", "伊万乔夫方言" },
            { "%%JYUTPING", "粤语拼音" },
            { "%%KOCIEWIE", "科奇韦方言" },
            { "%%LENGADOC", "隆格多克方言" },
            { "%%LUNA1918", "俄文拼字（1918年起）" },
            { "%%NEWFOUND", "纽芬兰方言" },
            { "%%OXENDICT", "《牛津英语词典》拼法" },
            { "%%PETR1708", "俄文拼字（1708年）" },
            { "%%SCOTLAND", "苏格兰标准英文" },
            { "%%SPANGLIS", "西班牙式英语" },
            { "%%SURMIRAN", "瑞士苏迈拉方言" },
            { "%%TONGYONG", "通用拼音" },
            { "%%VALENCIA", "巴伦西亚文" },
            { "%%VALLADER", "瑞士瓦勒德方言" },
            { "%%VECDRUKA", "维杜卡方言" },
            { "%%VIVARAUP", "维瓦鲁普方言" },
            { "%%WADEGILE", "WG 威氏拼音法" },
            { "%%XSISTEMO", "西西斯特莫方言" },
            { "type.ca.roc", "民国纪年" },
            { "type.co.eor", "欧洲排序规则" },
            { "type.hc.h11", "12小时制（0–11）" },
            { "type.hc.h12", "12小时制（1–12）" },
            { "type.hc.h23", "24小时制（0–23）" },
            { "type.hc.h24", "24小时制（1–24）" },
            { "type.m0.bgn", "美国地名委员会 (BGN)" },
            { "type.nu.ahom", "阿霍姆数字" },
            { "type.nu.arab", "阿拉伯-印度数字" },
            { "type.nu.armn", "亚美尼亚数字" },
            { "type.nu.bali", "巴厘文数字" },
            { "type.nu.beng", "孟加拉数字" },
            { "type.nu.brah", "婆罗米数字" },
            { "type.nu.cakm", "查克玛数字" },
            { "type.nu.cham", "占文数字" },
            { "type.nu.cyrl", "斯拉夫数字" },
            { "type.nu.deva", "梵文数字" },
            { "type.nu.diak", "迪维西阿库鲁数字" },
            { "type.nu.ethi", "埃塞俄比亚数字" },
            { "type.nu.geor", "格鲁吉亚数字" },
            { "type.nu.gong", metaValue_type_nu_gong },
            { "type.nu.gonm", metaValue_type_nu_gong },
            { "type.nu.grek", "希腊数字" },
            { "type.nu.gujr", "古吉拉特数字" },
            { "type.nu.guru", "果鲁穆奇数字" },
            { "type.nu.hans", "简体中文数字" },
            { "type.nu.hant", "繁体中文数字" },
            { "type.nu.hebr", "希伯来数字" },
            { "type.nu.hmng", "杨松录苗文数字" },
            { "type.nu.hmnp", "尼亚肯蒲丘苗文数字" },
            { "type.nu.java", "爪哇文数字" },
            { "type.nu.jpan", "日文数字" },
            { "type.nu.kali", "克耶字母数字" },
            { "type.nu.kawi", "卡维数字" },
            { "type.nu.khmr", "高棉数字" },
            { "type.nu.knda", "卡纳达数字" },
            { "type.nu.lana", "老傣文数字" },
            { "type.nu.laoo", "老挝数字" },
            { "type.nu.latn", "西方数字" },
            { "type.nu.lepc", "雷布查文数字" },
            { "type.nu.limb", "林布文数字" },
            { "type.nu.mlym", "马拉雅拉姆数字" },
            { "type.nu.modi", "莫迪数字" },
            { "type.nu.mong", "蒙古文数字" },
            { "type.nu.mroo", "谬文数字" },
            { "type.nu.mtei", "曼尼普尔数字" },
            { "type.nu.mymr", "缅甸数字" },
            { "type.nu.nkoo", "曼德数字" },
            { "type.nu.olck", "桑塔利文数字" },
            { "type.nu.orya", "奥里亚数字" },
            { "type.nu.osma", "奥斯曼数字" },
            { "type.nu.rohg", "哈乃斐罗兴亚数字" },
            { "type.nu.saur", "索拉什特拉文数字" },
            { "type.nu.shrd", "夏拉达数字" },
            { "type.nu.sind", "库达瓦迪数字" },
            { "type.nu.sinh", "僧伽罗文数字" },
            { "type.nu.sora", "素拉僧平数字" },
            { "type.nu.sund", "苏丹文数字" },
            { "type.nu.takr", "泰克里数字" },
            { "type.nu.talu", "新傣仂文数字" },
            { "type.nu.taml", "传统泰米尔数字" },
            { "type.nu.telu", "泰卢固数字" },
            { "type.nu.thai", "泰文数字" },
            { "type.nu.tibt", "藏文数字" },
            { "type.nu.tirh", "迈蒂利数字" },
            { "type.nu.tnsa", "坦萨数字" },
            { "type.nu.vaii", "瓦伊文数字" },
            { "type.nu.wara", "瓦郎奇蒂数字" },
            { "type.nu.wcho", "万秋数字" },
            { "type.ca.dangi", "檀纪历" },
            { "type.co.ducet", "默认Unicode排序" },
            { "type.co.emoji", "表情符号排序" },
            { "type.lb.loose", "宽松换行样式" },
            { "type.nu.roman", "罗马数字" },
            { "type.ca.coptic", "科普特历" },
            { "type.ca.hebrew", "希伯来历" },
            { "type.ca.indian", "印度国定历" },
            { "type.co.compat", "基于兼容性沿用既往排序" },
            { "type.co.pinyin", "拼音排序" },
            { "type.co.search", "常规搜索" },
            { "type.co.stroke", "笔画排序" },
            { "type.co.unihan", "部首笔画排序" },
            { "type.co.zhuyin", "注音排序" },
            { "type.d0.fwidth", "全角" },
            { "type.d0.hwidth", "半角" },
            { "type.lb.normal", "正常换行样式" },
            { "type.lb.strict", "严格换行样式" },
            { "type.m0.ungegn", "联合国地名专家组 (UNGEGN)" },
            { "type.ms.metric", "公制" },
            { "type.nu.native", "当地数字" },
            { "type.ca.chinese", "农历" },
            { "type.ca.islamic", "伊斯兰历" },
            { "type.ca.iso8601", "国际标准历法" },
            { "type.ca.persian", "波斯历" },
            { "type.cf.account", "会计货币格式" },
            { "type.d0.npinyin", metaValue_key_nu },
            { "type.nu.arabext", "扩展阿拉伯-印度数字" },
            { "type.nu.armnlow", "亚美尼亚小写数字" },
            { "type.nu.finance", "金融数字" },
            { "type.nu.greklow", "希腊小写数字" },
            { "type.nu.hanidec", "中文十进制数字" },
            { "type.nu.hansfin", "简体中文大写数字" },
            { "type.nu.hantfin", "繁体中文大写数字" },
            { "type.nu.jpanfin", "日文大写数字" },
            { "type.nu.mathdbl", "数学空心数字" },
            { "type.nu.tamldec", "泰米尔数字" },
            { "type.ca.buddhist", "佛历" },
            { "type.ca.ethiopic", "埃塞俄比亚历" },
            { "type.ca.japanese", "和历" },
            { "type.cf.standard", "标准货币格式" },
            { "type.co.phonetic", "语音排序" },
            { "type.co.searchjl", "按谚文初声辅音搜索" },
            { "type.co.standard", "标准排序" },
            { "type.ms.uksystem", "英制" },
            { "type.ms.ussystem", "美制" },
            { "type.nu.fullwide", "全角数字" },
            { "type.nu.lanatham", "兰纳文数字" },
            { "type.nu.mathbold", "数学粗体数字" },
            { "type.nu.mathmono", "数学等宽数字" },
            { "type.nu.mathsanb", "数学无衬线粗体数字" },
            { "type.nu.mathsans", "数学无衬线数字" },
            { "type.nu.mymrshan", "缅甸掸文数字" },
            { "type.nu.mymrtlng", "缅甸泰兰数字" },
            { "type.nu.romanlow", "罗马小写数字" },
            { "type.ca.gregorian", "公历" },
            { "type.co.phonebook", "电话簿排序" },
            { "ListKeyTypePattern", "{0}：{1}" },
            { "type.co.dictionary", "字典排序" },
            { "type.co.traditional", "传统排序" },
            { "type.nu.traditional", "传统数字" },
            { "type.ca.islamic-tbla", "表格式伊斯兰历（天文纪元）" },
            { "type.ca.islamic-civil", "表格式伊斯兰历（民用纪元）" },
            { "ListCompositionPattern", "{0}，{1}" },
            { "type.ca.islamic-umalqura", "伊斯兰历（乌姆库拉）" },
            { "type.ca.ethiopic-amete-alem", "埃塞俄比亚阿米特阿莱姆日历" },
        };
        return data;
    }
}
