/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.notification;

import com.intellij.codeWithMe.ClientId;
import com.intellij.httpClient.http.request.notification.HttpClientWhatsNewContentProvider;
import com.intellij.httpClient.http.request.notification.HttpClientWhatsNewContentProviderKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.PathKt;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0007J\b\u0010\f\u001a\u0004\u0018\u00010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/httpClient/http/request/notification/HttpClientWhatsNewContentService;", "Lcom/intellij/openapi/Disposable;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "directory", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getWhatsNewFile", "getWhatsNewFileIfCreated", "createDirectory", "Ljava/nio/file/Path;", "dispose", "", "deleteFile", "Companion", "intellij.restClient"})
public final class HttpClientWhatsNewContentService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope scope;
    @Nullable
    private VirtualFile file;
    @Nullable
    private VirtualFile directory;
    @NotNull
    private final ReentrantLock lock;

    public HttpClientWhatsNewContentService(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.scope = scope;
        this.lock = new ReentrantLock();
        HttpClientWhatsNewContentProviderKt.access$getEP_NAME$p().addChangeListener(() -> HttpClientWhatsNewContentService._init_$lambda$0(this), (Disposable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    @Nullable
    public final VirtualFile getWhatsNewFile() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            VirtualFile virtualFile = this.file;
            if (virtualFile != null) {
                VirtualFile file = virtualFile;
                boolean bl2 = false;
                if (file.exists()) {
                    VirtualFile virtualFile2 = file;
                    return virtualFile2;
                }
            }
            try {
                VirtualFile vParent;
                Path parent = this.createDirectory();
                VirtualFile virtualFile3 = vParent = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(parent);
                VirtualFile vFile = virtualFile3 != null ? virtualFile3.findChild("whats-new.http") : null;
                this.directory = vParent;
                this.file = vFile;
            }
            catch (Exception e) {
                HttpClientWhatsNewContentProviderKt.access$getLOG$p().warn("Cannot create whats new directory", (Throwable)e);
            }
            VirtualFile virtualFile4 = this.file;
            return virtualFile4;
        }
        finally {
            lock.unlock();
        }
    }

    @Nullable
    public final VirtualFile getWhatsNewFileIfCreated() {
        return this.file;
    }

    private final Path createDirectory() {
        Path directory = FileUtil.createTempDirectory((String)"whats-new-dir", null).toPath();
        Path path = directory.resolve("whats-new.http");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = PathKt.createParentDirectories((Path)path);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path3 = Files.createFile(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"createFile(...)");
        Path file = path3;
        PathsKt.writeText$default((Path)file, (CharSequence)HttpClientWhatsNewContentProviderKt.access$getWhatsNewFileContent(), null, (OpenOption[])new OpenOption[0], (int)2, null);
        NioFiles.setReadOnly((Path)file, (boolean)true);
        for (HttpClientWhatsNewContentProvider contentProvider : HttpClientWhatsNewContentProviderKt.access$getEP_NAME$p().getExtensionList()) {
            for (HttpClientWhatsNewContentProvider.AdditionalFile additionalFile : contentProvider.getAdditionalFiles()) {
                Path newFile;
                Path path4 = directory.resolve(additionalFile.getSubPath());
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
                Path path5 = PathKt.createParentDirectories((Path)path4);
                FileAttribute[] fileAttributeArray2 = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(path5, Arrays.copyOf(fileAttributeArray2, fileAttributeArray2.length)), (String)"createFile(...)");
                PathsKt.writeText$default((Path)newFile, (CharSequence)additionalFile.getContent(), null, (OpenOption[])new OpenOption[0], (int)2, null);
            }
        }
        Intrinsics.checkNotNull((Object)directory);
        return directory;
    }

    public void dispose() {
        block0: {
            VirtualFile virtualFile = this.directory;
            if (virtualFile == null) break block0;
            VirtualFile file = virtualFile;
            boolean bl = false;
            this.deleteFile(file);
        }
    }

    private final void deleteFile(VirtualFile file) {
        block2: {
            Object object;
            Object object2 = this;
            try {
                HttpClientWhatsNewContentService $this$deleteFile_u24lambda_u244 = object2;
                boolean bl = false;
                NioFiles.deleteRecursively((Path)file.toNioPath());
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object it = object = throwable;
            boolean bl = false;
            HttpClientWhatsNewContentProviderKt.access$getLOG$p().warn("Cannot delete file!!");
        }
    }

    private static final void _init_$lambda$0(HttpClientWhatsNewContentService this$0) {
        BuildersKt.launch$default((CoroutineScope)this$0.scope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ HttpClientWhatsNewContentService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        VirtualFile prevFile;
                        VirtualFile $i$a$-withLock-HttpClientWhatsNewContentService$1$1$prevFile$22;
                        ResultKt.throwOnFailure((Object)$result);
                        Lock lock = HttpClientWhatsNewContentService.access$getLock$p(this.this$0);
                        HttpClientWhatsNewContentService httpClientWhatsNewContentService = this.this$0;
                        lock.lock();
                        try {
                            boolean $i$a$-withLock-HttpClientWhatsNewContentService$1$1$prevFile$22 = false;
                            VirtualFile prevFile2 = HttpClientWhatsNewContentService.access$getFile$p(httpClientWhatsNewContentService);
                            HttpClientWhatsNewContentService.access$setFile$p(httpClientWhatsNewContentService, null);
                            $i$a$-withLock-HttpClientWhatsNewContentService$1$1$prevFile$22 = prevFile2;
                        }
                        finally {
                            lock.unlock();
                        }
                        VirtualFile virtualFile = prevFile = $i$a$-withLock-HttpClientWhatsNewContentService$1$1$prevFile$22;
                        if (virtualFile != null) {
                            lock = virtualFile;
                            httpClientWhatsNewContentService = this.this$0;
                            Lock file = lock;
                            boolean bl = false;
                            HttpClientWhatsNewContentService.access$deleteFile(httpClientWhatsNewContentService, (VirtualFile)file);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @JvmStatic
    @NotNull
    public static final HttpClientWhatsNewContentService getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ ReentrantLock access$getLock$p(HttpClientWhatsNewContentService $this) {
        return $this.lock;
    }

    public static final /* synthetic */ VirtualFile access$getFile$p(HttpClientWhatsNewContentService $this) {
        return $this.file;
    }

    public static final /* synthetic */ void access$setFile$p(HttpClientWhatsNewContentService $this, VirtualFile virtualFile) {
        $this.file = virtualFile;
    }

    public static final /* synthetic */ void access$deleteFile(HttpClientWhatsNewContentService $this, VirtualFile file) {
        $this.deleteFile(file);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/httpClient/http/request/notification/HttpClientWhatsNewContentService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/httpClient/http/request/notification/HttpClientWhatsNewContentService;", "intellij.restClient"})
    @SourceDebugExtension(value={"SMAP\nHttpClientWhatsNewContentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientWhatsNewContentProvider.kt\ncom/intellij/httpClient/http/request/notification/HttpClientWhatsNewContentService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,136:1\n40#2,3:137\n*S KotlinDebug\n*F\n+ 1 HttpClientWhatsNewContentProvider.kt\ncom/intellij/httpClient/http/request/notification/HttpClientWhatsNewContentService$Companion\n*L\n124#1:137,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final HttpClientWhatsNewContentService getInstance() {
            boolean $i$f$service = false;
            Class<HttpClientWhatsNewContentService> serviceClass$iv = HttpClientWhatsNewContentService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (HttpClientWhatsNewContentService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

