/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request;

import com.intellij.httpClient.actions.HttpRequestOpenCollectionExternalProvider;
import com.intellij.httpClient.execution.HttpClientUsersMimeTypes;
import com.intellij.httpClient.http.request.HttpRequestCollectionProvider;
import com.intellij.httpClient.http.request.HttpRequestFileType;
import com.intellij.httpClient.http.request.HttpRequestFileUtilsRt;
import com.intellij.httpClient.http.request.HttpRequestLanguage;
import com.intellij.httpClient.http.request.run.HttpRequestHistoryManager;
import com.intellij.httpClient.http.request.run.HttpRequestInvalidLogFileException;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.ide.scratch.ScratchesSearchScope;
import com.intellij.json.JsonFileType;
import com.intellij.json.JsonLanguage;
import com.intellij.json.jsonLines.JsonLinesFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequestFileUtils
extends HttpRequestFileUtilsRt {
    public static boolean isLogFile(@NotNull Project project, @NotNull String pathToFile) {
        if (project == null) {
            HttpRequestFileUtils.$$$reportNull$$$0(0);
        }
        if (pathToFile == null) {
            HttpRequestFileUtils.$$$reportNull$$$0(1);
        }
        try {
            HttpRequestHistoryManager historyManager = HttpRequestHistoryManager.getInstance(project);
            String pathToLogFile = historyManager.getLogDirectoryPath() + File.separator + historyManager.getLogFile().getName();
            return pathToLogFile.equals(pathToFile);
        }
        catch (HttpRequestInvalidLogFileException ex) {
            return false;
        }
    }

    public static boolean isFileFromCollections(@NotNull String pathToFile) {
        VirtualFile root;
        if (pathToFile == null) {
            HttpRequestFileUtils.$$$reportNull$$$0(2);
        }
        if ((root = HttpRequestCollectionProvider.getCollectionFolder()) == null) {
            return false;
        }
        return PathUtil.getParentPath((String)pathToFile).equals(root.getPath()) || HttpRequestFileUtils.isProvidedCollectionFile(pathToFile);
    }

    private static boolean isProvidedCollectionFile(@NotNull String pathToFile) {
        if (pathToFile == null) {
            HttpRequestFileUtils.$$$reportNull$$$0(3);
        }
        for (HttpRequestOpenCollectionExternalProvider provider : HttpRequestOpenCollectionExternalProvider.getProviders()) {
            for (Map.Entry<String, VirtualFile> collectionEntry : provider.provideCollectionFiles().entrySet()) {
                if (!pathToFile.equals(collectionEntry.getValue().getPath())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isHttpRequestSystemFile(@NotNull Project project, @NotNull String pathToFile) {
        if (project == null) {
            HttpRequestFileUtils.$$$reportNull$$$0(4);
        }
        if (pathToFile == null) {
            HttpRequestFileUtils.$$$reportNull$$$0(5);
        }
        return HttpRequestFileUtils.isLogFile(project, pathToFile) || HttpRequestFileUtils.isFileFromCollections(pathToFile);
    }

    @RequiresReadLock
    public static boolean hasHttpFilesInProject(@NotNull Project project) {
        if (project == null) {
            HttpRequestFileUtils.$$$reportNull$$$0(6);
        }
        ThreadingAssertions.softAssertReadAccess();
        return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            GlobalSearchScope scope = ProjectScope.getContentScope((Project)project).uniteWith(ScratchesSearchScope.getScratchesScope((Project)project));
            boolean hasFilesInProject = FileTypeIndex.containsFileOfType((FileType)HttpRequestFileType.INSTANCE, (GlobalSearchScope)scope);
            return CachedValueProvider.Result.createSingleDependency((Object)hasFilesInProject, (Object)PsiModificationTracker.getInstance((Project)project).forLanguage((Language)HttpRequestLanguage.INSTANCE));
        });
    }

    @Nullable
    public static FileType findFileType(String mimeType) {
        if (mimeType != null && mimeType.endsWith("+json")) {
            mimeType = "application/json";
        }
        if ("application/x-ndjson".equals(mimeType)) {
            return JsonLinesFileType.INSTANCE;
        }
        if ("text/event-stream".equals(mimeType)) {
            return PlainTextFileType.INSTANCE;
        }
        if (HttpClientUsersMimeTypes.isJson(HttpClientUsersMimeTypes.usersMimeTypeMark(mimeType))) {
            return JsonFileType.INSTANCE;
        }
        Collection languages2 = Language.findInstancesByMimeType((String)mimeType);
        if (HttpRequestFileUtils.isJson(languages2)) {
            return JsonFileType.INSTANCE;
        }
        LanguageFileType fileType = null;
        for (Language language : languages2) {
            LanguageFileType langFileType = language.getAssociatedFileType();
            if (langFileType == null) continue;
            fileType = langFileType;
            break;
        }
        if (fileType == null && (mimeType != null && mimeType.endsWith("+xml") || HttpClientUsersMimeTypes.isXml(HttpClientUsersMimeTypes.usersMimeTypeMark(mimeType)))) {
            return XmlFileType.INSTANCE;
        }
        if (fileType == null && HttpClientUsersMimeTypes.isText(HttpClientUsersMimeTypes.usersMimeTypeMark(mimeType))) {
            return PlainTextFileType.INSTANCE;
        }
        return HttpRequestFileUtils.findByExtension(mimeType, fileType);
    }

    @Nullable
    private static FileType findByExtension(String mimeType, FileType fileType) {
        String possibleExtension;
        if (fileType == null && mimeType != null && (possibleExtension = HttpRequestFileUtils.getPossibleExtensionFromMimeType(mimeType)) != null && (fileType = FileTypeManager.getInstance().getFileTypeByExtension(possibleExtension)) == UnknownFileType.INSTANCE) {
            fileType = null;
        }
        return fileType;
    }

    private static boolean isJson(@NotNull Collection<Language> languages2) {
        if (languages2 == null) {
            HttpRequestFileUtils.$$$reportNull$$$0(7);
        }
        for (Language language : languages2) {
            if (language != JsonLanguage.INSTANCE) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languages";
                break;
            }
        }
        objectArray2[1] = "com/intellij/httpClient/http/request/HttpRequestFileUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isLogFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileFromCollections";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isProvidedCollectionFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isHttpRequestSystemFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "hasHttpFilesInProject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isJson";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

