/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aiplayground.ui.chat.editor;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.aiplayground.models.chat.Chat;
import com.intellij.aiplayground.models.chat.ChatId;
import com.intellij.aiplayground.models.chat.ChatRepository;
import com.intellij.aiplayground.ui.chat.editor.ChatVirtualFile;
import com.intellij.aiplayground.ui.chat.editor.ChatVirtualFileHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\r\u001a\u00020\u0007H\u0016J\"\u0010\u000e\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0007H\u0014J\u001a\u0010\u0013\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0014J\u001c\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u0018\u00a8\u0006\u001a"}, d2={"Lcom/intellij/aiplayground/ui/chat/editor/PlaygroundFileSystem;", "Lcom/intellij/openapi/vfs/DeprecatedVirtualFileSystem;", "<init>", "()V", "findFileByPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "", "refresh", "", "asynchronous", "", "refreshAndFindFileByPath", "getProtocol", "renameFile", "requestor", "", "vFile", "newName", "deleteFile", "wrapWithEvent", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "block", "Lkotlin/Function0;", "Companion", "intellij.aiplayground.ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPlaygroundFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlaygroundFileSystem.kt\ncom/intellij/aiplayground/ui/chat/editor/PlaygroundFileSystem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,70:1\n827#2:71\n855#2,2:72\n1310#3,2:74\n30#4,2:76\n*S KotlinDebug\n*F\n+ 1 PlaygroundFileSystem.kt\ncom/intellij/aiplayground/ui/chat/editor/PlaygroundFileSystem\n*L\n27#1:71\n27#1:72,2\n28#1:74,2\n32#1:76,2\n*E\n"})
public final class PlaygroundFileSystem
extends DeprecatedVirtualFileSystem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable = 8;
    @NotNull
    public static final String PROTOCOL = "ai-playground";

    /*
     * WARNING - void declaration
     */
    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        VirtualFile virtualFile;
        Object object;
        List split;
        String[] stringArray;
        block9: {
            void $this$filterNotTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            stringArray = new String[]{"/"};
            Iterable $this$filterNot$iv = StringsKt.split$default((CharSequence)path, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            int $i$f$filterNotTo = 0;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                String p0 = (String)element$iv$iv;
                boolean bl = false;
                CharSequence charSequence = p0;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            split = (List)destination$iv$iv;
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            Object[] $this$firstOrNull$iv = projectArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Project it = (Project)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getLocationHash(), (Object)CollectionsKt.getOrNull((List)split, (int)0))) continue;
                object = element$iv;
                break block9;
            }
            object = null;
        }
        stringArray = (String[])object;
        if (stringArray != null) {
            String[] project = stringArray;
            boolean bl = false;
            String string = (String)CollectionsKt.getOrNull((List)split, (int)1);
            if (string != null) {
                String id = string;
                boolean bl2 = false;
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<ChatRepository> serviceClass$iv = ChatRepository.class;
                Object object2 = $this$service$iv.getService(serviceClass$iv);
                if (object2 == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                Chat chat = ((ChatRepository)object2).getChat-HECah-U(ChatId.constructor-impl((String)id));
                if (chat != null) {
                    Chat chat2 = chat;
                    boolean bl3 = false;
                    virtualFile = ChatVirtualFileHolder.Companion.getInstance((Project)project).getOrCreate(chat2);
                } else {
                    virtualFile = null;
                }
            } else {
                virtualFile = null;
            }
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    public void refresh(boolean asynchronous) {
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.findFileByPath(path);
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    protected void renameFile(@Nullable Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        String string = vFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String oldName = string;
        this.fireBeforePropertyChange(requestor, vFile, "name", oldName, newName);
        this.wrapWithEvent((VFileEvent)new VFilePropertyChangeEvent((Object)this, vFile, "name", (Object)oldName, (Object)newName), (Function0<Unit>)((Function0)() -> PlaygroundFileSystem.renameFile$lambda$4(vFile, newName)));
        this.firePropertyChanged(requestor, vFile, "name", oldName, newName);
    }

    protected void deleteFile(@Nullable Object requestor, @NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        this.fireBeforeFileDeletion(requestor, vFile);
        this.wrapWithEvent((VFileEvent)new VFileDeleteEvent((Object)this, vFile), (Function0<Unit>)((Function0)PlaygroundFileSystem::deleteFile$lambda$5));
        this.fireFileDeleted(requestor, vFile, vFile.getName(), null);
    }

    public final void wrapWithEvent(@NotNull VFileEvent event, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        BulkFileListener listener = (BulkFileListener)messageBus.syncPublisher(topic);
        listener.before(CollectionsKt.listOf((Object)event));
        block.invoke();
        listener.after(CollectionsKt.listOf((Object)event));
    }

    private static final Unit renameFile$lambda$4(VirtualFile $vFile, String $newName) {
        Intrinsics.checkNotNull((Object)$vFile, (String)"null cannot be cast to non-null type com.intellij.aiplayground.ui.chat.editor.ChatVirtualFile");
        ((ChatVirtualFile)$vFile).setFileName($newName);
        return Unit.INSTANCE;
    }

    private static final Unit deleteFile$lambda$5() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/aiplayground/ui/chat/editor/PlaygroundFileSystem$Companion;", "", "<init>", "()V", "PROTOCOL", "", "getInstance", "Lcom/intellij/aiplayground/ui/chat/editor/PlaygroundFileSystem;", "intellij.aiplayground.ui"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PlaygroundFileSystem getInstance() {
            VirtualFileSystem virtualFileSystem = VirtualFileManager.getInstance().getFileSystem(PlaygroundFileSystem.PROTOCOL);
            Intrinsics.checkNotNull((Object)virtualFileSystem, (String)"null cannot be cast to non-null type com.intellij.aiplayground.ui.chat.editor.PlaygroundFileSystem");
            return (PlaygroundFileSystem)virtualFileSystem;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

