/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.diff;

import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.ModelLightCopier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.diff.DbDiffRoot;
import com.intellij.database.model.diff.SchemaDiffAction;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.structure.DvViewOptionsFun;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.ide.diff.AsyncDiffElement;
import com.intellij.ide.diff.DiffElement;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.dir.ComparableDiffElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.sql.SqlFileType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class DbDiffElement
extends DiffElement<BasicElement>
implements AsyncDiffElement,
ComparableDiffElement {
    static final Logger LOG = Logger.getInstance(DbDiffElement.class);
    public static final String IGNORE_ORDER = "IGNORE_ORDER";
    public static final String IGNORE_CASE = "IGNORE_CASE";
    public static final String IGNORE_SOURCE_CODE = "IGNORE_SOURCE_CODE";
    public static final String IGNORE_IMPLICIT_OBJECTS = "IGNORE_IMPLICIT_OBJECTS";
    public static final String PG_IGNORE_OWNER = "PG_IGNORE_OWNER";
    public static final String MYSQL_IGNORE_DEFINER = "MYSQL_IGNORE_DEFINER";
    private final Object myParent;
    private final BasicElement myElement;
    private BasicModElement myAltElement;

    public DbDiffElement(@NotNull DbDiffRoot root, @NotNull BasicElement element, @Nullable BasicModElement altElement) {
        if (root == null) {
            DbDiffElement.$$$reportNull$$$0(0);
        }
        if (element == null) {
            DbDiffElement.$$$reportNull$$$0(1);
        }
        this.myParent = root;
        this.myElement = element;
        this.myAltElement = altElement;
    }

    private DbDiffElement(@NotNull DbDiffElement parent, @NotNull BasicElement element, @Nullable BasicModElement altElement) {
        if (parent == null) {
            DbDiffElement.$$$reportNull$$$0(2);
        }
        if (element == null) {
            DbDiffElement.$$$reportNull$$$0(3);
        }
        this.myParent = parent;
        this.myElement = element;
        this.myAltElement = altElement;
    }

    public void reinitializeAltElement() {
        this.myAltElement = SchemaDiffAction.createAltElement(this.getRoot().getAltModel(), this.myElement);
    }

    public void refresh(boolean userInitiated) {
    }

    @NotNull
    public DbDiffRoot getRoot() {
        DbDiffRoot dbDiffRoot = this.myParent instanceof DbDiffRoot ? (DbDiffRoot)this.myParent : Objects.requireNonNull(this.getParent()).getRoot();
        if (dbDiffRoot == null) {
            DbDiffElement.$$$reportNull$$$0(4);
        }
        return dbDiffRoot;
    }

    @Nullable
    public DbDiffElement getParent() {
        return (DbDiffElement)((Object)ObjectUtils.tryCast((Object)this.myParent, DbDiffElement.class));
    }

    public String getPresentablePath() {
        return this.getRoot().getDataSource().getName() + ":/" + this.getPath(this.getValue());
    }

    public String getPath() {
        return this.getPresentablePath();
    }

    @NotNull
    private String getPath(@Nullable BasicElement value) {
        if (value == null) {
            return "";
        }
        String name2 = this.getIdentifierMode().apply(value.getName());
        BasicElement parent = value.getParent();
        String string = (String)(parent == null ? "" : this.getPath(parent) + DbDiffElement.getSeparator()) + name2;
        if (string == null) {
            DbDiffElement.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String elementName = this.myElement.identity(false) + ":" + this.myElement.getKind().code();
        String string = this.getIdentifierMode().apply(elementName);
        if (string == null) {
            DbDiffElement.$$$reportNull$$$0(6);
        }
        return string;
    }

    public String getPresentableName() {
        String elementName = this.myElement.getName();
        if (StringUtil.isEmpty((String)elementName)) {
            if (this.myElement instanceof DasForeignKey) {
                elementName = "foreign key";
            } else if (this.myElement instanceof DasTableKey) {
                elementName = ((DasTableKey)this.myElement).isPrimary() ? "primary key" : "key";
            } else if (this.myElement instanceof DasIndex) {
                boolean unique = ((DasIndex)this.myElement).isUnique();
                elementName = unique ? "unique index" : "index";
            }
        }
        return this.getIdentifierMode().apply(elementName);
    }

    public long getSize() {
        return -1L;
    }

    public long getTimeStamp() {
        return -1L;
    }

    public FileType getFileType() {
        return SqlFileType.INSTANCE;
    }

    public boolean isContainer() {
        return DbDiffElement.isContainer(this.myElement);
    }

    public static boolean isContainer(BasicElement element) {
        return element.hasChildren() && !(element instanceof BasicSourceAware);
    }

    public DiffElement<?>[] getChildren() {
        BasicElement targetElement = this.getParent() == null && this.getRoot().getRootElement().getParent() == this.myElement ? this.getRoot().getRootElement() : null;
        ArrayList<DbDiffElement> list = new ArrayList<DbDiffElement>();
        LocalDataSource lds = DbImplUtilCore.getMaybeLocalDataSource((DasDataSource)this.getRoot().getDataSource());
        TreePattern scope2 = lds == null ? null : lds.getIntrospectionScope();
        Condition<DasObject> uiFilter = this.getRoot().getFilter();
        boolean ignoreImplicit = this.isIgnoreImplicit();
        Condition filter = n -> DataSourceSchemaMapping.isIntrospected((TreePattern)scope2, (DasObject)n) && uiFilter.value(n) && (!ignoreImplicit || !(n instanceof BasicElement) || !DbDiffElement.isImplicitObject((BasicElement)n));
        Set hidden = DvViewOptionsFun.getDatabaseViewOptions((Project)this.getRoot().getProject()).getHiddenKinds();
        for (Family f : this.myElement.getFamilies()) {
            Object objects;
            ModFamily altF;
            if (hidden.contains(f.getMetaObject().kind.code())) continue;
            ModFamily modFamily = altF = this.myAltElement == null ? null : this.myAltElement.familyOf(((ModFamily)f).getMetaObject().kind);
            Object object = targetElement == null ? f.jbi().filter(filter) : (objects = targetElement.getParentFamily() == f ? Collections.singleton(targetElement) : Collections.emptyList());
            if (altF != null) {
                BaseModel.modifyFast((BasicModel)altF.getModel(), arg_0 -> this.lambda$getChildren$1(list, (Iterable)objects, altF, arg_0));
                continue;
            }
            this.appendChildrenOfFamiliesNotSupportingMigration(list, (Iterable<? extends BasicElement>)objects);
        }
        return list.isEmpty() ? EMPTY_ARRAY : list.toArray(DiffElement.EMPTY_ARRAY);
    }

    public static boolean isImplicitObject(BasicElement obj) {
        return obj.isAutoCreated() || obj.isElementSurrogate() || obj instanceof BasicIndex && !DbDiffElement.isExplicitIndex((BasicIndex)obj) || obj.getKind() == ObjectKind.DEFAULT && obj instanceof BasicNamedElement && ((BasicNamedElement)obj).isNameSurrogate();
    }

    private static boolean isExplicitIndex(BasicIndex obj) {
        BasicLikeTable table = obj.getLikeTable();
        if (table == null) {
            return true;
        }
        BasicKey key = (BasicKey)table.getDasChildren(ObjectKind.KEY).filter(BasicKey.class).filter(k -> k.getUnderlyingIndex() == obj).first();
        if (key == null) {
            return true;
        }
        return ((ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(DbImplUtilCore.getDbms((BasicElement)obj))).isIndexExplicitFor(obj, key);
    }

    private void appendChildren(List<DbDiffElement> list, Iterable<? extends BasicElement> f, @NotNull ModFamily<?> altF) {
        if (altF == null) {
            DbDiffElement.$$$reportNull$$$0(7);
        }
        altF.markChildrenAsSyncPending();
        Iterator it = altF.iterator();
        for (BasicElement basicElement : f) {
            BasicModElement alt;
            if (it != null && !it.hasNext()) {
                it = null;
            }
            BasicModElement basicModElement = alt = it == null ? altF.createNewOne() : (BasicModElement)it.next();
            if (alt != null) {
                alt.resetSyncPending();
            }
            list.add(new DbDiffElement(this, basicElement, alt));
        }
        altF.removeSyncPendingChildren();
    }

    private void appendChildrenOfFamiliesNotSupportingMigration(List<DbDiffElement> list, Iterable<? extends BasicElement> f) {
        for (BasicElement basicElement : f) {
            list.add(new DbDiffElement(this, basicElement, null));
        }
    }

    public byte @NotNull [] getContent() throws IOException {
        ScriptingSingleModelTaskBuilder builder = new ScriptingSingleModelTaskBuilder(this.getRoot().getModel(), ScriptCategory.CREATE_COMPLETE);
        builder.getElements().add(this.getValue());
        builder.setOptions(this.getRoot().createOptions());
        builder.setCurrentNamespace((BasicNamespace)DasUtil.getParentOfClass((DasObject)this.getValue(), BasicNamespace.class, (boolean)false));
        ScriptingResult result = ScriptGenerators.INSTANCE.makeScript(this.getRoot().getProject(), (ScriptingTask)builder.build());
        CompositeText script2 = result.getScript();
        byte[] byArray = script2.getText().toString().getBytes(this.getCharset());
        if (byArray == null) {
            DbDiffElement.$$$reportNull$$$0(8);
        }
        return byArray;
    }

    @NotNull
    public DiffContent createDiffContent(@Nullable Project project, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
        if (indicator == null) {
            DbDiffElement.$$$reportNull$$$0(9);
        }
        DiffContent diffContent = (DiffContent)ReadAction.compute(() -> {
            try {
                Project project1 = this.getRoot().getProject();
                Language language = this.getRoot().getLanguage();
                PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project1);
                String text = StringUtil.convertLineSeparators((String)new String(this.getContent(), this.getCharset()));
                PsiFile psiFile = psiFileFactory.createFileFromText("a." + this.getFileType().getDefaultExtension(), language, (CharSequence)text, false, true);
                VirtualFile virtualFile = psiFile.getViewProvider().getVirtualFile();
                if (virtualFile instanceof LightVirtualFile) {
                    ((LightVirtualFile)virtualFile).setWritable(false);
                }
                Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
                assert (document != null);
                DocumentContent content = DiffContentFactory.getInstance().create(project1, document, virtualFile);
                content.putUserData(DiffUserDataKeys.LANGUAGE, (Object)language);
                return content;
            }
            catch (IOException e) {
                throw new DiffRequestProducerException((Throwable)e);
            }
        });
        if (diffContent == null) {
            DbDiffElement.$$$reportNull$$$0(10);
        }
        return diffContent;
    }

    @NotNull
    private Case getIdentifierMode() {
        Case case_ = this.isIgnoreCase() ? Case.LOWER : Case.MIXED;
        if (case_ == null) {
            DbDiffElement.$$$reportNull$$$0(11);
        }
        return case_;
    }

    private boolean isIgnoreCase() {
        return (Boolean)this.getRoot().getSettings().customSettings.get(IGNORE_CASE);
    }

    private boolean isIgnoreImplicit() {
        return (Boolean)this.getRoot().getSettings().customSettings.get(IGNORE_IMPLICIT_OBJECTS);
    }

    private boolean isIgnoreSources() {
        return (Boolean)this.getRoot().getSettings().customSettings.get(IGNORE_SOURCE_CODE);
    }

    @NotNull
    public BasicElement getValue() {
        BasicElement basicElement = this.myElement;
        if (basicElement == null) {
            DbDiffElement.$$$reportNull$$$0(12);
        }
        return basicElement;
    }

    @Nullable
    public BasicModElement getAltElement() {
        return this.myAltElement;
    }

    public Icon getIcon() {
        return this.myParent instanceof DbDiffRoot ? this.getRoot().getDataSource().getIcon() : DbPresentationCore.getIcon((DasObject)this.getValue());
    }

    public boolean isOperationsEnabled() {
        return true;
    }

    @NotNull
    public Promise<DiffElement> copyToAsync(@NotNull DiffElement container, @Nullable DiffElement target, @NotNull String relativePath) {
        if (container == null) {
            DbDiffElement.$$$reportNull$$$0(13);
        }
        if (relativePath == null) {
            DbDiffElement.$$$reportNull$$$0(14);
        }
        Promise promise = Promises.cancelledPromise();
        if (promise == null) {
            DbDiffElement.$$$reportNull$$$0(15);
        }
        return promise;
    }

    @NotNull
    public Promise<Void> deleteAsync() {
        Promise promise = Promises.cancelledPromise();
        if (promise == null) {
            DbDiffElement.$$$reportNull$$$0(16);
        }
        return promise;
    }

    public String toString() {
        return "DbDiffElement{kind=" + String.valueOf(this.myElement.getKind()) + ", name=" + QNameUtil.getQualifiedName((DasObject)this.myElement) + "}";
    }

    @Nullable
    public Boolean isContentEqual(@NotNull DiffElement other) {
        DbDiffElement e2;
        if (other == null) {
            DbDiffElement.$$$reportNull$$$0(17);
        }
        if ((e2 = (DbDiffElement)((Object)ObjectUtils.tryCast((Object)other, DbDiffElement.class))) == null) {
            return null;
        }
        if (this.myAltElement == null && e2.myAltElement == null) {
            return this.isEqual(this.getValue(), e2.getValue());
        }
        if (this.myAltElement == null || e2.myAltElement == null) {
            return null;
        }
        return this.isEqual((BasicElement)Objects.requireNonNull(this.myAltElement), e2.getValue()) && this.isEqual((BasicElement)Objects.requireNonNull(e2.myAltElement), this.getValue());
    }

    private void fillAltElement(DbDiffElement other) {
        BasicModElement altElement = Objects.requireNonNull(this.myAltElement);
        if (other != null) {
            DbDiffElement.assignElement(other.getValue(), altElement, false);
        }
        BasicMetaUtils.copyMatchedProperties((BasicElement)this.getValue(), (BasicModElement)altElement, (other == null ? 1 : 0) != 0, (boolean)false, (boolean)true);
    }

    private void fillAltElementUpward(@NotNull DbDiffElement other, boolean withSources) {
        if (other == null) {
            DbDiffElement.$$$reportNull$$$0(18);
        }
        BasicModElement alt = this.myAltElement;
        for (BasicElement o = other.getValue(); alt != null && o != null; alt = alt.getParent(), o = o.getParent()) {
            DbDiffElement.assignElement(o, alt, withSources);
        }
    }

    public void prepare(@Nullable DiffElement<?> other) {
        if (this.myAltElement == null) {
            return;
        }
        BaseModel.modifyFast((BasicModel)this.myAltElement.getModel(), r -> {
            DbDiffElement o = (DbDiffElement)((Object)((Object)ObjectUtils.tryCast((Object)other, DbDiffElement.class)));
            boolean withSources = !this.isIgnoreSources();
            this.fillAltElement(o);
            if (!this.isContainer()) {
                DbDiffElement.copyChildren(this.getValue(), this.myAltElement, withSources);
            }
            if (withSources) {
                BasicMetaUtils.copySourceText((BasicElement)this.getValue(), (BasicModElement)this.myAltElement, (boolean)true, (boolean)true);
            }
            if (o != null && this.getParent() == null) {
                this.fillAltElementUpward(o, withSources);
            }
        });
    }

    public static void copyChildren(@NotNull BasicElement from, @NotNull BasicModElement to, boolean withSources) {
        if (from == null) {
            DbDiffElement.$$$reportNull$$$0(19);
        }
        if (to == null) {
            DbDiffElement.$$$reportNull$$$0(20);
        }
        DbDiffElement.copyChildren(from, to, withSources, Predicates.alwaysTrue());
    }

    public static void copyChildren(@NotNull BasicElement from, @NotNull BasicModElement to, boolean withSources, @NotNull Predicate<ObjectKind> filter) {
        if (from == null) {
            DbDiffElement.$$$reportNull$$$0(21);
        }
        if (to == null) {
            DbDiffElement.$$$reportNull$$$0(22);
        }
        if (filter == null) {
            DbDiffElement.$$$reportNull$$$0(23);
        }
        for (Family fromF : from.getFamilies()) {
            ModFamily toF;
            ObjectKind kind;
            if (fromF.isEmpty() || !filter.test(kind = fromF.first().getKind()) || (toF = to.familyOf(kind)) == null) continue;
            toF.clear();
            for (BasicElement fromC : fromF) {
                BasicModElement toC = toF.createNewOne();
                DbDiffElement.assignElement(fromC, toC, withSources);
                DbDiffElement.copyChildren(fromC, toC, withSources);
            }
        }
    }

    public static void assignElement(@NotNull BasicElement from, @NotNull BasicModElement to, boolean withSources) {
        if (from == null) {
            DbDiffElement.$$$reportNull$$$0(24);
        }
        if (to == null) {
            DbDiffElement.$$$reportNull$$$0(25);
        }
        if (from.getMetaObject() != to.getMetaObject()) {
            BasicMetaUtils.copyMatchedProperties((BasicElement)from, (BasicModElement)to, (boolean)true, (boolean)withSources, (boolean)true);
        } else {
            ModelLightCopier.copyProperties((BasicElement)from, (BasicModElement)to, (boolean)withSources, (boolean)true);
        }
    }

    private boolean isEqual(@NotNull BasicElement o1, @NotNull BasicElement o2) {
        if (o1 == null) {
            DbDiffElement.$$$reportNull$$$0(26);
        }
        if (o2 == null) {
            DbDiffElement.$$$reportNull$$$0(27);
        }
        return ScriptGenerators.INSTANCE.byModel(this.getRoot().getModel()).isEqual(o1, o2, this.getRoot().createOptions());
    }

    private /* synthetic */ void lambda$getChildren$1(List list, Iterable objects, ModFamily altF, BasicModRoot r) {
        this.appendChildren(list, objects, altF);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 8, 10, 11, 12, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/diff/DbDiffElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "altF";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 19: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 20: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/diff/DbDiffElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffContent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentifierMode";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "copyToAsync";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "deleteAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendChildren";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDiffContent";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "copyToAsync";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isContentEqual";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fillAltElementUpward";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "copyChildren";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "assignElement";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isEqual";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 8, 10, 11, 12, 15, 16 -> new IllegalStateException(string);
        };
    }
}

