/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.tooltip.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TipLayoutHint;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TooltipAnchor;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.HorizontalAxisTooltipPosition;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.VerticalAxisTooltipPosition;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.layout.HorizontalTooltipExpander;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.layout.LayoutManager;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.layout.VerticalAlignmentResolver;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.layout.VerticalTooltipRotatingExpander;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.spec.TooltipSpec;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 <2\u00020\u0001:\u0005<=>?@B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J:\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00112\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011H\u0002J\u001e\u0010 \u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00142\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0002J*\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00112\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0002J(\u0010#\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u00052\u000e\b\u0002\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0002J(\u0010%\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020)H\u0002J*\u0010*\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010$\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020-H\u0002J\u001c\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0010\u00100\u001a\u00020-2\u0006\u00101\u001a\u00020\u0014H\u0002J\u0010\u00100\u001a\u00020-2\u0006\u00101\u001a\u00020\u0012H\u0002J\u0010\u00100\u001a\u00020-2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020-2\u0006\u00101\u001a\u00020\u0014H\u0002J\u0010\u00104\u001a\u00020-2\u0006\u00101\u001a\u00020\u0012H\u0002J\u0010\u00104\u001a\u00020-2\u0006\u00102\u001a\u000203H\u0002J\u0018\u00105\u001a\u00020-2\u0006\u00101\u001a\u00020\u00122\u0006\u00106\u001a\u00020\u0003H\u0002J\u0018\u00107\u001a\u00020-2\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u00108\u001a\u00020\u001cH\u0002J\u0010\u00109\u001a\u00020-2\u0006\u0010'\u001a\u00020\nH\u0002J\u001c\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0018\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager;", "", "myViewport", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "myPreferredHorizontalAlignment", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$HorizontalAlignment;", "(Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$HorizontalAlignment;)V", "myCursorCoord", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "myHorizontalSpace", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "myHorizontalTooltipSpace", "myVerticalAlignmentResolver", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/VerticalAlignmentResolver;", "myVerticalSpace", "myVerticalTooltipSpace", "arrange", "", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$PositionedTooltip;", "tooltips", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$MeasuredTooltip;", "cursorCoord", "geomBounds", "hAxisTooltipPosition", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/HorizontalAxisTooltipPosition;", "vAxisTooltipPosition", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/VerticalAxisTooltipPosition;", "calculateAnchorX", "", "measuredTooltip", "horizontalAlignment", "calculateCornerTooltipsPosition", "calculateCursorTooltipPosition", "restrictions", "calculateDataTooltipsPosition", "calculateHorizontalTooltipPosition", "preferredAlignment", "calculatePlotCornerTooltipPosition", "tooltipY", "verticalTooltipRange", "horizontalAnchor", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/TooltipAnchor$HorizontalAnchor;", "calculateVerticalTooltipPosition", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$VerticalAlignment;", "ignoreCursor", "", "centered", "fixOverlappingWithShifting", "isAxisTooltip", "tooltip", "tooltipSpec", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/spec/TooltipSpec;", "isCorner", "isTooltipWithinBounds", "bounds", "overlapsCursorHorizontalRange", "tooltipX", "overlapsCursorVerticalRange", "rearrangeWithoutOverlapping", "selectCorner", "Companion", "HorizontalAlignment", "MeasuredTooltip", "PositionedTooltip", "VerticalAlignment", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nLayoutManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayoutManager.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,725:1\n288#2,2:726\n288#2,2:728\n1549#2:730\n1620#2,3:731\n766#2:734\n857#2,2:735\n819#2:737\n847#2,2:738\n1726#2,3:740\n766#2:743\n857#2,2:744\n1477#2:746\n1502#2,3:747\n1505#2,3:757\n1855#2,2:762\n1855#2,2:765\n1855#2,2:767\n1045#2:769\n766#2:770\n857#2,2:771\n1963#2,14:773\n1855#2,2:787\n1855#2,2:789\n1045#2:791\n766#2:792\n857#2,2:793\n2333#2,14:795\n1855#2,2:809\n1726#2,3:811\n1726#2,3:814\n766#2:817\n857#2,2:818\n372#3,7:750\n215#4:760\n216#4:764\n1#5:761\n*S KotlinDebug\n*F\n+ 1 LayoutManager.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager\n*L\n50#1:726,2\n95#1:728,2\n117#1:730\n117#1:731,3\n119#1:734\n119#1:735,2\n125#1:737\n125#1:738,2\n125#1:740,3\n203#1:743\n203#1:744,2\n204#1:746\n204#1:747,3\n204#1:757,3\n227#1:762,2\n258#1:765,2\n271#1:767,2\n274#1:769\n277#1:770\n277#1:771,2\n278#1:773,14\n286#1:787,2\n296#1:789,2\n299#1:791\n302#1:792\n302#1:793,2\n303#1:795,14\n333#1:809,2\n453#1:811,3\n531#1:814,3\n607#1:817\n607#1:818,2\n204#1:750,7\n205#1:760\n205#1:764\n*E\n"})
public final class LayoutManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DoubleRectangle myViewport;
    @NotNull
    private final HorizontalAlignment myPreferredHorizontalAlignment;
    @NotNull
    private final DoubleSpan myHorizontalSpace;
    @NotNull
    private DoubleSpan myVerticalSpace;
    @NotNull
    private DoubleVector myCursorCoord;
    @NotNull
    private DoubleSpan myHorizontalTooltipSpace;
    @NotNull
    private DoubleSpan myVerticalTooltipSpace;
    private VerticalAlignmentResolver myVerticalAlignmentResolver;
    @NotNull
    private static final DoubleVector CURSOR_DIMENSION = new DoubleVector(10.0, 10.0);
    @NotNull
    private static final DoubleSpan EMPTY_DOUBLE_RANGE = DoubleSpan.Companion.withLowerEnd(0.0, 0.0);

    public LayoutManager(@NotNull DoubleRectangle myViewport, @NotNull HorizontalAlignment myPreferredHorizontalAlignment) {
        Intrinsics.checkNotNullParameter((Object)myViewport, (String)"myViewport");
        Intrinsics.checkNotNullParameter((Object)((Object)myPreferredHorizontalAlignment), (String)"myPreferredHorizontalAlignment");
        this.myViewport = myViewport;
        this.myPreferredHorizontalAlignment = myPreferredHorizontalAlignment;
        this.myHorizontalSpace = new DoubleSpan(this.myViewport.getLeft(), this.myViewport.getRight());
        this.myVerticalSpace = new DoubleSpan(0.0, 0.0);
        this.myCursorCoord = DoubleVector.Companion.getZERO();
        this.myHorizontalTooltipSpace = new DoubleSpan(this.myViewport.getLeft(), this.myViewport.getRight());
        this.myVerticalTooltipSpace = new DoubleSpan(this.myViewport.getTop(), this.myViewport.getBottom());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PositionedTooltip> arrange(@NotNull List<MeasuredTooltip> tooltips, @NotNull DoubleVector cursorCoord, @NotNull DoubleRectangle geomBounds, @NotNull HorizontalAxisTooltipPosition hAxisTooltipPosition, @NotNull VerticalAxisTooltipPosition vAxisTooltipPosition) {
        void $this$filterNotTo$iv$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection<DoubleRectangle> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object v3;
        Object object;
        Object $this$firstOrNull$iv;
        ArrayList<PositionedTooltip> desiredPosition;
        block28: {
            Object v0;
            boolean bl;
            MeasuredTooltip it;
            block27: {
                Intrinsics.checkNotNullParameter(tooltips, (String)"tooltips");
                Intrinsics.checkNotNullParameter((Object)cursorCoord, (String)"cursorCoord");
                Intrinsics.checkNotNullParameter((Object)geomBounds, (String)"geomBounds");
                Intrinsics.checkNotNullParameter((Object)((Object)hAxisTooltipPosition), (String)"hAxisTooltipPosition");
                Intrinsics.checkNotNullParameter((Object)((Object)vAxisTooltipPosition), (String)"vAxisTooltipPosition");
                this.myCursorCoord = cursorCoord;
                this.myVerticalSpace = new DoubleSpan(this.myViewport.getTop(), this.myViewport.getBottom());
                this.myVerticalAlignmentResolver = new VerticalAlignmentResolver(this.myVerticalSpace);
                this.myHorizontalTooltipSpace = DoubleSpan.Companion.withLowerEnd(geomBounds.getLeft(), geomBounds.getWidth());
                this.myVerticalTooltipSpace = DoubleSpan.Companion.withLowerEnd(geomBounds.getTop(), geomBounds.getHeight());
                desiredPosition = new ArrayList<PositionedTooltip>();
                Iterable iterable = tooltips;
                boolean $i$f$firstOrNull = false;
                for (Object t : $this$firstOrNull$iv) {
                    it = (MeasuredTooltip)t;
                    bl = false;
                    if (!(it.getHintKind$plot_builder() == TipLayoutHint.Kind.X_AXIS_TOOLTIP)) continue;
                    v0 = t;
                    break block27;
                }
                v0 = null;
            }
            object = v0;
            if (object != null) {
                VerticalAlignment verticalAlignment;
                MeasuredTooltip xAxisTooltip = object;
                boolean bl2 = false;
                if (hAxisTooltipPosition.isBottom()) {
                    verticalAlignment = VerticalAlignment.BOTTOM;
                } else if (hAxisTooltipPosition.isTop()) {
                    verticalAlignment = VerticalAlignment.TOP;
                } else {
                    throw new IllegalStateException("Axis tooltips with BOTTOM or TOP positions are currently supported.".toString());
                }
                PositionedTooltip positionedTooltip = LayoutManager.calculateVerticalTooltipPosition$default(this, xAxisTooltip, verticalAlignment, true, false, 8, null);
                if (this.isTooltipWithinBounds(positionedTooltip, geomBounds)) {
                    DoubleSpan doubleSpan;
                    desiredPosition.add(positionedTooltip);
                    if (hAxisTooltipPosition.isBottom()) {
                        doubleSpan = new DoubleSpan(this.myViewport.getTop(), Math.min(positionedTooltip.getStemCoord().getY(), positionedTooltip.getTop$plot_builder()));
                    } else if (hAxisTooltipPosition.isTop()) {
                        doubleSpan = new DoubleSpan(Math.max(positionedTooltip.getStemCoord().getY(), positionedTooltip.getBottom$plot_builder()), this.myViewport.getBottom());
                    } else {
                        throw new IllegalStateException("Axis tooltips with BOTTOM or TOP positions are currently supported.".toString());
                    }
                    this.myVerticalSpace = doubleSpan;
                    this.myVerticalAlignmentResolver = new VerticalAlignmentResolver(this.myVerticalSpace);
                }
            }
            $this$firstOrNull$iv = (TipLayoutHint.Kind[])tooltips;
            boolean $i$f$firstOrNull = false;
            for (Object t : $this$firstOrNull$iv) {
                it = (MeasuredTooltip)t;
                bl = false;
                if (!(it.getHintKind$plot_builder() == TipLayoutHint.Kind.Y_AXIS_TOOLTIP)) continue;
                v3 = t;
                break block28;
            }
            v3 = null;
        }
        object = v3;
        if (object != null) {
            HorizontalAlignment horizontalAlignment;
            MeasuredTooltip it = object;
            boolean bl = false;
            if (vAxisTooltipPosition.isLeft()) {
                horizontalAlignment = HorizontalAlignment.LEFT;
            } else if (vAxisTooltipPosition.isRight()) {
                horizontalAlignment = HorizontalAlignment.RIGHT;
            } else {
                throw new IllegalStateException("Axis tooltips with LEFT or RIGHT positions are currently supported.".toString());
            }
            HorizontalAlignment horizontalAlignment2 = horizontalAlignment;
            PositionedTooltip positionedTooltip = LayoutManager.calculateHorizontalTooltipPosition$default(this, it, horizontalAlignment2, null, 4, null);
            if (this.isTooltipWithinBounds(positionedTooltip, geomBounds)) {
                desiredPosition.add(positionedTooltip);
            }
        }
        if (geomBounds.contains(cursorCoord)) {
            CollectionsKt.addAll((Collection)desiredPosition, (Iterable)this.calculateCornerTooltipsPosition(tooltips));
        }
        object = desiredPosition;
        $this$firstOrNull$iv = new TipLayoutHint.Kind[]{TipLayoutHint.Kind.Y_AXIS_TOOLTIP};
        $this$firstOrNull$iv = LayoutManager.Companion.select(desiredPosition, $this$firstOrNull$iv);
        List<MeasuredTooltip> list2 = tooltips;
        LayoutManager layoutManager = this;
        boolean $i$f$map = false;
        void bl = $this$map$iv;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            PositionedTooltip positionedTooltip = (PositionedTooltip)item$iv$iv;
            collection = collection2;
            boolean bl2 = false;
            collection.add(p0.rect$plot_builder());
        }
        collection = (List)collection2;
        $this$map$iv = layoutManager.calculateDataTooltipsPosition(list2, (List<DoubleRectangle>)collection);
        boolean $i$f$filter232 = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        Collection collection3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PositionedTooltip positionedTooltip = (PositionedTooltip)element$iv$iv;
            boolean bl3 = false;
            if (!this.isTooltipWithinBounds(positionedTooltip, geomBounds)) continue;
            collection3.add(element$iv$iv);
        }
        $this$filter$iv = (List)collection3;
        CollectionsKt.addAll((Collection)object, (Iterable)$this$filter$iv);
        Iterable $this$filterNot$iv = tooltips;
        boolean $i$f$filterNot = false;
        Iterable $i$f$filter232 = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean bl3 = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            MeasuredTooltip p0 = (MeasuredTooltip)element$iv$iv;
            boolean bl4 = false;
            if (this.isAxisTooltip(p0)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        if (!((Collection)((List)destination$iv$iv2)).isEmpty()) {
            boolean bl4;
            block29: {
                Iterable $this$all$iv = desiredPosition;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl4 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        PositionedTooltip positionedTooltip = (PositionedTooltip)element$iv;
                        boolean bl6 = false;
                        if (this.isAxisTooltip(positionedTooltip)) continue;
                        bl4 = false;
                        break block29;
                    }
                    bl4 = true;
                }
            }
            if (bl4) {
                desiredPosition.clear();
            }
        }
        return this.rearrangeWithoutOverlapping((List<PositionedTooltip>)desiredPosition);
    }

    private final boolean isTooltipWithinBounds(PositionedTooltip tooltip, DoubleRectangle bounds) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[tooltip.getHintKind$plot_builder().ordinal()]) {
            case 1: {
                bl = bounds.xRange().contains(tooltip.getStemCoord().getX());
                break;
            }
            case 2: {
                bl = bounds.yRange().contains(tooltip.getStemCoord().getY());
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                bl = bounds.contains(tooltip.getStemCoord());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final List<PositionedTooltip> calculateDataTooltipsPosition(List<MeasuredTooltip> tooltips, List<DoubleRectangle> restrictions) {
        ArrayList<PositionedTooltip> placementList = new ArrayList<PositionedTooltip>();
        for (MeasuredTooltip measuredTooltip : tooltips) {
            if (this.isCorner(measuredTooltip)) continue;
            switch (WhenMappings.$EnumSwitchMapping$0[measuredTooltip.getHintKind$plot_builder().ordinal()]) {
                case 3: {
                    placementList.add(LayoutManager.calculateVerticalTooltipPosition$default(this, measuredTooltip, VerticalAlignment.TOP, false, false, 8, null));
                    break;
                }
                case 4: {
                    placementList.add(this.calculateHorizontalTooltipPosition(measuredTooltip, this.myPreferredHorizontalAlignment, restrictions));
                    break;
                }
                case 5: {
                    placementList.add(this.calculateCursorTooltipPosition(measuredTooltip, restrictions));
                    break;
                }
                case 6: {
                    placementList.add(this.calculateVerticalTooltipPosition(measuredTooltip, VerticalAlignment.BOTTOM, true, false));
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                }
            }
        }
        return placementList;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PositionedTooltip> calculateCornerTooltipsPosition(List<MeasuredTooltip> tooltips) {
        Object answer$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        ArrayList<PositionedTooltip> placementList = new ArrayList<PositionedTooltip>();
        Iterable $this$filter$iv = tooltips;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MeasuredTooltip p0 = (MeasuredTooltip)element$iv$iv;
            boolean bl = false;
            if (!this.isCorner(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            TooltipAnchor key$iv$iv;
            MeasuredTooltip it = (MeasuredTooltip)element$iv$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)it.getTooltipSpec$plot_builder().getAnchor());
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Object $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            DoubleSpan doubleSpan;
            Object object32;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            TooltipAnchor tooltipAnchor = (TooltipAnchor)entry.getKey();
            List cornerTooltips = (List)entry.getValue();
            Iterable bl3 = cornerTooltips;
            double d = 0.0;
            for (Object object32 : bl3) {
                void it;
                answer$iv$iv$iv = (MeasuredTooltip)object32;
                double d2 = d;
                boolean bl4 = false;
                double d3 = it.getSize$plot_builder().getY();
                d = d2 + d3;
            }
            double tooltipsHeight = d + 5.0 * (double)cornerTooltips.size();
            switch (WhenMappings.$EnumSwitchMapping$1[tooltipAnchor.getVerticalAnchor().ordinal()]) {
                case 1: {
                    doubleSpan = LayoutManager.Companion.rightAligned(this.myVerticalTooltipSpace.getLowerEnd(), tooltipsHeight, 0.0);
                    break;
                }
                case 2: {
                    doubleSpan = LayoutManager.Companion.leftAligned(this.myVerticalTooltipSpace.getUpperEnd(), tooltipsHeight, 0.0);
                    break;
                }
                case 3: {
                    doubleSpan = LayoutManager.Companion.centered((this.myVerticalTooltipSpace.getLowerEnd() + this.myVerticalTooltipSpace.getUpperEnd()) / (double)2, tooltipsHeight);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DoubleSpan verticalTooltipRange = doubleSpan;
            double tooltipY = 0.0;
            tooltipY = verticalTooltipRange.getLowerEnd();
            Iterable $this$forEach$iv2 = cornerTooltips;
            boolean $i$f$forEach2 = false;
            object32 = $this$forEach$iv2.iterator();
            while (object32.hasNext()) {
                Object element$iv2 = object32.next();
                MeasuredTooltip tooltip = (MeasuredTooltip)element$iv2;
                boolean bl5 = false;
                PositionedTooltip positionedTooltip = this.calculatePlotCornerTooltipPosition(tooltip, tooltipY, verticalTooltipRange, tooltipAnchor.getHorizontalAnchor());
                placementList.add(positionedTooltip);
                tooltipY += positionedTooltip.getHeight$plot_builder() + 5.0;
            }
        }
        return placementList;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PositionedTooltip> rearrangeWithoutOverlapping(List<PositionedTooltip> tooltips) {
        Object element$iv4;
        Iterator $this$maxByOrNull$iv;
        boolean $i$f$filterTo;
        Iterable $this$filter$iv;
        void $this$sortedBy$iv;
        Iterable element$iv22;
        Iterable $this$forEach$iv;
        boolean $i$f$forEach;
        double d;
        double d2;
        List horizontalsWithOverlappedCorners;
        Object p0;
        if (tooltips.isEmpty()) {
            return tooltips;
        }
        ArrayList<DoubleRectangle> restrictions = new ArrayList<DoubleRectangle>();
        ArrayList<PositionedTooltip> separatedTooltips = new ArrayList<PositionedTooltip>();
        TipLayoutHint.Kind[] kindArray = new TipLayoutHint.Kind[]{TipLayoutHint.Kind.CURSOR_TOOLTIP, TipLayoutHint.Kind.X_AXIS_TOOLTIP, TipLayoutHint.Kind.Y_AXIS_TOOLTIP};
        Iterable $this$forEach$iv2 = LayoutManager.Companion.select(tooltips, kindArray);
        boolean $i$f$forEach22 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            p0 = (PositionedTooltip)element$iv3;
            boolean bl2 = false;
            LayoutManager.rearrangeWithoutOverlapping$fixate(separatedTooltips, restrictions, (PositionedTooltip)p0);
        }
        TipLayoutHint.Kind[] $i$f$forEach22 = new TipLayoutHint.Kind[]{TipLayoutHint.Kind.HORIZONTAL_TOOLTIP};
        List horizontalTooltips = horizontalsWithOverlappedCorners = LayoutManager.Companion.withOverlapped(LayoutManager.Companion.select(tooltips, $i$f$forEach22), this.selectCorner(tooltips));
        boolean bl = false;
        p0 = horizontalTooltips;
        double bl2 = 0.0;
        Iterator iterator2 = p0.iterator();
        while (iterator2.hasNext()) {
            void p02;
            Object t = iterator2.next();
            PositionedTooltip positionedTooltip = (PositionedTooltip)t;
            d2 = bl2;
            boolean bl3 = false;
            d = p02.getHeight$plot_builder();
            bl2 = d2 + d;
        }
        if (bl2 < this.myVerticalSpace.getLength()) {
            p0 = new HorizontalTooltipExpander(this.myVerticalSpace).fixOverlapping(horizontalTooltips);
            $i$f$forEach = false;
            for (Iterable element$iv22 : $this$forEach$iv) {
                PositionedTooltip p03 = (PositionedTooltip)((Object)element$iv22);
                boolean bl4 = false;
                LayoutManager.rearrangeWithoutOverlapping$fixate(separatedTooltips, restrictions, p03);
            }
        } else {
            PositionedTooltip positionedTooltip;
            Object v0;
            void $this$filterTo$iv$iv;
            $this$forEach$iv = horizontalTooltips;
            boolean $i$f$sortedBy = false;
            List tooltips2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a2, T b2) {
                    PositionedTooltip it = (PositionedTooltip)a2;
                    boolean bl = false;
                    Comparable comparable = Double.valueOf(it.getStemCoord().getY());
                    it = (PositionedTooltip)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getStemCoord().getY()));
                }
            });
            boolean bl5 = false;
            element$iv22 = tooltips2;
            boolean $i$f$filter = false;
            void bl4 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PositionedTooltip it = (PositionedTooltip)element$iv$iv;
                boolean bl6 = false;
                if (!(it.getStemCoord().getY() < this.myCursorCoord.getY())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    PositionedTooltip it = (PositionedTooltip)maxElem$iv;
                    boolean bl7 = false;
                    double maxValue$iv = it.getStemCoord().getY();
                    do {
                        Object e$iv = iterator$iv.next();
                        PositionedTooltip it2 = (PositionedTooltip)e$iv;
                        $i$a$-maxByOrNull-LayoutManager$rearrangeWithoutOverlapping$2$4$2 = false;
                        double v$iv = it2.getStemCoord().getY();
                        if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            if ((positionedTooltip = (PositionedTooltip)v0) == null) {
                positionedTooltip = (PositionedTooltip)CollectionsKt.first((List)tooltips2);
            }
            PositionedTooltip p04 = positionedTooltip;
            boolean bl8 = false;
            LayoutManager.rearrangeWithoutOverlapping$fixate(separatedTooltips, restrictions, p04);
        }
        Iterable $this$forEach$iv3 = CollectionsKt.minus((Iterable)this.selectCorner(tooltips), (Iterable)horizontalsWithOverlappedCorners);
        boolean $i$f$forEach3 = false;
        for (Object element$iv4 : $this$forEach$iv3) {
            PositionedTooltip p05 = (PositionedTooltip)element$iv4;
            boolean bl9 = false;
            LayoutManager.rearrangeWithoutOverlapping$fixate(separatedTooltips, restrictions, p05);
        }
        TipLayoutHint.Kind[] kindArray2 = new TipLayoutHint.Kind[]{TipLayoutHint.Kind.VERTICAL_TOOLTIP, TipLayoutHint.Kind.ROTATED_TOOLTIP};
        List verticalTooltips = CollectionsKt.minus((Iterable)LayoutManager.Companion.select(tooltips, kindArray2), (Iterable)this.selectCorner(tooltips));
        boolean bl10 = false;
        element$iv4 = verticalTooltips;
        double d3 = 0.0;
        $this$maxByOrNull$iv = element$iv4.iterator();
        while ($this$maxByOrNull$iv.hasNext()) {
            void p06;
            Object $i$f$maxByOrNull = $this$maxByOrNull$iv.next();
            PositionedTooltip iterator$iv = (PositionedTooltip)$i$f$maxByOrNull;
            d2 = d3;
            boolean bl11 = false;
            d = p06.getWidth$plot_builder();
            d3 = d2 + d;
        }
        if (d3 < this.myHorizontalSpace.getLength()) {
            element$iv4 = this.fixOverlappingWithShifting(new VerticalTooltipRotatingExpander(this.myVerticalSpace, this.myHorizontalSpace).fixOverlapping(verticalTooltips, (List<DoubleRectangle>)restrictions));
            $i$f$forEach = false;
            for (Iterable element$iv22 : $this$forEach$iv) {
                PositionedTooltip p07 = (PositionedTooltip)((Object)element$iv22);
                boolean bl12 = false;
                LayoutManager.rearrangeWithoutOverlapping$fixate(separatedTooltips, restrictions, p07);
            }
        } else {
            PositionedTooltip positionedTooltip;
            Object v2;
            void $this$minByOrNull$iv;
            void $this$filterTo$iv$iv;
            $this$forEach$iv = verticalTooltips;
            boolean $i$f$sortedBy = false;
            List tooltips3 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a2, T b2) {
                    PositionedTooltip it = (PositionedTooltip)a2;
                    boolean bl = false;
                    Comparable comparable = Double.valueOf(it.getStemCoord().getX());
                    it = (PositionedTooltip)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getStemCoord().getX()));
                }
            });
            boolean bl13 = false;
            element$iv22 = tooltips3;
            boolean $i$f$filter = false;
            Iterable bl12 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PositionedTooltip it = (PositionedTooltip)element$iv$iv;
                boolean bl14 = false;
                if (!(it.getStemCoord().getX() > this.myCursorCoord.getX())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v2 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v2 = minElem$iv;
                } else {
                    PositionedTooltip it = (PositionedTooltip)minElem$iv;
                    boolean bl15 = false;
                    double minValue$iv = it.getStemCoord().getX();
                    do {
                        Object e$iv = iterator$iv.next();
                        PositionedTooltip it3 = (PositionedTooltip)e$iv;
                        $i$a$-minByOrNull-LayoutManager$rearrangeWithoutOverlapping$4$4$2 = false;
                        double v$iv = it3.getStemCoord().getX();
                        if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v2 = minElem$iv;
                }
            }
            if ((positionedTooltip = (PositionedTooltip)v2) == null) {
                positionedTooltip = (PositionedTooltip)CollectionsKt.last((List)tooltips3);
            }
            PositionedTooltip p08 = positionedTooltip;
            boolean bl16 = false;
            LayoutManager.rearrangeWithoutOverlapping$fixate(separatedTooltips, restrictions, p08);
        }
        return separatedTooltips;
    }

    private final List<PositionedTooltip> fixOverlappingWithShifting(List<PositionedTooltip> tooltips) {
        ArrayList<PositionedTooltip> placementList = new ArrayList<PositionedTooltip>();
        Function1[] function1Array = new Function1[]{fixOverlappingWithShifting.1.INSTANCE, fixOverlappingWithShifting.2.INSTANCE};
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)tooltips, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PositionedTooltip positionedTooltip;
            PositionedTooltip tooltip = (PositionedTooltip)element$iv;
            boolean bl = false;
            if (LayoutManager.Companion.isOverlapped(placementList, tooltip)) {
                DoubleVector newPosition = new DoubleVector(((PositionedTooltip)CollectionsKt.last((List)placementList)).rect$plot_builder().getRight() + 5.0, tooltip.getTooltipCoord().getY());
                positionedTooltip = tooltip.moveTo$plot_builder(newPosition);
            } else {
                positionedTooltip = tooltip;
            }
            PositionedTooltip newTooltip = positionedTooltip;
            placementList.add(newTooltip);
        }
        return placementList;
    }

    private final PositionedTooltip calculateVerticalTooltipPosition(MeasuredTooltip measuredTooltip, VerticalAlignment preferredAlignment, boolean ignoreCursor, boolean centered) {
        double tooltipY;
        double stemY;
        double tooltipX;
        block7: {
            DoubleSpan bottomTooltipRange;
            double targetBottomPoint;
            block9: {
                DoubleSpan cursorVerticalRange;
                DoubleSpan topTooltipRange;
                double tooltipHeight;
                double targetTopPoint;
                double targetCoordY;
                LayoutManager $this$calculateVerticalTooltipPosition_u24lambda_u2431;
                block8: {
                    block6: {
                        tooltipX = centered ? LayoutManager.Companion.centerInsideRange(measuredTooltip.getHintCoord$plot_builder().getX(), measuredTooltip.getSize$plot_builder().getX(), this.myHorizontalSpace) : measuredTooltip.getHintCoord$plot_builder().getX();
                        stemY = 0.0;
                        tooltipY = 0.0;
                        $this$calculateVerticalTooltipPosition_u24lambda_u2431 = this;
                        boolean bl = false;
                        targetCoordY = measuredTooltip.getHintCoord$plot_builder().getY();
                        double stemLength = measuredTooltip.getStemLength$plot_builder();
                        targetTopPoint = targetCoordY - measuredTooltip.getHintRadius$plot_builder();
                        targetBottomPoint = targetCoordY + measuredTooltip.getHintRadius$plot_builder();
                        tooltipHeight = measuredTooltip.getSize$plot_builder().getY();
                        topTooltipRange = LayoutManager.Companion.leftAligned(targetTopPoint, tooltipHeight, stemLength);
                        bottomTooltipRange = LayoutManager.Companion.rightAligned(targetBottomPoint, tooltipHeight, stemLength);
                        cursorVerticalRange = !ignoreCursor && $this$calculateVerticalTooltipPosition_u24lambda_u2431.overlapsCursorHorizontalRange(measuredTooltip, tooltipX) ? DoubleSpan.Companion.withLowerEnd($this$calculateVerticalTooltipPosition_u24lambda_u2431.myCursorCoord.getY(), CURSOR_DIMENSION.getY()) : EMPTY_DOUBLE_RANGE;
                        if (measuredTooltip.getHintKind$plot_builder() != TipLayoutHint.Kind.X_AXIS_TOOLTIP || preferredAlignment != VerticalAlignment.TOP) break block6;
                        tooltipY = $this$calculateVerticalTooltipPosition_u24lambda_u2431.myVerticalSpace.contains(topTooltipRange) ? topTooltipRange.getLowerEnd().doubleValue() : $this$calculateVerticalTooltipPosition_u24lambda_u2431.myVerticalSpace.getLowerEnd().doubleValue();
                        stemY = targetTopPoint;
                        break block7;
                    }
                    if (measuredTooltip.getHintKind$plot_builder() != TipLayoutHint.Kind.X_AXIS_TOOLTIP || preferredAlignment != VerticalAlignment.BOTTOM) break block8;
                    tooltipY = $this$calculateVerticalTooltipPosition_u24lambda_u2431.myVerticalSpace.contains(bottomTooltipRange) ? bottomTooltipRange.getLowerEnd() : $this$calculateVerticalTooltipPosition_u24lambda_u2431.myVerticalSpace.getUpperEnd() - tooltipHeight;
                    stemY = targetBottomPoint;
                    break block7;
                }
                if (!$this$calculateVerticalTooltipPosition_u24lambda_u2431.myVerticalTooltipSpace.contains(targetTopPoint)) break block9;
                VerticalAlignmentResolver verticalAlignmentResolver = $this$calculateVerticalTooltipPosition_u24lambda_u2431.myVerticalAlignmentResolver;
                if (verticalAlignmentResolver == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myVerticalAlignmentResolver");
                    verticalAlignmentResolver = null;
                }
                switch (WhenMappings.$EnumSwitchMapping$2[verticalAlignmentResolver.resolve(topTooltipRange, bottomTooltipRange, preferredAlignment, cursorVerticalRange).ordinal()]) {
                    case 1: {
                        tooltipY = topTooltipRange.getLowerEnd();
                        stemY = targetTopPoint;
                        break block7;
                    }
                    case 2: {
                        tooltipY = bottomTooltipRange.getLowerEnd();
                        stemY = targetBottomPoint;
                        break block7;
                    }
                    case 3: {
                        tooltipY = LayoutManager.Companion.centerInsideRange(targetCoordY, tooltipHeight, $this$calculateVerticalTooltipPosition_u24lambda_u2431.myVerticalSpace);
                        stemY = targetCoordY;
                        break block7;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            tooltipY = bottomTooltipRange.getLowerEnd();
            stemY = targetBottomPoint;
        }
        return new PositionedTooltip(measuredTooltip, new DoubleVector(tooltipX, tooltipY), new DoubleVector(measuredTooltip.getHintCoord$plot_builder().getX(), stemY));
    }

    static /* synthetic */ PositionedTooltip calculateVerticalTooltipPosition$default(LayoutManager layoutManager, MeasuredTooltip measuredTooltip, VerticalAlignment verticalAlignment, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return layoutManager.calculateVerticalTooltipPosition(measuredTooltip, verticalAlignment, bl, bl2);
    }

    /*
     * Unable to fully structure code
     */
    private final PositionedTooltip calculateHorizontalTooltipPosition(MeasuredTooltip measuredTooltip, HorizontalAlignment preferredAlignment, List<DoubleRectangle> restrictions) {
        block14: {
            block16: {
                block15: {
                    block13: {
                        block12: {
                            tooltipY = org.jetbrains.letsPlot.core.plot.builder.tooltip.layout.LayoutManager$Companion.access$centerInsideRange(LayoutManager.Companion, measuredTooltip.getHintCoord$plot_builder().getY(), measuredTooltip.getSize$plot_builder().getY(), this.myVerticalSpace);
                            tooltipX = 0.0;
                            stemX = 0.0;
                            $this$calculateHorizontalTooltipPosition_u24lambda_u2433 = this;
                            $i$a$-run-LayoutManager$calculateHorizontalTooltipPosition$1 = false;
                            targetCoordX = measuredTooltip.getHintCoord$plot_builder().getX();
                            tooltipWidth = measuredTooltip.getSize$plot_builder().getX();
                            hintSize = measuredTooltip.getHintRadius$plot_builder();
                            stemLength = measuredTooltip.getStemLength$plot_builder();
                            margin = hintSize + stemLength;
                            targetLeftPoint = targetCoordX - hintSize;
                            leftTooltipPlacement = org.jetbrains.letsPlot.core.plot.builder.tooltip.layout.LayoutManager$Companion.access$leftAligned(LayoutManager.Companion, targetCoordX, tooltipWidth, margin);
                            rightTooltipPlacement = org.jetbrains.letsPlot.core.plot.builder.tooltip.layout.LayoutManager$Companion.access$rightAligned(LayoutManager.Companion, targetCoordX, tooltipWidth, margin);
                            if (!$this$calculateHorizontalTooltipPosition_u24lambda_u2433.myHorizontalSpace.contains(leftTooltipPlacement) || measuredTooltip.getHintKind$plot_builder() != TipLayoutHint.Kind.Y_AXIS_TOOLTIP && !$this$calculateHorizontalTooltipPosition_u24lambda_u2433.myHorizontalTooltipSpace.contains(targetLeftPoint)) ** GOTO lbl-1000
                            $this$all$iv = restrictions;
                            $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                v0 = true;
                            } else {
                                for (T element$iv : $this$all$iv) {
                                    it = (DoubleRectangle)element$iv;
                                    $i$a$-all-LayoutManager$calculateHorizontalTooltipPosition$1$canFitLeft$1 = false;
                                    tooltipRect = new DoubleRectangle(new DoubleVector(leftTooltipPlacement.getLowerEnd(), tooltipY), measuredTooltip.getSize$plot_builder());
                                    if (it.intersects(tooltipRect) == false) continue;
                                    v0 = false;
                                    break block12;
                                }
                                v0 = true;
                            }
                        }
                        if (v0) {
                            v1 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v1 = false;
                        }
                        canFitLeft = v1;
                        canFitRight = $this$calculateHorizontalTooltipPosition_u24lambda_u2433.myHorizontalSpace.contains(rightTooltipPlacement);
                        if (measuredTooltip.getHintKind$plot_builder() != TipLayoutHint.Kind.Y_AXIS_TOOLTIP || preferredAlignment != HorizontalAlignment.LEFT || canFitLeft) break block13;
                        tooltipX = $this$calculateHorizontalTooltipPosition_u24lambda_u2433.myHorizontalSpace.getLowerEnd();
                        stemX = targetLeftPoint;
                        break block14;
                    }
                    if (measuredTooltip.getHintKind$plot_builder() != TipLayoutHint.Kind.Y_AXIS_TOOLTIP || preferredAlignment != HorizontalAlignment.RIGHT || canFitRight) break block15;
                    tooltipX = $this$calculateHorizontalTooltipPosition_u24lambda_u2433.myHorizontalSpace.getUpperEnd() - tooltipWidth;
                    stemX = targetLeftPoint;
                    break block14;
                }
                if (canFitLeft || canFitRight) break block16;
                switch (WhenMappings.$EnumSwitchMapping$3[preferredAlignment.ordinal()]) {
                    case 1: {
                        stemX = targetLeftPoint;
                        tooltipX = stemX + stemLength;
                        break block14;
                    }
                    case 2: {
                        stemX = targetCoordX + hintSize;
                        tooltipX = stemX - tooltipWidth - stemLength;
                        break block14;
                    }
                    case 3: {
                        stemX = targetCoordX;
                        tooltipX = targetCoordX - tooltipWidth / (double)2;
                        break block14;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            if (preferredAlignment == HorizontalAlignment.LEFT && canFitLeft || !canFitRight) {
                tooltipX = leftTooltipPlacement.getLowerEnd();
                stemX = targetLeftPoint;
            } else {
                tooltipX = rightTooltipPlacement.getLowerEnd();
                stemX = targetCoordX + hintSize;
            }
        }
        stemCoord = new DoubleVector(stemX, measuredTooltip.getHintCoord$plot_builder().getY());
        tooltipCoord = new DoubleVector(tooltipX, tooltipY);
        return new PositionedTooltip(measuredTooltip, tooltipCoord, stemCoord);
    }

    static /* synthetic */ PositionedTooltip calculateHorizontalTooltipPosition$default(LayoutManager layoutManager, MeasuredTooltip measuredTooltip, HorizontalAlignment horizontalAlignment, List list2, int n, Object object) {
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return layoutManager.calculateHorizontalTooltipPosition(measuredTooltip, horizontalAlignment, list2);
    }

    /*
     * Unable to fully structure code
     */
    private final PositionedTooltip calculateCursorTooltipPosition(MeasuredTooltip measuredTooltip, List<DoubleRectangle> restrictions) {
        block5: {
            tooltipX = org.jetbrains.letsPlot.core.plot.builder.tooltip.layout.LayoutManager$Companion.access$centerInsideRange(LayoutManager.Companion, this.myCursorCoord.getX(), measuredTooltip.getSize$plot_builder().getX(), this.myHorizontalSpace);
            tooltipY = 0.0;
            stemY = 0.0;
            $this$calculateCursorTooltipPosition_u24lambda_u2435 = this;
            $i$a$-run-LayoutManager$calculateCursorTooltipPosition$1 = false;
            targetCoordY = $this$calculateCursorTooltipPosition_u24lambda_u2435.myCursorCoord.getY();
            tooltipHeight = measuredTooltip.getSize$plot_builder().getY();
            stemLength = measuredTooltip.getStemLength$plot_builder();
            targetTopPoint = targetCoordY - measuredTooltip.getHintRadius$plot_builder();
            targetBottomPoint = targetCoordY + measuredTooltip.getHintRadius$plot_builder();
            topTooltipPlacement = org.jetbrains.letsPlot.core.plot.builder.tooltip.layout.LayoutManager$Companion.access$leftAligned(LayoutManager.Companion, targetTopPoint, tooltipHeight, stemLength);
            bottomTooltipPlacement = org.jetbrains.letsPlot.core.plot.builder.tooltip.layout.LayoutManager$Companion.access$rightAligned(LayoutManager.Companion, targetBottomPoint, tooltipHeight, stemLength);
            if (!$this$calculateCursorTooltipPosition_u24lambda_u2435.myVerticalSpace.contains(topTooltipPlacement)) ** GOTO lbl-1000
            $this$all$iv = restrictions;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v0 = true;
            } else {
                for (T element$iv : $this$all$iv) {
                    it = (DoubleRectangle)element$iv;
                    $i$a$-all-LayoutManager$calculateCursorTooltipPosition$1$1 = false;
                    tooltipRect = new DoubleRectangle(new DoubleVector(tooltipX, topTooltipPlacement.getLowerEnd()), measuredTooltip.getSize$plot_builder());
                    if (it.intersects(tooltipRect) == false) continue;
                    v0 = false;
                    break block5;
                }
                v0 = true;
            }
        }
        if (v0) {
            tooltipY = topTooltipPlacement.getLowerEnd();
            stemY = targetTopPoint;
        } else lbl-1000:
        // 2 sources

        {
            tooltipY = bottomTooltipPlacement.getLowerEnd();
            stemY = targetBottomPoint;
        }
        tooltipCoord = new DoubleVector(tooltipX, tooltipY);
        stemCoord = new DoubleVector(this.myCursorCoord.getX(), stemY);
        return new PositionedTooltip(measuredTooltip, tooltipCoord, stemCoord);
    }

    private final double calculateAnchorX(MeasuredTooltip measuredTooltip, HorizontalAlignment horizontalAlignment) {
        double d;
        switch (WhenMappings.$EnumSwitchMapping$3[horizontalAlignment.ordinal()]) {
            case 2: {
                d = this.myHorizontalTooltipSpace.getUpperEnd() - measuredTooltip.getSize$plot_builder().getX();
                break;
            }
            case 1: {
                d = this.myHorizontalSpace.getLowerEnd() + this.myHorizontalTooltipSpace.getLowerEnd() + 5.0;
                break;
            }
            case 3: {
                d = (this.myHorizontalTooltipSpace.getLowerEnd() + this.myHorizontalTooltipSpace.getUpperEnd() - measuredTooltip.getSize$plot_builder().getX()) / (double)2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    private final PositionedTooltip calculatePlotCornerTooltipPosition(MeasuredTooltip measuredTooltip, double tooltipY, DoubleSpan verticalTooltipRange, TooltipAnchor.HorizontalAnchor horizontalAnchor) {
        HorizontalAlignment horizontalAlignment;
        switch (WhenMappings.$EnumSwitchMapping$4[horizontalAnchor.ordinal()]) {
            case 1: {
                horizontalAlignment = HorizontalAlignment.RIGHT;
                break;
            }
            case 2: {
                horizontalAlignment = HorizontalAlignment.LEFT;
                break;
            }
            case 3: {
                horizontalAlignment = HorizontalAlignment.CENTER;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        HorizontalAlignment horizontalAlignment2 = horizontalAlignment;
        double tooltipX = this.calculateAnchorX(measuredTooltip, horizontalAlignment2);
        boolean isOverlapX = this.overlapsCursorHorizontalRange(measuredTooltip, tooltipX);
        boolean isOverlapY = this.overlapsCursorVerticalRange(verticalTooltipRange);
        if (isOverlapX && isOverlapY) {
            tooltipX = this.calculateAnchorX(measuredTooltip, horizontalAlignment2.inversed());
        }
        DoubleVector tooltipCoord = new DoubleVector(tooltipX, tooltipY);
        return new PositionedTooltip(measuredTooltip, tooltipCoord, tooltipCoord);
    }

    private final boolean overlapsCursorHorizontalRange(MeasuredTooltip measuredTooltip, double tooltipX) {
        DoubleSpan horizontalTooltipRange = DoubleSpan.Companion.withLowerEnd(tooltipX, measuredTooltip.getSize$plot_builder().getX());
        DoubleSpan cursorHorizontalRange = DoubleSpan.Companion.withLowerEnd(this.myCursorCoord.getX(), CURSOR_DIMENSION.getX());
        return horizontalTooltipRange.connected(cursorHorizontalRange);
    }

    private final boolean overlapsCursorVerticalRange(DoubleSpan verticalTooltipRange) {
        DoubleSpan cursorVerticalRange = DoubleSpan.Companion.withLowerEnd(this.myCursorCoord.getY(), CURSOR_DIMENSION.getY());
        return verticalTooltipRange.connected(cursorVerticalRange);
    }

    private final boolean isCorner(TooltipSpec tooltipSpec) {
        return tooltipSpec.getAnchor() != null;
    }

    private final boolean isCorner(MeasuredTooltip tooltip) {
        return this.isCorner(tooltip.getTooltipSpec$plot_builder());
    }

    private final boolean isCorner(PositionedTooltip tooltip) {
        return this.isCorner(tooltip.getTooltipSpec());
    }

    private final boolean isAxisTooltip(TooltipSpec tooltipSpec) {
        TipLayoutHint.Kind[] kindArray = new TipLayoutHint.Kind[]{TipLayoutHint.Kind.X_AXIS_TOOLTIP, TipLayoutHint.Kind.Y_AXIS_TOOLTIP};
        return CollectionsKt.listOf((Object[])kindArray).contains((Object)tooltipSpec.getLayoutHint().getKind());
    }

    private final boolean isAxisTooltip(MeasuredTooltip tooltip) {
        return this.isAxisTooltip(tooltip.getTooltipSpec$plot_builder());
    }

    private final boolean isAxisTooltip(PositionedTooltip tooltip) {
        return this.isAxisTooltip(tooltip.getTooltipSpec());
    }

    /*
     * WARNING - void declaration
     */
    private final List<PositionedTooltip> selectCorner(List<PositionedTooltip> $this$selectCorner) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$selectCorner;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PositionedTooltip p0 = (PositionedTooltip)element$iv$iv;
            boolean bl = false;
            if (!this.isCorner(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final void rearrangeWithoutOverlapping$fixate(ArrayList<PositionedTooltip> separatedTooltips, ArrayList<DoubleRectangle> restrictions, PositionedTooltip positionedTooltip) {
        separatedTooltips.add(positionedTooltip);
        restrictions.add(positionedTooltip.rect$plot_builder());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0002J \u0010\u000f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u001d\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0013J \u0010\u0014\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u001a\u0010\u0015\u001a\u00020\u0016*\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J1\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017*\b\u0012\u0004\u0012\u00020\u00180\u00172\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c\"\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eJ&\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017*\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$Companion;", "", "()V", "CURSOR_DIMENSION", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "EMPTY_DOUBLE_RANGE", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "centerInsideRange", "", "position", "size", "range", "centered", "start", "length", "leftAligned", "margin", "moveIntoLimit", "limit", "moveIntoLimit$plot_builder", "rightAligned", "isOverlapped", "", "", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$PositionedTooltip;", "tooltip", "select", "kinds", "", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/TipLayoutHint$Kind;", "(Ljava/util/List;[Lorg/jetbrains/letsPlot/core/plot/base/tooltip/TipLayoutHint$Kind;)Ljava/util/List;", "withOverlapped", "tooltips", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nLayoutManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayoutManager.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,725:1\n766#2:726\n857#2,2:727\n766#2:730\n857#2,2:731\n1#3:729\n*S KotlinDebug\n*F\n+ 1 LayoutManager.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$Companion\n*L\n712#1:726\n712#1:727,2\n720#1:730\n720#1:731,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DoubleSpan moveIntoLimit$plot_builder(@NotNull DoubleSpan range, @NotNull DoubleSpan limit) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)limit, (String)"limit");
            if (limit.contains(range)) {
                return range;
            }
            return range.getLowerEnd() < limit.getLowerEnd() ? DoubleSpan.Companion.withLowerEnd(limit.getLowerEnd(), range.getLength()) : (range.getUpperEnd() > limit.getUpperEnd() ? DoubleSpan.Companion.withUpperEnd(limit.getUpperEnd(), range.getLength()) : range);
        }

        private final DoubleSpan centered(double start2, double length) {
            return DoubleSpan.Companion.withLowerEnd(start2 - length / (double)2, length);
        }

        private final DoubleSpan leftAligned(double start2, double length, double margin) {
            return DoubleSpan.Companion.withLowerEnd(start2 - length - margin, length);
        }

        private final DoubleSpan rightAligned(double start2, double length, double margin) {
            return DoubleSpan.Companion.withLowerEnd(start2 + margin, length);
        }

        private final double centerInsideRange(double position, double size2, DoubleSpan range) {
            return this.moveIntoLimit$plot_builder(this.centered(position, size2), range).getLowerEnd();
        }

        /*
         * WARNING - void declaration
         */
        private final List<PositionedTooltip> select(List<PositionedTooltip> $this$select, TipLayoutHint.Kind ... kinds) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = $this$select;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PositionedTooltip it = (PositionedTooltip)element$iv$iv;
                boolean bl = false;
                if (!ArraysKt.contains((Object[])kinds, (Object)((Object)it.getHintKind$plot_builder()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final boolean isOverlapped(List<PositionedTooltip> $this$isOverlapped, PositionedTooltip tooltip) {
            Object v0;
            block1: {
                Iterable iterable = $this$isOverlapped;
                for (Object t : iterable) {
                    PositionedTooltip it = (PositionedTooltip)t;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)tooltip) && it.rect$plot_builder().intersects(tooltip.rect$plot_builder()))) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0 != null;
        }

        /*
         * WARNING - void declaration
         */
        private final List<PositionedTooltip> withOverlapped(List<PositionedTooltip> $this$withOverlapped, List<PositionedTooltip> tooltips) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = tooltips;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PositionedTooltip tooltip = (PositionedTooltip)element$iv$iv;
                boolean bl = false;
                if (!Companion.isOverlapped($this$withOverlapped, tooltip)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List overlapped = (List)destination$iv$iv;
            return CollectionsKt.plus((Collection)CollectionsKt.minus((Iterable)$this$withOverlapped, (Iterable)tooltips), (Iterable)overlapped);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0000j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$HorizontalAlignment;", "", "(Ljava/lang/String;I)V", "inversed", "LEFT", "RIGHT", "CENTER", "plot-builder"})
    public static final class HorizontalAlignment
    extends Enum<HorizontalAlignment> {
        public static final /* enum */ HorizontalAlignment LEFT = new HorizontalAlignment();
        public static final /* enum */ HorizontalAlignment RIGHT = new HorizontalAlignment();
        public static final /* enum */ HorizontalAlignment CENTER = new HorizontalAlignment();
        private static final /* synthetic */ HorizontalAlignment[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        @NotNull
        public final HorizontalAlignment inversed() {
            HorizontalAlignment horizontalAlignment;
            switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    horizontalAlignment = RIGHT;
                    break;
                }
                case 2: {
                    horizontalAlignment = LEFT;
                    break;
                }
                case 3: {
                    horizontalAlignment = CENTER;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return horizontalAlignment;
        }

        public static HorizontalAlignment[] values() {
            return (HorizontalAlignment[])$VALUES.clone();
        }

        public static HorizontalAlignment valueOf(String value) {
            return Enum.valueOf(HorizontalAlignment.class, value);
        }

        @NotNull
        public static EnumEntries<HorizontalAlignment> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = horizontalAlignmentArray = new HorizontalAlignment[]{HorizontalAlignment.LEFT, HorizontalAlignment.RIGHT, HorizontalAlignment.CENTER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[HorizontalAlignment.values().length];
                try {
                    nArray[HorizontalAlignment.LEFT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[HorizontalAlignment.RIGHT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[HorizontalAlignment.CENTER.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0014\u0010\t\u001a\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0014\u0010\u0014\u001a\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$MeasuredTooltip;", "", "tooltipSpec", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/spec/TooltipSpec;", "size", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "strokeWidth", "", "(Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/spec/TooltipSpec;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;D)V", "hintCoord", "getHintCoord$plot_builder", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "hintKind", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/TipLayoutHint$Kind;", "getHintKind$plot_builder", "()Lorg/jetbrains/letsPlot/core/plot/base/tooltip/TipLayoutHint$Kind;", "hintRadius", "getHintRadius$plot_builder", "()D", "getSize$plot_builder", "stemLength", "getStemLength$plot_builder", "getTooltipSpec$plot_builder", "()Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/spec/TooltipSpec;", "plot-builder"})
    public static final class MeasuredTooltip {
        @NotNull
        private final TooltipSpec tooltipSpec;
        @NotNull
        private final DoubleVector size;
        private final double strokeWidth;

        public MeasuredTooltip(@NotNull TooltipSpec tooltipSpec, @NotNull DoubleVector size2, double strokeWidth) {
            Intrinsics.checkNotNullParameter((Object)tooltipSpec, (String)"tooltipSpec");
            Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
            this.tooltipSpec = tooltipSpec;
            this.size = size2;
            this.strokeWidth = strokeWidth;
        }

        @NotNull
        public final TooltipSpec getTooltipSpec$plot_builder() {
            return this.tooltipSpec;
        }

        @NotNull
        public final DoubleVector getSize$plot_builder() {
            return this.size;
        }

        @NotNull
        public final DoubleVector getHintCoord$plot_builder() {
            DoubleVector doubleVector = this.tooltipSpec.getLayoutHint().getCoord();
            Intrinsics.checkNotNull((Object)doubleVector);
            return doubleVector;
        }

        @NotNull
        public final TipLayoutHint.Kind getHintKind$plot_builder() {
            return this.tooltipSpec.getLayoutHint().getKind();
        }

        public final double getHintRadius$plot_builder() {
            return this.tooltipSpec.getLayoutHint().getObjectRadius() + this.strokeWidth;
        }

        public final double getStemLength$plot_builder() {
            return this.tooltipSpec.getLayoutHint().getStemLength().getValue();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0012\u0012\u0006\u0010\b\u001a\u00020\u0000\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u0015\u0010&\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b'J\r\u0010(\u001a\u00020)H\u0000\u00a2\u0006\u0002\b*R\u0014\u0010\u000b\u001a\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u00128@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000eR\u0014\u0010\u0017\u001a\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001aR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u000eR\u0014\u0010$\u001a\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u000e\u00a8\u0006+"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$PositionedTooltip;", "", "measuredTooltip", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$MeasuredTooltip;", "tooltipCoord", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "stemCoord", "(Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$MeasuredTooltip;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;)V", "positionedTooltip", "newTooltipCoord", "(Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$PositionedTooltip;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;)V", "bottom", "", "getBottom$plot_builder", "()D", "height", "getHeight$plot_builder", "hintKind", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/TipLayoutHint$Kind;", "getHintKind$plot_builder", "()Lorg/jetbrains/letsPlot/core/plot/base/tooltip/TipLayoutHint$Kind;", "left", "getLeft$plot_builder", "right", "getRight$plot_builder", "getStemCoord", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getTooltipCoord", "tooltipSize", "getTooltipSize$plot_builder", "tooltipSpec", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/spec/TooltipSpec;", "getTooltipSpec", "()Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/spec/TooltipSpec;", "top", "getTop$plot_builder", "width", "getWidth$plot_builder", "moveTo", "moveTo$plot_builder", "rect", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "rect$plot_builder", "plot-builder"})
    public static final class PositionedTooltip {
        @NotNull
        private final DoubleVector tooltipSize;
        @NotNull
        private final TooltipSpec tooltipSpec;
        @NotNull
        private final DoubleVector tooltipCoord;
        @NotNull
        private final DoubleVector stemCoord;

        @NotNull
        public final DoubleVector getTooltipSize$plot_builder() {
            return this.tooltipSize;
        }

        @NotNull
        public final TooltipSpec getTooltipSpec() {
            return this.tooltipSpec;
        }

        @NotNull
        public final DoubleVector getTooltipCoord() {
            return this.tooltipCoord;
        }

        @NotNull
        public final DoubleVector getStemCoord() {
            return this.stemCoord;
        }

        public final double getLeft$plot_builder() {
            return this.tooltipCoord.getX();
        }

        public final double getTop$plot_builder() {
            return this.tooltipCoord.getY();
        }

        public final double getWidth$plot_builder() {
            return this.tooltipSize.getX();
        }

        public final double getHeight$plot_builder() {
            return this.tooltipSize.getY();
        }

        public final double getBottom$plot_builder() {
            return this.tooltipCoord.getY() + this.getHeight$plot_builder();
        }

        public final double getRight$plot_builder() {
            return this.tooltipCoord.getX() + this.getWidth$plot_builder();
        }

        @NotNull
        public final TipLayoutHint.Kind getHintKind$plot_builder() {
            return this.tooltipSpec.getLayoutHint().getKind();
        }

        public PositionedTooltip(@NotNull MeasuredTooltip measuredTooltip, @NotNull DoubleVector tooltipCoord, @NotNull DoubleVector stemCoord) {
            Intrinsics.checkNotNullParameter((Object)measuredTooltip, (String)"measuredTooltip");
            Intrinsics.checkNotNullParameter((Object)tooltipCoord, (String)"tooltipCoord");
            Intrinsics.checkNotNullParameter((Object)stemCoord, (String)"stemCoord");
            this.tooltipSpec = measuredTooltip.getTooltipSpec$plot_builder();
            this.tooltipSize = measuredTooltip.getSize$plot_builder();
            this.tooltipCoord = tooltipCoord;
            this.stemCoord = stemCoord;
        }

        private PositionedTooltip(PositionedTooltip positionedTooltip, DoubleVector newTooltipCoord) {
            this.tooltipSpec = positionedTooltip.tooltipSpec;
            this.tooltipSize = positionedTooltip.tooltipSize;
            this.stemCoord = positionedTooltip.stemCoord;
            this.tooltipCoord = newTooltipCoord;
        }

        @NotNull
        public final PositionedTooltip moveTo$plot_builder(@NotNull DoubleVector newTooltipCoord) {
            Intrinsics.checkNotNullParameter((Object)newTooltipCoord, (String)"newTooltipCoord");
            return new PositionedTooltip(this, newTooltipCoord);
        }

        @NotNull
        public final DoubleRectangle rect$plot_builder() {
            return new DoubleRectangle(this.tooltipCoord, this.tooltipSize);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/layout/LayoutManager$VerticalAlignment;", "", "(Ljava/lang/String;I)V", "TOP", "BOTTOM", "FIT", "plot-builder"})
    public static final class VerticalAlignment
    extends Enum<VerticalAlignment> {
        public static final /* enum */ VerticalAlignment TOP = new VerticalAlignment();
        public static final /* enum */ VerticalAlignment BOTTOM = new VerticalAlignment();
        public static final /* enum */ VerticalAlignment FIT = new VerticalAlignment();
        private static final /* synthetic */ VerticalAlignment[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static VerticalAlignment[] values() {
            return (VerticalAlignment[])$VALUES.clone();
        }

        public static VerticalAlignment valueOf(String value) {
            return Enum.valueOf(VerticalAlignment.class, value);
        }

        @NotNull
        public static EnumEntries<VerticalAlignment> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = verticalAlignmentArray = new VerticalAlignment[]{VerticalAlignment.TOP, VerticalAlignment.BOTTOM, VerticalAlignment.FIT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;
        public static final /* synthetic */ int[] $EnumSwitchMapping$4;

        static {
            int[] nArray = new int[TipLayoutHint.Kind.values().length];
            try {
                nArray[TipLayoutHint.Kind.X_AXIS_TOOLTIP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TipLayoutHint.Kind.Y_AXIS_TOOLTIP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TipLayoutHint.Kind.VERTICAL_TOOLTIP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TipLayoutHint.Kind.HORIZONTAL_TOOLTIP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TipLayoutHint.Kind.CURSOR_TOOLTIP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TipLayoutHint.Kind.ROTATED_TOOLTIP.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TooltipAnchor.VerticalAnchor.values().length];
            try {
                nArray[TooltipAnchor.VerticalAnchor.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TooltipAnchor.VerticalAnchor.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TooltipAnchor.VerticalAnchor.MIDDLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[VerticalAlignment.values().length];
            try {
                nArray[VerticalAlignment.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerticalAlignment.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerticalAlignment.FIT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[HorizontalAlignment.values().length];
            try {
                nArray[HorizontalAlignment.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HorizontalAlignment.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HorizontalAlignment.CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
            nArray = new int[TooltipAnchor.HorizontalAnchor.values().length];
            try {
                nArray[TooltipAnchor.HorizontalAnchor.RIGHT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TooltipAnchor.HorizontalAnchor.LEFT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TooltipAnchor.HorizontalAnchor.CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$4 = nArray;
        }
    }
}

