/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.render.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.values.Font;
import org.jetbrains.letsPlot.core.plot.base.render.text.Latex;
import org.jetbrains.letsPlot.core.plot.base.render.text.RenderState;
import org.jetbrains.letsPlot.core.plot.base.render.text.RichText;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTSpanElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0006123456B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00070\u0018H\u0002J\"\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001c0\u001b0\u001a2\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J.\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u001a2\u0006\u0010\u001d\u001a\u00020\u0005J\u0016\u0010$\u001a\u00020\u00122\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002J\u0010\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020+H\u0002J\u001e\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020(0/2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001e\u00100\u001a\u00020\u00122\f\u0010.\u001a\b\u0012\u0004\u0012\u00020(0/2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex;", "", "()V", "GREEK_LETTERS", "", "", "INDENT_SIZE_FACTOR", "", "INDENT_SYMBOL", "INDEX_RELATIVE_SHIFT", "INDEX_SIZE_FACTOR", "MISCELLANEOUS", "OPERATIONS", "RELATIONS", "SYMBOLS", "ZERO_WIDTH_SPACE_SYMBOL", "estimateWidthForIndexNode", "content", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode$Span;", "level", "", "font", "Lorg/jetbrains/letsPlot/commons/values/Font;", "widthCalculator", "Lkotlin/Function2;", "extractFormulas", "", "Lkotlin/Pair;", "Lkotlin/ranges/IntRange;", "text", "getSvgForIndexNode", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgElement;", "isSuperior", "", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RenderState;", "parse", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode;", "tokens", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token;", "parseCommand", "token", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token$Command;", "parseGroup", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$GroupNode;", "iterator", "", "parseSupOrSub", "GroupNode", "LatexElement", "SubscriptNode", "SuperscriptNode", "TextNode", "Token", "plot-base"})
@SourceDebugExtension(value={"SMAP\nLatex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Latex.kt\norg/jetbrains/letsPlot/core/plot/base/render/text/Latex\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,362:1\n1549#2:363\n1620#2,3:364\n1559#2:368\n1590#2,4:369\n1#3:367\n*S KotlinDebug\n*F\n+ 1 Latex.kt\norg/jetbrains/letsPlot/core/plot/base/render/text/Latex\n*L\n18#1:363\n18#1:364,3\n165#1:368\n165#1:369,4\n*E\n"})
public final class Latex {
    @NotNull
    public static final Latex INSTANCE = new Latex();
    @NotNull
    private static final String ZERO_WIDTH_SPACE_SYMBOL = "\u200b";
    @NotNull
    private static final String INDENT_SYMBOL = " ";
    private static final double INDENT_SIZE_FACTOR = 0.1;
    private static final double INDEX_SIZE_FACTOR = 0.7;
    private static final double INDEX_RELATIVE_SHIFT = 0.4;
    @NotNull
    private static final Map<String, String> GREEK_LETTERS;
    @NotNull
    private static final Map<String, String> OPERATIONS;
    @NotNull
    private static final Map<String, String> RELATIONS;
    @NotNull
    private static final Map<String, String> MISCELLANEOUS;
    @NotNull
    private static final Map<String, String> SYMBOLS;

    private Latex() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RichText.RichTextNode> parse(@NotNull String text2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Iterable $this$map$iv = this.extractFormulas(text2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair2 = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String formula = (String)pair2.component1();
            IntRange range = (IntRange)pair2.component2();
            String text3 = StringsKt.replace$default((String)formula, (String)"-", (String)"\u2212", (boolean)false, (int)4, null);
            collection.add(TuplesKt.to((Object)new LatexElement(INSTANCE.parse(Token.Companion.tokenize(text3))), (Object)range));
        }
        List formulas = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        return RichText.INSTANCE.fillTextTermGaps$plot_base(text2, formulas);
    }

    private final List<Pair<String, IntRange>> extractFormulas(String text2) {
        List formulas = new ArrayList();
        int formulaStart = 0;
        int n = text2.length() - 1;
        for (int i = 0; i < n; ++i) {
            String formula;
            String string;
            Intrinsics.checkNotNullExpressionValue((Object)text2.substring(i, i + 2), (String)"substring(...)");
            if (Intrinsics.areEqual((Object)string, (Object)"\\(")) {
                formulaStart = i + 2;
                continue;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)"\\)")) continue;
            Intrinsics.checkNotNullExpressionValue((Object)text2.substring(formulaStart, i), (String)"substring(...)");
            IntRange range = new IntRange(formulaStart - 2, i + 1);
            formulas.add(new Pair((Object)formula, (Object)range));
        }
        return formulas;
    }

    private final RichText.RichTextNode.Span parse(Sequence<? extends Token> tokens) {
        return this.parseGroup(tokens.iterator(), 0);
    }

    private final GroupNode parseGroup(Iterator<? extends Token> iterator2, int level) {
        List nodes = new ArrayList();
        while (iterator2.hasNext()) {
            Token token = iterator2.next();
            Token token2 = token;
            if (token2 instanceof Token.Command) {
                nodes.add(this.parseCommand((Token.Command)token));
                continue;
            }
            if (token2 instanceof Token.OpenBrace) {
                nodes.add(this.parseGroup(iterator2, level));
                continue;
            }
            if (token2 instanceof Token.CloseBrace) break;
            if (token2 instanceof Token.Superscript) {
                nodes.add(new SuperscriptNode(this.parseSupOrSub(iterator2, level + 1), level));
                continue;
            }
            if (token2 instanceof Token.Subscript) {
                nodes.add(new SubscriptNode(this.parseSupOrSub(iterator2, level + 1), level));
                continue;
            }
            if (token2 instanceof Token.Text) {
                nodes.add(new TextNode(((Token.Text)token).getContent()));
                continue;
            }
            if (token2 instanceof Token.Space || !(token2 instanceof Token.ExplicitSpace)) continue;
            nodes.add(new TextNode(((Token.ExplicitSpace)token).getSpace()));
        }
        return new GroupNode(nodes);
    }

    private final RichText.RichTextNode.Span parseSupOrSub(Iterator<? extends Token> iterator2, int level) {
        RichText.RichTextNode.Span span;
        Token nextToken2 = iterator2.next();
        if (nextToken2 instanceof Token.OpenBrace) {
            span = this.parseGroup(iterator2, level);
        } else if (nextToken2 instanceof Token.Text) {
            span = new TextNode(((Token.Text)nextToken2).getContent());
        } else if (nextToken2 instanceof Token.Command) {
            span = this.parseCommand((Token.Command)nextToken2);
        } else {
            throw new IllegalArgumentException("Unexpected token after superscript or subscript");
        }
        return span;
    }

    private final RichText.RichTextNode.Span parseCommand(Token.Command token) {
        Map<String, String> map2 = SYMBOLS;
        String string = map2.get(token.getName());
        if (string == null) {
            boolean bl = false;
            string = '\\' + token.getName();
        }
        String string2 = string;
        return new TextNode(string2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<SvgElement> getSvgForIndexNode(RichText.RichTextNode.Span content, int level, boolean isSuperior, RenderState ctx2) {
        SvgTSpanElement svgTSpanElement;
        void $this$mapIndexedTo$iv$iv;
        SvgTSpanElement svgTSpanElement2;
        Pair pair2 = isSuperior ? TuplesKt.to((Object)"-", (Object)"") : TuplesKt.to((Object)"", (Object)"-");
        String shift = (String)pair2.component1();
        String backShift = (String)pair2.component2();
        SvgTSpanElement $this$getSvgForIndexNode_u24lambda_u242 = svgTSpanElement2 = new SvgTSpanElement(INDENT_SYMBOL);
        boolean bl = false;
        $this$getSvgForIndexNode_u24lambda_u242.setAttribute(SvgTSpanElement.Companion.getFONT_SIZE(), "0.1em");
        SvgTSpanElement indentTSpan = svgTSpanElement2;
        double indexSize = Math.pow(0.7, level + 1);
        Iterable $this$mapIndexed$iv = content.render(ctx2);
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            void element;
            void var24_28;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            SvgElement svgElement = (SvgElement)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            void $this$getSvgForIndexNode_u24lambda_u244_u24lambda_u243 = var24_28 = element;
            boolean bl3 = false;
            if ($this$getSvgForIndexNode_u24lambda_u244_u24lambda_u243.getAttribute(SvgTSpanElement.Companion.getFONT_SIZE()).get() == null) {
                $this$getSvgForIndexNode_u24lambda_u244_u24lambda_u243.setAttribute(SvgTSpanElement.Companion.getFONT_SIZE(), indexSize + "em");
            }
            if (i == false) {
                $this$getSvgForIndexNode_u24lambda_u244_u24lambda_u243.setAttribute(SvgTSpanElement.Companion.getDY(), shift + "0.4em");
            }
            collection.add(var24_28);
        }
        List indexTSpanElements = (List)destination$iv$iv;
        SvgTSpanElement $this$getSvgForIndexNode_u24lambda_u245 = svgTSpanElement = new SvgTSpanElement(ZERO_WIDTH_SPACE_SYMBOL);
        boolean bl4 = false;
        $this$getSvgForIndexNode_u24lambda_u245.setAttribute(SvgTSpanElement.Companion.getFONT_SIZE(), indexSize + "em");
        $this$getSvgForIndexNode_u24lambda_u245.setAttribute(SvgTSpanElement.Companion.getDY(), backShift + "0.4em");
        SvgTSpanElement restoreBaselineTSpan = svgTSpanElement;
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)ctx2.apply(indentTSpan)), (Iterable)indexTSpanElements), (Object)ctx2.apply(restoreBaselineTSpan));
    }

    private final double estimateWidthForIndexNode(RichText.RichTextNode.Span content, int level, Font font, Function2<? super String, ? super Font, Double> widthCalculator) {
        int indexFontSize = MathKt.roundToInt((double)((double)font.getSize() * Math.pow(0.7, level + 1)));
        Font indexFont = new Font(font.getFamily(), indexFontSize, font.isBold(), font.isItalic());
        return content.estimateWidth(indexFont, widthCalculator);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Alpha", (Object)"\u0391"), TuplesKt.to((Object)"Beta", (Object)"\u0392"), TuplesKt.to((Object)"Gamma", (Object)"\u0393"), TuplesKt.to((Object)"Delta", (Object)"\u0394"), TuplesKt.to((Object)"Epsilon", (Object)"\u0395"), TuplesKt.to((Object)"Zeta", (Object)"\u0396"), TuplesKt.to((Object)"Eta", (Object)"\u0397"), TuplesKt.to((Object)"Theta", (Object)"\u0398"), TuplesKt.to((Object)"Iota", (Object)"\u0399"), TuplesKt.to((Object)"Kappa", (Object)"\u039a"), TuplesKt.to((Object)"Lambda", (Object)"\u039b"), TuplesKt.to((Object)"Mu", (Object)"\u039c"), TuplesKt.to((Object)"Nu", (Object)"\u039d"), TuplesKt.to((Object)"Xi", (Object)"\u039e"), TuplesKt.to((Object)"Omicron", (Object)"\u039f"), TuplesKt.to((Object)"Pi", (Object)"\u03a0"), TuplesKt.to((Object)"Rho", (Object)"\u03a1"), TuplesKt.to((Object)"Sigma", (Object)"\u03a3"), TuplesKt.to((Object)"Tau", (Object)"\u03a4"), TuplesKt.to((Object)"Upsilon", (Object)"\u03a5"), TuplesKt.to((Object)"Phi", (Object)"\u03a6"), TuplesKt.to((Object)"Chi", (Object)"\u03a7"), TuplesKt.to((Object)"Psi", (Object)"\u03a8"), TuplesKt.to((Object)"Omega", (Object)"\u03a9"), TuplesKt.to((Object)"alpha", (Object)"\u03b1"), TuplesKt.to((Object)"beta", (Object)"\u03b2"), TuplesKt.to((Object)"gamma", (Object)"\u03b3"), TuplesKt.to((Object)"delta", (Object)"\u03b4"), TuplesKt.to((Object)"epsilon", (Object)"\u03b5"), TuplesKt.to((Object)"zeta", (Object)"\u03b6"), TuplesKt.to((Object)"eta", (Object)"\u03b7"), TuplesKt.to((Object)"theta", (Object)"\u03b8"), TuplesKt.to((Object)"iota", (Object)"\u03b9"), TuplesKt.to((Object)"kappa", (Object)"\u03ba"), TuplesKt.to((Object)"lambda", (Object)"\u03bb"), TuplesKt.to((Object)"mu", (Object)"\u03bc"), TuplesKt.to((Object)"nu", (Object)"\u03bd"), TuplesKt.to((Object)"xi", (Object)"\u03be"), TuplesKt.to((Object)"omicron", (Object)"\u03bf"), TuplesKt.to((Object)"pi", (Object)"\u03c0"), TuplesKt.to((Object)"rho", (Object)"\u03c1"), TuplesKt.to((Object)"sigma", (Object)"\u03c3"), TuplesKt.to((Object)"tau", (Object)"\u03c4"), TuplesKt.to((Object)"upsilon", (Object)"\u03c5"), TuplesKt.to((Object)"phi", (Object)"\u03c6"), TuplesKt.to((Object)"chi", (Object)"\u03c7"), TuplesKt.to((Object)"psi", (Object)"\u03c8"), TuplesKt.to((Object)"omega", (Object)"\u03c9")};
        GREEK_LETTERS = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"pm", (Object)"\u00b1"), TuplesKt.to((Object)"mp", (Object)"\u2213"), TuplesKt.to((Object)"times", (Object)"\u00d7"), TuplesKt.to((Object)"div", (Object)"\u00f7"), TuplesKt.to((Object)"cdot", (Object)"\u00b7")};
        OPERATIONS = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"leq", (Object)"\u2264"), TuplesKt.to((Object)"geq", (Object)"\u2265"), TuplesKt.to((Object)"neq", (Object)"\u2260")};
        RELATIONS = MapsKt.mapOf((Pair[])pairArray);
        MISCELLANEOUS = MapsKt.mapOf((Pair)TuplesKt.to((Object)"infty", (Object)"\u221e"));
        SYMBOLS = MapsKt.plus((Map)MapsKt.plus((Map)MapsKt.plus(GREEK_LETTERS, OPERATIONS), RELATIONS), MISCELLANEOUS);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0003J\u0019\u0010\f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00120\u0016H\u0016J\t\u0010\u0018\u001a\u00020\bH\u00d6\u0001J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\t\u0010\u001d\u001a\u00020\u0017H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$GroupNode;", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode$Span;", "children", "", "(Ljava/util/List;)V", "getChildren", "()Ljava/util/List;", "visualCharCount", "", "getVisualCharCount", "()I", "component1", "copy", "equals", "", "other", "", "estimateWidth", "", "font", "Lorg/jetbrains/letsPlot/commons/values/Font;", "widthCalculator", "Lkotlin/Function2;", "", "hashCode", "render", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgElement;", "context", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RenderState;", "toString", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nLatex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Latex.kt\norg/jetbrains/letsPlot/core/plot/base/render/text/Latex$GroupNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,362:1\n1#2:363\n1360#3:364\n1446#3,5:365\n*S KotlinDebug\n*F\n+ 1 Latex.kt\norg/jetbrains/letsPlot/core/plot/base/render/text/Latex$GroupNode\n*L\n338#1:364\n338#1:365,5\n*E\n"})
    public static final class GroupNode
    implements RichText.RichTextNode.Span {
        @NotNull
        private final List<RichText.RichTextNode.Span> children;
        private final int visualCharCount;

        /*
         * WARNING - void declaration
         */
        public GroupNode(@NotNull List<? extends RichText.RichTextNode.Span> children2) {
            int n;
            Intrinsics.checkNotNullParameter(children2, (String)"children");
            this.children = children2;
            Iterable iterable = this.children;
            GroupNode groupNode = this;
            int n2 = 0;
            for (Object t : iterable) {
                void it;
                RichText.RichTextNode.Span span = (RichText.RichTextNode.Span)t;
                n = n2;
                boolean bl = false;
                int n3 = it.getVisualCharCount();
                n2 = n + n3;
            }
            groupNode.visualCharCount = n = n2;
        }

        @NotNull
        public final List<RichText.RichTextNode.Span> getChildren() {
            return this.children;
        }

        @Override
        public int getVisualCharCount() {
            return this.visualCharCount;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public double estimateWidth(@NotNull Font font, @NotNull Function2<? super String, ? super Font, Double> widthCalculator) {
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            Intrinsics.checkNotNullParameter(widthCalculator, (String)"widthCalculator");
            Iterable iterable = this.children;
            double d = 0.0;
            for (Object t : iterable) {
                void it;
                RichText.RichTextNode.Span span = (RichText.RichTextNode.Span)t;
                double d2 = d;
                boolean bl = false;
                double d3 = it.estimateWidth(font, widthCalculator);
                d = d2 + d3;
            }
            return d;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<SvgElement> render(@NotNull RenderState context) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Iterable $this$flatMap$iv = this.children;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                RichText.RichTextNode.Span it = (RichText.RichTextNode.Span)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.render(context);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Override
        @NotNull
        public List<SvgElement> render() {
            return RichText.RichTextNode.Span.DefaultImpls.render(this);
        }

        @NotNull
        public final List<RichText.RichTextNode.Span> component1() {
            return this.children;
        }

        @NotNull
        public final GroupNode copy(@NotNull List<? extends RichText.RichTextNode.Span> children2) {
            Intrinsics.checkNotNullParameter(children2, (String)"children");
            return new GroupNode(children2);
        }

        public static /* synthetic */ GroupNode copy$default(GroupNode groupNode, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = groupNode.children;
            }
            return groupNode.copy(list2);
        }

        @NotNull
        public String toString() {
            return "GroupNode(children=" + this.children + ')';
        }

        public int hashCode() {
            return ((Object)this.children).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GroupNode)) {
                return false;
            }
            GroupNode groupNode = (GroupNode)other;
            return Intrinsics.areEqual(this.children, groupNode.children);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\rH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$LatexElement;", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode$Span;", "node", "(Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode$Span;)V", "visualCharCount", "", "getVisualCharCount", "()I", "estimateWidth", "", "font", "Lorg/jetbrains/letsPlot/commons/values/Font;", "widthCalculator", "Lkotlin/Function2;", "", "render", "", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgElement;", "context", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RenderState;", "plot-base"})
    private static final class LatexElement
    implements RichText.RichTextNode.Span {
        @NotNull
        private final RichText.RichTextNode.Span node;
        private final int visualCharCount;

        public LatexElement(@NotNull RichText.RichTextNode.Span node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.node = node;
            this.visualCharCount = this.node.getVisualCharCount();
        }

        @Override
        public int getVisualCharCount() {
            return this.visualCharCount;
        }

        @Override
        public double estimateWidth(@NotNull Font font, @NotNull Function2<? super String, ? super Font, Double> widthCalculator) {
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            Intrinsics.checkNotNullParameter(widthCalculator, (String)"widthCalculator");
            return this.node.estimateWidth(font, widthCalculator);
        }

        @Override
        @NotNull
        public List<SvgElement> render(@NotNull RenderState context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return this.node.render(context);
        }

        @Override
        @NotNull
        public List<SvgElement> render() {
            return RichText.RichTextNode.Span.DefaultImpls.render(this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0004H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J*\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00140\u0018H\u0016J\t\u0010\u001a\u001a\u00020\u0004H\u00d6\u0001J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\t\u0010 \u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006!"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$SubscriptNode;", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode$Span;", "content", "level", "", "(Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode$Span;I)V", "getContent", "()Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode$Span;", "getLevel", "()I", "visualCharCount", "getVisualCharCount", "component1", "component2", "copy", "equals", "", "other", "", "estimateWidth", "", "font", "Lorg/jetbrains/letsPlot/commons/values/Font;", "widthCalculator", "Lkotlin/Function2;", "", "hashCode", "render", "", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgElement;", "context", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RenderState;", "toString", "plot-base"})
    public static final class SubscriptNode
    implements RichText.RichTextNode.Span {
        @NotNull
        private final RichText.RichTextNode.Span content;
        private final int level;
        private final int visualCharCount;

        public SubscriptNode(@NotNull RichText.RichTextNode.Span content, int level) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.content = content;
            this.level = level;
            this.visualCharCount = this.content.getVisualCharCount();
        }

        @NotNull
        public final RichText.RichTextNode.Span getContent() {
            return this.content;
        }

        public final int getLevel() {
            return this.level;
        }

        @Override
        public int getVisualCharCount() {
            return this.visualCharCount;
        }

        @Override
        public double estimateWidth(@NotNull Font font, @NotNull Function2<? super String, ? super Font, Double> widthCalculator) {
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            Intrinsics.checkNotNullParameter(widthCalculator, (String)"widthCalculator");
            return INSTANCE.estimateWidthForIndexNode(this.content, this.level, font, (Function2<? super String, ? super Font, Double>)widthCalculator);
        }

        @Override
        @NotNull
        public List<SvgElement> render(@NotNull RenderState context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return INSTANCE.getSvgForIndexNode(this.content, this.level, false, context);
        }

        @Override
        @NotNull
        public List<SvgElement> render() {
            return RichText.RichTextNode.Span.DefaultImpls.render(this);
        }

        @NotNull
        public final RichText.RichTextNode.Span component1() {
            return this.content;
        }

        public final int component2() {
            return this.level;
        }

        @NotNull
        public final SubscriptNode copy(@NotNull RichText.RichTextNode.Span content, int level) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            return new SubscriptNode(content, level);
        }

        public static /* synthetic */ SubscriptNode copy$default(SubscriptNode subscriptNode, RichText.RichTextNode.Span span, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                span = subscriptNode.content;
            }
            if ((n2 & 2) != 0) {
                n = subscriptNode.level;
            }
            return subscriptNode.copy(span, n);
        }

        @NotNull
        public String toString() {
            return "SubscriptNode(content=" + this.content + ", level=" + this.level + ')';
        }

        public int hashCode() {
            int result2 = this.content.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.level);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SubscriptNode)) {
                return false;
            }
            SubscriptNode subscriptNode = (SubscriptNode)other;
            if (!Intrinsics.areEqual((Object)this.content, (Object)subscriptNode.content)) {
                return false;
            }
            return this.level == subscriptNode.level;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0004H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J*\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00140\u0018H\u0016J\t\u0010\u001a\u001a\u00020\u0004H\u00d6\u0001J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\t\u0010 \u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006!"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$SuperscriptNode;", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode$Span;", "content", "level", "", "(Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode$Span;I)V", "getContent", "()Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode$Span;", "getLevel", "()I", "visualCharCount", "getVisualCharCount", "component1", "component2", "copy", "equals", "", "other", "", "estimateWidth", "", "font", "Lorg/jetbrains/letsPlot/commons/values/Font;", "widthCalculator", "Lkotlin/Function2;", "", "hashCode", "render", "", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgElement;", "context", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RenderState;", "toString", "plot-base"})
    public static final class SuperscriptNode
    implements RichText.RichTextNode.Span {
        @NotNull
        private final RichText.RichTextNode.Span content;
        private final int level;
        private final int visualCharCount;

        public SuperscriptNode(@NotNull RichText.RichTextNode.Span content, int level) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.content = content;
            this.level = level;
            this.visualCharCount = this.content.getVisualCharCount();
        }

        @NotNull
        public final RichText.RichTextNode.Span getContent() {
            return this.content;
        }

        public final int getLevel() {
            return this.level;
        }

        @Override
        public int getVisualCharCount() {
            return this.visualCharCount;
        }

        @Override
        public double estimateWidth(@NotNull Font font, @NotNull Function2<? super String, ? super Font, Double> widthCalculator) {
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            Intrinsics.checkNotNullParameter(widthCalculator, (String)"widthCalculator");
            return INSTANCE.estimateWidthForIndexNode(this.content, this.level, font, (Function2<? super String, ? super Font, Double>)widthCalculator);
        }

        @Override
        @NotNull
        public List<SvgElement> render(@NotNull RenderState context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return INSTANCE.getSvgForIndexNode(this.content, this.level, true, context);
        }

        @Override
        @NotNull
        public List<SvgElement> render() {
            return RichText.RichTextNode.Span.DefaultImpls.render(this);
        }

        @NotNull
        public final RichText.RichTextNode.Span component1() {
            return this.content;
        }

        public final int component2() {
            return this.level;
        }

        @NotNull
        public final SuperscriptNode copy(@NotNull RichText.RichTextNode.Span content, int level) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            return new SuperscriptNode(content, level);
        }

        public static /* synthetic */ SuperscriptNode copy$default(SuperscriptNode superscriptNode, RichText.RichTextNode.Span span, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                span = superscriptNode.content;
            }
            if ((n2 & 2) != 0) {
                n = superscriptNode.level;
            }
            return superscriptNode.copy(span, n);
        }

        @NotNull
        public String toString() {
            return "SuperscriptNode(content=" + this.content + ", level=" + this.level + ')';
        }

        public int hashCode() {
            int result2 = this.content.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.level);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SuperscriptNode)) {
                return false;
            }
            SuperscriptNode superscriptNode = (SuperscriptNode)other;
            if (!Intrinsics.areEqual((Object)this.content, (Object)superscriptNode.content)) {
                return false;
            }
            return this.level == superscriptNode.level;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00120\u0016H\u0016J\t\u0010\u0017\u001a\u00020\bH\u00d6\u0001J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$TextNode;", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RichText$RichTextNode$Span;", "content", "", "(Ljava/lang/String;)V", "getContent", "()Ljava/lang/String;", "visualCharCount", "", "getVisualCharCount", "()I", "component1", "copy", "equals", "", "other", "", "estimateWidth", "", "font", "Lorg/jetbrains/letsPlot/commons/values/Font;", "widthCalculator", "Lkotlin/Function2;", "hashCode", "render", "", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgElement;", "context", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/RenderState;", "toString", "plot-base"})
    public static final class TextNode
    implements RichText.RichTextNode.Span {
        @NotNull
        private final String content;
        private final int visualCharCount;

        public TextNode(@NotNull String content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.content = content;
            this.visualCharCount = this.content.length();
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }

        @Override
        public int getVisualCharCount() {
            return this.visualCharCount;
        }

        @Override
        public double estimateWidth(@NotNull Font font, @NotNull Function2<? super String, ? super Font, Double> widthCalculator) {
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            Intrinsics.checkNotNullParameter(widthCalculator, (String)"widthCalculator");
            return ((Number)widthCalculator.invoke((Object)this.content, (Object)font)).doubleValue();
        }

        @Override
        @NotNull
        public List<SvgElement> render(@NotNull RenderState context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return CollectionsKt.listOf((Object)context.apply(new SvgTSpanElement(this.content)));
        }

        @Override
        @NotNull
        public List<SvgElement> render() {
            return RichText.RichTextNode.Span.DefaultImpls.render(this);
        }

        @NotNull
        public final String component1() {
            return this.content;
        }

        @NotNull
        public final TextNode copy(@NotNull String content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            return new TextNode(content);
        }

        public static /* synthetic */ TextNode copy$default(TextNode textNode, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = textNode.content;
            }
            return textNode.copy(string);
        }

        @NotNull
        public String toString() {
            return "TextNode(content=" + this.content + ')';
        }

        public int hashCode() {
            return this.content.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TextNode)) {
                return false;
            }
            TextNode textNode = (TextNode)other;
            return Intrinsics.areEqual((Object)this.content, (Object)textNode.content);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\f\b\u0010\u0018\u0000 \u00052\u00020\u0001:\n\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token;", "", "()V", "CloseBrace", "Command", "Companion", "ControlSymbol", "ExplicitSpace", "OpenBrace", "Space", "Subscript", "Superscript", "Text", "plot-base"})
    public static class Token {
        @NotNull
        public static final Companion Companion = new Companion(null);

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token$CloseBrace;", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token;", "()V", "plot-base"})
        public static final class CloseBrace
        extends Token {
            @NotNull
            public static final CloseBrace INSTANCE = new CloseBrace();

            private CloseBrace() {
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token$Command;", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token;", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "plot-base"})
        public static final class Command
        extends Token {
            @NotNull
            private final String name;

            public Command(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                this.name = name;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            @NotNull
            public final Command copy(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return new Command(name);
            }

            public static /* synthetic */ Command copy$default(Command command, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = command.name;
                }
                return command.copy(string);
            }

            @NotNull
            public String toString() {
                return "Command(name=" + this.name + ')';
            }

            public int hashCode() {
                return this.name.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Command)) {
                    return false;
                }
                Command command = (Command)other;
                return Intrinsics.areEqual((Object)this.name, (Object)command.name);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token$Companion;", "", "()V", "tokenize", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token;", "input", "", "plot-base"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Sequence<Token> tokenize(@NotNull String input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Token>, Continuation<? super Unit>, Object>(input, null){
                    int I$0;
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ String $input;
                    {
                        this.$input = $input;
                        super(2, $completion);
                    }

                    /*
                     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
                     * Unable to fully structure code
                     * Enabled aggressive block sorting
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        block0 : switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                $this$sequence = (SequenceScope)this.L$0;
                                i = 0;
                                break;
                            }
                            case 1: {
                                i = this.I$0;
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
                                break;
                            }
                            case 2: {
                                i = this.I$0;
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
                                break;
                            }
                            case 3: {
                                i = this.I$0;
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
                                break;
                            }
                            case 4: {
                                i = this.I$0;
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v3 = $result;
                                break;
                            }
                            case 5: {
                                i = this.I$0;
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v4 = $result;
                                break;
                            }
                            case 6: {
                                i = this.I$0;
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v5 = $result;
                                break;
                            }
                            case 7: {
                                i = this.I$0;
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v6 = $result;
                                break;
                            }
                            case 8: {
                                i = this.I$0;
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v7 = $result;
                                while (true) {
                                    ++i;
                                    break block0;
                                    break;
                                }
                            }
                            case 9: {
                                i = this.I$0;
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v8 = $result;
                                while (true) {
                                    ++i;
                                    break block0;
                                    break;
                                }
                            }
                            case 10: {
                                i = this.I$0;
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v9 = $result;
                                while (true) {
                                    ++i;
                                    break block0;
                                    break;
                                }
                            }
                            case 11: {
                                i = this.I$0;
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v10 = $result;
                                while (true) {
                                    ++i;
                                    break block0;
                                    break;
                                }
                            }
                            case 12: {
                                i = this.I$0;
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v11 = $result;
                                while (true) {
                                    ++i;
                                    break block0;
                                    break;
                                }
                            }
                            default: {
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                        }
lbl92:
                        // 21 sources

                        block42: while (i < this.$input.length()) {
                            controlSymbol = ControlSymbol.Companion.fromChar(this.$input.charAt(i));
                            if (controlSymbol == null) {
                                text = new StringBuilder();
                                if (i > 0 && ControlSymbol.Companion.isSupOrSub(this.$input.charAt(i - 1))) {
                                    text.append(this.$input.charAt(i));
                                } else {
                                    while (i < this.$input.length() && ControlSymbol.Companion.fromChar(this.$input.charAt(i)) == null) {
                                        text.append(this.$input.charAt(i));
                                        ++i;
                                    }
                                }
                                var6_7 = text.toString();
                                Intrinsics.checkNotNullExpressionValue((Object)var6_7, (String)"toString(...)");
                                this.L$0 = $this$sequence;
                                this.I$0 = ++i;
                                this.label = 1;
                                v0 = $this$sequence.yield((Object)new Text(var6_7), (Continuation)this);
                                if (v0 != var10_2) continue;
                                return var10_2;
                            }
                            var5_6 = controlSymbol;
                            switch (tokenize.WhenMappings.$EnumSwitchMapping$0[var5_6.ordinal()]) {
                                case 1: {
                                    command = new StringBuilder();
                                    ++i;
                                    while (i < this.$input.length() && (Character.isLetter(this.$input.charAt(i)) || ((CharSequence)command).length() == 0 && StringsKt.contains$default((CharSequence)",: ", (char)this.$input.charAt(i), (boolean)false, (int)2, null))) {
                                        command.append(this.$input.charAt(i));
                                        ++i;
                                    }
                                    var8_9 = command.toString();
                                    tmp = -1;
                                    switch (var8_9.hashCode()) {
                                        case 32: {
                                            if (!var8_9.equals(" ")) break;
                                            tmp = 1;
                                            break;
                                        }
                                        case 3481927: {
                                            if (!var8_9.equals("quad")) break;
                                            tmp = 2;
                                            break;
                                        }
                                        case 107839800: {
                                            if (!var8_9.equals("qquad")) break;
                                            tmp = 3;
                                            break;
                                        }
                                        case 58: {
                                            if (!var8_9.equals(":")) break;
                                            tmp = 4;
                                            break;
                                        }
                                        case 44: {
                                            if (!var8_9.equals(",")) break;
                                            tmp = 5;
                                            break;
                                        }
                                    }
                                    switch (tmp) {
                                        case 2: {
                                            this.L$0 = $this$sequence;
                                            this.I$0 = i;
                                            this.label = 2;
                                            v1 = $this$sequence.yield((Object)ExplicitSpace.Companion.getQUAD(), (Continuation)this);
                                            if (v1 != var10_2) continue block42;
                                            return var10_2;
                                        }
                                        case 3: {
                                            this.L$0 = $this$sequence;
                                            this.I$0 = i;
                                            this.label = 3;
                                            v2 = $this$sequence.yield((Object)ExplicitSpace.Companion.getQQUAD(), (Continuation)this);
                                            if (v2 != var10_2) continue block42;
                                            return var10_2;
                                        }
                                        case 5: {
                                            this.L$0 = $this$sequence;
                                            this.I$0 = i;
                                            this.label = 4;
                                            v3 = $this$sequence.yield((Object)ExplicitSpace.Companion.getCOMMA(), (Continuation)this);
                                            if (v3 != var10_2) continue block42;
                                            return var10_2;
                                        }
                                        case 4: {
                                            this.L$0 = $this$sequence;
                                            this.I$0 = i;
                                            this.label = 5;
                                            v4 = $this$sequence.yield((Object)ExplicitSpace.Companion.getCOLON(), (Continuation)this);
                                            if (v4 != var10_2) continue block42;
                                            return var10_2;
                                        }
                                        case 1: {
                                            this.L$0 = $this$sequence;
                                            this.I$0 = i;
                                            this.label = 6;
                                            v5 = $this$sequence.yield((Object)ExplicitSpace.Companion.getSPACE(), (Continuation)this);
                                            if (v5 != var10_2) continue block42;
                                            return var10_2;
                                        }
                                    }
                                    var9_10 = command.toString();
                                    Intrinsics.checkNotNullExpressionValue((Object)var9_10, (String)"toString(...)");
                                    this.L$0 = $this$sequence;
                                    this.I$0 = i;
                                    this.label = 7;
                                    v6 = $this$sequence.yield((Object)new Command(var9_10), (Continuation)this);
                                    if (v6 != var10_2) continue block42;
                                    return var10_2;
                                }
                                case 2: {
                                    this.L$0 = $this$sequence;
                                    this.I$0 = i;
                                    this.label = 8;
                                    if ((v7 = $this$sequence.yield((Object)OpenBrace.INSTANCE, (Continuation)this)) != var10_2) ** continue;
                                    return var10_2;
                                }
                                case 3: {
                                    this.L$0 = $this$sequence;
                                    this.I$0 = i;
                                    this.label = 9;
                                    if ((v8 = $this$sequence.yield((Object)CloseBrace.INSTANCE, (Continuation)this)) != var10_2) ** continue;
                                    return var10_2;
                                }
                                case 4: {
                                    this.L$0 = $this$sequence;
                                    this.I$0 = i;
                                    this.label = 10;
                                    if ((v9 = $this$sequence.yield((Object)Superscript.INSTANCE, (Continuation)this)) != var10_2) ** continue;
                                    return var10_2;
                                }
                                case 5: {
                                    this.L$0 = $this$sequence;
                                    this.I$0 = i;
                                    this.label = 11;
                                    if ((v10 = $this$sequence.yield((Object)Subscript.INSTANCE, (Continuation)this)) != var10_2) ** continue;
                                    return var10_2;
                                }
                                case 6: {
                                    this.L$0 = $this$sequence;
                                    this.I$0 = i;
                                    this.label = 12;
                                    if ((v11 = $this$sequence.yield((Object)Space.INSTANCE, (Continuation)this)) != var10_2) ** continue;
                                    return var10_2;
                                }
                            }
                            ** break;
                        }
                        return Unit.INSTANCE;
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        Function2<SequenceScope<? super Token>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value;
                        return (Continuation)function2;
                    }

                    @Nullable
                    public final Object invoke(@NotNull SequenceScope<? super Token> p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\f\n\u0002\b\u000b\b\u0082\u0081\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\rB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token$ControlSymbol;", "", "symbol", "", "(Ljava/lang/String;IC)V", "getSymbol", "()C", "BACKSLASH", "OPEN_BRACE", "CLOSE_BRACE", "SUPERSCRIPT", "SUBSCRIPT", "SPACE", "Companion", "plot-base"})
        private static final class ControlSymbol
        extends Enum<ControlSymbol> {
            @NotNull
            public static final Companion Companion;
            private final char symbol;
            public static final /* enum */ ControlSymbol BACKSLASH;
            public static final /* enum */ ControlSymbol OPEN_BRACE;
            public static final /* enum */ ControlSymbol CLOSE_BRACE;
            public static final /* enum */ ControlSymbol SUPERSCRIPT;
            public static final /* enum */ ControlSymbol SUBSCRIPT;
            public static final /* enum */ ControlSymbol SPACE;
            private static final /* synthetic */ ControlSymbol[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private ControlSymbol(char symbol) {
                this.symbol = symbol;
            }

            public final char getSymbol() {
                return this.symbol;
            }

            public static ControlSymbol[] values() {
                return (ControlSymbol[])$VALUES.clone();
            }

            public static ControlSymbol valueOf(String value) {
                return Enum.valueOf(ControlSymbol.class, value);
            }

            @NotNull
            public static EnumEntries<ControlSymbol> getEntries() {
                return $ENTRIES;
            }

            static {
                BACKSLASH = new ControlSymbol('\\');
                OPEN_BRACE = new ControlSymbol('{');
                CLOSE_BRACE = new ControlSymbol('}');
                SUPERSCRIPT = new ControlSymbol('^');
                SUBSCRIPT = new ControlSymbol('_');
                SPACE = new ControlSymbol(' ');
                $VALUES = controlSymbolArray = new ControlSymbol[]{ControlSymbol.BACKSLASH, ControlSymbol.OPEN_BRACE, ControlSymbol.CLOSE_BRACE, ControlSymbol.SUPERSCRIPT, ControlSymbol.SUBSCRIPT, ControlSymbol.SPACE};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                Companion = new Companion(null);
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token$ControlSymbol$Companion;", "", "()V", "fromChar", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token$ControlSymbol;", "char", "", "isSupOrSub", "", "plot-base"})
            @SourceDebugExtension(value={"SMAP\nLatex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Latex.kt\norg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token$ControlSymbol$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,362:1\n1#2:363\n*E\n"})
            public static final class Companion {
                private Companion() {
                }

                @Nullable
                public final ControlSymbol fromChar(char c) {
                    Object v0;
                    block1: {
                        Iterable iterable = (Iterable)ControlSymbol.getEntries();
                        for (Object t : iterable) {
                            ControlSymbol it = (ControlSymbol)((Object)t);
                            boolean bl = false;
                            if (!(it.getSymbol() == c)) continue;
                            v0 = t;
                            break block1;
                        }
                        v0 = null;
                    }
                    return v0;
                }

                public final boolean isSupOrSub(char c) {
                    ControlSymbol[] controlSymbolArray = new ControlSymbol[]{SUPERSCRIPT, SUBSCRIPT};
                    return CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])controlSymbolArray), (Object)((Object)this.fromChar(c)));
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token$ExplicitSpace;", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token;", "space", "", "(Ljava/lang/String;)V", "getSpace", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "plot-base"})
        public static final class ExplicitSpace
        extends Token {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final String space;
            @NotNull
            private static final ExplicitSpace QUAD = new ExplicitSpace("\u2003");
            @NotNull
            private static final ExplicitSpace QQUAD = new ExplicitSpace("\u2003\u2003");
            @NotNull
            private static final ExplicitSpace COMMA = new ExplicitSpace("\u2006");
            @NotNull
            private static final ExplicitSpace COLON = new ExplicitSpace("\u205f");
            @NotNull
            private static final ExplicitSpace SPACE = new ExplicitSpace(" ");

            public ExplicitSpace(@NotNull String space) {
                Intrinsics.checkNotNullParameter((Object)space, (String)"space");
                this.space = space;
            }

            @NotNull
            public final String getSpace() {
                return this.space;
            }

            @NotNull
            public final String component1() {
                return this.space;
            }

            @NotNull
            public final ExplicitSpace copy(@NotNull String space) {
                Intrinsics.checkNotNullParameter((Object)space, (String)"space");
                return new ExplicitSpace(space);
            }

            public static /* synthetic */ ExplicitSpace copy$default(ExplicitSpace explicitSpace, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = explicitSpace.space;
                }
                return explicitSpace.copy(string);
            }

            @NotNull
            public String toString() {
                return "ExplicitSpace(space=" + this.space + ')';
            }

            public int hashCode() {
                return this.space.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ExplicitSpace)) {
                    return false;
                }
                ExplicitSpace explicitSpace = (ExplicitSpace)other;
                return Intrinsics.areEqual((Object)this.space, (Object)explicitSpace.space);
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token$ExplicitSpace$Companion;", "", "()V", "COLON", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token$ExplicitSpace;", "getCOLON", "()Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token$ExplicitSpace;", "COMMA", "getCOMMA", "QQUAD", "getQQUAD", "QUAD", "getQUAD", "SPACE", "getSPACE", "plot-base"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final ExplicitSpace getQUAD() {
                    return QUAD;
                }

                @NotNull
                public final ExplicitSpace getQQUAD() {
                    return QQUAD;
                }

                @NotNull
                public final ExplicitSpace getCOMMA() {
                    return COMMA;
                }

                @NotNull
                public final ExplicitSpace getCOLON() {
                    return COLON;
                }

                @NotNull
                public final ExplicitSpace getSPACE() {
                    return SPACE;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token$OpenBrace;", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token;", "()V", "plot-base"})
        public static final class OpenBrace
        extends Token {
            @NotNull
            public static final OpenBrace INSTANCE = new OpenBrace();

            private OpenBrace() {
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token$Space;", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token;", "()V", "plot-base"})
        public static final class Space
        extends Token {
            @NotNull
            public static final Space INSTANCE = new Space();

            private Space() {
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token$Subscript;", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token;", "()V", "plot-base"})
        public static final class Subscript
        extends Token {
            @NotNull
            public static final Subscript INSTANCE = new Subscript();

            private Subscript() {
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token$Superscript;", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token;", "()V", "plot-base"})
        public static final class Superscript
        extends Token {
            @NotNull
            public static final Superscript INSTANCE = new Superscript();

            private Superscript() {
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token$Text;", "Lorg/jetbrains/letsPlot/core/plot/base/render/text/Latex$Token;", "content", "", "(Ljava/lang/String;)V", "getContent", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "plot-base"})
        public static final class Text
        extends Token {
            @NotNull
            private final String content;

            public Text(@NotNull String content) {
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                this.content = content;
            }

            @NotNull
            public final String getContent() {
                return this.content;
            }

            @NotNull
            public final String component1() {
                return this.content;
            }

            @NotNull
            public final Text copy(@NotNull String content) {
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                return new Text(content);
            }

            public static /* synthetic */ Text copy$default(Text text2, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = text2.content;
                }
                return text2.copy(string);
            }

            @NotNull
            public String toString() {
                return "Text(content=" + this.content + ')';
            }

            public int hashCode() {
                return this.content.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Text)) {
                    return false;
                }
                Text text2 = (Text)other;
                return Intrinsics.areEqual((Object)this.content, (Object)text2.content);
            }
        }
    }
}

