/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.diff.model;

import com.intellij.swagger.core.diff.SwDiffResult;
import com.intellij.swagger.core.diff.SwDiffUtilsKt;
import com.intellij.swagger.core.diff.model.SwModifiedElement;
import com.intellij.swagger.core.diff.model.SwModifiedHttpOperation;
import com.intellij.swagger.core.diff.model.SwModifiedRootElement;
import com.intellij.swagger.core.diff.model.SwModifiedUrl;
import com.intellij.swagger.core.model.api.SwHttpOperation;
import com.intellij.swagger.core.model.api.SwUrl;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u0015\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u000f0\u0016H\u0016R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lcom/intellij/swagger/core/diff/model/SwModifiedUrl;", "Lcom/intellij/swagger/core/diff/model/SwModifiedElement;", "Lcom/intellij/swagger/core/model/api/SwUrl;", "original", "modified", "root", "Lcom/intellij/swagger/core/diff/model/SwModifiedRootElement;", "<init>", "(Lcom/intellij/swagger/core/model/api/SwUrl;Lcom/intellij/swagger/core/model/api/SwUrl;Lcom/intellij/swagger/core/diff/model/SwModifiedRootElement;)V", "getOriginal", "()Lcom/intellij/swagger/core/model/api/SwUrl;", "getModified", "getRoot", "()Lcom/intellij/swagger/core/diff/model/SwModifiedRootElement;", "mySupportedOperationsDiff", "Lcom/intellij/swagger/core/diff/SwDiffResult;", "Lcom/intellij/swagger/core/model/api/SwHttpOperation;", "getMySupportedOperationsDiff", "()Lcom/intellij/swagger/core/diff/SwDiffResult;", "mySupportedOperationsDiff$delegate", "Lkotlin/Lazy;", "computeChildrenDiffs", "", "", "intellij.swagger.core"})
public final class SwModifiedUrl
implements SwModifiedElement<SwUrl> {
    @NotNull
    private final SwUrl original;
    @NotNull
    private final SwUrl modified;
    @NotNull
    private final SwModifiedRootElement root;
    @NotNull
    private final Lazy mySupportedOperationsDiff$delegate;

    public SwModifiedUrl(@NotNull SwUrl original, @NotNull SwUrl modified, @NotNull SwModifiedRootElement root) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)modified, (String)"modified");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.original = original;
        this.modified = modified;
        this.root = root;
        this.mySupportedOperationsDiff$delegate = LazyKt.lazy(() -> SwModifiedUrl.mySupportedOperationsDiff_delegate$lambda$1(this));
    }

    @Override
    @NotNull
    public SwUrl getOriginal() {
        return this.original;
    }

    @Override
    @NotNull
    public SwUrl getModified() {
        return this.modified;
    }

    @Override
    @NotNull
    public SwModifiedRootElement getRoot() {
        return this.root;
    }

    private final SwDiffResult<SwHttpOperation> getMySupportedOperationsDiff() {
        Lazy lazy = this.mySupportedOperationsDiff$delegate;
        return (SwDiffResult)lazy.getValue();
    }

    @NotNull
    public Collection<SwDiffResult<? extends Object>> computeChildrenDiffs() {
        return SetsKt.setOf(this.getMySupportedOperationsDiff());
    }

    private static final SwModifiedElement mySupportedOperationsDiff_delegate$lambda$1$lambda$0(SwModifiedUrl this$0, SwHttpOperation before, SwHttpOperation after) {
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        return new SwModifiedHttpOperation(before, after, this$0.getRoot());
    }

    private static final SwDiffResult mySupportedOperationsDiff_delegate$lambda$1(SwModifiedUrl this$0) {
        return SwDiffUtilsKt.calculateDiffBetween((Collection)this$0.getOriginal().getSupportedOperations(), (Collection)this$0.getModified().getSupportedOperations(), (Function1)mySupportedOperationsDiff.2.1.INSTANCE, (arg_0, arg_1) -> SwModifiedUrl.mySupportedOperationsDiff_delegate$lambda$1$lambda$0(this$0, arg_0, arg_1));
    }
}

