/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataWrangler.jupyterPython.cell.resolver;

import com.intellij.dataWrangler.jupyterPython.cell.JupyterDataWranglerCellMetadata;
import com.intellij.dataWrangler.jupyterPython.cell.JupyterDataWranglerCellMetadataKt;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.py.editor.completion.JupyterRuntimeEnvService;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.xdebugger.XNamedTreeNode;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/dataWrangler/jupyterPython/cell/resolver/JupyterRuntimeDataWranglerUnresolvedReferenceSkipper;", "Lcom/jetbrains/python/inspections/PyInspectionExtension;", "<init>", "()V", "ignoreUnresolvedReference", "", "node", "Lcom/jetbrains/python/psi/PyElement;", "reference", "Lcom/intellij/psi/PsiReference;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "isRelatedToPreviousDataCell", "notebookVirtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "intellij.dataWrangler.jupyterPython"})
@SourceDebugExtension(value={"SMAP\nJupyterRuntimeDataCellUnresolvedReferenceSkipper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRuntimeDataCellUnresolvedReferenceSkipper.kt\ncom/intellij/dataWrangler/jupyterPython/cell/resolver/JupyterRuntimeDataWranglerUnresolvedReferenceSkipper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n1#2:41\n30#3,2:42\n1761#4,3:44\n1761#4,3:47\n*S KotlinDebug\n*F\n+ 1 JupyterRuntimeDataCellUnresolvedReferenceSkipper.kt\ncom/intellij/dataWrangler/jupyterPython/cell/resolver/JupyterRuntimeDataWranglerUnresolvedReferenceSkipper\n*L\n23#1:42,2\n25#1:44,3\n34#1:47,3\n*E\n"})
public final class JupyterRuntimeDataWranglerUnresolvedReferenceSkipper
extends PyInspectionExtension {
    public boolean ignoreUnresolvedReference(@NotNull PyElement node, @NotNull PsiReference reference, @NotNull TypeEvalContext context) {
        boolean bl;
        block9: {
            PsiFile virtualFile;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            PsiFile psiFile = context.getOrigin();
            if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) {
                return false;
            }
            PsiFile psiFile2 = virtualFile = psiFile;
            BackedNotebookVirtualFile.Companion companion = BackedNotebookVirtualFile.Companion;
            PsiFile p0 = psiFile2;
            boolean bl2 = false;
            BackedNotebookVirtualFile backedNotebookVirtualFile = companion.takeIfBacked((VirtualFile)p0);
            if (backedNotebookVirtualFile == null) {
                return false;
            }
            BackedNotebookVirtualFile notebook = backedNotebookVirtualFile;
            String string = node.getName();
            if (string == null) {
                return false;
            }
            String name = string;
            if (this.isRelatedToPreviousDataCell(node, notebook)) {
                return true;
            }
            Project project = node.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<JupyterRuntimeEnvService> serviceClass$iv = JupyterRuntimeEnvService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            JupyterRuntimeEnvService runtimeService = (JupyterRuntimeEnvService)object;
            List list = runtimeService.getGlobalPythonVariables((VirtualFile)virtualFile, project2);
            if (list == null) {
                return false;
            }
            List treeNodeList = list;
            Iterable $this$any$iv = treeNodeList;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TreeNode it = (TreeNode)element$iv;
                    boolean bl3 = false;
                    if (!(it instanceof XNamedTreeNode && Intrinsics.areEqual((Object)((XNamedTreeNode)it).getName(), (Object)name))) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRelatedToPreviousDataCell(PyElement node, BackedNotebookVirtualFile notebookVirtualFile) {
        Document document = PsiDocumentManager.getInstance((Project)node.getProject()).getDocument(node.getContainingFile());
        if (document == null) {
            return false;
        }
        Document document2 = document;
        int lineNumber = document2.getLineNumber(node.getTextRange().getStartOffset());
        try {
            boolean bl;
            NotebookCellLines.Interval interval = (NotebookCellLines.Interval)NotebookCellLines.Companion.get(document2).intervalsIterator(lineNumber).next();
            List cellsBefore = notebookVirtualFile.getNotebook().computeCells().subList(0, interval.getOrdinal());
            Iterable $this$any$iv = cellsBefore;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                JupyterCell it = (JupyterCell)element$iv;
                boolean bl2 = false;
                if (it.getCellType() == JupyterCellType.DATA_WRANGLER) {
                    JupyterDataWranglerCellMetadata jupyterDataWranglerCellMetadata = JupyterDataWranglerCellMetadataKt.getDataWranglerMetadata(it);
                    if (Intrinsics.areEqual((Object)(jupyterDataWranglerCellMetadata != null ? jupyterDataWranglerCellMetadata.getVariableName() : null), (Object)node.getName())) {
                        return true;
                    }
                }
                bl = false;
            } while (!bl);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }
}

