/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.manage;

import com.google.common.collect.ImmutableList;
import com.intellij.commandInterface.command.CommandExecutor;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.django.manage.DjangoManageTask;
import com.intellij.python.django.util.DjangoUtil;
import com.intellij.util.NotNullFunction;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.HelperPackage;
import com.jetbrains.python.PythonHelper;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DjangoConsoleExecutor
implements CommandExecutor {
    static final CommandExecutor INSTANCE = new DjangoConsoleExecutor();
    private static final FileSystemFlusher SYSTEM_FLUSHER = new FileSystemFlusher();

    private DjangoConsoleExecutor() {
    }

    public void execute(@NotNull String commandName, @NotNull Module module, @NotNull List<String> parameters, @Nullable ConsoleView consoleView, @Nullable Runnable onExecuted) {
        if (commandName == null) {
            DjangoConsoleExecutor.$$$reportNull$$$0(0);
        }
        if (module == null) {
            DjangoConsoleExecutor.$$$reportNull$$$0(1);
        }
        if (parameters == null) {
            DjangoConsoleExecutor.$$$reportNull$$$0(2);
        }
        VirtualFile manageFile = DjangoUtil.getManageFile((Module)module);
        String projectRoot = DjangoUtil.getProjectRoot((Module)module);
        if (projectRoot == null && manageFile != null) {
            projectRoot = manageFile.getParent().getPath();
        }
        try {
            DjangoManageTask task = new DjangoManageTask(module, DjangoBundle.message((String)"manage.run.tab.name", (Object[])new Object[0]));
            task.setWorkingDirectory(projectRoot);
            task.setHelper((HelperPackage)PythonHelper.DJANGO_MANAGE);
            ImmutableList.Builder parametersString = new ImmutableList.Builder().add((Object)commandName).addAll(parameters);
            if (!SystemInfo.isWindows) {
                NotNullFunction escaperFunction = StringUtil.escaper((boolean)false, (String)"|>$\"'& ");
                projectRoot = (String)escaperFunction.fun((Object)projectRoot);
            }
            parametersString.add((Object)projectRoot);
            task.setParameters((List)parametersString.build());
            task.setHelpId("reference.manage.py");
            task.setAfterCompletion(() -> {
                SYSTEM_FLUSHER.run();
                if (onExecuted != null) {
                    onExecuted.run();
                }
            });
            task.run(consoleView);
        }
        catch (ExecutionException e) {
            Messages.showErrorDialog((String)DjangoBundle.message((String)"manage.run.error", (Object[])new Object[]{e.getMessage()}), (String)DjangoBundle.message((String)"django", (Object[])new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "commandName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
        }
        objectArray[1] = "com/intellij/python/django/manage/DjangoConsoleExecutor";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class FileSystemFlusher
    implements Runnable {
        private FileSystemFlusher() {
        }

        @Override
        public void run() {
            LocalFileSystem.getInstance().refresh(true);
        }
    }
}

