/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.microservices;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.javascript.microservices.JsRequestBodyAutoPopupHandlerKt;
import com.intellij.javascript.microservices.JsRequestBodyDetectionKt;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/javascript/microservices/JsRequestBodyAutoPopupHandler;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "<init>", "()V", "checkAutoPopup", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "charTyped", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isSuitableCharTyped", "", "isInsideJsRequestBody", "psiFile", "showCompletionPopup", "", "condition", "Lcom/intellij/openapi/util/Condition;", "intellij.javascript.langInjection"})
public final class JsRequestBodyAutoPopupHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.getFileType() instanceof JavaScriptFileType && this.isSuitableCharTyped(charTyped)) {
            this.showCompletionPopup(editor, project, (Condition<PsiFile>)((Condition)arg_0 -> JsRequestBodyAutoPopupHandler.checkAutoPopup$lambda$0(this, editor, arg_0)));
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private final boolean isSuitableCharTyped(char charTyped) {
        return JsRequestBodyAutoPopupHandlerKt.access$getLetterOrBraceOrNewLinePattern$p().matches((CharSequence)String.valueOf(charTyped));
    }

    private final boolean isInsideJsRequestBody(PsiFile psiFile, Editor editor) {
        PsiElement psiElement = psiFile.findElementAt(editor.getCaretModel().getOffset());
        if (psiElement == null) {
            return false;
        }
        PsiElement elementAtCaret = psiElement;
        return SequencesKt.any(JsRequestBodyDetectionKt.findBodyDeclarations(elementAtCaret));
    }

    private final void showCompletionPopup(Editor editor, Project project, Condition<PsiFile> condition) {
        AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, condition);
    }

    private static final boolean checkAutoPopup$lambda$0(JsRequestBodyAutoPopupHandler this$0, Editor $editor, PsiFile psiFile) {
        Intrinsics.checkNotNull((Object)psiFile);
        return this$0.isInsideJsRequestBody(psiFile, $editor);
    }
}

