/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.python.community.helpersLocator.PythonHelpersLocator;
import com.intellij.python.remoteInterpreter.PyHelpersDownload;
import com.intellij.python.remoteInterpreter.PyHelpersUpload;
import com.intellij.python.remoteInterpreter.PyRemoteProcessUtil;
import com.intellij.python.remoteInterpreter.PyRemoteSkeletonGeneratorWithRemoteSources;
import com.intellij.python.remoteInterpreter.PyRemoteSocketToLocalHostProviderFactory;
import com.intellij.python.remoteInterpreter.PySshCommandLineStateUtil;
import com.intellij.python.remoteInterpreter.PythonRemoteInterpreterBundle;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteFile;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.process.CapturingSshProcessHandler;
import com.intellij.ssh.process.SshExecProcess;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.ZipUtil;
import com.jetbrains.plugins.remotesdk.RemoteSdkSessionUtil;
import com.jetbrains.python.remote.PyRemoteInterpreterUtil;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteProcessHandler;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.remote.PyRemoteSourceItem;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.skeletons.LineWiseProcessOutputListener;
import java.awt.Component;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PyRemoteSkeletonGenerator
extends PyRemoteSkeletonGeneratorWithRemoteSources {
    @Nullable
    private final Component myOwnerComponent;
    private final PyRemoteSdkAdditionalData myRemoteSdkData;
    private final RemoteCredentials myCredentials;

    PyRemoteSkeletonGenerator(@Nullable Project project, @Nullable Component ownerComponent, String skeletonsPath, Sdk sdk) throws ExecutionException {
        super(skeletonsPath, sdk, null, project);
        this.myOwnerComponent = ownerComponent;
        this.myRemoteSdkData = this.getRemoteSdkAdditionalData();
        try {
            this.myCredentials = this.myRemoteSdkData.getRemoteCredentials(project, false);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Couldn't get remote credentials", e);
        }
    }

    public void prepare() {
        ListenableFuture<?> future = PyHelpersUpload.uploadAllHelpers(this.myProject, null, this.myCredentials, (RemoteSdkProperties)this.myRemoteSdkData, false);
        try {
            future.get();
        }
        catch (Exception e) {
            LOG.error("Helpers upload failed", (Throwable)e);
        }
    }

    @NotNull
    protected ProcessOutput getProcessOutput(String homePath, String @NotNull [] commandLine, @Nullable String stdin, @Nullable Map<String, String> extraEnv, int timeout) throws InvalidSdkException {
        if (commandLine == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(0);
        }
        ProcessOutput processOutput = this.runProcessWithOptionalLineOutputListener(homePath, Arrays.asList(commandLine), stdin, null);
        if (processOutput == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(1);
        }
        return processOutput;
    }

    @NotNull
    protected ProcessOutput runProcessWithLineOutputListener(@NotNull String homePath, @NotNull List<String> cmd, @NotNull Map<String, String> env, @Nullable String stdin, int timeout, @NotNull LineWiseProcessOutputListener listener) throws ExecutionException, InvalidSdkException {
        if (homePath == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(2);
        }
        if (cmd == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(3);
        }
        if (env == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(4);
        }
        if (listener == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(5);
        }
        ProcessOutput processOutput = this.runProcessWithOptionalLineOutputListener(homePath, cmd, stdin, listener);
        if (processOutput == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(6);
        }
        return processOutput;
    }

    private ProcessOutput runProcessWithOptionalLineOutputListener(String homePath, List<String> cmd, String stdin, LineWiseProcessOutputListener listener) throws InvalidSdkException {
        String[] commandLine = PyRemoteSkeletonGenerator.addUnbuffered(homePath, ArrayUtil.toStringArray(cmd));
        try {
            PyRemotePathMapper pathMapper = this.createPathMappings(this.myProject, (PyRemoteSdkAdditionalDataBase)this.getRemoteSdkAdditionalData());
            ConnectionBuilder connectionBuilder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)this.myCredentials, (Project)this.myProject);
            RemoteSdkSessionUtil.checkConnection((ConnectionBuilder)connectionBuilder, (Project)this.myProject);
            CapturingSshProcessHandler handler = PyRemoteProcessUtil.getProcessHandler(connectionBuilder, this.myCredentials, (RemoteSdkProperties)this.myRemoteSdkData, pathMapper, commandLine, null, false);
            if (listener != null) {
                handler.addProcessListener((ProcessListener)new LineWiseProcessOutputListener.Adapter(listener));
            }
            if (stdin != null) {
                PyRemoteSkeletonGenerator.sendLineToProcessInput((BaseProcessHandler)handler, (String)stdin);
            }
            return handler.runProcess();
        }
        catch (ExecutionException e) {
            throw new InvalidSdkException(e.getMessage(), (Throwable)e);
        }
    }

    private ProcessHandler getProcessHandler(@Nullable Project project, GeneralCommandLine commandLine) throws InvalidSdkException {
        try {
            assert (this.mySdk.getSdkAdditionalData() instanceof PyRemoteSdkAdditionalDataBase);
            PyRemotePathMapper pathMapper = this.createPathMappings(project, (PyRemoteSdkAdditionalDataBase)this.mySdk.getSdkAdditionalData());
            return PyRemoteSkeletonGenerator.startRemoteProcessImpl(project, this.myCredentials, (RemoteSdkProperties)this.myRemoteSdkData, commandLine, pathMapper);
        }
        catch (RemoteSdkException e) {
            throw new InvalidSdkException(PythonRemoteInterpreterBundle.message("python.remote.skeleton.generator.error.running.sdk", new Object[0]));
        }
    }

    private static PyRemoteProcessHandler startRemoteProcessImpl(@Nullable Project project, RemoteCredentials credentials, RemoteSdkProperties sdkProperties, GeneralCommandLine commandLine, PyRemotePathMapper pathMapper) throws RemoteSdkException {
        ConnectionBuilder connectionBuilder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)credentials, (Project)project);
        RemoteSdkSessionUtil.checkConnection((ConnectionBuilder)connectionBuilder, (Project)project);
        PyRemoteProcessUtil.uploadAllHelpers(credentials, sdkProperties, project);
        PyRemoteSocketToLocalHostProvider sshRemoteSocketProvider = PyRemoteSocketToLocalHostProviderFactory.ssh(connectionBuilder, sdkProperties);
        PySshCommandLineStateUtil.patchCommandLineForSshSession(commandLine, sdkProperties, pathMapper, sshRemoteSocketProvider);
        commandLine.setExePath(sdkProperties.getInterpreterPath());
        SshExecProcess process = RemoteCredentialsUtil.processBuilder((ConnectionBuilder)connectionBuilder, (GeneralCommandLine)commandLine).withAllocatePty(true).start();
        String fullInterpreterPath = RemoteSdkProperties.getFullInterpreterPath((RemoteCredentials)credentials, (RemoteSdkProperties)sdkProperties);
        PyRemoteProcessHandler handler = PyRemoteProcessHandler.createProcessHandler((RemoteProcess)process, (String)fullInterpreterPath, (GeneralCommandLine)commandLine, (PyRemotePathMapper)pathMapper, (PyRemoteSocketToLocalHostProvider)sshRemoteSocketProvider);
        PyRemoteInterpreterUtil.closeOnProcessTermination((ProcessHandler)handler, (Closeable)sshRemoteSocketProvider);
        return handler;
    }

    @NotNull
    private GeneralCommandLine createZipSourcesCommandLine() {
        GeneralCommandLine cmd = new GeneralCommandLine(new String[]{this.mySdk.getHomePath()});
        cmd.getParametersList().addParamsGroup("Exe Options");
        ParamsGroup group = cmd.getParametersList().addParamsGroup("Script");
        group.addParameters(new String[]{PythonHelpersLocator.findPathStringInHelpers((String)"generator3/__main__.py"), "-z", this.getSkeletonsPath()});
        GeneralCommandLine generalCommandLine = cmd;
        if (generalCommandLine == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(7);
        }
        return generalCommandLine;
    }

    private static void extractSources(File arc, String localPath) throws IOException {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        indicator.setText(PythonRemoteInterpreterBundle.message("ssh.interpreter.skeletons.extracting.contents.indicator.text", arc.getPath()));
        CountingFilenameFilter countingFilenameFilter = new CountingFilenameFilter();
        ZipUtil.extract((File)arc, (File)new File(localPath), (FilenameFilter)countingFilenameFilter);
        LOG.info("Extracted " + countingFilenameFilter.myCount + " files from skeletons zip");
    }

    private static void sendSourcesToCompressList(@NotNull Collection<PyRemoteSourceItem> list, @NotNull ProcessHandler process) {
        if (list == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(8);
        }
        if (process == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(9);
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        try (PrintWriter w = new PrintWriter(process.getProcessInput(), false, StandardCharsets.UTF_8);){
            for (PyRemoteSourceItem sourceItem : list) {
                indicator.setText(PythonRemoteInterpreterBundle.message("ssh.interpreter.skeletons.compressing.module.indicator.text", sourceItem.getModule()));
                String arcPath = sourceItem.getArcPath();
                arcPath = StringUtil.trimStart((String)arcPath, (String)"/");
                w.println(sourceItem.getPath() + " " + arcPath);
            }
            w.println("-");
            w.flush();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    protected String getRemoteSkeletonsPath() {
        String sdkHomePath = this.mySdk.getHomePath();
        assert (sdkHomePath != null) : this.mySdk;
        return RemoteFile.createRemoteFile((String)PythonSdkUtil.getSkeletonsPath((String)this.myRemoteSdkData.getHelpersPath(), (String)sdkHomePath)).getPath();
    }

    @Override
    protected void downloadSourcesToLocalFolder(@NotNull String localPath, @NotNull Collection<PyRemoteSourceItem> sourcesToDownload) throws InvalidSdkException {
        if (localPath == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(10);
        }
        if (sourcesToDownload == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(11);
        }
        final Ref zipTransfer = Ref.create((Object)false);
        final Ref zipSourceItem = Ref.create(null);
        GeneralCommandLine cmd = this.createZipSourcesCommandLine();
        long compressingStartedInNanos = System.nanoTime();
        ProcessHandler process = this.getProcessHandler(this.myProject, cmd);
        final Semaphore semaphore = new Semaphore(0);
        final StringBuilder output = new StringBuilder();
        process.addProcessListener(new ProcessListener(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                String text = event.getText();
                output.append(text);
                if (text.startsWith("OK: ")) {
                    text = text.substring(4).trim();
                    zipSourceItem.set((Object)new PyRemoteSourceItem(text, new File(text).getParent(), 0));
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                LOG.info("Remote zip process terminated with exit code " + event.getExitCode());
                if (event.getExitCode() != 0) {
                    zipTransfer.set((Object)false);
                } else {
                    zipTransfer.set((Object)true);
                }
                semaphore.release(1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/python/remoteInterpreter/PyRemoteSkeletonGenerator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        process.startNotify();
        LOG.info("Compressing " + sourcesToDownload.size() + " source files");
        PyRemoteSkeletonGenerator.sendSourcesToCompressList(sourcesToDownload, process);
        process.waitFor(2000L);
        try {
            while (!process.isProcessTerminated() && !semaphore.tryAcquire(120L, TimeUnit.SECONDS)) {
                long durationInMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - compressingStartedInNanos);
                LOG.info("Still compressing source files during " + StringUtil.formatDuration((long)durationInMillis) + "...");
            }
        }
        catch (InterruptedException e) {
            zipTransfer.set((Object)false);
        }
        if (((Boolean)zipTransfer.get()).booleanValue()) {
            try {
                PyRemoteSourceItem remoteZip = (PyRemoteSourceItem)zipSourceItem.get();
                String name = new File(remoteZip.getPath()).getName();
                File zipFile = new File(localPath, name);
                FileUtil.delete((File)zipFile);
                LOG.info("Downloading zipped sources and localSourcesFile: " + remoteZip.getPath());
                this.transferSources(Lists.newArrayList((Object[])new PyRemoteSourceItem[]{remoteZip}), localPath);
                LOG.info("Extracting downloaded zipped sources and localSourcesFile: " + zipFile.getPath());
                PyRemoteSkeletonGenerator.extractSources(zipFile, localPath);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                zipTransfer.set((Object)false);
            }
        }
        if (!((Boolean)zipTransfer.get()).booleanValue()) {
            LOG.warn("Problems with compressing sources:\n" + String.valueOf(output));
            try {
                this.transferSources(sourcesToDownload, localPath);
            }
            catch (Exception e) {
                LOG.error("Can't copy sources ", (Throwable)e);
            }
        }
    }

    private void transferSources(Collection<PyRemoteSourceItem> sources, String localFolder) throws FileSystemException {
        PyHelpersDownload.transferSources(this.myProject, this.myOwnerComponent, this.myCredentials, (RemoteSdkProperties)this.myRemoteSdkData, sources, localFolder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/remoteInterpreter/PyRemoteSkeletonGenerator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcesToDownload";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/remoteInterpreter/PyRemoteSkeletonGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOutput";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcessWithLineOutputListener";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createZipSourcesCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithLineOutputListener";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sendSourcesToCompressList";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "downloadSourcesToLocalFolder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 7 -> new IllegalStateException(string);
        };
    }

    private static class CountingFilenameFilter
    implements FilenameFilter {
        private int myCount = 0;

        private CountingFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            ++this.myCount;
            return true;
        }
    }
}

