/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j;

import java.io.IOException;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.locationtech.proj4j.InvalidValueException;
import org.locationtech.proj4j.Registry;
import org.locationtech.proj4j.UnknownAuthorityCodeException;
import org.locationtech.proj4j.UnsupportedParameterException;
import org.locationtech.proj4j.io.Proj4FileReader;
import org.locationtech.proj4j.parser.Proj4Parser;

public class CRSFactory {
    private static Proj4FileReader csReader = new Proj4FileReader();
    private static Registry registry = new Registry();

    public Registry getRegistry() {
        return registry;
    }

    public CoordinateReferenceSystem createFromName(String name2) throws UnsupportedParameterException, InvalidValueException, UnknownAuthorityCodeException {
        String[] params = csReader.getParameters(name2);
        if (params == null) {
            throw new UnknownAuthorityCodeException(name2);
        }
        return this.createFromParameters(name2, params);
    }

    public CoordinateReferenceSystem createFromParameters(String name2, String paramStr2) throws UnsupportedParameterException, InvalidValueException {
        return this.createFromParameters(name2, CRSFactory.splitParameters(paramStr2));
    }

    public CoordinateReferenceSystem createFromParameters(String name2, String[] params) throws UnsupportedParameterException, InvalidValueException {
        if (params == null) {
            return null;
        }
        Proj4Parser parser = new Proj4Parser(registry);
        return parser.parse(name2, params);
    }

    public String readEpsgFromParameters(String paramStr2) throws IOException {
        return this.readEpsgFromParameters(CRSFactory.splitParameters(paramStr2));
    }

    public String readEpsgFromParameters(String[] params) throws IOException {
        return csReader.readEpsgCodeFromFile(params);
    }

    private static String[] splitParameters(String paramStr2) {
        String[] params = paramStr2.split("\\s+");
        return params;
    }
}

