/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.sql.common.impl.formatter.settings;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Weighted;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettingsDefault;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlLanguage;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB#\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0019\u001a\u00020\u0007H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/sql/common/impl/formatter/settings/SqlPredefinedCodeStyle;", "Lcom/intellij/psi/codeStyle/PredefinedCodeStyle;", "Lcom/intellij/openapi/util/Weighted;", "originalName", "", "displayName", "weight", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;D)V", "getOriginalName", "()Ljava/lang/String;", "getDefaultStyle", "Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettingsDefault;", "isApplicableToLanguage", "", "language", "Lcom/intellij/lang/Language;", "apply", "", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "sql", "Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;", "setup", "getWeight", "Companion", "intellij.database.sql.common.impl"})
public abstract class SqlPredefinedCodeStyle
extends PredefinedCodeStyle
implements Weighted {
    @NotNull
    protected static final Companion Companion = new Companion(null);
    @NotNull
    private final String originalName;
    private final double weight;
    @NotNull
    private static final Logger log;

    public SqlPredefinedCodeStyle(@NlsSafe @NotNull String originalName, @NlsContexts.ListItem @NotNull String displayName, double weight) {
        Intrinsics.checkNotNullParameter((Object)originalName, (String)"originalName");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        super(displayName, (Language)SqlLanguage.INSTANCE);
        this.originalName = originalName;
        this.weight = weight;
    }

    @NotNull
    public final String getOriginalName() {
        return this.originalName;
    }

    @Nullable
    protected SqlCodeStyleSettingsDefault getDefaultStyle() {
        return null;
    }

    public boolean isApplicableToLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return Intrinsics.areEqual((Object)language, (Object)((Object)SqlLanguage.INSTANCE)) || language instanceof SqlLanguageDialect;
    }

    public void apply(@NotNull CodeStyleSettings settings, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        log.info("Applying pre-defined code style: " + this.originalName);
        SqlCodeStyleSettings sqlCodeStyleSettings = SqlCodeStyles.getSqlSettings(settings, language);
        Intrinsics.checkNotNullExpressionValue((Object)sqlCodeStyleSettings, (String)"getSqlSettings(...)");
        SqlCodeStyleSettings sql = sqlCodeStyleSettings;
        this.apply(sql);
    }

    public final void apply(@NotNull SqlCodeStyleSettings sql) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        SqlCodeStyleSettingsDefault ds = this.getDefaultStyle();
        if (ds != null) {
            sql.assignDefaults(ds);
        }
        this.setup(sql);
    }

    protected void setup(@NotNull SqlCodeStyleSettings sql) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
    }

    public double getWeight() {
        return this.weight;
    }

    static {
        Logger logger2 = Logger.getInstance(SqlPredefinedCodeStyle.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        log = logger2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0084\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/sql/common/impl/formatter/settings/SqlPredefinedCodeStyle$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.database.sql.common.impl"})
    protected static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

