/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.transport.ecf;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.invoke.CallSite;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.filetransfer.FileTransferJob;
import org.eclipse.ecf.filetransfer.IFileRangeSpecification;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IFileTransferPausable;
import org.eclipse.ecf.filetransfer.IIncomingFileTransfer;
import org.eclipse.ecf.filetransfer.IRetrieveFileTransferOptions;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.UserCancelledException;
import org.eclipse.ecf.filetransfer.events.IFileTransferConnectStartEvent;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDataEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDoneEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceivePausedEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveResumedEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveStartEvent;
import org.eclipse.ecf.filetransfer.identity.FileCreateException;
import org.eclipse.ecf.filetransfer.identity.FileIDFactory;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransfer;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransferFactory;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.repository.AuthenticationFailedException;
import org.eclipse.equinox.internal.p2.repository.FileInfo;
import org.eclipse.equinox.internal.p2.repository.JREHttpClientRequiredException;
import org.eclipse.equinox.internal.p2.repository.Messages;
import org.eclipse.equinox.internal.p2.repository.ProgressStatistics;
import org.eclipse.equinox.internal.p2.repository.RepositoryPreferences;
import org.eclipse.equinox.internal.p2.repository.RepositoryTracing;
import org.eclipse.equinox.internal.p2.transport.ecf.Activator;
import org.eclipse.equinox.internal.p2.transport.ecf.RepositoryStatusHelper;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public final class FileReader
extends FileTransferJob
implements IFileTransferListener {
    static Map<String, Map<String, String>> options;
    private static IFileReaderProbe testProbe;
    private boolean closeStreamWhenFinished = false;
    private Exception exception;
    private FileInfo fileInfo;
    private long lastProgressCount;
    private long lastStatsCount;
    protected IProgressMonitor theMonitor;
    private OutputStream theOutputStream;
    private ProgressStatistics statistics;
    private final int connectionRetryCount;
    private final long connectionRetryDelay;
    private final boolean retryOnSocketTimeout;
    private final IConnectContext connectContext;
    private URI requestUri;
    protected IFileTransferConnectStartEvent connectEvent;
    private Job cancelJob;
    private boolean monitorStarted;
    private final IProvisioningAgent agent;
    private boolean isPause = false;
    private boolean hasPaused = false;
    private IFileTransferPausable pasuable = null;

    static {
        HashMap<String, CallSite> extraRequestHeaders = new HashMap<String, CallSite>(1);
        String userAgent = null;
        String javaSpec = FileReader.getProperty("java.runtime.version", "unknownJava");
        String javaVendor = FileReader.getProperty("java.vendor", "unknownJavaVendor");
        String osName = FileReader.getProperty("org.osgi.framework.os.name", "unknownOS");
        String osgiArch = FileReader.getProperty("org.osgi.framework.processor", "unknownArch");
        String language = FileReader.getProperty("osgi.nl", "unknownLanguage");
        String osVersion = FileReader.getProperty("org.osgi.framework.os.version", "unknownOSVersion");
        String p2Version = Activator.getVersion().map(Version::toString).orElse("unknownVersion");
        userAgent = "p2/" + p2Version + " (Java " + javaSpec + " " + javaVendor + "; " + osName + " " + osVersion + " " + osgiArch + "; " + language + ") ";
        String userAgentProvided = FileReader.getProperty("p2.userAgent", null);
        if (userAgentProvided == null) {
            String productId = FileReader.getProperty("eclipse.product", "unknownProduct");
            String appId = FileReader.getProperty("eclipse.application", "unknownApp");
            String buildId = FileReader.getProperty("eclipse.buildId", "unknownBuildId");
            userAgent = userAgent + productId + "/" + buildId + " (" + appId + ")";
        } else {
            userAgent = userAgent + userAgentProvided;
        }
        extraRequestHeaders.put("User-Agent", (CallSite)((Object)userAgent));
        options = new HashMap<String, Map<String, String>>(1);
        options.put(IRetrieveFileTransferOptions.REQUEST_HEADERS, extraRequestHeaders);
    }

    private static String getProperty(String key, String defaultValue) {
        String value = Activator.getProperty(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public FileReader(IProvisioningAgent aAgent, IConnectContext aConnectContext) {
        super(Messages.FileTransport_reader);
        this.setSystem(true);
        this.setUser(false);
        this.connectionRetryCount = RepositoryPreferences.getConnectionRetryCount();
        this.connectionRetryDelay = RepositoryPreferences.getConnectionMsRetryDelay();
        this.retryOnSocketTimeout = RepositoryPreferences.getRetryOnSocketTimeout();
        this.connectContext = aConnectContext;
        this.agent = aAgent;
    }

    public FileInfo getLastFileInfo() {
        return this.fileInfo;
    }

    public synchronized void handleTransferEvent(IFileTransferEvent event) {
        if (event instanceof IFileTransferConnectStartEvent) {
            this.connectEvent = (IFileTransferConnectStartEvent)event;
            this.connectEvent.connectUsingJob(((IFileTransferConnectStartEvent)event).prepareConnectJob(null));
            this.cancelJob = new CancelHandler();
            this.cancelJob.schedule(500L);
        } else if (event instanceof IIncomingFileTransferReceiveStartEvent) {
            if (this.cancelJob != null) {
                this.cancelJob.cancel();
            }
            IIncomingFileTransfer source = ((IIncomingFileTransferEvent)event).getSource();
            try {
                FileInfo fi = new FileInfo();
                Date lastModified = source.getRemoteLastModified();
                if (lastModified != null) {
                    fi.setLastModified(lastModified.getTime());
                }
                fi.setName(source.getRemoteFileName());
                fi.setSize(source.getFileLength());
                this.fileInfo = fi;
                ((IIncomingFileTransferReceiveStartEvent)event).receive(this.theOutputStream, (FileTransferJob)this);
            }
            catch (IOException e) {
                this.exception = e;
                return;
            }
            long fileLength = source.getFileLength();
            ProgressStatistics stats = new ProgressStatistics(this.agent, this.requestUri, source.getRemoteFileName(), fileLength);
            this.setStatistics(stats);
            if (this.theMonitor != null) {
                this.theMonitor.beginTask(null, 1000);
                this.monitorStarted = true;
                this.theMonitor.subTask(stats.report());
                this.lastStatsCount = 0L;
                this.lastProgressCount = 0L;
            }
            this.onStart(source);
        } else if (event instanceof IIncomingFileTransferReceiveDataEvent) {
            IIncomingFileTransfer source = ((IIncomingFileTransferEvent)event).getSource();
            if (this.theMonitor != null) {
                if (this.theMonitor.isCanceled()) {
                    source.cancel();
                    return;
                }
                long br = source.getBytesReceived();
                long count = br - this.lastStatsCount;
                this.lastStatsCount = br;
                ProgressStatistics stats = this.getStatistics();
                if (stats != null) {
                    stats.increase(count);
                    this.fileInfo.setAverageSpeed(stats.getAverageSpeed());
                    if (stats.shouldReport()) {
                        count = br - this.lastProgressCount;
                        this.lastProgressCount = br;
                        this.theMonitor.subTask(stats.report());
                        this.theMonitor.worked((int)(1000L * count / stats.getTotal()));
                    }
                }
            }
            this.pauseIfPossible(source);
            this.onData(source);
        } else if (event instanceof IIncomingFileTransferReceiveDoneEvent) {
            this.hasPaused = false;
            if (this.closeStreamWhenFinished) {
                FileReader.hardClose(this.theOutputStream);
            }
            if (this.exception == null) {
                this.exception = ((IIncomingFileTransferReceiveDoneEvent)event).getException();
            }
            this.onDone(((IIncomingFileTransferReceiveDoneEvent)event).getSource());
        } else if (event instanceof IIncomingFileTransferReceivePausedEvent) {
            this.hasPaused = true;
        } else if (event instanceof IIncomingFileTransferReceiveResumedEvent) {
            if (this.cancelJob != null) {
                this.cancelJob.cancel();
            }
            try {
                try {
                    ((IIncomingFileTransferReceiveResumedEvent)event).receive(this.theOutputStream, (FileTransferJob)this);
                }
                catch (IOException e) {
                    this.exception = e;
                    this.hasPaused = false;
                }
            }
            finally {
                this.hasPaused = false;
            }
        }
    }

    private synchronized void pauseIfPossible(IIncomingFileTransfer source) {
        if (this.isPaused() && !this.hasPaused) {
            this.pasuable = (IFileTransferPausable)source.getAdapter(IFileTransferPausable.class);
            if (this.pasuable != null) {
                this.pasuable.pause();
            }
        }
    }

    public InputStream read(URI url, IProgressMonitor monitor) throws CoreException, FileNotFoundException, AuthenticationFailedException, JREHttpClientRequiredException {
        PipedOutputStream output;
        final PipedInputStream input = new PipedInputStream();
        try {
            output = new PipedOutputStream(input);
        }
        catch (IOException e) {
            throw RepositoryStatusHelper.wrap(e);
        }
        RepositoryTracing.debug((String)"Downloading {0}", (Object)url);
        this.sendRetrieveRequest(url, output, null, true, monitor);
        return new InputStream(){

            @Override
            public int available() throws IOException {
                this.checkException();
                return input.available();
            }

            @Override
            public void close() throws IOException {
                FileReader.hardClose(input);
                this.checkException();
            }

            @Override
            public void mark(int readlimit) {
                input.mark(readlimit);
            }

            @Override
            public boolean markSupported() {
                return input.markSupported();
            }

            @Override
            public int read() throws IOException {
                this.checkException();
                return input.read();
            }

            @Override
            public int read(byte[] b) throws IOException {
                this.checkException();
                return input.read(b);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                this.checkException();
                return input.read(b, off, len);
            }

            @Override
            public void reset() throws IOException {
                this.checkException();
                input.reset();
            }

            @Override
            public long skip(long n) throws IOException {
                this.checkException();
                return input.skip(n);
            }

            private void checkException() throws IOException {
                IOException e;
                if (FileReader.this.getException() == null) {
                    return;
                }
                Throwable t = RepositoryStatusHelper.unwind(FileReader.this.getException());
                if (t instanceof IOException) {
                    e = (IOException)t;
                } else {
                    if (t instanceof UserCancelledException) {
                        Throwable cause = t;
                        t = new OperationCanceledException(t.getMessage());
                        t.initCause(cause);
                    }
                    e = new IOException(t.getMessage());
                    e.initCause(t);
                }
                throw e;
            }
        };
    }

    public void readInto(URI uri, OutputStream anOutputStream, IProgressMonitor monitor) throws CoreException, FileNotFoundException, AuthenticationFailedException, JREHttpClientRequiredException {
        this.readInto(uri, anOutputStream, -1L, monitor);
    }

    public boolean belongsTo(Object family) {
        return family == this;
    }

    public void readInto(URI uri, OutputStream anOutputStream, long startPos, IProgressMonitor monitor) throws CoreException, FileNotFoundException, AuthenticationFailedException, JREHttpClientRequiredException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                this.sendRetrieveRequest(uri, anOutputStream, startPos != -1L ? new DownloadRange(startPos) : null, false, monitor);
                Job.getJobManager().join((Object)this, (IProgressMonitor)new SuppressBlockedMonitor(monitor, 0));
                this.waitPaused(uri, anOutputStream, startPos, monitor);
                if (monitor.isCanceled() && this.connectEvent != null) {
                    this.connectEvent.cancel();
                }
                this.checkException(uri, this.connectionRetryCount);
            }
            catch (InterruptedException e) {
                monitor.setCanceled(true);
                throw new OperationCanceledException();
            }
        }
        finally {
            if (this.cancelJob != null) {
                this.cancelJob.cancel();
                this.cancelJob = null;
            }
            if (!this.monitorStarted) {
                monitor.beginTask(null, 1);
            }
            this.monitorStarted = false;
            monitor.done();
        }
    }

    protected void waitPaused(URI uri, OutputStream anOutputStream, long startPos, IProgressMonitor monitor) throws AuthenticationFailedException, JREHttpClientRequiredException, FileNotFoundException, CoreException, OperationCanceledException, InterruptedException {
        if (this.hasPaused) {
            while (this.hasPaused) {
                Thread.sleep(1000L);
                if (!monitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            Job.getJobManager().join((Object)this, (IProgressMonitor)new SuppressBlockedMonitor(monitor, 0));
            this.waitPaused(uri, anOutputStream, startPos, monitor);
        }
    }

    protected void sendRetrieveRequest(URI uri, OutputStream outputStream, DownloadRange range, boolean closeStreamOnFinish, IProgressMonitor monitor) throws CoreException, FileNotFoundException, AuthenticationFailedException, JREHttpClientRequiredException {
        IRetrieveFileTransferFactory factory = Activator.getDefault().getRetrieveFileTransferFactory();
        if (factory == null) {
            throw RepositoryStatusHelper.fromMessage(Messages.ecf_configuration_error);
        }
        IRetrieveFileTransfer adapter = factory.newInstance();
        adapter.setConnectContextForAuthentication(this.connectContext);
        this.exception = null;
        this.closeStreamWhenFinished = closeStreamOnFinish;
        this.fileInfo = null;
        this.statistics = null;
        this.lastProgressCount = 0L;
        this.lastStatsCount = 0L;
        this.theMonitor = monitor;
        this.monitorStarted = false;
        this.theOutputStream = outputStream;
        this.requestUri = uri;
        int retryCount = 0;
        while (true) {
            block7: {
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    IFileID fileID = FileIDFactory.getDefault().createFileID(adapter.getRetrieveNamespace(), uri.toString());
                    adapter.sendRetrieveRequest(fileID, (IFileRangeSpecification)range, (IFileTransferListener)this, options);
                }
                catch (IncomingFileTransferException e) {
                    this.exception = e;
                }
                catch (FileCreateException e) {
                    this.exception = e;
                }
                catch (Throwable t) {
                    if (this.exception == null) break block7;
                    this.exception.printStackTrace();
                }
            }
            if (this.checkException(uri, retryCount)) break;
            ++retryCount;
        }
    }

    public synchronized boolean pause() {
        this.isPause = true;
        return true;
    }

    public boolean isPaused() {
        return this.isPause;
    }

    public synchronized boolean resume() {
        this.isPause = false;
        if (this.pasuable != null) {
            return this.pasuable.resume();
        }
        return false;
    }

    private boolean checkException(URI uri, int attemptCounter) throws CoreException, FileNotFoundException, AuthenticationFailedException, JREHttpClientRequiredException {
        if (this.exception != null) {
            RepositoryStatusHelper.checkJREHttpClientRequired(this.exception);
            RepositoryStatusHelper.checkPermissionDenied(this.exception);
            RepositoryStatusHelper.checkFileNotFound(this.exception, uri);
            Throwable t = RepositoryStatusHelper.unwind(this.exception);
            if (t instanceof CoreException) {
                throw RepositoryStatusHelper.unwindCoreException((CoreException)t);
            }
            if (!this.retryOnSocketTimeout && t instanceof SocketTimeoutException) {
                throw RepositoryStatusHelper.wrap(t);
            }
            if (t instanceof IOException && attemptCounter < this.connectionRetryCount) {
                this.exception = null;
                try {
                    LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.transport.ecf", NLS.bind((String)Messages.connection_to_0_failed_on_1_retry_attempt_2, (Object[])new String[]{uri.toString(), t.getMessage(), String.valueOf(attemptCounter)}), t));
                    Thread.sleep(this.connectionRetryDelay);
                    return false;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            throw RepositoryStatusHelper.wrap(this.exception);
        }
        return true;
    }

    protected Exception getException() {
        return this.exception;
    }

    public static void hardClose(Object aStream) {
        if (aStream != null) {
            try {
                if (aStream instanceof OutputStream) {
                    ((OutputStream)aStream).close();
                } else if (aStream instanceof InputStream) {
                    ((InputStream)aStream).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void onDone(IIncomingFileTransfer source) {
        if (testProbe != null) {
            testProbe.onDone(this, source, this.theMonitor);
        }
    }

    private void onStart(IIncomingFileTransfer source) {
        if (testProbe != null) {
            testProbe.onStart(this, source, this.theMonitor);
        }
    }

    private void onData(IIncomingFileTransfer source) {
        if (testProbe != null) {
            testProbe.onData(this, source, this.theMonitor);
        }
    }

    public static void setTestProbe(IFileReaderProbe probe) {
        testProbe = probe;
    }

    private synchronized void setStatistics(ProgressStatistics statistics) {
        this.statistics = statistics;
    }

    private synchronized ProgressStatistics getStatistics() {
        return this.statistics;
    }

    protected class CancelHandler
    extends Job {
        protected CancelHandler() {
            super(Messages.FileTransport_cancelCheck);
            this.setSystem(true);
        }

        public IStatus run(IProgressMonitor jobMonitor) {
            while (FileReader.this.cancelJob == this && !jobMonitor.isCanceled()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    return Status.CANCEL_STATUS;
                }
                if (FileReader.this.theMonitor == null || !FileReader.this.theMonitor.isCanceled() || FileReader.this.connectEvent == null) continue;
                FileReader.this.connectEvent.cancel();
            }
            return Status.OK_STATUS;
        }

        protected void canceling() {
            Thread t = this.getThread();
            if (t != null) {
                t.interrupt();
            }
        }
    }

    private static class DownloadRange
    implements IFileRangeSpecification {
        private final long startPosition;

        public DownloadRange(long startPos) {
            this.startPosition = startPos;
        }

        public long getEndPosition() {
            return -1L;
        }

        public long getStartPosition() {
            return this.startPosition;
        }
    }

    public static interface IFileReaderProbe {
        public void onStart(FileReader var1, IIncomingFileTransfer var2, IProgressMonitor var3);

        public void onData(FileReader var1, IIncomingFileTransfer var2, IProgressMonitor var3);

        public void onDone(FileReader var1, IIncomingFileTransfer var2, IProgressMonitor var3);
    }

    static class SuppressBlockedMonitor
    extends ProgressMonitorWrapper {
        public SuppressBlockedMonitor(IProgressMonitor monitor, int ticks) {
            super(monitor.slice(ticks));
        }

        public void setBlocked(IStatus reason) {
        }

        public void clearBlocked() {
        }
    }
}

