/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class StreamMonitor
implements Runnable {
    private BufferedReader input;
    private boolean printStreamContents;
    private String waitString;
    private boolean waitStringSeen;
    private List triggers = new LinkedList();
    private List triggersSeen = new LinkedList();
    private String prefixString;
    private boolean printContents;
    private StringBuffer captureBuffer;

    public StreamMonitor(InputStream istr) {
        this(istr, null, false);
    }

    public StreamMonitor(InputStream istr, String prefixString, boolean printContents) {
        this.input = new BufferedReader(new InputStreamReader(istr));
        this.prefixString = prefixString;
        this.printContents = printContents;
        Thread thr = new Thread(this);
        thr.setDaemon(true);
        thr.start();
    }

    public boolean addTrigger(String str, int value) {
        return this.addTrigger(new String[]{str}, value);
    }

    public boolean addTrigger(String[] strs, int value) {
        for (Trigger trigger : this.triggers) {
            if (!trigger.equals(strs)) continue;
            return false;
        }
        Trigger trigger = new Trigger(strs, value);
        return this.triggers.add(trigger);
    }

    public boolean removeTrigger(String str) {
        return this.removeTrigger(new String[]{str});
    }

    public boolean removeTrigger(String[] strs) {
        ListIterator iter = this.triggers.listIterator();
        while (iter.hasNext()) {
            Trigger trigger = (Trigger)iter.next();
            if (!trigger.equals(strs)) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    public synchronized List getTriggersSeen() {
        List tmpList = this.triggersSeen;
        this.triggersSeen = new LinkedList();
        return tmpList;
    }

    public synchronized boolean waitFor(String str, long millis) {
        this.waitString = str;
        this.waitStringSeen = false;
        try {
            this.wait(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.waitString = null;
        return this.waitStringSeen;
    }

    public synchronized void startCapture() {
        this.captureBuffer = new StringBuffer();
    }

    public synchronized String stopCapture() {
        String ret = this.captureBuffer.toString();
        this.captureBuffer = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        byte[] buf = new byte[10240];
        boolean shouldContinue = true;
        try {
            do {
                String str;
                if ((str = this.input.readLine()) == null) {
                    shouldContinue = false;
                    continue;
                }
                if (this.printContents) {
                    System.err.println(this.prefixString + ": " + str);
                }
                StreamMonitor streamMonitor = this;
                synchronized (streamMonitor) {
                    if (this.captureBuffer != null) {
                        this.captureBuffer.append(str);
                        this.captureBuffer.append("\n");
                    }
                    if (this.waitString != null && str.indexOf(this.waitString) != -1) {
                        this.waitStringSeen = true;
                        this.notifyAll();
                    }
                    for (Trigger trigger : this.triggers) {
                        if (!trigger.matches(str)) continue;
                        this.triggersSeen.add(new Integer(trigger.triggerVal));
                    }
                }
            } while (shouldContinue);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.err.print("StreamMonitor ");
        if (this.prefixString != null) {
            System.err.print("\"" + this.prefixString + "\" ");
        }
        System.err.println("exiting");
    }

    class Trigger {
        private String[] triggerStrings;
        private int triggerVal;

        Trigger(String str, int val) {
            this.triggerStrings = new String[]{str};
            this.triggerVal = val;
        }

        Trigger(String[] strs, int val) {
            this.triggerStrings = strs;
            this.triggerVal = val;
        }

        boolean matches(String str) {
            for (int i = 0; i < this.triggerStrings.length; ++i) {
                if (str.indexOf(this.triggerStrings[i]) != -1) continue;
                return false;
            }
            return true;
        }

        boolean equals(String[] strs) {
            if (strs.length != this.triggerStrings.length) {
                return false;
            }
            for (int i = 0; i < strs.length; ++i) {
                if (strs[i].equals(this.triggerStrings[i])) continue;
                return false;
            }
            return true;
        }
    }
}

