/**
 * Copyright (c) 2017, 2020 Kichwa Coders Ltd. and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j.debug;

import org.eclipse.lsp4j.debug.util.ToStringBuilder;

/**
 * Response to 'writeMemory' request.
 * <p>
 * Since 1.48
 */
@SuppressWarnings("all")
public class WriteMemoryResponse {
  /**
   * Property that should be returned when 'allowPartial' is true to
   * indicate the offset of the first byte of data successfully written. Can
   * be negative.
   * <p>
   * This is an optional property.
   */
  private Integer offset;

  /**
   * Property that should be returned when 'allowPartial' is true to
   * indicate the number of bytes starting from address that were successfully
   * written.
   * <p>
   * This is an optional property.
   */
  private Integer bytesWritten;

  /**
   * Property that should be returned when 'allowPartial' is true to
   * indicate the offset of the first byte of data successfully written. Can
   * be negative.
   * <p>
   * This is an optional property.
   */
  public Integer getOffset() {
    return this.offset;
  }

  /**
   * Property that should be returned when 'allowPartial' is true to
   * indicate the offset of the first byte of data successfully written. Can
   * be negative.
   * <p>
   * This is an optional property.
   */
  public void setOffset(final Integer offset) {
    this.offset = offset;
  }

  /**
   * Property that should be returned when 'allowPartial' is true to
   * indicate the number of bytes starting from address that were successfully
   * written.
   * <p>
   * This is an optional property.
   */
  public Integer getBytesWritten() {
    return this.bytesWritten;
  }

  /**
   * Property that should be returned when 'allowPartial' is true to
   * indicate the number of bytes starting from address that were successfully
   * written.
   * <p>
   * This is an optional property.
   */
  public void setBytesWritten(final Integer bytesWritten) {
    this.bytesWritten = bytesWritten;
  }

  @Override
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("offset", this.offset);
    b.add("bytesWritten", this.bytesWritten);
    return b.toString();
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    WriteMemoryResponse other = (WriteMemoryResponse) obj;
    if (this.offset == null) {
      if (other.offset != null)
        return false;
    } else if (!this.offset.equals(other.offset))
      return false;
    if (this.bytesWritten == null) {
      if (other.bytesWritten != null)
        return false;
    } else if (!this.bytesWritten.equals(other.bytesWritten))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.offset== null) ? 0 : this.offset.hashCode());
    return prime * result + ((this.bytesWritten== null) ? 0 : this.bytesWritten.hashCode());
  }
}
