/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.rules.RuleMatch;

public class RemoteRuleResult {
    private final boolean remote;
    private final boolean success;
    private final List<RuleMatch> matches;
    private final Set<AnalyzedSentence> processedSentences;
    private final Map<AnalyzedSentence, List<RuleMatch>> sentenceMatches = new HashMap<AnalyzedSentence, List<RuleMatch>>();

    public RemoteRuleResult(boolean remote, boolean success, List<RuleMatch> matches, List<AnalyzedSentence> processedSentences) {
        this.remote = remote;
        this.success = success;
        this.matches = matches;
        this.processedSentences = Collections.unmodifiableSet(new HashSet<AnalyzedSentence>(processedSentences));
        for (RuleMatch match : matches) {
            this.sentenceMatches.compute(match.getSentence(), (sentence, ruleMatches) -> {
                if (ruleMatches == null) {
                    return new ArrayList<RuleMatch>(Collections.singletonList(match));
                }
                ruleMatches.add(match);
                return ruleMatches;
            });
        }
    }

    public boolean isRemote() {
        return this.remote;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public List<RuleMatch> getMatches() {
        return this.matches;
    }

    public Set<AnalyzedSentence> matchedSentences() {
        return this.sentenceMatches.keySet();
    }

    public Set<AnalyzedSentence> processedSentences() {
        return this.processedSentences;
    }

    @Nullable
    public List<RuleMatch> matchesForSentence(AnalyzedSentence sentence) {
        List defaultValue = this.processedSentences.contains(sentence) ? Collections.emptyList() : null;
        return this.sentenceMatches.getOrDefault(sentence, defaultValue);
    }
}

