// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Contains information about a citation that references a specific source document. Citations provide traceability between the model's generated response and the source documents that informed that response.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct Citation {
    /// <p>The title or identifier of the source document being cited.</p>
    pub title: ::std::option::Option<::std::string::String>,
    /// <p>The specific content from the source document that was referenced or cited in the generated response.</p>
    pub source_content: ::std::option::Option<::std::vec::Vec<crate::types::CitationSourceContent>>,
    /// <p>The precise location within the source document where the cited content can be found, including character positions, page numbers, or chunk identifiers.</p>
    pub location: ::std::option::Option<crate::types::CitationLocation>,
}
impl Citation {
    /// <p>The title or identifier of the source document being cited.</p>
    pub fn title(&self) -> ::std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p>The specific content from the source document that was referenced or cited in the generated response.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.source_content.is_none()`.
    pub fn source_content(&self) -> &[crate::types::CitationSourceContent] {
        self.source_content.as_deref().unwrap_or_default()
    }
    /// <p>The precise location within the source document where the cited content can be found, including character positions, page numbers, or chunk identifiers.</p>
    pub fn location(&self) -> ::std::option::Option<&crate::types::CitationLocation> {
        self.location.as_ref()
    }
}
impl Citation {
    /// Creates a new builder-style object to manufacture [`Citation`](crate::types::Citation).
    pub fn builder() -> crate::types::builders::CitationBuilder {
        crate::types::builders::CitationBuilder::default()
    }
}

/// A builder for [`Citation`](crate::types::Citation).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct CitationBuilder {
    pub(crate) title: ::std::option::Option<::std::string::String>,
    pub(crate) source_content: ::std::option::Option<::std::vec::Vec<crate::types::CitationSourceContent>>,
    pub(crate) location: ::std::option::Option<crate::types::CitationLocation>,
}
impl CitationBuilder {
    /// <p>The title or identifier of the source document being cited.</p>
    pub fn title(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.title = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The title or identifier of the source document being cited.</p>
    pub fn set_title(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.title = input;
        self
    }
    /// <p>The title or identifier of the source document being cited.</p>
    pub fn get_title(&self) -> &::std::option::Option<::std::string::String> {
        &self.title
    }
    /// Appends an item to `source_content`.
    ///
    /// To override the contents of this collection use [`set_source_content`](Self::set_source_content).
    ///
    /// <p>The specific content from the source document that was referenced or cited in the generated response.</p>
    pub fn source_content(mut self, input: crate::types::CitationSourceContent) -> Self {
        let mut v = self.source_content.unwrap_or_default();
        v.push(input);
        self.source_content = ::std::option::Option::Some(v);
        self
    }
    /// <p>The specific content from the source document that was referenced or cited in the generated response.</p>
    pub fn set_source_content(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::CitationSourceContent>>) -> Self {
        self.source_content = input;
        self
    }
    /// <p>The specific content from the source document that was referenced or cited in the generated response.</p>
    pub fn get_source_content(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::CitationSourceContent>> {
        &self.source_content
    }
    /// <p>The precise location within the source document where the cited content can be found, including character positions, page numbers, or chunk identifiers.</p>
    pub fn location(mut self, input: crate::types::CitationLocation) -> Self {
        self.location = ::std::option::Option::Some(input);
        self
    }
    /// <p>The precise location within the source document where the cited content can be found, including character positions, page numbers, or chunk identifiers.</p>
    pub fn set_location(mut self, input: ::std::option::Option<crate::types::CitationLocation>) -> Self {
        self.location = input;
        self
    }
    /// <p>The precise location within the source document where the cited content can be found, including character positions, page numbers, or chunk identifiers.</p>
    pub fn get_location(&self) -> &::std::option::Option<crate::types::CitationLocation> {
        &self.location
    }
    /// Consumes the builder and constructs a [`Citation`](crate::types::Citation).
    pub fn build(self) -> crate::types::Citation {
        crate::types::Citation {
            title: self.title,
            source_content: self.source_content,
            location: self.location,
        }
    }
}
