// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by aliasgen. DO NOT EDIT.

// Package kms aliases all exported identifiers in package
// "cloud.google.com/go/kms/apiv1/kmspb".
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb.
// Please read https://github.com/googleapis/google-cloud-go/blob/main/migration.md
// for more details.
package kms

import (
	src "cloud.google.com/go/kms/apiv1/kmspb"
	grpc "google.golang.org/grpc"
)

// Deprecated: Please use consts in: cloud.google.com/go/kms/apiv1/kmspb
const (
	CryptoKeyVersion_CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED = src.CryptoKeyVersion_CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED
	CryptoKeyVersion_CRYPTO_KEY_VERSION_STATE_UNSPECIFIED     = src.CryptoKeyVersion_CRYPTO_KEY_VERSION_STATE_UNSPECIFIED
	CryptoKeyVersion_CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED      = src.CryptoKeyVersion_CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED
	CryptoKeyVersion_DESTROYED                                = src.CryptoKeyVersion_DESTROYED
	CryptoKeyVersion_DESTROY_SCHEDULED                        = src.CryptoKeyVersion_DESTROY_SCHEDULED
	CryptoKeyVersion_DISABLED                                 = src.CryptoKeyVersion_DISABLED
	CryptoKeyVersion_EC_SIGN_P256_SHA256                      = src.CryptoKeyVersion_EC_SIGN_P256_SHA256
	CryptoKeyVersion_EC_SIGN_P384_SHA384                      = src.CryptoKeyVersion_EC_SIGN_P384_SHA384
	CryptoKeyVersion_EC_SIGN_SECP256K1_SHA256                 = src.CryptoKeyVersion_EC_SIGN_SECP256K1_SHA256
	CryptoKeyVersion_ENABLED                                  = src.CryptoKeyVersion_ENABLED
	CryptoKeyVersion_EXTERNAL_SYMMETRIC_ENCRYPTION            = src.CryptoKeyVersion_EXTERNAL_SYMMETRIC_ENCRYPTION
	CryptoKeyVersion_FULL                                     = src.CryptoKeyVersion_FULL
	CryptoKeyVersion_GOOGLE_SYMMETRIC_ENCRYPTION              = src.CryptoKeyVersion_GOOGLE_SYMMETRIC_ENCRYPTION
	CryptoKeyVersion_HMAC_SHA256                              = src.CryptoKeyVersion_HMAC_SHA256
	CryptoKeyVersion_IMPORT_FAILED                            = src.CryptoKeyVersion_IMPORT_FAILED
	CryptoKeyVersion_PENDING_GENERATION                       = src.CryptoKeyVersion_PENDING_GENERATION
	CryptoKeyVersion_PENDING_IMPORT                           = src.CryptoKeyVersion_PENDING_IMPORT
	CryptoKeyVersion_RSA_DECRYPT_OAEP_2048_SHA1               = src.CryptoKeyVersion_RSA_DECRYPT_OAEP_2048_SHA1
	CryptoKeyVersion_RSA_DECRYPT_OAEP_2048_SHA256             = src.CryptoKeyVersion_RSA_DECRYPT_OAEP_2048_SHA256
	CryptoKeyVersion_RSA_DECRYPT_OAEP_3072_SHA1               = src.CryptoKeyVersion_RSA_DECRYPT_OAEP_3072_SHA1
	CryptoKeyVersion_RSA_DECRYPT_OAEP_3072_SHA256             = src.CryptoKeyVersion_RSA_DECRYPT_OAEP_3072_SHA256
	CryptoKeyVersion_RSA_DECRYPT_OAEP_4096_SHA1               = src.CryptoKeyVersion_RSA_DECRYPT_OAEP_4096_SHA1
	CryptoKeyVersion_RSA_DECRYPT_OAEP_4096_SHA256             = src.CryptoKeyVersion_RSA_DECRYPT_OAEP_4096_SHA256
	CryptoKeyVersion_RSA_DECRYPT_OAEP_4096_SHA512             = src.CryptoKeyVersion_RSA_DECRYPT_OAEP_4096_SHA512
	CryptoKeyVersion_RSA_SIGN_PKCS1_2048_SHA256               = src.CryptoKeyVersion_RSA_SIGN_PKCS1_2048_SHA256
	CryptoKeyVersion_RSA_SIGN_PKCS1_3072_SHA256               = src.CryptoKeyVersion_RSA_SIGN_PKCS1_3072_SHA256
	CryptoKeyVersion_RSA_SIGN_PKCS1_4096_SHA256               = src.CryptoKeyVersion_RSA_SIGN_PKCS1_4096_SHA256
	CryptoKeyVersion_RSA_SIGN_PKCS1_4096_SHA512               = src.CryptoKeyVersion_RSA_SIGN_PKCS1_4096_SHA512
	CryptoKeyVersion_RSA_SIGN_PSS_2048_SHA256                 = src.CryptoKeyVersion_RSA_SIGN_PSS_2048_SHA256
	CryptoKeyVersion_RSA_SIGN_PSS_3072_SHA256                 = src.CryptoKeyVersion_RSA_SIGN_PSS_3072_SHA256
	CryptoKeyVersion_RSA_SIGN_PSS_4096_SHA256                 = src.CryptoKeyVersion_RSA_SIGN_PSS_4096_SHA256
	CryptoKeyVersion_RSA_SIGN_PSS_4096_SHA512                 = src.CryptoKeyVersion_RSA_SIGN_PSS_4096_SHA512
	CryptoKeyVersion_RSA_SIGN_RAW_PKCS1_2048                  = src.CryptoKeyVersion_RSA_SIGN_RAW_PKCS1_2048
	CryptoKeyVersion_RSA_SIGN_RAW_PKCS1_3072                  = src.CryptoKeyVersion_RSA_SIGN_RAW_PKCS1_3072
	CryptoKeyVersion_RSA_SIGN_RAW_PKCS1_4096                  = src.CryptoKeyVersion_RSA_SIGN_RAW_PKCS1_4096
	CryptoKey_ASYMMETRIC_DECRYPT                              = src.CryptoKey_ASYMMETRIC_DECRYPT
	CryptoKey_ASYMMETRIC_SIGN                                 = src.CryptoKey_ASYMMETRIC_SIGN
	CryptoKey_CRYPTO_KEY_PURPOSE_UNSPECIFIED                  = src.CryptoKey_CRYPTO_KEY_PURPOSE_UNSPECIFIED
	CryptoKey_ENCRYPT_DECRYPT                                 = src.CryptoKey_ENCRYPT_DECRYPT
	CryptoKey_MAC                                             = src.CryptoKey_MAC
	ImportJob_ACTIVE                                          = src.ImportJob_ACTIVE
	ImportJob_EXPIRED                                         = src.ImportJob_EXPIRED
	ImportJob_IMPORT_JOB_STATE_UNSPECIFIED                    = src.ImportJob_IMPORT_JOB_STATE_UNSPECIFIED
	ImportJob_IMPORT_METHOD_UNSPECIFIED                       = src.ImportJob_IMPORT_METHOD_UNSPECIFIED
	ImportJob_PENDING_GENERATION                              = src.ImportJob_PENDING_GENERATION
	ImportJob_RSA_OAEP_3072_SHA1_AES_256                      = src.ImportJob_RSA_OAEP_3072_SHA1_AES_256
	ImportJob_RSA_OAEP_4096_SHA1_AES_256                      = src.ImportJob_RSA_OAEP_4096_SHA1_AES_256
	KeyOperationAttestation_ATTESTATION_FORMAT_UNSPECIFIED    = src.KeyOperationAttestation_ATTESTATION_FORMAT_UNSPECIFIED
	KeyOperationAttestation_CAVIUM_V1_COMPRESSED              = src.KeyOperationAttestation_CAVIUM_V1_COMPRESSED
	KeyOperationAttestation_CAVIUM_V2_COMPRESSED              = src.KeyOperationAttestation_CAVIUM_V2_COMPRESSED
	ProtectionLevel_EXTERNAL                                  = src.ProtectionLevel_EXTERNAL
	ProtectionLevel_EXTERNAL_VPC                              = src.ProtectionLevel_EXTERNAL_VPC
	ProtectionLevel_HSM                                       = src.ProtectionLevel_HSM
	ProtectionLevel_PROTECTION_LEVEL_UNSPECIFIED              = src.ProtectionLevel_PROTECTION_LEVEL_UNSPECIFIED
	ProtectionLevel_SOFTWARE                                  = src.ProtectionLevel_SOFTWARE
)

// Deprecated: Please use vars in: cloud.google.com/go/kms/apiv1/kmspb
var (
	CryptoKeyVersion_CryptoKeyVersionAlgorithm_name  = src.CryptoKeyVersion_CryptoKeyVersionAlgorithm_name
	CryptoKeyVersion_CryptoKeyVersionAlgorithm_value = src.CryptoKeyVersion_CryptoKeyVersionAlgorithm_value
	CryptoKeyVersion_CryptoKeyVersionState_name      = src.CryptoKeyVersion_CryptoKeyVersionState_name
	CryptoKeyVersion_CryptoKeyVersionState_value     = src.CryptoKeyVersion_CryptoKeyVersionState_value
	CryptoKeyVersion_CryptoKeyVersionView_name       = src.CryptoKeyVersion_CryptoKeyVersionView_name
	CryptoKeyVersion_CryptoKeyVersionView_value      = src.CryptoKeyVersion_CryptoKeyVersionView_value
	CryptoKey_CryptoKeyPurpose_name                  = src.CryptoKey_CryptoKeyPurpose_name
	CryptoKey_CryptoKeyPurpose_value                 = src.CryptoKey_CryptoKeyPurpose_value
	File_google_cloud_kms_v1_ekm_service_proto       = src.File_google_cloud_kms_v1_ekm_service_proto
	File_google_cloud_kms_v1_resources_proto         = src.File_google_cloud_kms_v1_resources_proto
	File_google_cloud_kms_v1_service_proto           = src.File_google_cloud_kms_v1_service_proto
	ImportJob_ImportJobState_name                    = src.ImportJob_ImportJobState_name
	ImportJob_ImportJobState_value                   = src.ImportJob_ImportJobState_value
	ImportJob_ImportMethod_name                      = src.ImportJob_ImportMethod_name
	ImportJob_ImportMethod_value                     = src.ImportJob_ImportMethod_value
	KeyOperationAttestation_AttestationFormat_name   = src.KeyOperationAttestation_AttestationFormat_name
	KeyOperationAttestation_AttestationFormat_value  = src.KeyOperationAttestation_AttestationFormat_value
	ProtectionLevel_name                             = src.ProtectionLevel_name
	ProtectionLevel_value                            = src.ProtectionLevel_value
)

// Request message for
// [KeyManagementService.AsymmetricDecrypt][google.cloud.kms.v1.KeyManagementService.AsymmetricDecrypt].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type AsymmetricDecryptRequest = src.AsymmetricDecryptRequest

// Response message for
// [KeyManagementService.AsymmetricDecrypt][google.cloud.kms.v1.KeyManagementService.AsymmetricDecrypt].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type AsymmetricDecryptResponse = src.AsymmetricDecryptResponse

// Request message for
// [KeyManagementService.AsymmetricSign][google.cloud.kms.v1.KeyManagementService.AsymmetricSign].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type AsymmetricSignRequest = src.AsymmetricSignRequest

// Response message for
// [KeyManagementService.AsymmetricSign][google.cloud.kms.v1.KeyManagementService.AsymmetricSign].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type AsymmetricSignResponse = src.AsymmetricSignResponse

// A [Certificate][google.cloud.kms.v1.Certificate] represents an X.509
// certificate used to authenticate HTTPS connections to EKM replicas.
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type Certificate = src.Certificate

// Request message for
// [KeyManagementService.CreateCryptoKey][google.cloud.kms.v1.KeyManagementService.CreateCryptoKey].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type CreateCryptoKeyRequest = src.CreateCryptoKeyRequest

// Request message for
// [KeyManagementService.CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type CreateCryptoKeyVersionRequest = src.CreateCryptoKeyVersionRequest

// Request message for [KeyManagementService.CreateEkmConnection][].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type CreateEkmConnectionRequest = src.CreateEkmConnectionRequest

// Request message for
// [KeyManagementService.CreateImportJob][google.cloud.kms.v1.KeyManagementService.CreateImportJob].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type CreateImportJobRequest = src.CreateImportJobRequest

// Request message for
// [KeyManagementService.CreateKeyRing][google.cloud.kms.v1.KeyManagementService.CreateKeyRing].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type CreateKeyRingRequest = src.CreateKeyRingRequest

// A [CryptoKey][google.cloud.kms.v1.CryptoKey] represents a logical key that
// can be used for cryptographic operations. A
// [CryptoKey][google.cloud.kms.v1.CryptoKey] is made up of zero or more
// [versions][google.cloud.kms.v1.CryptoKeyVersion], which represent the actual
// key material used in cryptographic operations.
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type CryptoKey = src.CryptoKey

// A [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] represents an
// individual cryptographic key, and the associated key material. An
// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED]
// version can be used for cryptographic operations. For security reasons, the
// raw cryptographic key material represented by a
// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] can never be viewed
// or exported. It can only be used to encrypt, decrypt, or sign data when an
// authorized user or application invokes Cloud KMS.
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type CryptoKeyVersion = src.CryptoKeyVersion

// A [CryptoKeyVersionTemplate][google.cloud.kms.v1.CryptoKeyVersionTemplate]
// specifies the properties to use when creating a new
// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion], either manually
// with
// [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
// or automatically as a result of auto-rotation.
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type CryptoKeyVersionTemplate = src.CryptoKeyVersionTemplate

// The algorithm of the
// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion], indicating what
// parameters must be used for each cryptographic operation. The
// [GOOGLE_SYMMETRIC_ENCRYPTION][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm.GOOGLE_SYMMETRIC_ENCRYPTION]
// algorithm is usable with
// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
// [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
// Algorithms beginning with "RSA_SIGN_" are usable with
// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
// [ASYMMETRIC_SIGN][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_SIGN].
// The fields in the name after "RSA_SIGN_" correspond to the following
// parameters: padding algorithm, modulus bit length, and digest algorithm. For
// PSS, the salt length used is equal to the length of digest algorithm. For
// example,
// [RSA_SIGN_PSS_2048_SHA256][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm.RSA_SIGN_PSS_2048_SHA256]
// will use PSS with a salt length of 256 bits or 32 bytes. Algorithms
// beginning with "RSA_DECRYPT_" are usable with
// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
// [ASYMMETRIC_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_DECRYPT].
// The fields in the name after "RSA_DECRYPT_" correspond to the following
// parameters: padding algorithm, modulus bit length, and digest algorithm.
// Algorithms beginning with "EC_SIGN_" are usable with
// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
// [ASYMMETRIC_SIGN][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_SIGN].
// The fields in the name after "EC_SIGN_" correspond to the following
// parameters: elliptic curve, digest algorithm. Algorithms beginning with
// "HMAC_" are usable with
// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
// [MAC][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.MAC]. The suffix
// following "HMAC_" corresponds to the hash algorithm being used (eg. SHA256).
// For more information, see [Key purposes and algorithms]
// (https://cloud.google.com/kms/docs/algorithms).
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type CryptoKeyVersion_CryptoKeyVersionAlgorithm = src.CryptoKeyVersion_CryptoKeyVersionAlgorithm

// The state of a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion],
// indicating if it can be used.
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type CryptoKeyVersion_CryptoKeyVersionState = src.CryptoKeyVersion_CryptoKeyVersionState

// A view for [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]s.
// Controls the level of detail returned for
// [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] in
// [KeyManagementService.ListCryptoKeyVersions][google.cloud.kms.v1.KeyManagementService.ListCryptoKeyVersions]
// and
// [KeyManagementService.ListCryptoKeys][google.cloud.kms.v1.KeyManagementService.ListCryptoKeys].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type CryptoKeyVersion_CryptoKeyVersionView = src.CryptoKeyVersion_CryptoKeyVersionView

// [CryptoKeyPurpose][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose]
// describes the cryptographic capabilities of a
// [CryptoKey][google.cloud.kms.v1.CryptoKey]. A given key can only be used for
// the operations allowed by its purpose. For more information, see [Key
// purposes](https://cloud.google.com/kms/docs/algorithms#key_purposes).
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type CryptoKey_CryptoKeyPurpose = src.CryptoKey_CryptoKeyPurpose
type CryptoKey_RotationPeriod = src.CryptoKey_RotationPeriod

// Request message for
// [KeyManagementService.Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type DecryptRequest = src.DecryptRequest

// Response message for
// [KeyManagementService.Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type DecryptResponse = src.DecryptResponse

// Request message for
// [KeyManagementService.DestroyCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.DestroyCryptoKeyVersion].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type DestroyCryptoKeyVersionRequest = src.DestroyCryptoKeyVersionRequest

// A [Digest][google.cloud.kms.v1.Digest] holds a cryptographic message
// digest.
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type Digest = src.Digest
type Digest_Sha256 = src.Digest_Sha256
type Digest_Sha384 = src.Digest_Sha384
type Digest_Sha512 = src.Digest_Sha512

// An [EkmConnection][google.cloud.kms.v1.EkmConnection] represents an
// individual EKM connection. It can be used for creating
// [CryptoKeys][google.cloud.kms.v1.CryptoKey] and
// [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] with a
// [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of
// [EXTERNAL_VPC][CryptoKeyVersion.ProtectionLevel.EXTERNAL_VPC], as well as
// performing cryptographic operations using keys created within the
// [EkmConnection][google.cloud.kms.v1.EkmConnection].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type EkmConnection = src.EkmConnection

// A [ServiceResolver][google.cloud.kms.v1.EkmConnection.ServiceResolver]
// represents an EKM replica that can be reached within an
// [EkmConnection][google.cloud.kms.v1.EkmConnection].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type EkmConnection_ServiceResolver = src.EkmConnection_ServiceResolver

// EkmServiceClient is the client API for EkmService service. For semantics
// around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type EkmServiceClient = src.EkmServiceClient

// EkmServiceServer is the server API for EkmService service.
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type EkmServiceServer = src.EkmServiceServer

// Request message for
// [KeyManagementService.Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type EncryptRequest = src.EncryptRequest

// Response message for
// [KeyManagementService.Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type EncryptResponse = src.EncryptResponse

// ExternalProtectionLevelOptions stores a group of additional fields for
// configuring a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that
// are specific to the [EXTERNAL][google.cloud.kms.v1.ProtectionLevel.EXTERNAL]
// protection level and
// [EXTERNAL_VPC][google.cloud.kms.v1.ProtectionLevel.EXTERNAL_VPC] protection
// levels.
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type ExternalProtectionLevelOptions = src.ExternalProtectionLevelOptions

// Request message for
// [KeyManagementService.GenerateRandomBytes][google.cloud.kms.v1.KeyManagementService.GenerateRandomBytes].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type GenerateRandomBytesRequest = src.GenerateRandomBytesRequest

// Response message for
// [KeyManagementService.GenerateRandomBytes][google.cloud.kms.v1.KeyManagementService.GenerateRandomBytes].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type GenerateRandomBytesResponse = src.GenerateRandomBytesResponse

// Request message for
// [KeyManagementService.GetCryptoKey][google.cloud.kms.v1.KeyManagementService.GetCryptoKey].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type GetCryptoKeyRequest = src.GetCryptoKeyRequest

// Request message for
// [KeyManagementService.GetCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.GetCryptoKeyVersion].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type GetCryptoKeyVersionRequest = src.GetCryptoKeyVersionRequest

// Request message for [KeyManagementService.GetEkmConnection][].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type GetEkmConnectionRequest = src.GetEkmConnectionRequest

// Request message for
// [KeyManagementService.GetImportJob][google.cloud.kms.v1.KeyManagementService.GetImportJob].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type GetImportJobRequest = src.GetImportJobRequest

// Request message for
// [KeyManagementService.GetKeyRing][google.cloud.kms.v1.KeyManagementService.GetKeyRing].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type GetKeyRingRequest = src.GetKeyRingRequest

// Request message for
// [KeyManagementService.GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type GetPublicKeyRequest = src.GetPublicKeyRequest

// Request message for
// [KeyManagementService.ImportCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.ImportCryptoKeyVersion].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type ImportCryptoKeyVersionRequest = src.ImportCryptoKeyVersionRequest
type ImportCryptoKeyVersionRequest_RsaAesWrappedKey = src.ImportCryptoKeyVersionRequest_RsaAesWrappedKey

// An [ImportJob][google.cloud.kms.v1.ImportJob] can be used to create
// [CryptoKeys][google.cloud.kms.v1.CryptoKey] and
// [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] using pre-existing
// key material, generated outside of Cloud KMS. When an
// [ImportJob][google.cloud.kms.v1.ImportJob] is created, Cloud KMS will
// generate a "wrapping key", which is a public/private key pair. You use the
// wrapping key to encrypt (also known as wrap) the pre-existing key material
// to protect it during the import process. The nature of the wrapping key
// depends on the choice of
// [import_method][google.cloud.kms.v1.ImportJob.import_method]. When the
// wrapping key generation is complete, the
// [state][google.cloud.kms.v1.ImportJob.state] will be set to
// [ACTIVE][google.cloud.kms.v1.ImportJob.ImportJobState.ACTIVE] and the
// [public_key][google.cloud.kms.v1.ImportJob.public_key] can be fetched. The
// fetched public key can then be used to wrap your pre-existing key material.
// Once the key material is wrapped, it can be imported into a new
// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in an existing
// [CryptoKey][google.cloud.kms.v1.CryptoKey] by calling
// [ImportCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.ImportCryptoKeyVersion].
// Multiple [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] can be
// imported with a single [ImportJob][google.cloud.kms.v1.ImportJob]. Cloud KMS
// uses the private key portion of the wrapping key to unwrap the key material.
// Only Cloud KMS has access to the private key. An
// [ImportJob][google.cloud.kms.v1.ImportJob] expires 3 days after it is
// created. Once expired, Cloud KMS will no longer be able to import or unwrap
// any key material that was wrapped with the
// [ImportJob][google.cloud.kms.v1.ImportJob]'s public key. For more
// information, see [Importing a
// key](https://cloud.google.com/kms/docs/importing-a-key).
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type ImportJob = src.ImportJob

// The state of the [ImportJob][google.cloud.kms.v1.ImportJob], indicating if
// it can be used.
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type ImportJob_ImportJobState = src.ImportJob_ImportJobState

// [ImportMethod][google.cloud.kms.v1.ImportJob.ImportMethod] describes the
// key wrapping method chosen for this
// [ImportJob][google.cloud.kms.v1.ImportJob].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type ImportJob_ImportMethod = src.ImportJob_ImportMethod

// The public key component of the wrapping key. For details of the type of
// key this public key corresponds to, see the
// [ImportMethod][google.cloud.kms.v1.ImportJob.ImportMethod].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type ImportJob_WrappingPublicKey = src.ImportJob_WrappingPublicKey

// KeyManagementServiceClient is the client API for KeyManagementService
// service. For semantics around ctx use and closing/ending streaming RPCs,
// please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type KeyManagementServiceClient = src.KeyManagementServiceClient

// KeyManagementServiceServer is the server API for KeyManagementService
// service.
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type KeyManagementServiceServer = src.KeyManagementServiceServer

// Contains an HSM-generated attestation about a key operation. For more
// information, see [Verifying attestations]
// (https://cloud.google.com/kms/docs/attest-key).
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type KeyOperationAttestation = src.KeyOperationAttestation

// Attestation formats provided by the HSM.
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type KeyOperationAttestation_AttestationFormat = src.KeyOperationAttestation_AttestationFormat

// Certificate chains needed to verify the attestation. Certificates in chains
// are PEM-encoded and are ordered based on
// https://tools.ietf.org/html/rfc5246#section-7.4.2.
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type KeyOperationAttestation_CertificateChains = src.KeyOperationAttestation_CertificateChains

// A [KeyRing][google.cloud.kms.v1.KeyRing] is a toplevel logical grouping of
// [CryptoKeys][google.cloud.kms.v1.CryptoKey].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type KeyRing = src.KeyRing

// Request message for
// [KeyManagementService.ListCryptoKeyVersions][google.cloud.kms.v1.KeyManagementService.ListCryptoKeyVersions].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type ListCryptoKeyVersionsRequest = src.ListCryptoKeyVersionsRequest

// Response message for
// [KeyManagementService.ListCryptoKeyVersions][google.cloud.kms.v1.KeyManagementService.ListCryptoKeyVersions].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type ListCryptoKeyVersionsResponse = src.ListCryptoKeyVersionsResponse

// Request message for
// [KeyManagementService.ListCryptoKeys][google.cloud.kms.v1.KeyManagementService.ListCryptoKeys].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type ListCryptoKeysRequest = src.ListCryptoKeysRequest

// Response message for
// [KeyManagementService.ListCryptoKeys][google.cloud.kms.v1.KeyManagementService.ListCryptoKeys].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type ListCryptoKeysResponse = src.ListCryptoKeysResponse

// Request message for [KeyManagementService.ListEkmConnections][].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type ListEkmConnectionsRequest = src.ListEkmConnectionsRequest

// Response message for [KeyManagementService.ListEkmConnections][].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type ListEkmConnectionsResponse = src.ListEkmConnectionsResponse

// Request message for
// [KeyManagementService.ListImportJobs][google.cloud.kms.v1.KeyManagementService.ListImportJobs].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type ListImportJobsRequest = src.ListImportJobsRequest

// Response message for
// [KeyManagementService.ListImportJobs][google.cloud.kms.v1.KeyManagementService.ListImportJobs].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type ListImportJobsResponse = src.ListImportJobsResponse

// Request message for
// [KeyManagementService.ListKeyRings][google.cloud.kms.v1.KeyManagementService.ListKeyRings].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type ListKeyRingsRequest = src.ListKeyRingsRequest

// Response message for
// [KeyManagementService.ListKeyRings][google.cloud.kms.v1.KeyManagementService.ListKeyRings].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type ListKeyRingsResponse = src.ListKeyRingsResponse

// Cloud KMS metadata for the given
// [google.cloud.location.Location][google.cloud.location.Location].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type LocationMetadata = src.LocationMetadata

// Request message for
// [KeyManagementService.MacSign][google.cloud.kms.v1.KeyManagementService.MacSign].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type MacSignRequest = src.MacSignRequest

// Response message for
// [KeyManagementService.MacSign][google.cloud.kms.v1.KeyManagementService.MacSign].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type MacSignResponse = src.MacSignResponse

// Request message for
// [KeyManagementService.MacVerify][google.cloud.kms.v1.KeyManagementService.MacVerify].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type MacVerifyRequest = src.MacVerifyRequest

// Response message for
// [KeyManagementService.MacVerify][google.cloud.kms.v1.KeyManagementService.MacVerify].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type MacVerifyResponse = src.MacVerifyResponse

// [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] specifies how
// cryptographic operations are performed. For more information, see
// [Protection levels]
// (https://cloud.google.com/kms/docs/algorithms#protection_levels).
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type ProtectionLevel = src.ProtectionLevel

// The public key for a given
// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. Obtained via
// [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type PublicKey = src.PublicKey

// Request message for
// [KeyManagementService.RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type RestoreCryptoKeyVersionRequest = src.RestoreCryptoKeyVersionRequest

// UnimplementedEkmServiceServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type UnimplementedEkmServiceServer = src.UnimplementedEkmServiceServer

// UnimplementedKeyManagementServiceServer can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type UnimplementedKeyManagementServiceServer = src.UnimplementedKeyManagementServiceServer

// Request message for
// [KeyManagementService.UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type UpdateCryptoKeyPrimaryVersionRequest = src.UpdateCryptoKeyPrimaryVersionRequest

// Request message for
// [KeyManagementService.UpdateCryptoKey][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKey].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type UpdateCryptoKeyRequest = src.UpdateCryptoKeyRequest

// Request message for
// [KeyManagementService.UpdateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyVersion].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type UpdateCryptoKeyVersionRequest = src.UpdateCryptoKeyVersionRequest

// Request message for [KeyManagementService.UpdateEkmConnection][].
//
// Deprecated: Please use types in: cloud.google.com/go/kms/apiv1/kmspb
type UpdateEkmConnectionRequest = src.UpdateEkmConnectionRequest

// Deprecated: Please use funcs in: cloud.google.com/go/kms/apiv1/kmspb
func NewEkmServiceClient(cc grpc.ClientConnInterface) EkmServiceClient {
	return src.NewEkmServiceClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/kms/apiv1/kmspb
func NewKeyManagementServiceClient(cc grpc.ClientConnInterface) KeyManagementServiceClient {
	return src.NewKeyManagementServiceClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/kms/apiv1/kmspb
func RegisterEkmServiceServer(s *grpc.Server, srv EkmServiceServer) {
	src.RegisterEkmServiceServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/kms/apiv1/kmspb
func RegisterKeyManagementServiceServer(s *grpc.Server, srv KeyManagementServiceServer) {
	src.RegisterKeyManagementServiceServer(s, srv)
}
