/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.ko;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ko extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Falkland = new String[] {
               "\ud3ec\ud074\ub79c\ub4dc \ud45c\uc900\uc2dc",
               "FIST",
               "\ud3ec\ud074\ub79c\ub4dc \ud558\uacc4 \ud45c\uc900\uc2dc",
               "FIST",
               "\ud3ec\ud074\ub79c\ub4dc \uc2dc\uac04",
               "FIT",
            };
        final String[] Iran = new String[] {
               "\uc774\ub780 \ud45c\uc900\uc2dc",
               "IST",
               "\uc774\ub780 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "IDT",
               "\uc774\ub780 \uc2dc\uac04",
               "IT",
            };
        final String[] Cape_Verde = new String[] {
               "\uce74\ubcf4 \ubca0\ub974\ub370 \ud45c\uc900\uc2dc",
               "CVST",
               "\uce74\ubcf4 \ubca0\ub974\ub370 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "CVST",
               "\uce74\ubcf4 \ubca0\ub974\ub370 \uc2dc\uac04",
               "CVT",
            };
        final String[] GMT = new String[] {
               "\uadf8\ub9ac\ub2c8\uce58 \ud45c\uc900\uc2dc",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Omsk = new String[] {
               "\uc634\uc2a4\ud06c \ud45c\uc900\uc2dc",
               "OST",
               "\uc634\uc2a4\ud06c \ud558\uacc4 \ud45c\uc900\uc2dc",
               "OST",
               "\uc634\uc2a4\ud06c \uc2dc\uac04",
               "OT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "\ud558\uc640\uc774 \uc54c\ub958\uc0e8 \ud45c\uc900\uc2dc",
               "HAST",
               "\ud558\uc640\uc774 \uc54c\ub958\uc0e8 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "HADT",
               "\ud558\uc640\uc774 \uc54c\ub958\uc0e8 \uc2dc\uac04",
               "HAT",
            };
        final String[] Myanmar = new String[] {
               "\ubbf8\uc580\ub9c8 \ud45c\uc900\uc2dc",
               "MT",
               "Myanmar Summer Time",
               "MST",
               "Myanmar Time",
               "MT",
            };
        final String[] Sakhalin = new String[] {
               "\uc0ac\ud560\ub9b0 \ud45c\uc900\uc2dc",
               "SST",
               "\uc0ac\ud560\ub9b0 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "SST",
               "\uc0ac\ud560\ub9b0 \uc2dc\uac04",
               "ST",
            };
        final String[] Yakutsk = new String[] {
               "\uc57c\ucfe0\uce20\ud06c \ud45c\uc900\uc2dc",
               "YST",
               "\uc57c\ucfe0\uce20\ud06c \ud558\uacc4 \ud45c\uc900\uc2dc",
               "YST",
               "\uc57c\ucfe0\uce20\ud06c \uc2dc\uac04",
               "YT",
            };
        final String[] Paraguay = new String[] {
               "\ud30c\ub77c\uacfc\uc774 \ud45c\uc900\uc2dc",
               "PST",
               "\ud30c\ub77c\uacfc\uc774 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "PST",
               "\ud30c\ub77c\uacfc\uc774 \uc2dc\uac04",
               "PT",
            };
        final String[] Nepal = new String[] {
               "\ub124\ud314 \ud45c\uc900\uc2dc",
               "NT",
               "Nepal Summer Time",
               "NST",
               "Nepal Time",
               "NT",
            };
        final String[] Maldives = new String[] {
               "\ubab0\ub514\ube0c \ud45c\uc900\uc2dc",
               "MT",
               "Maldives Summer Time",
               "MST",
               "Maldives Time",
               "MT",
            };
        final String[] Turkmenistan = new String[] {
               "\ud22c\ub974\ud06c\uba54\ub2c8\uc2a4\ud0c4 \ud45c\uc900\uc2dc",
               "TST",
               "\ud22c\ub974\ud06c\uba54\ub2c8\uc2a4\ud0c4 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "TST",
               "\ud22c\ub974\ud06c\uba54\ub2c8\uc2a4\ud0c4 \uc2dc\uac04",
               "TT",
            };
        final String[] Japan = new String[] {
               "\uc77c\ubcf8 \ud45c\uc900\uc2dc",
               "JST",
               "\uc77c\ubcf8 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "JDT",
               "\uc77c\ubcf8 \uc2dc\uac04",
               "JT",
            };
        final String[] Vladivostok = new String[] {
               "\ube14\ub77c\ub514\ubcf4\uc2a4\ud1a0\ud06c \ud45c\uc900\uc2dc",
               "VST",
               "\ube14\ub77c\ub514\ubcf4\uc2a4\ud1a0\ud06c \ud558\uacc4 \ud45c\uc900\uc2dc",
               "VST",
               "\ube14\ub77c\ub514\ubcf4\uc2a4\ud1a0\ud06c \uc2dc\uac04",
               "VT",
            };
        final String[] Europe_Western = new String[] {
               "\uc11c\ubd80 \uc720\ub7fd \ud45c\uc900\uc2dc",
               "WEST",
               "\uc11c\ubd80 \uc720\ub7fd \ud558\uacc4 \ud45c\uc900\uc2dc",
               "WEST",
               "\uc11c\ubd80 \uc720\ub7fd \uc2dc\uac04",
               "WET",
            };
        final String[] Bangladesh = new String[] {
               "\ubc29\uae00\ub77c\ub370\uc2dc \ud45c\uc900\uc2dc",
               "BST",
               "\ubc29\uae00\ub77c\ub370\uc2dc \ud558\uacc4 \ud45c\uc900\uc2dc",
               "BST",
               "\ubc29\uae00\ub77c\ub370\uc2dc \uc2dc\uac04",
               "BT",
            };
        final String[] Greenland_Western = new String[] {
               "\uadf8\ub9b0\ub780\ub4dc \uc11c\ubd80 \ud45c\uc900\uc2dc",
               "WGST",
               "\uadf8\ub9b0\ub780\ub4dc \uc11c\ubd80 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "WGST",
               "\uadf8\ub9b0\ub780\ub4dc \uc11c\ubd80 \uc2dc\uac04",
               "WGT",
            };
        final String[] Colombia = new String[] {
               "\ucf5c\ub86c\ube44\uc544 \ud45c\uc900\uc2dc",
               "CST",
               "\ucf5c\ub86c\ube44\uc544 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "CST",
               "\ucf5c\ub86c\ube44\uc544 \uc2dc\uac04",
               "CT",
            };
        final String[] Suriname = new String[] {
               "\uc218\ub9ac\ub0a8 \ud45c\uc900\uc2dc",
               "ST",
               "Suriname Summer Time",
               "SST",
               "Suriname Time",
               "ST",
            };
        final String[] Singapore = new String[] {
               "\uc2f1\uac00\ud3ec\ub974 \ud45c\uc900\uc2dc",
               "SST",
               "Singapore Daylight Time",
               "SDT",
               "Singapore Time",
               "ST",
            };
        final String[] Hovd = new String[] {
               "\ud638\ube0c\ub4dc \ud45c\uc900\uc2dc",
               "HST",
               "\ud638\ube0c\ub4dc \ud558\uacc4 \ud45c\uc900\uc2dc",
               "HST",
               "\ud638\ube0c\ub4dc \uc2dc\uac04",
               "HT",
            };
        final String[] Amazon = new String[] {
               "\uc544\ub9c8\uc874 \ud45c\uc900\uc2dc",
               "AST",
               "\uc544\ub9c8\uc874 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "AST",
               "\uc544\ub9c8\uc874 \uc2dc\uac04",
               "AT",
            };
        final String[] Pakistan = new String[] {
               "\ud30c\ud0a4\uc2a4\ud0c4 \ud45c\uc900\uc2dc",
               "PST",
               "\ud30c\ud0a4\uc2a4\ud0c4 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "PST",
               "\ud30c\ud0a4\uc2a4\ud0c4 \uc2dc\uac04",
               "PT",
            };
        final String[] Mongolia = new String[] {
               "\uc6b8\ub780\ubc14\ud1a0\ub974 \ud45c\uc900\uc2dc",
               "UBST",
               "\uc6b8\ub780\ubc14\ud1a0\ub974 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "UBST",
               "\uc6b8\ub780\ubc14\ud1a0\ub974 \uc2dc\uac04",
               "UBT",
            };
        final String[] America_Pacific = new String[] {
               "\ubbf8 \ud0dc\ud3c9\uc591 \ud45c\uc900\uc2dc",
               "PST",
               "\ubbf8 \ud0dc\ud3c9\uc591 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "PDT",
               "\ubbf8 \ud0dc\ud3c9\uc591 \uc2dc\uac04",
               "PT",
            };
        final String[] Argentina_Western = new String[] {
               "\uc544\ub974\ud5e8\ud2f0\ub098 \uc11c\ubd80 \ud45c\uc900\uc2dc",
               "WAST",
               "\uc544\ub974\ud5e8\ud2f0\ub098 \uc11c\ubd80 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "WAST",
               "\uc544\ub974\ud5e8\ud2f0\ub098 \uc11c\ubd80 \uc2dc\uac04",
               "WAT",
            };
        final String[] Galapagos = new String[] {
               "\uac08\ub77c\ud30c\uace0\uc2a4 \ud45c\uc900\uc2dc",
               "GT",
               "Galapagos Summer Time",
               "GST",
               "Galapagos Time",
               "GT",
            };
        final String[] French_Guiana = new String[] {
               "\ud504\ub791\uc2a4\ub839 \uae30\uc544\ub098 \ud45c\uc900\uc2dc",
               "FGT",
               "French Guiana Summer Time",
               "FGST",
               "French Guiana Time",
               "FGT",
            };
        final String[] Greenland_Eastern = new String[] {
               "\uadf8\ub9b0\ub780\ub4dc \ub3d9\ubd80 \ud45c\uc900\uc2dc",
               "EGST",
               "\uadf8\ub9b0\ub780\ub4dc \ub3d9\ubd80 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "EGST",
               "\uadf8\ub9b0\ub780\ub4dc \ub3d9\ubd80 \uc2dc\uac04",
               "EGT",
            };
        final String[] Christmas = new String[] {
               "\ud06c\ub9ac\uc2a4\ub9c8\uc2a4\uc12c \ud45c\uc900\uc2dc",
               "CIT",
               "Christmas Island Summer Time",
               "CIST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Volgograd = new String[] {
               "\ubcfc\uace0\uadf8\ub77c\ub4dc \ud45c\uc900\uc2dc",
               "VST",
               "\ubcfc\uace0\uadf8\ub77c\ub4dc \ud558\uacc4 \ud45c\uc900\uc2dc",
               "VST",
               "\ubcfc\uace0\uadf8\ub77c\ub4dc \uc2dc\uac04",
               "VT",
            };
        final String[] Korea = new String[] {
               "\ud55c\uad6d \ud45c\uc900\uc2dc",
               "KST",
               "\ud55c\uad6d \ud558\uacc4 \ud45c\uc900\uc2dc",
               "KDT",
               "\ud55c\uad6d \uc2dc\uac04",
               "KT",
            };
        final String[] Argentina = new String[] {
               "\uc544\ub974\ud5e8\ud2f0\ub098 \ud45c\uc900\uc2dc",
               "AST",
               "\uc544\ub974\ud5e8\ud2f0\ub098 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "AST",
               "\uc544\ub974\ud5e8\ud2f0\ub098 \uc2dc\uac04",
               "AT",
            };
        final String[] Lord_Howe = new String[] {
               "\ub85c\ub4dc \ud558\uc6b0 \ud45c\uc900\uc2dc",
               "LHST",
               "\ub85c\ub4dc \ud558\uc6b0 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "LHDT",
               "\ub85c\ub4dc \ud558\uc6b0 \uc2dc\uac04",
               "LHT",
            };
        final String[] Syowa = new String[] {
               "\uc1fc\uc640 \ud45c\uc900\uc2dc",
               "ST",
               "Syowa Summer Time",
               "SST",
               "Syowa Time",
               "ST",
            };
        final String[] Kyrgystan = new String[] {
               "\ud0a4\ub974\uae30\uc2a4\uc2a4\ud0c4 \ud45c\uc900\uc2dc",
               "KT",
               "Kyrgystan Summer Time",
               "KST",
               "Kyrgystan Time",
               "KT",
            };
        final String[] Arabian = new String[] {
               "\uc544\ub77c\ube44\uc544 \ud45c\uc900\uc2dc",
               "AST",
               "\uc544\ub77c\ube44\uc544 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "ADT",
               "\uc544\ub77c\ube44\uc544 \uc2dc\uac04",
               "AT",
            };
        final String[] Australia_Eastern = new String[] {
               "\uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544 \ub3d9\ubd80 \ud45c\uc900\uc2dc",
               "AEST",
               "\uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544 \ub3d9\ubd80 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "AEDT",
               "\ub3d9\ubd80 \uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544 \uc2dc\uac04",
               "EAT",
            };
        final String[] Irkutsk = new String[] {
               "\uc774\ub974\ucfe0\uce20\ud06c \ud45c\uc900\uc2dc",
               "IST",
               "\uc774\ub974\ucfe0\uce20\ud06c \ud558\uacc4 \ud45c\uc900\uc2dc",
               "IST",
               "\uc774\ub974\ucfe0\uce20\ud06c \uc2dc\uac04",
               "IT",
            };
        final String[] Mauritius = new String[] {
               "\ubaa8\ub9ac\uc154\uc2a4 \ud45c\uc900\uc2dc",
               "MST",
               "\ubaa8\ub9ac\uc154\uc2a4 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "MST",
               "\ubaa8\ub9ac\uc154\uc2a4 \uc2dc\uac04",
               "MT",
            };
        final String[] Indian_Ocean = new String[] {
               "\uc601\uad6d\ub839 \uc778\ub3c4\uc591 \uc2dd\ubbfc\uc9c0 \ud45c\uc900\uc2dc",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Choibalsan = new String[] {
               "\ucd08\uc774\ubc1c\uc0b0 \ud45c\uc900\uc2dc",
               "CST",
               "\ucd08\uc774\ubc1c\uc0b0 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "CST",
               "\ucd08\uc774\ubc1c\uc0b0 \uc2dc\uac04",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "\ubbf8 \ub3d9\ubd80 \ud45c\uc900\uc2dc",
               "EST",
               "\ubbf8 \ub3d9\ubd80 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "EDT",
               "\ubbf8 \ub3d9\ubd80 \uc2dc\uac04",
               "ET",
            };
        final String[] Australia_Western = new String[] {
               "\uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544 \uc11c\ubd80 \ud45c\uc900\uc2dc",
               "AWST",
               "\uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544 \uc11c\ubd80 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "AWDT",
               "\uc11c\ubd80 \uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544 \uc2dc\uac04",
               "WAT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544 \uc911\uc11c\ubd80 \ud45c\uc900\uc2dc",
               "ACWST",
               "\uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544 \uc911\uc11c\ubd80 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "ACWDT",
               "\uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544 \uc911\uc11c\ubd80 \uc2dc\uac04",
               "ACWT",
            };
        final String[] Krasnoyarsk = new String[] {
               "\ud06c\ub77c\uc2a4\ub178\uc57c\ub974\uc2a4\ud06c \ud45c\uc900\uc2dc",
               "KST",
               "\ud06c\ub77c\uc2a4\ub178\uc57c\ub974\uc2a4\ud06c \ud558\uacc4 \ud45c\uc900\uc2dc",
               "KST",
               "\ud06c\ub77c\uc2a4\ub178\uc57c\ub974\uc2a4\ud06c \uc2dc\uac04",
               "KT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\uc778\ub3c4\ub124\uc2dc\uc544 \ub3d9\ubd80 \uc2dc\uac04",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Venezuela = new String[] {
               "\ubca0\ub124\uc8fc\uc5d8\ub77c \ud45c\uc900\uc2dc",
               "VT",
               "Venezuela Summer Time",
               "VST",
               "Venezuela Time",
               "VT",
            };
        final String[] Bhutan = new String[] {
               "\ubd80\ud0c4 \ud45c\uc900\uc2dc",
               "BT",
               "Bhutan Summer Time",
               "BST",
               "Bhutan Time",
               "BT",
            };
        final String[] Noronha = new String[] {
               "\ud398\ub974\ub09c\ub3c4 \ub370 \ub178\ub85c\ub0d0 \ud45c\uc900\uc2dc",
               "FNST",
               "\ud398\ub974\ub09c\ub3c4 \ub370 \ub178\ub85c\ub0d0 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "FNST",
               "\ud398\ub974\ub09c\ub3c4 \ub370 \ub178\ub85c\ub0d0 \uc2dc\uac04",
               "FNT",
            };
        final String[] Malaysia = new String[] {
               "\ub9d0\ub808\uc774\uc2dc\uc544 \ud45c\uc900\uc2dc",
               "MT",
               "Malaysia Summer Time",
               "MST",
               "Malaysia Time",
               "MT",
            };
        final String[] Novosibirsk = new String[] {
               "\ub178\ubcf4\uc2dc\ube44\ub974\uc2a4\ud06c \ud45c\uc900\uc2dc",
               "NST",
               "\ub178\ubcf4\uc2dc\ube44\ub974\uc2a4\ud06c \ud558\uacc4 \ud45c\uc900\uc2dc",
               "NST",
               "\ub178\ubcf4\uc2dc\ube44\ub974\uc2a4\ud06c \uc2dc\uac04",
               "NT",
            };
        final String[] America_Mountain = new String[] {
               "\ubbf8 \uc0b0\uc545 \ud45c\uc900\uc2dc",
               "MST",
               "\ubbf8 \uc0b0\uc9c0 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "MDT",
               "\ubbf8 \uc0b0\uc9c0 \uc2dc\uac04",
               "MT",
            };
        final String[] Vostok = new String[] {
               "\ubcf4\uc2a4\ud1a0\ud06c \ud45c\uc900\uc2dc",
               "VT",
               "Vostok Summer Time",
               "VST",
               "Vostok Time",
               "VT",
            };
        final String[] Alaska = new String[] {
               "\uc54c\ub798\uc2a4\uce74 \ud45c\uc900\uc2dc",
               "AKST",
               "\uc54c\ub798\uc2a4\uce74 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "AKDT",
               "\uc54c\ub798\uc2a4\uce74 \uc2dc\uac04",
               "AKT",
            };
        final String[] Armenia = new String[] {
               "\uc544\ub974\uba54\ub2c8\uc544 \ud45c\uc900\uc2dc",
               "AST",
               "\uc544\ub974\uba54\ub2c8\uc544 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "AST",
               "\uc544\ub974\uba54\ub2c8\uc544 \uc2dc\uac04",
               "AT",
            };
        final String[] Australia_Central = new String[] {
               "\uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544 \uc911\ubd80 \ud45c\uc900\uc2dc",
               "ACST",
               "\uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544 \uc911\ubd80 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "ACDT",
               "\uc911\uc559 \uc624\uc2a4\ud2b8\ub808\uc77c\ub9ac\uc544 \uc2dc\uac04",
               "CAT",
            };
        final String[] Azores = new String[] {
               "\uc544\uc870\ub808\uc2a4 \ud45c\uc900\uc2dc",
               "AST",
               "\uc544\uc870\ub808\uc2a4 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "AST",
               "\uc544\uc870\ub808\uc2a4 \uc2dc\uac04",
               "AT",
            };
        final String[] Reunion = new String[] {
               "\ub9ac\uc720\ub2c8\uc628 \ud45c\uc900\uc2dc",
               "RT",
               "Reunion Summer Time",
               "RST",
               "Reunion Time",
               "RT",
            };
        final String[] Indochina = new String[] {
               "\uc778\ub3c4\ucc28\uc774\ub098 \uc2dc\uac04",
               "IT",
               "Indochina Summer Time",
               "IST",
               "Indochina Time",
               "IT",
            };
        final String[] Ecuador = new String[] {
               "\uc5d0\ucf70\ub3c4\ub974 \ud45c\uc900\uc2dc",
               "ET",
               "Ecuador Summer Time",
               "EST",
               "Ecuador Time",
               "ET",
            };
        final String[] Magadan = new String[] {
               "\ub9c8\uac00\ub2e8 \ud45c\uc900\uc2dc",
               "MST",
               "\ub9c8\uac00\ub2e8 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "MST",
               "\ub9c8\uac00\ub2e8 \uc2dc\uac04",
               "MT",
            };
        final String[] Chatham = new String[] {
               "\ucc44\ud140 \ud45c\uc900\uc2dc",
               "CST",
               "\ucc44\ud140 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "CDT",
               "\ucc44\ud140 \uc2dc\uac04",
               "CT",
            };
        final String[] Davis = new String[] {
               "\ub370\uc774\ube44\uc2a4 \ud45c\uc900\uc2dc",
               "DT",
               "Davis Summer Time",
               "DST",
               "Davis Time",
               "DT",
            };
        final String[] Cuba = new String[] {
               "\ucfe0\ubc14 \ud45c\uc900\uc2dc",
               "CST",
               "\ucfe0\ubc14 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "CDT",
               "\ucfe0\ubc14 \uc2dc\uac04",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "\uc11c\uc544\ud504\ub9ac\uce74 \ud45c\uc900\uc2dc",
               "WAST",
               "\uc11c\uc544\ud504\ub9ac\uce74 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "WAST",
               "\uc11c\uc544\ud504\ub9ac\uce74 \uc2dc\uac04",
               "WAT",
            };
        final String[] Moscow = new String[] {
               "\ubaa8\uc2a4\ud06c\ubc14 \ud45c\uc900\uc2dc",
               "MST",
               "\ubaa8\uc2a4\ud06c\ubc14 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "MST",
               "\ubaa8\uc2a4\ud06c\ubc14 \uc2dc\uac04",
               "MT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\ub3d9\ubd80 \uce74\uc790\ud750\uc2a4\ud0c4 \uc2dc\uac04",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] New_Zealand = new String[] {
               "\ub274\uc9c8\ub79c\ub4dc \ud45c\uc900\uc2dc",
               "NZST",
               "\ub274\uc9c8\ub79c\ub4dc \ud558\uacc4 \ud45c\uc900\uc2dc",
               "NZDT",
               "\ub274\uc9c8\ub79c\ub4dc \uc2dc\uac04",
               "NZT",
            };
        final String[] Hong_Kong = new String[] {
               "\ud64d\ucf69 \ud45c\uc900\uc2dc",
               "HKST",
               "\ud64d\ucf69 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "HKST",
               "\ud64d\ucf69 \uc2dc\uac04",
               "HKT",
            };
        final String[] Brasilia = new String[] {
               "\ube0c\ub77c\uc9c8\ub9ac\uc544 \ud45c\uc900\uc2dc",
               "BST",
               "\ube0c\ub77c\uc9c8\ub9ac\uc544 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "BST",
               "\ube0c\ub77c\uc9c8\ub9ac\uc544 \uc2dc\uac04",
               "BT",
            };
        final String[] Taipei = new String[] {
               "\ud0c0\uc774\ubca0\uc774 \ud45c\uc900\uc2dc",
               "TST",
               "\ud0c0\uc774\ubca0\uc774 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "TDT",
               "\ud0c0\uc774\ubca0\uc774 \uc2dc\uac04",
               "TT",
            };
        final String[] Cocos = new String[] {
               "\ucf54\ucf54\uc2a4\uc12c \ud45c\uc900\uc2dc",
               "CIT",
               "Cocos Islands Summer Time",
               "CIST",
               "Cocos Islands Time",
               "CIT",
            };
        final String[] Indonesia_Western = new String[] {
               "\uc778\ub3c4\ub124\uc2dc\uc544 \uc11c\ubd80 \uc2dc\uac04",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Brunei = new String[] {
               "\ube0c\ub8e8\ub098\uc774 \ub2e4\ub8e8\uc0b4\ub78c \ud45c\uc900\uc2dc",
               "BDT",
               "Brunei Darussalam Summer Time",
               "BDST",
               "Brunei Darussalam Time",
               "BDT",
            };
        final String[] Seychelles = new String[] {
               "\uc138\uc774\uc178 \ud45c\uc900\uc2dc",
               "ST",
               "Seychelles Summer Time",
               "SST",
               "Seychelles Time",
               "ST",
            };
        final String[] Africa_Central = new String[] {
               "\uc911\uc559\uc544\ud504\ub9ac\uce74 \uc2dc\uac04",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Easter = new String[] {
               "\uc774\uc2a4\ud130\uc12c \ud45c\uc900\uc2dc",
               "EIST",
               "\uc774\uc2a4\ud130\uc12c \ud558\uacc4 \ud45c\uc900\uc2dc",
               "EIST",
               "\uc774\uc2a4\ud130\uc12c \uc2dc\uac04",
               "EIT",
            };
        final String[] South_Georgia = new String[] {
               "\uc0ac\uc6b0\uc2a4 \uc870\uc9c0\uc544 \ud45c\uc900\uc2dc",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] Indonesia_Central = new String[] {
               "\uc778\ub3c4\ub124\uc2dc\uc544 \uc911\ubd80 \uc2dc\uac04",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Philippines = new String[] {
               "\ud544\ub9ac\ud540 \ud45c\uc900\uc2dc",
               "PST",
               "\ud544\ub9ac\ud540 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "PST",
               "\ud544\ub9ac\ud540 \uc2dc\uac04",
               "PT",
            };
        final String[] Georgia = new String[] {
               "\uadf8\ub8e8\uc9c0\uc544 \ud45c\uc900\uc2dc",
               "GST",
               "\uadf8\ub8e8\uc9c0\uc544 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "GST",
               "\uadf8\ub8e8\uc9c0\uc544 \uc2dc\uac04",
               "GT",
            };
        final String[] Bolivia = new String[] {
               "\ubcfc\ub9ac\ube44\uc544 \ud45c\uc900\uc2dc",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Peru = new String[] {
               "\ud398\ub8e8 \ud45c\uc900\uc2dc",
               "PST",
               "\ud398\ub8e8 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "PST",
               "\ud398\ub8e8 \uc2dc\uac04",
               "PT",
            };
        final String[] Chamorro = new String[] {
               "\ucc28\ubaa8\ub85c \uc2dc\uac04",
               "CST",
               "Chamorro Daylight Time",
               "CDT",
               "Chamorro Time",
               "CT",
            };
        final String[] Newfoundland = new String[] {
               "\ub274\ud380\ub4e4\ub79c\ub4dc \ud45c\uc900\uc2dc",
               "NST",
               "\ub274\ud380\ub4e4\ub79c\ub4dc \ud558\uacc4 \ud45c\uc900\uc2dc",
               "NDT",
               "\ub274\ud380\ub4e4\ub79c\ub4dc \uc2dc\uac04",
               "NT",
            };
        final String[] Cook = new String[] {
               "\ucfe1\uc81c\ub3c4 \ud45c\uc900\uc2dc",
               "CIST",
               "\ucfe1\uc81c\ub3c4 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "CIHST",
               "\ucfe1\uc81c\ub3c4 \uc2dc\uac04",
               "CIT",
            };
        final String[] America_Central = new String[] {
               "\ubbf8 \uc911\ubd80 \ud45c\uc900\uc2dc",
               "CST",
               "\ubbf8 \uc911\ubd80 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "CDT",
               "\ubbf8 \uc911\ubd80 \uc2dc\uac04",
               "CT",
            };
        final String[] Africa_Eastern = new String[] {
               "\ub3d9\uc544\ud504\ub9ac\uce74 \uc2dc\uac04",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Azerbaijan = new String[] {
               "\uc544\uc81c\ub974\ubc14\uc774\uc794 \ud45c\uc900\uc2dc",
               "AST",
               "\uc544\uc81c\ub974\ubc14\uc774\uc794 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "AST",
               "\uc544\uc81c\ub974\ubc14\uc774\uc794 \uc2dc\uac04",
               "AT",
            };
        final String[] Yekaterinburg = new String[] {
               "\uc608\uce74\ud14c\ub9b0\ubd80\ub974\ud06c \ud45c\uc900\uc2dc",
               "YST",
               "\uc608\uce74\ud14c\ub9b0\ubd80\ub974\ud06c \ud558\uacc4 \ud45c\uc900\uc2dc",
               "YST",
               "\uc608\uce74\ud14c\ub9b0\ubd80\ub974\ud06c \uc2dc\uac04",
               "YT",
            };
        final String[] China = new String[] {
               "\uc911\uad6d \ud45c\uc900\uc2dc",
               "CST",
               "\uc911\uad6d \ud558\uacc4 \ud45c\uc900\uc2dc",
               "CDT",
               "\uc911\uad6d \uc2dc\uac04",
               "CT",
            };
        final String[] Africa_Southern = new String[] {
               "\ub0a8\uc544\ud504\ub9ac\uce74 \uc2dc\uac04",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Macquarie = new String[] {
               "\ub9e5\ucffc\ub9ac \ud45c\uc900\uc2dc",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] French_Southern = new String[] {
               "\ud504\ub791\uc2a4\ub839 \ub0a8\ucabd\uc2dd\ubbfc\uc9c0 \ud45c\uc900\uc2dc",
               "FSAT",
               "French Southern and Antarctic Summer Time",
               "FSAST",
               "French Southern and Antarctic Time",
               "FSAT",
            };
        final String[] Chile = new String[] {
               "\uce60\ub808 \ud45c\uc900\uc2dc",
               "CST",
               "\uce60\ub808 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "CST",
               "\uce60\ub808 \uc2dc\uac04",
               "CT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\uc11c\ubd80 \uce74\uc790\ud750\uc2a4\ud0c4 \uc2dc\uac04",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Israel = new String[] {
               "\uc774\uc2a4\ub77c\uc5d8 \ud45c\uc900\uc2dc",
               "IST",
               "\uc774\uc2a4\ub77c\uc5d8 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "IDT",
               "\uc774\uc2a4\ub77c\uc5d8 \uc2dc\uac04",
               "IT",
            };
        final String[] Tajikistan = new String[] {
               "\ud0c0\uc9c0\ud0a4\uc2a4\ud0c4 \ud45c\uc900\uc2dc",
               "TT",
               "Tajikistan Summer Time",
               "TST",
               "Tajikistan Time",
               "TT",
            };
        final String[] Mawson = new String[] {
               "\ubaa8\uc2a8 \ud45c\uc900\uc2dc",
               "MT",
               "Mawson Summer Time",
               "MST",
               "Mawson Time",
               "MT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "\ud53c\uc5d0\ub974 \ubbf8\ud074\ub871 \ud45c\uc900\uc2dc",
               "PMST",
               "\ud53c\uc5d0\ub974 \ubbf8\ud074\ub871 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "PMDT",
               "\ud53c\uc5d0\ub974 \ubbf8\ud074\ub871 \uc2dc\uac04",
               "PMT",
            };
        final String[] Fiji = new String[] {
               "\ud53c\uc9c0 \ud45c\uc900\uc2dc",
               "FST",
               "\ud53c\uc9c0 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "FST",
               "\ud53c\uc9c0 \uc2dc\uac04",
               "FT",
            };
        final String[] Rothera = new String[] {
               "\ub85c\ub370\ub77c \ud45c\uc900\uc2dc",
               "RT",
               "Rothera Summer Time",
               "RST",
               "Rothera Time",
               "RT",
            };
        final String[] Europe_Central = new String[] {
               "\uc911\ubd80\uc720\ub7fd \ud45c\uc900\uc2dc",
               "CEST",
               "\uc911\ubd80\uc720\ub7fd \ud558\uacc4 \ud45c\uc900\uc2dc",
               "CEST",
               "\uc911\ubd80\uc720\ub7fd \uc2dc\uac04",
               "CET",
            };
        final String[] India = new String[] {
               "\uc778\ub3c4 \ud45c\uc900\uc2dc",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] DumontDUrville = new String[] {
               "\ub4a4\ubabd \ub4a4\ub974\ube4c \ud45c\uc900\uc2dc",
               "DT",
               "Dumont-d\u2019Urville Summer Time",
               "DST",
               "Dumont-d\u2019Urville Time",
               "DT",
            };
        final String[] Uzbekistan = new String[] {
               "\uc6b0\uc988\ubca0\ud0a4\uc2a4\ud0c4 \ud45c\uc900\uc2dc",
               "UST",
               "\uc6b0\uc988\ubca0\ud0a4\uc2a4\ud0c4 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "UST",
               "\uc6b0\uc988\ubca0\ud0a4\uc2a4\ud0c4 \uc2dc\uac04",
               "UT",
            };
        final String[] Europe_Eastern = new String[] {
               "\ub3d9\ubd80\uc720\ub7fd \ud45c\uc900\uc2dc",
               "EEST",
               "\ub3d9\ubd80\uc720\ub7fd \ud558\uacc4 \ud45c\uc900\uc2dc",
               "EEST",
               "\ub3d9\ubd80\uc720\ub7fd \uc2dc\uac04",
               "EET",
            };
        final String[] Atlantic = new String[] {
               "\ub300\uc11c\uc591 \ud45c\uc900\uc2dc",
               "AST",
               "\ubbf8 \ub300\uc11c\uc591 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "ADT",
               "\ub300\uc11c\uc591 \uc2dc\uac04",
               "AT",
            };
        final String[] Uruguay = new String[] {
               "\uc6b0\ub8e8\uacfc\uc774 \ud45c\uc900\uc2dc",
               "UST",
               "\uc6b0\ub8e8\uacfc\uc774 \ud558\uacc4 \ud45c\uc900\uc2dc",
               "UST",
               "\uc6b0\ub8e8\uacfc\uc774 \uc2dc\uac04",
               "UT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Douala", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Dawson", America_Pacific },
            { "Asia/Yerevan", Armenia },
            { "Asia/Bangkok", Indochina },
            { "America/Bogota", Colombia },
            { "Asia/Colombo", India },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Blantyre", Africa_Central },
            { "Europe/Volgograd", Volgograd },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Africa/Malabo", Africa_Western },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Katmandu", Nepal },
            { "America/Resolute", America_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Anguilla", Atlantic },
            { "America/Regina", America_Central },
            { "Asia/Amman", Europe_Eastern },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Simferopol", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/North_Dakota/Center", America_Central },
            { "Indian/Kerguelen", French_Southern },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Bahia_Banderas", America_Central },
            { "Pacific/Rarotonga", Cook },
            { "Asia/Hebron", Europe_Eastern },
            { "Australia/Broken_Hill", Australia_Central },
            { "PST8PDT", America_Pacific },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Stockholm", Europe_Central },
            { "Africa/Bamako", GMT },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Curacao", Atlantic },
            { "Europe/Budapest", Europe_Central },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Guam", Chamorro },
            { "Africa/Maseru", Africa_Southern },
            { "America/Asuncion", Paraguay },
            { "America/Indiana/Winamac", America_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vientiane", Indochina },
            { "Africa/Niamey", Africa_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "Asia/Brunei", Brunei },
            { "Africa/Djibouti", Africa_Eastern },
            { "Asia/Tbilisi", Georgia },
            { "America/Merida", America_Central },
            { "America/Recife", Brasilia },
            { "Indian/Reunion", Reunion },
            { "Asia/Oral", Kazakhstan_Western },
            { "Africa/Lusaka", Africa_Central },
            { "America/Tortola", Atlantic },
            { "Africa/Ouagadougou", GMT },
            { "Asia/Kuching", Malaysia },
            { "America/Tegucigalpa", America_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "Europe/Vilnius", Europe_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "America/Moncton", Atlantic },
            { "America/Maceio", Brasilia },
            { "Africa/Dakar", GMT },
            { "America/Belize", America_Central },
            { "America/Cuiaba", Amazon },
            { "Asia/Tashkent", Uzbekistan },
            { "Atlantic/Canary", Europe_Western },
            { "America/Rankin_Inlet", America_Central },
            { "Antarctica/Rothera", Rothera },
            { "Indian/Cocos", Cocos },
            { "America/Glace_Bay", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "America/Cambridge_Bay", America_Mountain },
            { "Indian/Mauritius", Mauritius },
            { "Australia/Brisbane", Australia_Eastern },
            { "America/Grenada", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Antarctica/Vostok", Vostok },
            { "Pacific/Auckland", New_Zealand },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Africa/Nairobi", Africa_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "Pacific/Chatham", Chatham },
            { "America/Caracas", Venezuela },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Maputo", Africa_Central },
            { "America/Metlakatla", America_Pacific },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Asia/Baghdad", Arabian },
            { "Pacific/Saipan", Chamorro },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Singapore", Singapore },
            { "Africa/Cairo", Europe_Eastern },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "America/Inuvik", America_Mountain },
            { "Africa/Bissau", GMT },
            { "Asia/Taipei", Taipei },
            { "Indian/Comoro", Africa_Eastern },
            { "America/Manaus", Amazon },
            { "America/Indiana/Vevay", America_Eastern },
            { "Australia/Hobart", Australia_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Australia/Sydney", Australia_Eastern },
            { "Indian/Chagos", Indian_Ocean },
            { "Europe/Luxembourg", Europe_Central },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Phnom_Penh", Indochina },
            { "Australia/Currie", Australia_Eastern },
            { "America/Cancun", America_Central },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Seoul", Korea },
            { "Antarctica/McMurdo", New_Zealand },
            { "Atlantic/Stanley", Falkland },
            { "America/Lima", Peru },
            { "Europe/Rome", Europe_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Asia/Anadyr", Magadan },
            { "Europe/Helsinki", Europe_Eastern },
            { "America/Matamoros", America_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Coral_Harbour", America_Eastern },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Cordoba", Argentina },
            { "America/Detroit", America_Eastern },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Campo_Grande", Amazon },
            { "America/Hermosillo", America_Mountain },
            { "America/Boise", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "America/St_Kitts", Atlantic },
            { "Europe/Guernsey", GMT },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Tehran", Iran },
            { "America/Santa_Isabel", America_Pacific },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Mazatlan", America_Mountain },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Iqaluit", America_Eastern },
            { "Africa/Algiers", Europe_Central },
            { "America/Araguaina", Brasilia },
            { "America/St_Lucia", Atlantic },
            { "Asia/Yakutsk", Yakutsk },
            { "Indian/Mahe", Seychelles },
            { "America/Panama", America_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Europe/Gibraltar", Europe_Central },
            { "America/Aruba", Atlantic },
            { "Africa/Freetown", GMT },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Paramaribo", Suriname },
            { "Australia/Lindeman", Australia_Eastern },
            { "Asia/Hovd", Hovd },
            { "America/Bahia", Brasilia },
            { "America/Ciudad_Juarez", America_Mountain },
            { "Australia/Perth", Australia_Western },
            { "America/Edmonton", America_Mountain },
            { "Antarctica/Syowa", Syowa },
            { "America/Creston", America_Mountain },
            { "Africa/Nouakchott", GMT },
            { "America/Noronha", Noronha },
            { "America/La_Paz", Bolivia },
            { "America/Dominica", Atlantic },
            { "Asia/Saigon", Indochina },
            { "Antarctica/Macquarie", Macquarie },
            { "MST7MDT", America_Mountain },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Luanda", Africa_Western },
            { "Europe/Andorra", Europe_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "America/Argentina/Salta", Argentina },
            { "America/Kralendijk", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "America/Guadeloupe", Atlantic },
            { "Africa/Bangui", Africa_Western },
            { "Asia/Kamchatka", Magadan },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "America/Eirunepe", Amazon },
            { "Africa/Lubumbashi", Africa_Central },
            { "Antarctica/Palmer", Chile },
            { "Pacific/Galapagos", Galapagos },
            { "America/Monterrey", America_Central },
            { "Europe/London", GMT },
            { "Europe/Samara", Moscow },
            { "Europe/Monaco", Europe_Central },
            { "Atlantic/Bermuda", Atlantic },
            { "Indian/Christmas", Christmas },
            { "America/Yakutat", Alaska },
            { "America/St_Vincent", Atlantic },
            { "Europe/Vienna", Europe_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Asia/Qatar", Arabian },
            { "Africa/Gaborone", Africa_Central },
            { "America/Antigua", Atlantic },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Lisbon", Europe_Western },
            { "America/Montevideo", Uruguay },
            { "Europe/Zurich", Europe_Central },
            { "America/Winnipeg", America_Central },
            { "America/Santarem", Brasilia },
            { "Asia/Macau", China },
            { "Europe/Dublin", GMT },
            { "Asia/Vladivostok", Vladivostok },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Tijuana", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Thule", Atlantic },
            { "Europe/Copenhagen", Europe_Central },
            { "Asia/Thimphu", Bhutan },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Chihuahua", America_Central },
            { "America/Yellowknife", America_Mountain },
            { "Africa/Windhoek", Africa_Western },
            { "America/Cayman", America_Eastern },
            { "Antarctica/Davis", Davis },
            { "Europe/Berlin", Europe_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Omsk", Omsk },
            { "Europe/Chisinau", Europe_Eastern },
            { "Asia/Choibalsan", Choibalsan },
            { "Europe/Jersey", GMT },
            { "Europe/Prague", Europe_Central },
            { "Africa/Harare", Africa_Central },
            { "America/Toronto", America_Eastern },
            { "America/Montserrat", Atlantic },
            { "America/Miquelon", Pierre_Miquelon },
            { "Africa/Sao_Tome", GMT },
            { "Asia/Pyongyang", Korea },
            { "America/Porto_Velho", Amazon },
            { "America/Costa_Rica", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Mexico_City", America_Central },
            { "America/El_Salvador", America_Central },
            { "Asia/Kashgar", China },
            { "Europe/Kaliningrad", GMT },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Port_of_Spain", Atlantic },
            { "America/Kentucky/Monticello", America_Eastern },
            { "CST6CDT", America_Central },
            { "Asia/Karachi", Pakistan },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/Managua", America_Central },
            { "EST5EDT", America_Eastern },
            { "America/Nome", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Atlantic/Faeroe", Europe_Western },
            { "America/Rio_Branco", Amazon },
            { "Europe/Podgorica", Europe_Central },
            { "America/Santiago", Chile },
            { "America/Vancouver", America_Pacific },
            { "Asia/Bahrain", Arabian },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Guatemala", America_Central },
            { "Europe/Oslo", Europe_Central },
            { "America/Montreal", America_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Harbin", China },
            { "Africa/Johannesburg", Africa_Southern },
            { "Europe/Tallinn", Europe_Eastern },
            { "America/Ojinaga", America_Central },
            { "America/Barbados", Atlantic },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Asia/Urumqi", China },
            { "Asia/Gaza", Europe_Eastern },
            { "America/Louisville", America_Eastern },
            { "Atlantic/Azores", Azores },
            { "America/Lower_Princes", Atlantic },
            { "Asia/Kuwait", Arabian },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "Africa/Accra", GMT },
            { "America/Blanc-Sablon", Atlantic },
            { "Africa/Juba", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "America/Indiana/Knox", America_Central },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Dushanbe", Tajikistan },
            { "Europe/Isle_of_Man", GMT },
            { "America/Jamaica", America_Eastern },
            { "Indian/Maldives", Maldives },
            { "Africa/Abidjan", GMT },
            { "Europe/Malta", Europe_Central },
            { "Europe/Madrid", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Asia/Magadan", Magadan },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Banjul", GMT },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "America/Jujuy", Argentina },
            { "Asia/Calcutta", India },
            { "America/Buenos_Aires", Argentina },
            { "Europe/Athens", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Nassau", America_Eastern },
            { "America/Swift_Current", America_Central },
            { "America/Havana", Cuba },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Rainy_River", America_Central },
            { "America/Belem", Brasilia },
            { "America/Sao_Paulo", Brasilia },
            { "Pacific/Easter", Easter },
            { "America/Menominee", America_Central },
            { "America/Juneau", Alaska },
            { "America/Martinique", Atlantic },
            { "America/Mendoza", Argentina },
            { "Africa/Conakry", GMT },
            { "America/North_Dakota/New_Salem", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Godthab", Greenland_Western },
            { "Africa/Libreville", Africa_Western },
            { "America/St_Thomas", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "America/Shiprock", America_Mountain },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Europe/Riga", Europe_Eastern },
            { "America/Guayaquil", Ecuador },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Manila", Philippines },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Kigali", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Antarctica/Mawson", Mawson },
            { "America/Goose_Bay", Atlantic },
            { "Europe/Tirane", Europe_Central },
            { "America/Nipigon", America_Eastern },
            { "Asia/Chongqing", China },
            { "America/Cayenne", French_Guiana },
            { "Asia/Samarkand", Uzbekistan },
            { "Pacific/Fiji", Fiji },
            { "Australia/Darwin", Australia_Central },
            { "Europe/Skopje", Europe_Central },
            { "Australia/Adelaide", Australia_Central },
            { "Asia/Riyadh", Arabian },
            { "Asia/Aden", Arabian },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Africa/Lome", GMT },
            { "Atlantic/Madeira", Europe_Western },
        };
        return data;
    }
}
