#ifndef ICONS_H
#define ICONS_H

#include "common/config.h"

#define APP_ICON          ":/gpxsee.svg"

// Toolbar/menu icons
#define OPEN_FILE_ICON    ":/icons/" APP_NAME "/actions/22x22/document-open.svg"
#define OPEN_RECENT_ICON  ":/icons/" APP_NAME "/actions/22x22/document-open-recent.svg"
#define OPEN_DIR_ICON     ":/icons/" APP_NAME "/actions/22x22/document-open-folder.svg"
#define EXPORT_FILE_ICON  ":/icons/" APP_NAME "/actions/22x22/document-export.svg"
#define PRINT_FILE_ICON   ":/icons/" APP_NAME "/actions/22x22/document-print.svg"
#define CLOSE_FILE_ICON   ":/icons/" APP_NAME "/actions/22x22/document-close.svg"
#define SHOW_POI_ICON     ":/icons/" APP_NAME "/actions/22x22/flag.svg"
#define SHOW_MAP_ICON     ":/icons/" APP_NAME "/actions/22x22/map-globe.svg"
#define SHOW_GRAPHS_ICON  ":/icons/" APP_NAME "/actions/22x22/office-chart-area-stacked.svg"
#define QUIT_ICON         ":/icons/" APP_NAME "/actions/22x22/application-exit.svg"
#define RELOAD_FILE_ICON  ":/icons/" APP_NAME "/actions/22x22/view-refresh.svg"
#define NEXT_FILE_ICON    ":/icons/" APP_NAME "/actions/22x22/go-next.svg"
#define PREV_FILE_ICON    ":/icons/" APP_NAME "/actions/22x22/go-previous.svg"
#define LAST_FILE_ICON    ":/icons/" APP_NAME "/actions/22x22/go-last.svg"
#define FIRST_FILE_ICON   ":/icons/" APP_NAME "/actions/22x22/go-first.svg"
#define FULLSCREEN_ICON   ":/icons/" APP_NAME "/actions/22x22/view-fullscreen.svg"
#define SHOW_POS_ICON     ":/icons/" APP_NAME "/actions/22x22/transform-move.svg"

// Widgets
#define SHOW_PWD_ICON     ":/icons/" APP_NAME "/actions/22x22/show-hidden.svg"
#define HIDE_PWD_ICON     ":/icons/" APP_NAME "/actions/22x22/hint.svg"

// Options dialog icons
#define APPEARANCE_ICON   ":/icons/" APP_NAME "/preferences/48x48/gpxsee_appearance.svg"
#define POI_ICON          ":/icons/" APP_NAME "/preferences/48x48/gpxsee_poi.svg"
#define SYSTEM_ICON       ":/icons/" APP_NAME "/preferences/48x48/gpxsee_system.svg"
#define PRINT_EXPORT_ICON ":/icons/" APP_NAME "/preferences/48x48/gpxsee_print+export.svg"
#define DATA_ICON         ":/icons/" APP_NAME "/preferences/48x48/gpxsee_data.svg"
#define MAPS_ICON         ":/icons/" APP_NAME "/preferences/48x48/gpxsee_maps.svg"
#define DEM_ICON          ":/icons/" APP_NAME "/preferences/48x48/gpxsee_dem.svg"
#define POSITION_ICON     ":/icons/" APP_NAME "/preferences/48x48/gpxsee_position.svg"


// Desktop theme names
#define OPEN_FILE_NAME    "document-open"
#define OPEN_RECENT_NAME  "document-open-recent"
#define OPEN_DIR_NAME     "document-open-folder"
#define EXPORT_FILE_NAME  "document-export"
#define PRINT_FILE_NAME   "document-print"
#define CLOSE_FILE_NAME   "document-close"
#define SHOW_POI_NAME     "flag"
#define SHOW_MAP_NAME     "map-globe"
#define SHOW_GRAPHS_NAME  "office-chart-area-stacked"
#define QUIT_NAME         "application-exit"
#define RELOAD_FILE_NAME  "view-refresh"
#define NEXT_FILE_NAME    "go-next"
#define PREV_FILE_NAME    "go-previous"
#define LAST_FILE_NAME    "go-last"
#define FIRST_FILE_NAME   "go-first"
#define FULLSCREEN_NAME   "view-fullscreen"
#define SHOW_POS_NAME     "transform-move"

#define SHOW_PWD_NAME     "show-hidden"
#define HIDE_PWD_NAME     "hint"

#define APPEARANCE_NAME   "gpxsee_appearance"
#define POI_NAME          "gpxsee_poi"
#define SYSTEM_NAME       "gpxsee_system"
#define PRINT_EXPORT_NAME "gpxsee_print+export"
#define DATA_NAME         "gpxsee_data"
#define MAPS_NAME         "gpxsee_maps"
#define DEM_NAME          "gpxsee_dem"
#define POSITION_NAME     "gpxsee_position"

#endif /* ICONS_H */
