# Release Notes - v2.8.32

**Date**: 2026-01-30

## 📝 Executive Summary

```text
2.8.32 2026-01-30

- chore: rename release manager specification to a more generic name.
- chore: update `multi-db-docker-env` and `test_db` vendors.
- feat: remove `--skippassword` from test laboratory to enable security checks.
- fix: resolve false positive weak password warnings on MariaDB socket authentication (issue #875) and prevent dictionary corruption by silencing `curl`/`wget` output.
- test: add unit test [tests/test_issue_875.t](file:///tests/test_issue_875.t) to verify socket authentication detection.
- style: enforce artifact path hygiene (hide absolute workstation paths) in agent-generated reports.
```

## 📈 Diagnostic Growth Indicators

| Metric | Current | Progress | Status |
| :--- | :--- | :--- | :--- |
| Total Indicators | 9 | +1 | 🚀 |
| Efficiency Checks | 0 | 0 | 🛡️ |
| Risk Detections | 1 | 0 | 🛡️ |
| Information Points | 8 | +1 | 🚀 |

## 🧪 New Diagnostic Capabilities

### 🛑 New Risk Detections
- innodb_snapshot_isolation is OFF with REPEATABLE-READ (Stricter snapshot isolation is disabled)

### ℹ️ New Information Points
- Auto-generating raw output file: $raw_output_file
- InnoDB Snapshot Isolation: 
- Transaction Isolation Level: $isolation

## 🛠️ Internal Commit History

- feat: release 2.8.32 (a48c024)
- docs: document removal of --skippassword in Changelog (84df3e8)
- feat: remove --skippassword from test laboratory to enable security checks (85b42ec)
- chore: update multi-db-docker-env and test_db vendors (f14118f)
- chore: uncomment examples directory in .gitignore (8fe8fa2)
- feat: release 2.8.30 (fb45fd0)
- docs: formalize tracking of Makefile and build script changes (72b162f)
- docs: formalize test and ci requirements in Changelog and rules (b7d23f6)
- feat(workflow): add remember workflow and consolidate autolearning (f1fb317)
- docs: update Changelog and relax rules for docs-only updates (603c18b)
- fix(core): noisy system command failures with absolute paths (issue #874) (94f4e25)
- chore: bump version to 2.8.30 (f3372db)

## ⚙️ Technical Evolutions

### ➕ CLI Options Added
- `--Modeling`
- `--Performance`
- `--Security`
- `--System`
- `--cvefile`
- `--myisamstat`
- `--mysqladmin`
- `--mysqlcmd`
- `--passenv`
- `--schemadir`
- `--structstat`
- `--userenv`

### ➖ CLI Options Deprecated
- `--color`
- `--no-colstat`
- `--no-pfstat`
- `--nocolor`
- `--nocolstat`
- `--nodbstat`
- `--noidxstat`
- `--nomyisamstat`
- `--nopfstat`
- `--noplugininfo`
- `--nostructstat`
- `--nosysstat`
- `--notbstat`
- `--pass`
- `--password`
- `--server-log`
- `--user`
- `--verbose`

## ✅ Laboratory Verification Results

- [x] Automated TDD suite passed.
- [x] Multi-DB version laboratory execution validated.
- [x] Performance indicator delta analysis completed.
