/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.inventory.impl.webconsole;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.felix.inventory.ZipAttachmentProvider;
import org.apache.felix.inventory.impl.webconsole.ConfigurationPrinterAdapter;
import org.apache.felix.inventory.impl.webconsole.ResourceBundleManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class WebConsoleAdapter
implements ServiceTrackerCustomizer {
    private final BundleContext bundleContext;
    private final ServiceTracker cfgPrinterTracker;
    private final Map registrations = new HashMap();
    private final ResourceBundleManager rbManager;

    public WebConsoleAdapter(BundleContext btx) throws InvalidSyntaxException {
        this.bundleContext = btx;
        this.rbManager = new ResourceBundleManager(btx);
        this.cfgPrinterTracker = new ServiceTracker(this.bundleContext, this.bundleContext.createFilter("(|(objectClass=org.apache.felix.webconsole.ConfigurationPrinter)(&(felix.webconsole.label=*)(&(felix.webconsole.title=*)(felix.webconsole.configprinter.modes=*))))"), (ServiceTrackerCustomizer)this);
        this.cfgPrinterTracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.cfgPrinterTracker.close();
        ArrayList regs = new ArrayList();
        Map map = this.registrations;
        synchronized (map) {
            regs.addAll(this.registrations.values());
            this.registrations.clear();
        }
        for (ServiceRegistration reg : regs) {
            reg.unregister();
        }
        this.rbManager.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(ServiceReference reference, Object service) {
        ConfigurationPrinterAdapter cpa = ConfigurationPrinterAdapter.createAdapter(service, reference);
        if (cpa != null && cpa.title != null) {
            if (cpa.title.startsWith("%")) {
                String title = cpa.title.substring(1);
                ResourceBundle rb = this.rbManager.getResourceBundle(reference.getBundle());
                if (rb != null) {
                    try {
                        title = rb.getString(title);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                cpa.title = title;
            }
            if (cpa.label == null) {
                cpa.label = cpa.title;
            }
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ((Dictionary)props).put("felix.inventory.printer.name", cpa.label);
            ((Dictionary)props).put("felix.inventory.printer.title", cpa.title);
            ((Dictionary)props).put("felix.inventory.printer.format", cpa.getPrinterModes());
            ServiceRegistration reg = this.bundleContext.registerService(InventoryPrinter.class.getName(), (Object)new WebConsolePrinter(cpa), props);
            Map map = this.registrations;
            synchronized (map) {
                this.registrations.put(reference, reg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void remove(ServiceReference reference) {
        ServiceRegistration reg;
        Map map = this.registrations;
        synchronized (map) {
            reg = (ServiceRegistration)this.registrations.remove(reference);
        }
        if (reg != null) {
            reg.unregister();
        }
    }

    public Object addingService(ServiceReference reference) {
        Object service = this.bundleContext.getService(reference);
        if (service != null) {
            this.add(reference, service);
        }
        return service;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.remove(reference);
        this.add(reference, service);
    }

    public void removedService(ServiceReference reference, Object service) {
        this.remove(reference);
        this.bundleContext.ungetService(reference);
    }

    private static class WebConsolePrinter
    implements InventoryPrinter,
    ZipAttachmentProvider {
        final ConfigurationPrinterAdapter cpa;

        public WebConsolePrinter(ConfigurationPrinterAdapter cpa) {
            this.cpa = cpa;
        }

        @Override
        public void print(PrintWriter printWriter, Format format, boolean isZip) {
            String m = !isZip && format == Format.HTML ? "web" : (!isZip && format == Format.TEXT ? "txt" : (isZip && (format == Format.TEXT || format == Format.HTML) ? "zip" : null));
            if (m != null) {
                this.cpa.printConfiguration(printWriter, m);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addAttachments(ZipOutputStream zos, String namePrefix) throws IOException {
            URL[] attachments = this.cpa.getAttachments();
            if (attachments != null) {
                for (int i = 0; i < attachments.length; ++i) {
                    int pos;
                    URL current = attachments[i];
                    String path = current.getPath();
                    String name = path == null || path.length() == 0 ? "file" + Double.doubleToLongBits(Math.random()) : ((pos = path.lastIndexOf(47)) == -1 ? path : path.substring(pos + 1));
                    ZipEntry entry = new ZipEntry(namePrefix + name);
                    zos.putNextEntry(entry);
                    InputStream is = current.openStream();
                    try {
                        byte[] buffer = new byte[4096];
                        int n = 0;
                        while (-1 != (n = is.read(buffer))) {
                            zos.write(buffer, 0, n);
                        }
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    zos.closeEntry();
                }
            }
        }
    }
}

