/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.toolwindow.preview;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.PackageCheckerBundle;
import com.intellij.packageChecker.model.CallToAction;
import com.intellij.packageChecker.model.ModuleModel;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.model.PackageType;
import com.intellij.packageChecker.model.RemoteConfigService;
import com.intellij.packageChecker.model.SingleVersion;
import com.intellij.packageChecker.service.PackageService;
import com.intellij.packageChecker.service.PackageStatus;
import com.intellij.packageChecker.service.Vulnerable;
import com.intellij.packageChecker.toolwindow.preview.PackageHtmlRenderer;
import com.intellij.packageChecker.toolwindow.preview.TextDescriptionRenderer;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBFont;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u0003J\u0014\u0010 \u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u0002J\u0012\u0010!\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u0003J\u0012\u0010\"\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u0003J\u0012\u0010#\u001a\u00020\u001e2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0003J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u001eH\u0002J\u0006\u0010&\u001a\u00020\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006'"}, d2={"Lcom/intellij/packageChecker/toolwindow/preview/PackageTitlePanel;", "Lcom/intellij/ui/components/JBPanel;", "project", "Lcom/intellij/openapi/project/Project;", "packageStatus", "Lcom/intellij/packageChecker/service/PackageStatus;", "module", "Lcom/intellij/packageChecker/model/ModuleModel;", "descriptionRenderer", "Lcom/intellij/packageChecker/toolwindow/preview/TextDescriptionRenderer;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/packageChecker/service/PackageStatus;Lcom/intellij/packageChecker/model/ModuleModel;Lcom/intellij/packageChecker/toolwindow/preview/TextDescriptionRenderer;)V", "packageLabel", "Ljavax/swing/JEditorPane;", "copyDescriptionLink", "Lcom/intellij/ui/components/ActionLink;", "updateSafeVersionLink", "copySafeVersionLink", "psiManager", "Lcom/intellij/psi/PsiManager;", "Lorg/jetbrains/annotations/NotNull;", "packageService", "Lcom/intellij/packageChecker/service/PackageService;", "getPackageService", "()Lcom/intellij/packageChecker/service/PackageService;", "setPackageStatusAndUpdateSafeVersion", "", "isUpdateToSafeVersionAllowed", "", "packageText", "", "pkgStatus", "getSafeVersion", "updateSafeVersionLinkText", "copySafeVersionLinkText", "copyDescriptionLinkText", "copySafeVersionToClipboard", "urlDescription", "getContentAsText", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nPackageTitlePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageTitlePanel.kt\ncom/intellij/packageChecker/toolwindow/preview/PackageTitlePanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1#2:175\n*E\n"})
public final class PackageTitlePanel
extends JBPanel<PackageTitlePanel> {
    @NotNull
    private final Project project;
    @Nullable
    private PackageStatus packageStatus;
    @Nullable
    private ModuleModel module;
    @NotNull
    private final JEditorPane packageLabel;
    @NotNull
    private final ActionLink copyDescriptionLink;
    @NotNull
    private final ActionLink updateSafeVersionLink;
    @NotNull
    private final JEditorPane copySafeVersionLink;
    @NotNull
    private final PsiManager psiManager;

    /*
     * WARNING - void declaration
     */
    public PackageTitlePanel(@NotNull Project project, @Nullable PackageStatus packageStatus, @Nullable ModuleModel module, @NotNull TextDescriptionRenderer descriptionRenderer) {
        JEditorPane it;
        JEditorPane jEditorPane;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptionRenderer, (String)"descriptionRenderer");
        super((LayoutManager)new GridBagLayout());
        this.project = project;
        this.packageStatus = packageStatus;
        this.module = module;
        JEditorPane jEditorPane2 = jEditorPane = ComponentsKt.htmlComponent$default((String)this.packageText(this.packageStatus), (Font)((Font)JBFont.label()), null, null, (boolean)false, null, (int)60, null);
        PackageTitlePanel packageTitlePanel = this;
        boolean bl = false;
        it.setFocusable(true);
        packageTitlePanel.packageLabel = jEditorPane;
        this.copyDescriptionLink = new ActionLink(this.copyDescriptionLinkText(this.packageStatus), arg_0 -> PackageTitlePanel.copyDescriptionLink$lambda$1(descriptionRenderer, this, arg_0));
        it = jEditorPane = new ActionLink(this.updateSafeVersionLinkText(this.packageStatus), arg_0 -> PackageTitlePanel.updateSafeVersionLink$lambda$5(this, arg_0));
        packageTitlePanel = this;
        boolean bl2 = false;
        it.setAutoHideOnDisable(false);
        packageTitlePanel.updateSafeVersionLink = jEditorPane;
        this.copySafeVersionLink = ComponentsKt.htmlComponent$default((String)this.copySafeVersionLinkText(this.packageStatus), null, null, null, (boolean)false, arg_0 -> PackageTitlePanel.copySafeVersionLink$lambda$8(this, arg_0), (int)30, null);
        PsiManager psiManager = PsiManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        this.psiManager = psiManager;
        GridBag gridBag = new GridBag().setDefaultAnchor(0, 17).setDefaultAnchor(1, 13).setDefaultInsets(16, 20, 0, 0).setDefaultFill(2);
        Intrinsics.checkNotNullExpressionValue((Object)gridBag, (String)"setDefaultFill(...)");
        GridBag gridBag2 = gridBag;
        this.add(this.packageLabel, gridBag2.nextLine().next().weightx(1.0).anchor(21));
        String copyright = RemoteConfigService.getCopyright$default(RemoteConfigService.Companion.getInstance(), false, 1, null);
        if (copyright != null) {
            void it2;
            JEditorPane jEditorPane3;
            JEditorPane jEditorPane4 = jEditorPane3 = ComponentsKt.htmlComponent$default((String)copyright, null, null, null, (boolean)false, null, (int)62, null);
            packageTitlePanel = this;
            boolean bl3 = false;
            it2.setFocusable(true);
            packageTitlePanel.add(jEditorPane3, gridBag2.next().coverLine().weightx(0.0).anchor(22));
        }
        this.add((Component)this.copyDescriptionLink, gridBag2.nextLine().next().coverLine());
        this.add((Component)this.updateSafeVersionLink, gridBag2.nextLine().coverLine());
        this.add(this.copySafeVersionLink, gridBag2.nextLine().next().coverLine());
    }

    private final PackageService getPackageService() {
        return PackageService.Companion.getInstance(this.project);
    }

    public final void setPackageStatusAndUpdateSafeVersion(@Nullable PackageStatus packageStatus, @Nullable ModuleModel module) {
        this.packageStatus = packageStatus;
        this.module = module;
        ApplicationManager.getApplication().invokeLater(() -> PackageTitlePanel.setPackageStatusAndUpdateSafeVersion$lambda$10(this, packageStatus));
    }

    private final boolean isUpdateToSafeVersionAllowed(PackageStatus packageStatus) {
        Object object = packageStatus;
        PackageType packageType = object != null && (object = ((PackageStatus)object).getPkg()) != null ? ((Package)object).getType() : null;
        return (packageType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[packageType.ordinal()]) == 1;
    }

    @NlsSafe
    private final String packageText(PackageStatus pkgStatus2) {
        Object object = pkgStatus2;
        if (object == null || (object = ((PackageStatus)object).getPkg()) == null) {
            String string = PackageCheckerBundle.message("dependency.tree.select.dependency.message", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        Object pkg = object;
        Object[] objectArray = new Object[2];
        objectArray[0] = ((Package)pkg).getHumanReadableCoordinates();
        String string = pkgStatus2.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
        String string2 = PackageCheckerBundle.message("dependency.tree.package.html.message", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }

    private final String getSafeVersion(PackageStatus pkgStatus2) {
        Object object;
        return pkgStatus2 instanceof Vulnerable ? ((object = ((Vulnerable)pkgStatus2).getVulnerablePackage().getCallToAction()) != null && (object = ((CallToAction)object).getNewVersion()) != null ? ((SingleVersion)object).getValue() : null) : null;
    }

    @NlsSafe
    private final String updateSafeVersionLinkText(PackageStatus pkgStatus2) {
        String string = this.getSafeVersion(pkgStatus2);
        if (string == null) {
            return "";
        }
        String safeVersion = string;
        Object[] objectArray = new Object[]{safeVersion};
        String string2 = PackageCheckerBundle.message("dependency.safe.version.title", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }

    @NlsSafe
    private final String copySafeVersionLinkText(PackageStatus pkgStatus2) {
        String string = this.getSafeVersion(pkgStatus2);
        if (string == null) {
            return "";
        }
        String safeVersion = string;
        Object[] objectArray = new Object[]{"#copyCall2action", safeVersion, "Copy safe version to clipboard"};
        String string2 = PackageCheckerBundle.message("dependency.safe.version.link", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }

    @NlsSafe
    private final String copyDescriptionLinkText(PackageStatus packageStatus) {
        String string;
        if (packageStatus instanceof Vulnerable) {
            String string2 = PackageCheckerBundle.message("dependency.copy.description.link", new Object[0]);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            string = "";
        }
        return string;
    }

    private final void copySafeVersionToClipboard(String urlDescription) {
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(PackageHtmlRenderer.INSTANCE.getCallToAction(urlDescription)));
    }

    @NotNull
    public final String getContentAsText() {
        Object object;
        block3: {
            block2: {
                StringBuilder stringBuilder;
                PackageStatus packageStatus = this.packageStatus;
                object = packageStatus instanceof Vulnerable ? (Vulnerable)packageStatus : null;
                if (object == null) break block2;
                Vulnerable it = object;
                boolean bl = false;
                String newLine = System.lineSeparator();
                StringBuilder $this$getContentAsText_u24lambda_u2412_u24lambda_u2411 = stringBuilder = new StringBuilder();
                boolean bl2 = false;
                Object[] objectArray = new Object[2];
                objectArray[0] = it.getPkg().getHumanReadableCoordinates();
                String string = it.getClass().getSimpleName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
                Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                $this$getContentAsText_u24lambda_u2412_u24lambda_u2411.append(PackageCheckerBundle.message("dependency.tree.package.text.message", objectArray));
                $this$getContentAsText_u24lambda_u2412_u24lambda_u2411.append(newLine);
                $this$getContentAsText_u24lambda_u2412_u24lambda_u2411.append(newLine);
                $this$getContentAsText_u24lambda_u2412_u24lambda_u2411.append(this.updateSafeVersionLinkText(this.packageStatus));
                String string2 = stringBuilder.toString();
                object = string2;
                if (string2 != null) break block3;
            }
            object = "";
        }
        return object;
    }

    private static final Unit copyDescriptionLink$lambda$1(TextDescriptionRenderer $descriptionRenderer, PackageTitlePanel this$0, ActionEvent actionEvent) {
        Intrinsics.checkNotNullParameter((Object)actionEvent, (String)"<unused var>");
        String contentAsText = $descriptionRenderer.getContentAsText(this$0);
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(contentAsText));
        return Unit.INSTANCE;
    }

    private static final void updateSafeVersionLink$lambda$5$lambda$4(PackageTitlePanel this$0, PsiFile $buildFile, String $safeVersion, ActionLink $link) {
        PackageService packageService = this$0.getPackageService();
        PackageStatus packageStatus = this$0.packageStatus;
        Intrinsics.checkNotNull((Object)packageStatus);
        packageService.updateDependency($buildFile, packageStatus.getPkg(), $safeVersion);
        Object[] objectArray = new Object[]{$safeVersion};
        $link.setText(PackageCheckerBundle.message("dependency.safe.version.updated.title", objectArray));
    }

    private static final Unit updateSafeVersionLink$lambda$5(PackageTitlePanel this$0, ActionEvent event) {
        ModuleModel moduleModel;
        Object safeVersion;
        block7: {
            block6: {
                Object object;
                block5: {
                    block4: {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        object = this$0.packageStatus;
                        if (object == null) break block4;
                        PackageStatus it = object;
                        boolean bl = false;
                        String string = this$0.getSafeVersion(it);
                        object = string;
                        if (string != null) break block5;
                    }
                    return Unit.INSTANCE;
                }
                safeVersion = object;
                moduleModel = this$0.module;
                if (moduleModel == null || (moduleModel = moduleModel.getBuildFile()) == null) break block6;
                ModuleModel it = moduleModel;
                boolean bl = false;
                PsiFile psiFile = this$0.psiManager.findFile((VirtualFile)it);
                moduleModel = psiFile;
                if (psiFile != null) break block7;
            }
            return Unit.INSTANCE;
        }
        ModuleModel buildFile = moduleModel;
        Object object = event.getSource();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.ui.components.ActionLink");
        ActionLink link = (ActionLink)object;
        link.setEnabled(false);
        ApplicationManager.getApplication().executeOnPooledThread(() -> PackageTitlePanel.updateSafeVersionLink$lambda$5$lambda$4(this$0, (PsiFile)buildFile, (String)safeVersion, link));
        return Unit.INSTANCE;
    }

    private static final void copySafeVersionLink$lambda$8(PackageTitlePanel this$0, HyperlinkEvent e) {
        if (Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            String $this$copySafeVersionLink_u24lambda_u248_u24lambda_u247 = e.getDescription();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$copySafeVersionLink_u24lambda_u248_u24lambda_u247);
            if (PackageHtmlRenderer.INSTANCE.isCallToActionUrlDescription($this$copySafeVersionLink_u24lambda_u248_u24lambda_u247)) {
                this$0.copySafeVersionToClipboard($this$copySafeVersionLink_u24lambda_u248_u24lambda_u247);
                return;
            }
        }
        BrowserHyperlinkListener.INSTANCE.hyperlinkUpdate(e);
    }

    private static final void setPackageStatusAndUpdateSafeVersion$lambda$10(PackageTitlePanel this$0, PackageStatus $packageStatus) {
        this$0.packageLabel.setText(this$0.packageText($packageStatus));
        this$0.packageLabel.setFocusable(true);
        this$0.updateSafeVersionLink.setText(this$0.updateSafeVersionLinkText($packageStatus));
        this$0.updateSafeVersionLink.setFocusable(true);
        ActionLink actionLink = this$0.updateSafeVersionLink;
        String string = this$0.updateSafeVersionLink.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        actionLink.setVisible(!StringsKt.isBlank((CharSequence)string) && this$0.isUpdateToSafeVersionAllowed($packageStatus));
        this$0.updateSafeVersionLink.setEnabled(true);
        this$0.copySafeVersionLink.setText(this$0.copySafeVersionLinkText($packageStatus));
        this$0.copySafeVersionLink.setFocusable(true);
        JEditorPane jEditorPane = this$0.copySafeVersionLink;
        String string2 = this$0.updateSafeVersionLink.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        jEditorPane.setVisible(!StringsKt.isBlank((CharSequence)string2));
        this$0.copyDescriptionLink.setText(this$0.copyDescriptionLinkText($packageStatus));
        this$0.copyDescriptionLink.setFocusable(true);
        this$0.invalidate();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PackageType.values().length];
            try {
                nArray[PackageType.go.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

