/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend;

import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.frontend.TerminalSessionController;
import com.intellij.terminal.session.TerminalBeepEvent;
import com.intellij.terminal.session.TerminalCommandFinishedEvent;
import com.intellij.terminal.session.TerminalCommandStartedEvent;
import com.intellij.terminal.session.TerminalContentUpdatedEvent;
import com.intellij.terminal.session.TerminalCursorPositionChangedEvent;
import com.intellij.terminal.session.TerminalInitialStateEvent;
import com.intellij.terminal.session.TerminalOutputEvent;
import com.intellij.terminal.session.TerminalPromptFinishedEvent;
import com.intellij.terminal.session.TerminalPromptStartedEvent;
import com.intellij.terminal.session.TerminalSession;
import com.intellij.terminal.session.TerminalSessionTerminatedEvent;
import com.intellij.terminal.session.TerminalState;
import com.intellij.terminal.session.TerminalStateChangedEvent;
import com.intellij.terminal.session.dto.StyleRangeDto;
import com.intellij.terminal.session.dto.StyleRangeDtoKt;
import com.intellij.terminal.session.dto.TerminalBlocksModelStateDto;
import com.intellij.terminal.session.dto.TerminalBlocksModelStateDtoKt;
import com.intellij.terminal.session.dto.TerminalOutputModelStateDto;
import com.intellij.terminal.session.dto.TerminalOutputModelStateDtoKt;
import com.intellij.terminal.session.dto.TerminalStateDto;
import com.intellij.terminal.session.dto.TerminalStateDtoKt;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.DisposableWrapperList;
import java.awt.Toolkit;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlocksModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalSessionModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalShellIntegrationEventsListener;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;
import org.jetbrains.plugins.terminal.fus.BatchLatencyReporter;
import org.jetbrains.plugins.terminal.fus.DurationAndTextLength;
import org.jetbrains.plugins.terminal.fus.FrontendOutputActivity;
import org.jetbrains.plugins.terminal.fus.ReworkedTerminalUsageCollector;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u001c\u0010#\u001a\u00020 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0082@\u00a2\u0006\u0002\u0010'J\u0016\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020&H\u0082@\u00a2\u0006\u0002\u0010*J\"\u0010+\u001a\u00020 2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020 0-H\u0082@\u00a2\u0006\u0002\u0010.J\u0018\u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020\u00072\u0006\u0010)\u001a\u000201H\u0003J\b\u00102\u001a\u00020\u0007H\u0002J\u001a\u00103\u001a\u00020 2\n\u00104\u001a\u00060\u0015j\u0002`\u00162\u0006\u00105\u001a\u000206J\b\u00107\u001a\u00020 H\u0002J\u0016\u00108\u001a\u00020 2\u0006\u00105\u001a\u0002062\u0006\u00109\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0015j\u0002`\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/intellij/terminal/frontend/TerminalSessionController;", "", "project", "Lcom/intellij/openapi/project/Project;", "sessionModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;", "outputModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;", "alternateBufferModel", "blocksModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalBlocksModel;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "fusActivity", "Lorg/jetbrains/plugins/terminal/fus/FrontendOutputActivity;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalBlocksModel;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lkotlinx/coroutines/CoroutineScope;Lorg/jetbrains/plugins/terminal/fus/FrontendOutputActivity;)V", "terminationListeners", "Lcom/intellij/util/containers/DisposableWrapperList;", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "shellIntegrationEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalShellIntegrationEventsListener;", "edtContext", "Lkotlin/coroutines/CoroutineContext;", "documentUpdateLatencyReporter", "Lorg/jetbrains/plugins/terminal/fus/BatchLatencyReporter;", "Lorg/jetbrains/plugins/terminal/fus/DurationAndTextLength;", "handleEvents", "", "session", "Lcom/intellij/terminal/session/TerminalSession;", "doHandleEvents", "events", "", "Lcom/intellij/terminal/session/TerminalOutputEvent;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleEvent", "event", "(Lcom/intellij/terminal/session/TerminalOutputEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateOutputModel", "block", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateOutputModelContent", "model", "Lcom/intellij/terminal/session/TerminalContentUpdatedEvent;", "getCurrentOutputModel", "addTerminationCallback", "onTerminated", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "fireSessionTerminated", "addShellIntegrationListener", "listener", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nTerminalSessionController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalSessionController.kt\ncom/intellij/terminal/frontend/TerminalSessionController\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 BatchLatencyReporter.kt\norg/jetbrains/plugins/terminal/fus/BatchLatencyReporterKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n24#2:191\n24#2:196\n1563#3:192\n1634#3,3:193\n1803#3,3:198\n1011#3,2:204\n1011#3,2:233\n101#4:197\n87#4:201\n89#4:203\n90#4,2:206\n50#4:208\n52#4,20:210\n87#4:230\n89#4:232\n90#4,2:235\n1#5:202\n1#5:209\n1#5:231\n*S KotlinDebug\n*F\n+ 1 TerminalSessionController.kt\ncom/intellij/terminal/frontend/TerminalSessionController\n*L\n76#1:191\n182#1:196\n161#1:192\n161#1:193,3\n51#1:198,3\n52#1:204,2\n54#1:233,2\n51#1:197\n52#1:201\n52#1:203\n52#1:206,2\n53#1:208\n53#1:210,20\n54#1:230\n54#1:232\n54#1:235,2\n52#1:202\n53#1:209\n54#1:231\n*E\n"})
public final class TerminalSessionController {
    @NotNull
    private final Project project;
    @NotNull
    private final TerminalSessionModel sessionModel;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final TerminalOutputModel alternateBufferModel;
    @NotNull
    private final TerminalBlocksModel blocksModel;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final FrontendOutputActivity fusActivity;
    @NotNull
    private final DisposableWrapperList<Runnable> terminationListeners;
    @NotNull
    private final EventDispatcher<TerminalShellIntegrationEventsListener> shellIntegrationEventDispatcher;
    @NotNull
    private final CoroutineContext edtContext;
    @NotNull
    private final BatchLatencyReporter<DurationAndTextLength> documentUpdateLatencyReporter;

    public TerminalSessionController(@NotNull Project project, @NotNull TerminalSessionModel sessionModel, @NotNull TerminalOutputModel outputModel, @NotNull TerminalOutputModel alternateBufferModel, @NotNull TerminalBlocksModel blocksModel, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull CoroutineScope coroutineScope, @NotNull FrontendOutputActivity fusActivity) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sessionModel, (String)"sessionModel");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        Intrinsics.checkNotNullParameter((Object)alternateBufferModel, (String)"alternateBufferModel");
        Intrinsics.checkNotNullParameter((Object)blocksModel, (String)"blocksModel");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)fusActivity, (String)"fusActivity");
        this.project = project;
        this.sessionModel = sessionModel;
        this.outputModel = outputModel;
        this.alternateBufferModel = alternateBufferModel;
        this.blocksModel = blocksModel;
        this.settings = settings;
        this.coroutineScope = coroutineScope;
        this.fusActivity = fusActivity;
        this.terminationListeners = new DisposableWrapperList();
        EventDispatcher eventDispatcher2 = EventDispatcher.create(TerminalShellIntegrationEventsListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher2, (String)"create(...)");
        this.shellIntegrationEventDispatcher = eventDispatcher2;
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        this.edtContext = coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState));
        this.documentUpdateLatencyReporter = new BatchLatencyReporter(100, TerminalSessionController::documentUpdateLatencyReporter$lambda$3);
    }

    public final void handleEvents(@NotNull TerminalSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(session2, this, null){
            Object L$0;
            int label;
            final /* synthetic */ TerminalSession $session;
            final /* synthetic */ TerminalSessionController this$0;
            {
                this.$session = $session;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = this.$session.getOutputFlow((Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        outputFlow = (Flow)v0;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)outputFlow);
                        this.label = 2;
                        v1 = outputFlow.collect(new FlowCollector(this.this$0){
                            final /* synthetic */ TerminalSessionController this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public final Object emit(List<? extends TerminalOutputEvent> events, Continuation<? super Unit> $completion) {
                                Object object = TerminalSessionController.access$doHandleEvents(this.this$0, events, $completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl24
                    }
                    case 2: {
                        outputFlow = (Flow)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl24:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object doHandleEvents(List<? extends TerminalOutputEvent> events, Continuation<? super Unit> $completion) {
        if (!($completion instanceof doHandleEvents.1)) ** GOTO lbl-1000
        var9_3 = $completion;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ TerminalSessionController this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TerminalSessionController.access$doHandleEvents(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var3_6 = events.iterator();
lbl13:
                // 4 sources

                while (var3_6.hasNext()) {
                    event = (TerminalOutputEvent)var3_6.next();
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)events);
                    $continuation.L$1 = var3_6;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)event);
                    $continuation.label = 1;
                    v0 = this.handleEvent(event, (Continuation<? super Unit>)$continuation);
                    if (v0 != var10_5) continue;
                    return var10_5;
                }
                break;
            }
            case 1: {
                event = (TerminalOutputEvent)$continuation.L$2;
                var3_6 = (Iterator)$continuation.L$1;
                events = (List)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                    ** GOTO lbl13
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (Throwable t) {
                    $this$thisLogger$iv = this;
                    $i$f$thisLogger = false;
                    v1 = Logger.getInstance(TerminalSessionController.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getInstance(...)");
                    v1.error(t);
                    ** GOTO lbl13
                }
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleEvent(TerminalOutputEvent event, Continuation<? super Unit> $completion) {
        block23: {
            block29: {
                block28: {
                    block27: {
                        block26: {
                            block25: {
                                block24: {
                                    block22: {
                                        block21: {
                                            block20: {
                                                if (!($completion instanceof handleEvent.1)) ** GOTO lbl-1000
                                                var6_3 = $completion;
                                                if ((var6_3.label & -2147483648) != 0) {
                                                    var6_3.label -= -2147483648;
                                                } else lbl-1000:
                                                // 2 sources

                                                {
                                                    $continuation = new ContinuationImpl(this, $completion){
                                                        Object L$0;
                                                        /* synthetic */ Object result;
                                                        final /* synthetic */ TerminalSessionController this$0;
                                                        int label;
                                                        {
                                                            this.this$0 = this$0;
                                                            super($completion);
                                                        }

                                                        @Nullable
                                                        public final Object invokeSuspend(@NotNull Object $result) {
                                                            this.result = $result;
                                                            this.label |= Integer.MIN_VALUE;
                                                            return TerminalSessionController.access$handleEvent(this.this$0, null, (Continuation)this);
                                                        }
                                                    };
                                                }
                                                $result = $continuation.result;
                                                var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch ($continuation.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        var3_6 = event;
                                                        if (!(var3_6 instanceof TerminalInitialStateEvent)) break;
                                                        this.sessionModel.updateTerminalState(TerminalStateDtoKt.toTerminalState((TerminalStateDto)((TerminalInitialStateEvent)event).getSessionState()));
                                                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)event);
                                                        $continuation.label = 1;
                                                        v0 = this.updateOutputModel((Function1<? super TerminalOutputModel, Unit>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, handleEvent$lambda$4(com.intellij.terminal.frontend.TerminalSessionController com.intellij.terminal.session.TerminalOutputEvent org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel ), (Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;)Lkotlin/Unit;)((TerminalSessionController)this, (TerminalOutputEvent)event), (Continuation<? super Unit>)$continuation);
                                                        if (v0 == var7_5) {
                                                            return var7_5;
                                                        }
                                                        ** GOTO lbl25
                                                    }
                                                    case 1: {
                                                        event = (TerminalOutputEvent)$continuation.L$0;
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        v0 = $result;
lbl25:
                                                        // 2 sources

                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                if (!(var3_6 instanceof TerminalContentUpdatedEvent)) break block20;
                                                this.fusActivity.eventReceived((TerminalContentUpdatedEvent)event);
                                                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)event);
                                                $continuation.label = 2;
                                                v1 = this.updateOutputModel((Function1<? super TerminalOutputModel, Unit>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, handleEvent$lambda$5(com.intellij.terminal.frontend.TerminalSessionController com.intellij.terminal.session.TerminalOutputEvent org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel ), (Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;)Lkotlin/Unit;)((TerminalSessionController)this, (TerminalOutputEvent)event), (Continuation<? super Unit>)$continuation);
                                                if (v1 == var7_5) {
                                                    return var7_5;
                                                }
                                                ** GOTO lbl38
                                                {
                                                    case 2: {
                                                        event = (TerminalOutputEvent)$continuation.L$0;
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        v1 = $result;
lbl38:
                                                        // 2 sources

                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                            }
                                            if (!(var3_6 instanceof TerminalCursorPositionChangedEvent)) break block21;
                                            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)event);
                                            $continuation.label = 3;
                                            v2 = this.updateOutputModel((Function1<? super TerminalOutputModel, Unit>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, handleEvent$lambda$6(com.intellij.terminal.session.TerminalOutputEvent org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel ), (Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;)Lkotlin/Unit;)((TerminalOutputEvent)event), (Continuation<? super Unit>)$continuation);
                                            if (v2 == var7_5) {
                                                return var7_5;
                                            }
                                            ** GOTO lbl51
                                            {
                                                case 3: {
                                                    event = (TerminalOutputEvent)$continuation.L$0;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v2 = $result;
lbl51:
                                                    // 2 sources

                                                    return Unit.INSTANCE;
                                                }
                                            }
                                        }
                                        if (!(var3_6 instanceof TerminalStateChangedEvent)) break block22;
                                        state = TerminalStateDtoKt.toTerminalState((TerminalStateDto)((TerminalStateChangedEvent)event).getState());
                                        this.sessionModel.updateTerminalState(state);
                                        break block23;
                                    }
                                    if (!(var3_6 instanceof TerminalBeepEvent)) break block24;
                                    if (this.settings.audibleBell()) {
                                        Toolkit.getDefaultToolkit().beep();
                                    }
                                    break block23;
                                }
                                if (!Intrinsics.areEqual((Object)var3_6, (Object)TerminalSessionTerminatedEvent.INSTANCE)) break block25;
                                this.fireSessionTerminated();
                                break block23;
                            }
                            if (!Intrinsics.areEqual((Object)var3_6, (Object)TerminalPromptStartedEvent.INSTANCE)) break block26;
                            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)event);
                            $continuation.label = 4;
                            v3 = BuildersKt.withContext((CoroutineContext)this.edtContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                                int label;
                                final /* synthetic */ TerminalSessionController this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            TerminalSessionController.access$getBlocksModel$p(this.this$0).promptStarted(((Number)TerminalSessionController.access$getOutputModel$p(this.this$0).getCursorOffsetState().getValue()).intValue());
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)$continuation);
                            if (v3 == var7_5) {
                                return var7_5;
                            }
                            ** GOTO lbl78
                            {
                                case 4: {
                                    event = (TerminalOutputEvent)$continuation.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v3 = $result;
lbl78:
                                    // 2 sources

                                    ((TerminalShellIntegrationEventsListener)this.shellIntegrationEventDispatcher.getMulticaster()).promptStarted();
                                    break block23;
                                }
                            }
                        }
                        if (!Intrinsics.areEqual((Object)var3_6, (Object)TerminalPromptFinishedEvent.INSTANCE)) break block27;
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)event);
                        $continuation.label = 5;
                        v4 = BuildersKt.withContext((CoroutineContext)this.edtContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                            int label;
                            final /* synthetic */ TerminalSessionController this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        TerminalSessionController.access$getBlocksModel$p(this.this$0).promptFinished(((Number)TerminalSessionController.access$getOutputModel$p(this.this$0).getCursorOffsetState().getValue()).intValue());
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)$continuation);
                        if (v4 == var7_5) {
                            return var7_5;
                        }
                        ** GOTO lbl92
                        {
                            case 5: {
                                event = (TerminalOutputEvent)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v4 = $result;
lbl92:
                                // 2 sources

                                ((TerminalShellIntegrationEventsListener)this.shellIntegrationEventDispatcher.getMulticaster()).promptFinished();
                                break block23;
                            }
                        }
                    }
                    if (!(var3_6 instanceof TerminalCommandStartedEvent)) break block28;
                    $continuation.L$0 = event;
                    $continuation.label = 6;
                    v5 = BuildersKt.withContext((CoroutineContext)this.edtContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                        int label;
                        final /* synthetic */ TerminalSessionController this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    TerminalSessionController.access$getBlocksModel$p(this.this$0).commandStarted(((Number)TerminalSessionController.access$getOutputModel$p(this.this$0).getCursorOffsetState().getValue()).intValue());
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v5 == var7_5) {
                        return var7_5;
                    }
                    ** GOTO lbl106
                    {
                        case 6: {
                            event = (TerminalOutputEvent)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
lbl106:
                            // 2 sources

                            ((TerminalShellIntegrationEventsListener)this.shellIntegrationEventDispatcher.getMulticaster()).commandStarted(((TerminalCommandStartedEvent)event).getCommand());
                            break block23;
                        }
                    }
                }
                if (!(var3_6 instanceof TerminalCommandFinishedEvent)) break block29;
                $continuation.L$0 = event;
                $continuation.label = 7;
                v6 = BuildersKt.withContext((CoroutineContext)this.edtContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, event, null){
                    int label;
                    final /* synthetic */ TerminalSessionController this$0;
                    final /* synthetic */ TerminalOutputEvent $event;
                    {
                        this.this$0 = $receiver;
                        this.$event = $event;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                TerminalSessionController.access$getBlocksModel$p(this.this$0).commandFinished(((TerminalCommandFinishedEvent)this.$event).getExitCode());
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v6 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl120
                {
                    case 7: {
                        event = (TerminalOutputEvent)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
lbl120:
                        // 2 sources

                        ((TerminalShellIntegrationEventsListener)this.shellIntegrationEventDispatcher.getMulticaster()).commandFinished(((TerminalCommandFinishedEvent)event).getCommand(), ((TerminalCommandFinishedEvent)event).getExitCode(), ((TerminalCommandFinishedEvent)event).getCurrentDirectory());
                        break block23;
                    }
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object updateOutputModel(Function1<? super TerminalOutputModel, Unit> block, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)this.edtContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Object>, Object>(this, block, null){
            int label;
            final /* synthetic */ TerminalSessionController this$0;
            final /* synthetic */ Function1<TerminalOutputModel, Unit> $block;
            {
                this.this$0 = $receiver;
                this.$block = $block;
                super(2, $completion);
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object object;
                        ResultKt.throwOnFailure((Object)$result);
                        Runnable doUpdate = () -> updateOutputModel.2.invokeSuspend$lambda$0(this.$block, this.this$0);
                        LookupEx lookup = LookupManager.getInstance((Project)TerminalSessionController.access$getProject$p(this.this$0)).getActiveLookup();
                        if (lookup != null) {
                            Editor editor = lookup.getEditor();
                            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                            if (TerminalDataContextUtils.INSTANCE.isReworkedTerminalEditor(editor)) {
                                object = Boxing.boxBoolean((boolean)lookup.performGuardedChange(doUpdate));
                                return object;
                            }
                        }
                        doUpdate.run();
                        object = Unit.INSTANCE;
                        return object;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<Object> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(Function1 $block, TerminalSessionController this$0) {
                $block.invoke((Object)TerminalSessionController.access$getCurrentOutputModel(this$0));
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private final void updateOutputModelContent(TerminalOutputModel model, TerminalContentUpdatedEvent event) {
        void $this$mapTo$iv$iv;
        long startTime = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        Iterable $this$map$iv = event.getStyles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StyleRangeDto styleRangeDto = (StyleRangeDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StyleRangeDtoKt.toStyleRange((StyleRangeDto)it));
        }
        List styles = (List)destination$iv$iv;
        model.updateContent(event.getStartLineLogicalIndex(), event.getText(), styles);
        DurationAndTextLength latencyData = new DurationAndTextLength(TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)startTime), event.getText().length(), null);
        this.documentUpdateLatencyReporter.update(latencyData);
    }

    private final TerminalOutputModel getCurrentOutputModel() {
        return ((TerminalState)this.sessionModel.getTerminalState().getValue()).isAlternateScreenBuffer() ? this.alternateBufferModel : this.outputModel;
    }

    public final void addTerminationCallback(@NotNull Runnable onTerminated, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)onTerminated, (String)"onTerminated");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.terminationListeners.add((Object)onTerminated, parentDisposable);
    }

    private final void fireSessionTerminated() {
        Iterator iterator = this.terminationListeners.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Runnable listener2 = (Runnable)iterator2.next();
            try {
                listener2.run();
            }
            catch (Throwable t) {
                TerminalSessionController $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(TerminalSessionController.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Unhandled exception in termination listener", t);
            }
        }
    }

    public final void addShellIntegrationListener(@NotNull Disposable parentDisposable, @NotNull TerminalShellIntegrationEventsListener listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.shellIntegrationEventDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit documentUpdateLatencyReporter$lambda$3(List samples) {
        List $this$thirdLargestOf$iv;
        void p0;
        List $this$percentileOf$iv;
        long l;
        void $this$fold$iv$iv;
        List $this$totalDurationOf$iv;
        Intrinsics.checkNotNullParameter((Object)samples, (String)"samples");
        List list = samples;
        ReworkedTerminalUsageCollector reworkedTerminalUsageCollector = ReworkedTerminalUsageCollector.INSTANCE;
        boolean $i$f$totalDurationOf = false;
        Iterable iterable = $this$totalDurationOf$iv;
        long initial$iv$iv = Duration.Companion.getZERO-UwyO8pc();
        boolean $i$f$fold22 = false;
        long accumulator$iv$iv = initial$iv$iv;
        Iterator iterator = $this$fold$iv$iv.iterator();
        while (iterator.hasNext()) {
            void p02;
            void value$iv;
            Object element$iv$iv;
            Object t = element$iv$iv = iterator.next();
            long acc$iv = accumulator$iv$iv;
            boolean bl = false;
            DurationAndTextLength durationAndTextLength = (DurationAndTextLength)value$iv;
            l = acc$iv;
            boolean bl2 = false;
            long l2 = p02.getDuration-UwyO8pc();
            accumulator$iv$iv = Duration.plus-LRDsOJo((long)l, (long)l2);
        }
        l = accumulator$iv$iv;
        $this$totalDurationOf$iv = samples;
        int n$iv = 90;
        boolean $i$f$percentileOf = false;
        void $this$sortBy$iv$iv = $this$percentileOf$iv;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    DurationAndTextLength p0 = (DurationAndTextLength)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)Duration.box-impl((long)p0.getDuration-UwyO8pc());
                    p0 = (DurationAndTextLength)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)Duration.box-impl((long)p0.getDuration-UwyO8pc())));
                }
            });
        }
        int index$iv = RangesKt.coerceAtMost((int)($this$percentileOf$iv.size() * n$iv / 100), (int)($this$percentileOf$iv.size() - 1));
        DurationAndTextLength $i$f$fold22 = (DurationAndTextLength)$this$percentileOf$iv.get(index$iv);
        boolean bl = false;
        Duration duration = Duration.box-impl((long)p0.getDuration-UwyO8pc());
        $this$percentileOf$iv = samples;
        long l3 = ((Duration)((Comparable)duration)).unbox-impl();
        boolean $i$f$thirdLargestOf = false;
        if (!(!((Collection)$this$thirdLargestOf$iv).isEmpty())) {
            boolean $i$a$-check-BatchLatencyReporterKt$thirdLargestOf$1$iv22 = false;
            String $i$a$-check-BatchLatencyReporterKt$thirdLargestOf$1$iv22 = "It is expected that array is not empty";
            throw new IllegalStateException($i$a$-check-BatchLatencyReporterKt$thirdLargestOf$1$iv22.toString());
        }
        DurationAndTextLength p03 = (DurationAndTextLength)$this$thirdLargestOf$iv.get(0);
        boolean bl3 = false;
        Object max$iv = (Comparable)Duration.box-impl((long)p03.getDuration-UwyO8pc());
        Comparable secondLargest$iv = max$iv;
        Comparable thirdLargest$iv = max$iv;
        for (Object value$iv : $this$thirdLargestOf$iv) {
            DurationAndTextLength p04 = (DurationAndTextLength)value$iv;
            $i$a$-thirdLargestOf-TerminalSessionController$documentUpdateLatencyReporter$1$3 = false;
            Comparable comparableValue$iv = (Comparable)Duration.box-impl((long)p04.getDuration-UwyO8pc());
            if (comparableValue$iv.compareTo(max$iv) > 0) {
                thirdLargest$iv = secondLargest$iv;
                secondLargest$iv = max$iv;
                max$iv = comparableValue$iv;
                continue;
            }
            if (comparableValue$iv.compareTo(secondLargest$iv) > 0) {
                thirdLargest$iv = secondLargest$iv;
                secondLargest$iv = comparableValue$iv;
                continue;
            }
            if (comparableValue$iv.compareTo(thirdLargest$iv) <= 0) continue;
            thirdLargest$iv = comparableValue$iv;
        }
        Comparable comparable = thirdLargest$iv;
        long l4 = ((Duration)comparable).unbox-impl();
        $this$thirdLargestOf$iv = samples;
        n$iv = 90;
        $i$f$percentileOf = false;
        List $this$sortBy$iv$iv2 = $this$percentileOf$iv;
        $i$f$sortBy = false;
        if ($this$sortBy$iv$iv2.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv$iv2, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    DurationAndTextLength p0 = (DurationAndTextLength)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(p0.getTextLength());
                    p0 = (DurationAndTextLength)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(p0.getTextLength()));
                }
            });
        }
        index$iv = RangesKt.coerceAtMost((int)($this$percentileOf$iv.size() * n$iv / 100), (int)($this$percentileOf$iv.size() - 1));
        max$iv = (DurationAndTextLength)$this$percentileOf$iv.get(index$iv);
        long l5 = l4;
        boolean bl4 = false;
        int n = p0.getTextLength();
        reworkedTerminalUsageCollector.logFrontendDocumentUpdateLatency-2d-g_3Q(l, l3, l5, n);
        return Unit.INSTANCE;
    }

    private static final Unit handleEvent$lambda$4(TerminalSessionController this$0, TerminalOutputEvent $event, TerminalOutputModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.outputModel.restoreFromState(TerminalOutputModelStateDtoKt.toState((TerminalOutputModelStateDto)((TerminalInitialStateEvent)$event).getOutputModelState()));
        this$0.alternateBufferModel.restoreFromState(TerminalOutputModelStateDtoKt.toState((TerminalOutputModelStateDto)((TerminalInitialStateEvent)$event).getAlternateBufferState()));
        this$0.blocksModel.restoreFromState(TerminalBlocksModelStateDtoKt.toState((TerminalBlocksModelStateDto)((TerminalInitialStateEvent)$event).getBlocksModelState()));
        return Unit.INSTANCE;
    }

    private static final Unit handleEvent$lambda$5(TerminalSessionController this$0, TerminalOutputEvent $event, TerminalOutputModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this$0.fusActivity.beforeModelUpdate();
        this$0.updateOutputModelContent(model, (TerminalContentUpdatedEvent)$event);
        this$0.fusActivity.afterModelUpdate();
        return Unit.INSTANCE;
    }

    private static final Unit handleEvent$lambda$6(TerminalOutputEvent $event, TerminalOutputModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        model.updateCursorPosition(((TerminalCursorPositionChangedEvent)$event).getLogicalLineIndex(), ((TerminalCursorPositionChangedEvent)$event).getColumnIndex());
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$doHandleEvents(TerminalSessionController $this, List events, Continuation $completion) {
        return $this.doHandleEvents(events, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$handleEvent(TerminalSessionController $this, TerminalOutputEvent event, Continuation $completion) {
        return $this.handleEvent(event, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ TerminalBlocksModel access$getBlocksModel$p(TerminalSessionController $this) {
        return $this.blocksModel;
    }

    public static final /* synthetic */ TerminalOutputModel access$getOutputModel$p(TerminalSessionController $this) {
        return $this.outputModel;
    }

    public static final /* synthetic */ Object access$updateOutputModel(TerminalSessionController $this, Function1 block, Continuation $completion) {
        return $this.updateOutputModel((Function1<? super TerminalOutputModel, Unit>)block, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Project access$getProject$p(TerminalSessionController $this) {
        return $this.project;
    }

    public static final /* synthetic */ TerminalOutputModel access$getCurrentOutputModel(TerminalSessionController $this) {
        return $this.getCurrentOutputModel();
    }
}

