/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.EntryStream;
import one.util.streamex.Internals;
import one.util.streamex.StreamContext;

public class StreamEx<T>
extends AbstractStreamEx<T, StreamEx<T>> {
    StreamEx(Stream<? extends T> stream, StreamContext context) {
        super(stream, context);
    }

    StreamEx(Spliterator<? extends T> spliterator, StreamContext context) {
        super(spliterator, context);
    }

    @Override
    StreamEx<T> supply(Stream<T> stream) {
        return new StreamEx<T>(stream, this.context);
    }

    public <TT> StreamEx<TT> select(Class<TT> clazz) {
        return (StreamEx)this.filter(clazz::isInstance);
    }

    public <K, V> EntryStream<K, V> mapToEntry(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return new EntryStream(((Stream)this.stream()).map((? super T e) -> new AbstractMap.SimpleImmutableEntry(keyMapper.apply(e), valueMapper.apply(e))), this.context);
    }

    public <A> A[] toArray(A[] emptyArray) {
        if (emptyArray.length != 0) {
            throw new IllegalArgumentException("Empty array must be supplied");
        }
        return ((Stream)this.stream()).toArray(size -> size == 0 ? emptyArray : (Object[])Array.newInstance(emptyArray.getClass().getComponentType(), size));
    }

    @SafeVarargs
    public static <T> StreamEx<T> of(T ... elements) {
        return StreamEx.of(Arrays.spliterator(elements));
    }

    public static <T> StreamEx<T> of(Collection<? extends T> collection) {
        return StreamEx.of(collection.spliterator());
    }

    public static <T> StreamEx<T> of(Spliterator<? extends T> spliterator) {
        return new StreamEx<T>(spliterator, StreamContext.SEQUENTIAL);
    }

    public static <T> StreamEx<T> iterate(T seed, UnaryOperator<T> f) {
        return StreamEx.iterate(seed, Internals.alwaysTrue(), f);
    }

    public static <T> StreamEx<T> iterate(final T seed, final Predicate<? super T> predicate, final UnaryOperator<T> f) {
        Objects.requireNonNull(f);
        Objects.requireNonNull(predicate);
        Spliterators.AbstractSpliterator spliterator = new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 1040){
            T prev;
            boolean started;
            boolean finished;

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                Object t;
                Objects.requireNonNull(action);
                if (this.finished) {
                    return false;
                }
                if (this.started) {
                    t = f.apply(this.prev);
                } else {
                    t = seed;
                    this.started = true;
                }
                if (!predicate.test(t)) {
                    this.prev = null;
                    this.finished = true;
                    return false;
                }
                this.prev = t;
                action.accept(this.prev);
                return true;
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action) {
                Objects.requireNonNull(action);
                if (this.finished) {
                    return;
                }
                this.finished = true;
                Object t = this.started ? f.apply(this.prev) : seed;
                this.prev = null;
                while (predicate.test(t)) {
                    action.accept(t);
                    t = f.apply(t);
                }
            }
        };
        return StreamEx.of(spliterator);
    }
}

