/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.util.hash;

import com.jetbrains.rd.util.hash.PersistentHash;
import java.io.File;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000b\u001a\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u0000J\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\b2\u0006\u0010\u0014\u001a\u00020\u0007H\u0086\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cJ$\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001c2\u0014\b\u0002\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00100 J\u000e\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006%"}, d2={"Lcom/jetbrains/rd/util/hash/PersistentHash;", "", "()V", "format", "Ljava/text/SimpleDateFormat;", "items", "Ljava/util/SortedMap;", "", "Ljava/util/SortedSet;", "getItems", "()Ljava/util/SortedMap;", "encode", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "str", "equals", "", "other", "firstDiff", "get", "key", "hashCode", "", "mix", "", "value", "mixFile", "f", "Ljava/io/File;", "mixFileRecursively", "folder", "filter", "Lkotlin/Function1;", "store", "file", "Ljava/nio/file/Path;", "Companion", "rd-gen"})
@SourceDebugExtension(value={"SMAP\nPersistentHash.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistentHash.kt\ncom/jetbrains/rd/util/hash/PersistentHash\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,112:1\n1#2:113\n1295#3,2:114\n*S KotlinDebug\n*F\n+ 1 PersistentHash.kt\ncom/jetbrains/rd/util/hash/PersistentHash\n*L\n110#1:114,2\n*E\n"})
public final class PersistentHash {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SortedMap<String, SortedSet<String>> items = MapsKt.sortedMapOf((Pair[])new Pair[0]);
    @NotNull
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS");

    @NotNull
    public final SortedMap<String, SortedSet<String>> getItems() {
        return this.items;
    }

    public final void mix(@NotNull String key, @Nullable String value2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (value2 == null) {
            return;
        }
        Pair pair = TuplesKt.to((Object)key, (Object)value2);
        String k = (String)pair.component1();
        String v = (String)pair.component2();
        SortedSet sortedSet = (SortedSet)this.items.get(k);
        if (sortedSet == null) {
            TreeSet treeSet;
            TreeSet it = treeSet = new TreeSet();
            boolean bl = false;
            ((Map)this.items).put(k, it);
            sortedSet = treeSet;
        }
        SortedSet values = sortedSet;
        values.add(v);
    }

    private final StringBuilder encode(String str) {
        StringBuilder stringBuilder;
        StringBuilder $this$encode_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            char c2 = c;
            $this$encode_u24lambda_u241.append((String)(((c2 == '=' ? true : c2 == ',') ? true : c2 == '\\') ? "\\" + c : (c2 == '\r' ? "\\r" : (c2 == '\n' ? "\\n" : String.valueOf(c)))));
        }
        return stringBuilder;
    }

    public final void store(@NotNull Path file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : ((Map)this.items).entrySet()) {
            String k = (String)entry.getKey();
            SortedSet lst = (SortedSet)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)k, (String)"k");
            sb.append((CharSequence)this.encode(k));
            sb.append('=');
            Intrinsics.checkNotNullExpressionValue((Object)lst, (String)"lst");
            sb.append(CollectionsKt.joinToString$default((Iterable)lst, (CharSequence)",", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(this){
                final /* synthetic */ PersistentHash this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(String it) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    return PersistentHash.access$encode(this.this$0, it);
                }
            }), (int)30, null));
            sb.append(System.lineSeparator());
        }
        File toFile = file2.toFile();
        toFile.getParentFile().mkdirs();
        Intrinsics.checkNotNullExpressionValue((Object)toFile, (String)"toFile");
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sb.toString()");
        FilesKt.writeText$default((File)toFile, (String)string2, null, (int)2, null);
    }

    @NotNull
    public final SortedSet<String> get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SortedSet sortedSet = (SortedSet)this.items.get(key);
        if (sortedSet == null) {
            sortedSet = SetsKt.sortedSetOf((Object[])new String[0]);
        }
        return sortedSet;
    }

    public boolean equals(@Nullable Object other2) {
        if (this == other2) {
            return true;
        }
        Object object = other2;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other2, (String)"null cannot be cast to non-null type com.jetbrains.rd.util.hash.PersistentHash");
        PersistentHash cfr_ignored_0 = (PersistentHash)other2;
        return Intrinsics.areEqual(this.items, ((PersistentHash)other2).items);
    }

    public int hashCode() {
        return this.items.hashCode();
    }

    @Nullable
    public final String firstDiff(@NotNull PersistentHash other2) {
        SortedSet v;
        String k;
        Intrinsics.checkNotNullParameter((Object)other2, (String)"other");
        for (Map.Entry entry : ((Map)this.items).entrySet()) {
            k = (String)entry.getKey();
            v = (SortedSet)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)k, (String)"k");
            if (Intrinsics.areEqual(other2.get(k), (Object)v)) continue;
            return k;
        }
        for (Map.Entry entry : ((Map)other2.items).entrySet()) {
            k = (String)entry.getKey();
            v = (SortedSet)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)k, (String)"k");
            if (Intrinsics.areEqual(this.get(k), (Object)v)) continue;
            return k;
        }
        return null;
    }

    public final void mixFile(@NotNull File f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        if (f.exists()) {
            this.mix("file: " + f.getCanonicalPath(), this.format.format(new Date(f.lastModified())));
        }
    }

    public final void mixFileRecursively(@NotNull File folder, @NotNull Function1<? super File, Boolean> filter2) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)folder)), filter2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            this.mixFile(it);
        }
    }

    public static /* synthetic */ void mixFileRecursively$default(PersistentHash persistentHash, File file2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = mixFileRecursively.1.INSTANCE;
        }
        persistentHash.mixFileRecursively(file2, (Function1<? super File, Boolean>)function1);
    }

    public static final /* synthetic */ StringBuilder access$encode(PersistentHash $this, String str) {
        return $this.encode(str);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rd/util/hash/PersistentHash$Companion;", "", "()V", "load", "Lcom/jetbrains/rd/util/hash/PersistentHash;", "path", "Ljava/nio/file/Path;", "rd-gen"})
    @SourceDebugExtension(value={"SMAP\nPersistentHash.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistentHash.kt\ncom/jetbrains/rd/util/hash/PersistentHash$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n766#2:113\n857#2,2:114\n1855#2,2:116\n*S KotlinDebug\n*F\n+ 1 PersistentHash.kt\ncom/jetbrains/rd/util/hash/PersistentHash$Companion\n*L\n15#1:113\n15#1:114,2\n16#1:116,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final PersistentHash load(@NotNull Path path) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            PersistentHash persistentHash;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            PersistentHash $this$load_u24lambda_u242 = persistentHash = new PersistentHash();
            boolean bl = false;
            File file2 = path.toFile();
            if (!file2.isFile()) {
                return new PersistentHash();
            }
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
            Iterable iterable = FilesKt.readLines$default((File)file2, null, (int)1, null);
            boolean $i$f$filter = false;
            Iterator iterator2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (!(!StringsKt.isBlank((CharSequence)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String line = (String)element$iv;
                boolean bl3 = false;
                StringBuilder builder = new StringBuilder();
                String key = null;
                for (int i = 0; i < line.length(); ++i) {
                    char c = line.charAt(i);
                    if (c == '\\') {
                        if (line.charAt(++i) == 'r') {
                            builder.append('\r');
                            continue;
                        }
                        if (line.charAt(i) == 'n') {
                            builder.append('\n');
                            continue;
                        }
                        builder.append(line.charAt(i));
                        continue;
                    }
                    if (c == '=') {
                        key = builder.toString();
                        builder = new StringBuilder();
                        continue;
                    }
                    if (c == ',') {
                        String string2 = key;
                        Intrinsics.checkNotNull((Object)string2);
                        $this$load_u24lambda_u242.mix(string2, builder.toString());
                        builder = new StringBuilder();
                        continue;
                    }
                    builder.append(line.charAt(i));
                }
                String string3 = key;
                Intrinsics.checkNotNull(string3);
                $this$load_u24lambda_u242.mix(string3, builder.toString());
            }
            return persistentHash;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

