/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassUtil {
    private ClassUtil() {
    }

    @Nullable
    public static PsiMethod getAnyAbstractMethod(@NotNull PsiClass aClass) {
        if (aClass == null) {
            ClassUtil.$$$reportNull$$$0(0);
        }
        for (PsiMethod method : aClass.getMethods()) {
            if (!method.hasModifierProperty("abstract")) continue;
            return method;
        }
        return ClassUtil.getAnyMethodToImplement(aClass);
    }

    @Nullable
    public static PsiMethod getAnyMethodToImplement(@NotNull PsiClass aClass) {
        PsiClass superClass;
        if (aClass == null) {
            ClassUtil.$$$reportNull$$$0(1);
        }
        PsiClass psiClass = superClass = aClass instanceof PsiAnonymousClass ? PsiUtil.resolveClassInClassTypeOnly(((PsiAnonymousClass)aClass).getBaseClassType()) : aClass.getSuperClass();
        if (superClass != null && !superClass.hasModifierProperty("abstract") && !superClass.isEnum() && aClass.getImplementsListTypes().length == 0) {
            return null;
        }
        HashSet alreadyImplemented = new HashSet();
        for (HierarchicalMethodSignature signatureHierarchical : aClass.getVisibleSignatures()) {
            for (PsiMethod superS : signatureHierarchical.getMethod().findSuperMethods()) {
                ClassUtil.add(superS, alreadyImplemented);
            }
        }
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance(aClass.getProject()).getResolveHelper();
        for (HierarchicalMethodSignature signatureHierarchical : aClass.getVisibleSignatures()) {
            PsiMethod method = signatureHierarchical.getMethod();
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || "java.lang.Record".equals(containingClass.getQualifiedName())) continue;
            if (!(aClass.equals(containingClass) || !method.hasModifierProperty("abstract") || method.hasModifierProperty("static") || method.hasModifierProperty("private") || alreadyImplemented.contains(method))) {
                return method;
            }
            ArrayList<HierarchicalMethodSignature> superSignatures = new ArrayList<HierarchicalMethodSignature>(signatureHierarchical.getInaccessibleSuperSignatures());
            superSignatures.addAll(signatureHierarchical.getSuperSignatures());
            for (HierarchicalMethodSignature superSignatureHierarchical : superSignatures) {
                PsiMethod superMethod = superSignatureHierarchical.getMethod();
                if (!superMethod.hasModifierProperty("abstract") || resolveHelper.isAccessible(superMethod, method, null)) continue;
                return superMethod;
            }
        }
        return null;
    }

    private static boolean add(PsiMethod method, @NotNull Set<? super PsiMethod> alreadyImplemented) {
        boolean already;
        if (alreadyImplemented == null) {
            ClassUtil.$$$reportNull$$$0(2);
        }
        if (!(already = alreadyImplemented.add(method))) {
            return false;
        }
        for (PsiMethod superSig : method.findSuperMethods()) {
            already &= ClassUtil.add(superSig, alreadyImplemented);
        }
        return already;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alreadyImplemented";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/ClassUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnyAbstractMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnyMethodToImplement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

