/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u000e\b&\u0018\u00002\u00020\u0001B(\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u0018\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u0011\u0010\u001a\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u0011\u0010\u001c\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013R\u0011\u0010\u001d\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/resolve/CommonCompilerDeserializationConfiguration;", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationConfiguration;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "toMetadataVersion", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "Lkotlin/ExtensionFunctionType;", "<init>", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lkotlin/jvm/functions/Function1;)V", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "metadataVersion", "getMetadataVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "skipMetadataVersionCheck", "", "getSkipMetadataVersionCheck", "()Z", "skipPrereleaseCheck", "getSkipPrereleaseCheck", "reportErrorsOnPreReleaseDependencies", "getReportErrorsOnPreReleaseDependencies", "allowUnstableDependencies", "getAllowUnstableDependencies", "typeAliasesAllowed", "getTypeAliasesAllowed", "isJvmPackageNameSupported", "readDeserializedContracts", "getReadDeserializedContracts", "frontend"})
public abstract class CommonCompilerDeserializationConfiguration
implements DeserializationConfiguration {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final MetadataVersion metadataVersion;
    private final boolean skipMetadataVersionCheck;
    private final boolean skipPrereleaseCheck;
    private final boolean reportErrorsOnPreReleaseDependencies;
    private final boolean allowUnstableDependencies;
    private final boolean typeAliasesAllowed;
    private final boolean isJvmPackageNameSupported;
    private final boolean readDeserializedContracts;

    public CommonCompilerDeserializationConfiguration(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull Function1<? super LanguageVersion, MetadataVersion> toMetadataVersion) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter(toMetadataVersion, (String)"toMetadataVersion");
        this.languageVersionSettings = languageVersionSettings;
        this.metadataVersion = (MetadataVersion)toMetadataVersion.invoke((Object)this.languageVersionSettings.getLanguageVersion());
        this.skipMetadataVersionCheck = (Boolean)this.languageVersionSettings.getFlag(AnalysisFlags.getSkipMetadataVersionCheck());
        this.skipPrereleaseCheck = (Boolean)this.languageVersionSettings.getFlag(AnalysisFlags.getSkipPrereleaseCheck());
        this.reportErrorsOnPreReleaseDependencies = !this.skipPrereleaseCheck && !this.languageVersionSettings.isPreRelease() && !KotlinCompilerVersion.isPreRelease();
        this.allowUnstableDependencies = (Boolean)this.languageVersionSettings.getFlag(AnalysisFlags.getAllowUnstableDependencies());
        this.typeAliasesAllowed = this.languageVersionSettings.supportsFeature(LanguageFeature.TypeAliases);
        this.isJvmPackageNameSupported = this.languageVersionSettings.supportsFeature(LanguageFeature.JvmPackageName);
        this.readDeserializedContracts = this.languageVersionSettings.supportsFeature(LanguageFeature.ReadDeserializedContracts);
    }

    @NotNull
    protected final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    @Override
    @NotNull
    public MetadataVersion getMetadataVersion() {
        return this.metadataVersion;
    }

    @Override
    public final boolean getSkipMetadataVersionCheck() {
        return this.skipMetadataVersionCheck;
    }

    @Override
    public final boolean getSkipPrereleaseCheck() {
        return this.skipPrereleaseCheck;
    }

    @Override
    public final boolean getReportErrorsOnPreReleaseDependencies() {
        return this.reportErrorsOnPreReleaseDependencies;
    }

    @Override
    public final boolean getAllowUnstableDependencies() {
        return this.allowUnstableDependencies;
    }

    @Override
    public final boolean getTypeAliasesAllowed() {
        return this.typeAliasesAllowed;
    }

    @Override
    public final boolean isJvmPackageNameSupported() {
        return this.isJvmPackageNameSupported;
    }

    @Override
    public final boolean getReadDeserializedContracts() {
        return this.readDeserializedContracts;
    }
}

