/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.suggested;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.suggested.BaseSignatureChangePresentationTestKt;
import com.intellij.refactoring.suggested.LightJavaCodeInsightFixtureTestCaseWithUtils;
import com.intellij.refactoring.suggested.SignatureChangePresentationModel;
import com.intellij.refactoring.suggested.SuggestedChangeSignatureData;
import com.intellij.refactoring.suggested.SuggestedRefactoringData;
import com.intellij.refactoring.suggested.SuggestedRefactoringProviderImpl;
import com.intellij.refactoring.suggested.SuggestedRefactoringState;
import com.intellij.refactoring.suggested.SuggestedRefactoringSupport;
import com.intellij.testFramework.fixtures.LightJavaCodeInsightFixtureTestCase;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0014J:\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u001aH\u0004J6\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u001aH\u0004J<\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00152\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\u001a2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u001aH\u0002J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0004R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\r\u00a8\u0006$"}, d2={"Lcom/intellij/refactoring/suggested/BaseSuggestedRefactoringTest;", "Lcom/intellij/refactoring/suggested/LightJavaCodeInsightFixtureTestCaseWithUtils;", "<init>", "()V", "fileType", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "getFileType", "()Lcom/intellij/openapi/fileTypes/LanguageFileType;", "ignoreErrorsBefore", "", "getIgnoreErrorsBefore", "()Z", "setIgnoreErrorsBefore", "(Z)V", "ignoreErrorsAfter", "getIgnoreErrorsAfter", "setIgnoreErrorsAfter", "setUp", "", "doTestChangeSignature", "initialText", "", "expectedTextAfter", "usagesName", "expectedPresentation", "editingActions", "Lkotlin/Function0;", "doTestRename", "textAfterRefactoring", "oldName", "newName", "doTest", "actionName", "checkPresentation", "suggestedRefactoringIntention", "Lcom/intellij/codeInsight/intention/IntentionAction;", "intellij.java.testFramework"})
@SourceDebugExtension(value={"SMAP\nBaseSuggestedRefactoringTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseSuggestedRefactoringTest.kt\ncom/intellij/refactoring/suggested/BaseSuggestedRefactoringTest\n+ 2 actions.kt\ncom/intellij/openapi/command/ActionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n7#2,6:123\n295#3,2:129\n1#4:131\n*S KotlinDebug\n*F\n+ 1 BaseSuggestedRefactoringTest.kt\ncom/intellij/refactoring/suggested/BaseSuggestedRefactoringTest\n*L\n93#1:123,6\n119#1:129,2\n*E\n"})
public abstract class BaseSuggestedRefactoringTest
extends LightJavaCodeInsightFixtureTestCaseWithUtils {
    private boolean ignoreErrorsBefore;
    private boolean ignoreErrorsAfter;

    @NotNull
    protected abstract LanguageFileType getFileType();

    protected final boolean getIgnoreErrorsBefore() {
        return this.ignoreErrorsBefore;
    }

    protected final void setIgnoreErrorsBefore(boolean bl) {
        this.ignoreErrorsBefore = bl;
    }

    protected final boolean getIgnoreErrorsAfter() {
        return this.ignoreErrorsAfter;
    }

    protected final void setIgnoreErrorsAfter(boolean bl) {
        this.ignoreErrorsAfter = bl;
    }

    @Override
    protected void setUp() {
        this.ignoreErrorsBefore = false;
        this.ignoreErrorsAfter = false;
        super.setUp();
    }

    protected final void doTestChangeSignature(@NotNull String initialText, @NotNull String expectedTextAfter, @NotNull String usagesName, @Nullable String expectedPresentation, @NotNull Function0<Unit> editingActions) {
        Intrinsics.checkNotNullParameter((Object)initialText, (String)"initialText");
        Intrinsics.checkNotNullParameter((Object)expectedTextAfter, (String)"expectedTextAfter");
        Intrinsics.checkNotNullParameter((Object)usagesName, (String)"usagesName");
        Intrinsics.checkNotNullParameter(editingActions, (String)"editingActions");
        Object[] objectArray = new Object[]{usagesName};
        String string = RefactoringBundle.message((String)"suggested.refactoring.change.signature.intention.text", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.doTest(initialText, string, expectedTextAfter, (Function0<Unit>)((Function0)() -> BaseSuggestedRefactoringTest.doTestChangeSignature$lambda$1(expectedPresentation, this)), editingActions);
    }

    public static /* synthetic */ void doTestChangeSignature$default(BaseSuggestedRefactoringTest baseSuggestedRefactoringTest, String string, String string2, String string3, String string4, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doTestChangeSignature");
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        baseSuggestedRefactoringTest.doTestChangeSignature(string, string2, string3, string4, (Function0<Unit>)function0);
    }

    protected final void doTestRename(@NotNull String initialText, @NotNull String textAfterRefactoring, @NotNull String oldName, @NotNull String newName, @NotNull Function0<Unit> editingActions) {
        Intrinsics.checkNotNullParameter((Object)initialText, (String)"initialText");
        Intrinsics.checkNotNullParameter((Object)textAfterRefactoring, (String)"textAfterRefactoring");
        Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(editingActions, (String)"editingActions");
        Object[] objectArray = new Object[]{oldName};
        String string = RefactoringBundle.message((String)"suggested.refactoring.rename.intention.text", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.doTest(initialText, string, textAfterRefactoring, (Function0<Unit>)((Function0)BaseSuggestedRefactoringTest::doTestRename$lambda$2), editingActions);
    }

    private final void doTest(String initialText, String actionName, String textAfterRefactoring, Function0<Unit> checkPresentation, Function0<Unit> editingActions) {
        this.myFixture.configureByText((FileType)this.getFileType(), initialText);
        if (!this.ignoreErrorsBefore) {
            this.myFixture.testHighlighting(false, false, false, this.myFixture.getFile().getVirtualFile());
        } else {
            List<HighlightInfo> list = this.myFixture.doHighlighting();
            Intrinsics.checkNotNull(list);
        }
        this.executeEditingActions(editingActions);
        IntentionAction intention = this.suggestedRefactoringIntention();
        LightJavaCodeInsightFixtureTestCase.assertNotNull((String)"No refactoring available", (Object)intention);
        IntentionAction intentionAction = intention;
        Intrinsics.checkNotNull((Object)intentionAction);
        LightJavaCodeInsightFixtureTestCase.assertEquals((String)"Action name", (String)actionName, (String)intentionAction.getText());
        checkPresentation.invoke();
        Project project$iv = this.getProject();
        String name$iv = null;
        Object groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(intention, this){
            final /* synthetic */ IntentionAction $intention$inlined;
            final /* synthetic */ BaseSuggestedRefactoringTest this$0;
            {
                this.$intention$inlined = intentionAction;
                this.this$0 = baseSuggestedRefactoringTest;
            }

            public final void run() {
                boolean bl = false;
                this.$intention$inlined.invoke(BaseSuggestedRefactoringTest.access$getProject(this.this$0), BaseSuggestedRefactoringTest.access$getEditor(this.this$0), BaseSuggestedRefactoringTest.access$getFile(this.this$0));
                ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ BaseSuggestedRefactoringTest this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final void invoke() {
                        PostprocessReformattingAspect.getInstance((Project)BaseSuggestedRefactoringTest.access$getProject(this.this$0)).doPostponedFormatting();
                    }
                }));
            }
        }, name$iv, groupId$iv);
        int index = StringsKt.indexOf$default((CharSequence)textAfterRefactoring, (String)"<caret>", (int)0, (boolean)false, (int)6, null);
        if (index >= 0) {
            String string = textAfterRefactoring.substring(0, index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = textAfterRefactoring.substring(index + 7);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String text = string + string2;
            LightJavaCodeInsightFixtureTestCase.assertEquals((String)text, (String)this.getEditor().getDocument().getText());
            LightJavaCodeInsightFixtureTestCase.assertEquals((String)"Caret position", (int)index, (int)this.getEditor().getCaretModel().getOffset());
        } else {
            LightJavaCodeInsightFixtureTestCase.assertEquals((String)textAfterRefactoring, (String)this.getEditor().getDocument().getText());
        }
        if (!this.ignoreErrorsAfter) {
            this.myFixture.testHighlighting(false, false, false, this.myFixture.getFile().getVirtualFile());
        }
    }

    @Nullable
    protected final IntentionAction suggestedRefactoringIntention() {
        Object v1;
        block1: {
            List<IntentionAction> list = this.myFixture.getAvailableIntentions();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getAvailableIntentions(...)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IntentionAction it = (IntentionAction)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getFamilyName(), (Object)"Suggested Refactoring")) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private static final Unit doTestChangeSignature$lambda$1(String $expectedPresentation, BaseSuggestedRefactoringTest this$0) {
        if ($expectedPresentation != null) {
            Project project = this$0.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            SuggestedRefactoringState suggestedRefactoringState = SuggestedRefactoringProviderImpl.Companion.getInstance(project).getState();
            Intrinsics.checkNotNull((Object)suggestedRefactoringState);
            SuggestedRefactoringState it = suggestedRefactoringState;
            boolean bl = false;
            SuggestedRefactoringState state = it.getRefactoringSupport().getAvailability().refineSignaturesWithResolve(it);
            LightJavaCodeInsightFixtureTestCase.assertEquals((Object)SuggestedRefactoringState.ErrorLevel.NO_ERRORS, (Object)state.getErrorLevel());
            Assert.assertNotEquals((Object)state.getOldSignature(), (Object)state.getNewSignature());
            SuggestedRefactoringSupport refactoringSupport = state.getRefactoringSupport();
            SuggestedRefactoringData suggestedRefactoringData = refactoringSupport.getAvailability().detectAvailableRefactoring(state);
            Intrinsics.checkNotNull((Object)suggestedRefactoringData, (String)"null cannot be cast to non-null type com.intellij.refactoring.suggested.SuggestedChangeSignatureData");
            SuggestedChangeSignatureData data = (SuggestedChangeSignatureData)suggestedRefactoringData;
            SignatureChangePresentationModel model = refactoringSupport.getUi().buildSignatureChangePresentation(data.getOldSignature(), data.getNewSignature());
            LightJavaCodeInsightFixtureTestCase.assertEquals((String)$expectedPresentation, (String)((Object)StringsKt.trim((CharSequence)BaseSignatureChangePresentationTestKt.dump(model))).toString());
        }
        return Unit.INSTANCE;
    }

    private static final Unit doTestRename$lambda$2() {
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Project access$getProject(BaseSuggestedRefactoringTest $this) {
        return $this.getProject();
    }

    public static final /* synthetic */ Editor access$getEditor(BaseSuggestedRefactoringTest $this) {
        return $this.getEditor();
    }

    public static final /* synthetic */ PsiFile access$getFile(BaseSuggestedRefactoringTest $this) {
        return $this.getFile();
    }
}

