macro(configure_sdl_sound _NAME_TARGET _ONLY_DEFINES)
    set(PREVIOUS_INVOCATION ${CONFIGURE_SDL_SOUND_INVOKED_PREVIOUSLY})
    find_package(PkgConfig REQUIRED)
    pkg_check_modules(SDL QUIET IMPORTED_TARGET sdl)
    pkg_check_modules(SDL_MIXER QUIET IMPORTED_TARGET SDL_mixer)
    if(SDL_FOUND AND SDL_MIXER_FOUND)
        if(NOT _ONLY_DEFINES)
            TARGET_LINK_LIBRARIES(${_NAME_TARGET} PRIVATE PkgConfig::SDL PkgConfig::SDL_MIXER)
        endif()
        target_compile_definitions(${_NAME_TARGET} PRIVATE SOUND_SDL SOUND)
        if(NOT PREVIOUS_INVOCATION)
            message(STATUS "Support for sound with SDL - Ready")
        endif()
        set(CONFIGURE_SDL_SOUND_INVOKED_PREVIOUSLY YES CACHE
            INTERNAL "Mark if CONFIGURE_SDL_SOUND called successfully" FORCE)
    else()
        message(FATAL_ERROR "Support for sound with SDL - Failed")
    endif()
endmacro()
