//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// `NSItemBadge` represents a badge that can be attached to an `NSToolbarItem`.
    ///
    /// This badge provides a way to display small visual indicators, such as counts and text labels, within a toolbar item. Badges can be used to highlight important information,
    /// such as unread notifications or status indicators.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsitembadge?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSItemBadge;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSItemBadge {}
);

impl NSItemBadge {
    extern_methods!(
        /// Creates a badge displaying a localized numerical count.
        ///
        ///
        /// Parameter `count`: The integer value to localize and display in the badge.
        ///
        /// Returns: A new NSItemBadge instance with the localized specified count.
        #[unsafe(method(badgeWithCount:))]
        #[unsafe(method_family = none)]
        pub fn badgeWithCount(count: NSInteger) -> Retained<NSItemBadge>;

        /// Creates a badge displaying a text.
        ///
        ///
        /// Parameter `text`: The text to be displayed inside the badge.
        ///
        /// Returns: A new `NSItemBadge` instance with the specified text.
        #[unsafe(method(badgeWithText:))]
        #[unsafe(method_family = none)]
        pub fn badgeWithText(text: &NSString) -> Retained<NSItemBadge>;

        /// Creates a badge styled as an indicator. In this context, an indicator is simply a badge without any text.
        ///
        ///
        /// Returns: A new `NSItemBadge` instance styled as an indicator.
        #[unsafe(method(indicatorBadge))]
        #[unsafe(method_family = none)]
        pub fn indicatorBadge() -> Retained<NSItemBadge>;

        /// The text to be displayed within the badge.
        #[unsafe(method(text))]
        #[unsafe(method_family = none)]
        pub fn text(&self) -> Retained<NSString>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSItemBadge {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSItemBadge {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}
