/***************************************************************************
              builtinpalettes.h: data for builting palettes
                             -------------------
    begin                : September, 2010
    copyright            : (C) 2010 The University of Toronto
    email                : netterfield@astro.utoronto.ca
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BUILTINPALETTES_H
#define BUILTINPALETTES_H

namespace Kst {

static const int KstGrayscaleCount = 255;
static const QString KstGrayscaleName = "Kst Grayscale";

static const char *const KstColors[] = { "red",
                                      "blue",
                                      "green",
                                      "black",
                                      "magenta",
                                      "steelblue",
                                      "#501010",
                                      "#105010"
                                      };
static const int KstColorsCount = sizeof(KstColors) / sizeof(char*);
static const QString KstColorsName = "Kst Colors";

static const int CycleCount = 1021;
static const QString CycleName = "Spectrum (Cyclical)";
static unsigned char Cycle[1022][3] = {
{128, 238, 17},
{128, 238, 16},
{129, 238, 16},
{130, 237, 15},
{131, 237, 15},
{131, 236, 15},
{132, 236, 14},
{133, 235, 14},
{134, 235, 14},
{135, 235, 13},
{135, 234, 13},
{136, 234, 13},
{137, 233, 12},
{138, 233, 12},
{139, 232, 12},
{139, 232, 11},
{140, 232, 11},
{141, 231, 11},
{142, 231, 10},
{142, 230, 10},
{143, 230, 10},
{144, 229, 9},
{145, 229, 9},
{146, 228, 9},
{146, 228, 8},
{147, 227, 8},
{148, 227, 8},
{149, 226, 8},
{149, 226, 7},
{150, 225, 7},
{151, 225, 7},
{152, 224, 7},
{153, 224, 6},
{153, 223, 6},
{154, 223, 6},
{155, 222, 6},
{156, 222, 5},
{156, 221, 5},
{157, 221, 5},
{158, 220, 5},
{159, 219, 4},
{159, 219, 4},
{160, 218, 4},
{161, 218, 4},
{162, 217, 4},
{162, 217, 3},
{163, 216, 3},
{164, 215, 3},
{165, 215, 3},
{166, 214, 3},
{166, 214, 2},
{167, 213, 2},
{168, 213, 2},
{169, 212, 2},
{169, 211, 2},
{170, 211, 2},
{171, 210, 2},
{171, 210, 1},
{172, 209, 1},
{173, 208, 1},
{174, 208, 1},
{174, 207, 1},
{175, 207, 1},
{176, 206, 1},
{177, 205, 1},
{177, 205, 0},
{178, 204, 0},
{179, 203, 0},
{180, 203, 0},
{180, 202, 0},
{181, 201, 0},
{182, 201, 0},
{182, 200, 0},
{183, 200, 0},
{184, 199, 0},
{185, 198, 0},
{185, 198, 0},
{186, 197, 0},
{187, 196, 0},
{187, 196, 0},
{188, 195, 0},
{189, 194, 0},
{189, 194, 0},
{190, 193, 0},
{191, 192, 0},
{191, 192, 0},
{192, 191, 0},
{193, 190, 0},
{193, 190, 0},
{194, 189, 0},
{195, 188, 0},
{195, 187, 0},
{196, 187, 0},
{197, 186, 0},
{197, 185, 0},
{198, 185, 0},
{199, 184, 0},
{199, 183, 0},
{200, 182, 0},
{201, 182, 0},
{201, 181, 0},
{202, 180, 0},
{203, 180, 0},
{203, 179, 0},
{204, 178, 0},
{205, 177, 0},
{205, 177, 1},
{206, 176, 1},
{206, 175, 1},
{207, 175, 1},
{208, 174, 1},
{208, 173, 1},
{209, 172, 1},
{210, 172, 1},
{210, 171, 2},
{211, 170, 2},
{211, 169, 2},
{212, 169, 2},
{212, 168, 2},
{213, 167, 2},
{214, 166, 2},
{214, 166, 3},
{215, 165, 3},
{215, 164, 3},
{216, 163, 3},
{217, 163, 3},
{217, 162, 4},
{218, 161, 4},
{218, 160, 4},
{219, 160, 4},
{219, 159, 4},
{220, 158, 5},
{220, 157, 5},
{221, 157, 5},
{221, 156, 5},
{222, 155, 5},
{223, 154, 6},
{223, 153, 6},
{224, 153, 6},
{224, 152, 6},
{225, 151, 7},
{225, 150, 7},
{226, 150, 7},
{226, 149, 8},
{227, 148, 8},
{227, 147, 8},
{228, 146, 8},
{228, 146, 9},
{229, 145, 9},
{229, 144, 9},
{230, 143, 10},
{230, 143, 10},
{231, 142, 10},
{231, 141, 11},
{231, 140, 11},
{232, 139, 11},
{232, 139, 11},
{233, 138, 12},
{233, 137, 12},
{234, 136, 13},
{234, 136, 13},
{235, 135, 13},
{235, 134, 14},
{235, 133, 14},
{236, 132, 14},
{236, 132, 15},
{237, 131, 15},
{237, 130, 15},
{237, 129, 16},
{238, 128, 16},
{238, 128, 17},
{239, 127, 17},
{239, 126, 17},
{239, 125, 18},
{240, 124, 18},
{240, 124, 19},
{241, 123, 19},
{241, 122, 19},
{241, 121, 20},
{242, 121, 20},
{242, 120, 21},
{242, 119, 21},
{243, 118, 22},
{243, 117, 22},
{243, 117, 22},
{244, 116, 23},
{244, 115, 23},
{244, 114, 24},
{245, 113, 24},
{245, 113, 25},
{245, 112, 25},
{246, 111, 26},
{246, 110, 26},
{246, 110, 27},
{247, 109, 27},
{247, 108, 28},
{247, 107, 28},
{247, 106, 29},
{248, 106, 29},
{248, 105, 30},
{248, 104, 30},
{248, 103, 31},
{249, 103, 31},
{249, 102, 32},
{249, 101, 32},
{249, 100, 33},
{250, 100, 33},
{250, 99, 34},
{250, 98, 34},
{250, 97, 35},
{251, 96, 35},
{251, 96, 36},
{251, 95, 37},
{251, 94, 37},
{251, 93, 38},
{252, 93, 38},
{252, 92, 39},
{252, 91, 39},
{252, 90, 40},
{252, 90, 41},
{253, 89, 41},
{253, 88, 42},
{253, 87, 42},
{253, 87, 43},
{253, 86, 43},
{253, 85, 44},
{253, 84, 45},
{254, 84, 45},
{254, 83, 46},
{254, 82, 47},
{254, 81, 47},
{254, 81, 48},
{254, 80, 48},
{254, 79, 49},
{254, 79, 50},
{255, 78, 50},
{255, 77, 51},
{255, 76, 51},
{255, 76, 52},
{255, 75, 53},
{255, 74, 53},
{255, 73, 54},
{255, 73, 55},
{255, 72, 55},
{255, 71, 56},
{255, 71, 57},
{255, 70, 57},
{255, 69, 58},
{255, 69, 59},
{255, 68, 59},
{255, 67, 60},
{255, 66, 61},
{255, 66, 61},
{255, 65, 62},
{255, 64, 63},
{255, 64, 63},
{255, 63, 64},
{255, 62, 65},
{255, 62, 65},
{255, 61, 66},
{255, 60, 67},
{255, 60, 67},
{255, 59, 68},
{255, 58, 69},
{255, 58, 70},
{255, 57, 70},
{255, 56, 71},
{255, 56, 72},
{255, 55, 72},
{255, 54, 73},
{255, 54, 74},
{255, 53, 75},
{255, 52, 75},
{255, 52, 76},
{255, 51, 77},
{255, 51, 77},
{254, 50, 78},
{254, 49, 79},
{254, 49, 80},
{254, 48, 80},
{254, 47, 81},
{254, 47, 82},
{254, 46, 83},
{254, 46, 83},
{254, 45, 84},
{253, 44, 85},
{253, 44, 85},
{253, 43, 86},
{253, 43, 87},
{253, 42, 88},
{253, 41, 88},
{252, 41, 89},
{252, 40, 90},
{252, 40, 91},
{252, 39, 91},
{252, 39, 92},
{251, 38, 93},
{251, 37, 94},
{251, 37, 95},
{251, 36, 95},
{251, 36, 96},
{250, 35, 97},
{250, 35, 98},
{250, 34, 98},
{250, 34, 99},
{250, 33, 100},
{249, 33, 101},
{249, 32, 101},
{249, 31, 102},
{249, 31, 103},
{248, 30, 104},
{248, 30, 105},
{248, 29, 105},
{248, 29, 106},
{247, 28, 107},
{247, 28, 108},
{247, 27, 108},
{246, 27, 109},
{246, 26, 110},
{246, 26, 111},
{245, 26, 112},
{245, 25, 112},
{245, 25, 113},
{245, 24, 114},
{244, 24, 115},
{244, 23, 115},
{244, 23, 116},
{243, 22, 117},
{243, 22, 118},
{243, 21, 119},
{242, 21, 119},
{242, 21, 120},
{241, 20, 121},
{241, 20, 122},
{241, 19, 123},
{240, 19, 123},
{240, 18, 124},
{240, 18, 125},
{239, 18, 126},
{239, 17, 126},
{238, 17, 127},
{238, 16, 128},
{238, 16, 129},
{237, 16, 130},
{237, 15, 130},
{236, 15, 131},
{236, 14, 132},
{236, 14, 133},
{235, 14, 134},
{235, 13, 134},
{234, 13, 135},
{234, 13, 136},
{233, 12, 137},
{233, 12, 137},
{233, 12, 138},
{232, 11, 139},
{232, 11, 140},
{231, 11, 141},
{231, 10, 141},
{230, 10, 142},
{230, 10, 143},
{229, 9, 144},
{229, 9, 145},
{228, 9, 145},
{228, 9, 146},
{227, 8, 147},
{227, 8, 148},
{226, 8, 148},
{226, 7, 149},
{225, 7, 150},
{225, 7, 151},
{224, 7, 152},
{224, 6, 152},
{223, 6, 153},
{223, 6, 154},
{222, 6, 155},
{222, 5, 155},
{221, 5, 156},
{221, 5, 157},
{220, 5, 158},
{220, 4, 158},
{219, 4, 159},
{218, 4, 160},
{218, 4, 161},
{217, 4, 161},
{217, 3, 162},
{216, 3, 163},
{216, 3, 164},
{215, 3, 165},
{215, 3, 165},
{214, 3, 166},
{213, 2, 167},
{213, 2, 168},
{212, 2, 168},
{212, 2, 169},
{211, 2, 170},
{210, 2, 170},
{210, 1, 171},
{209, 1, 172},
{209, 1, 173},
{208, 1, 173},
{207, 1, 174},
{207, 1, 175},
{206, 1, 176},
{206, 1, 176},
{205, 1, 177},
{204, 0, 178},
{204, 0, 179},
{203, 0, 179},
{202, 0, 180},
{202, 0, 181},
{201, 0, 181},
{200, 0, 182},
{200, 0, 183},
{199, 0, 184},
{198, 0, 184},
{198, 0, 185},
{197, 0, 186},
{196, 0, 186},
{196, 0, 187},
{195, 0, 188},
{194, 0, 188},
{194, 0, 189},
{193, 0, 190},
{192, 0, 191},
{192, 0, 191},
{191, 0, 192},
{190, 0, 193},
{190, 0, 193},
{189, 0, 194},
{188, 0, 195},
{188, 0, 195},
{187, 0, 196},
{186, 0, 197},
{186, 0, 197},
{185, 0, 198},
{184, 0, 199},
{183, 0, 199},
{183, 0, 200},
{182, 0, 201},
{181, 0, 201},
{181, 0, 202},
{180, 0, 202},
{179, 0, 203},
{178, 0, 204},
{178, 0, 204},
{177, 1, 205},
{176, 1, 206},
{176, 1, 206},
{175, 1, 207},
{174, 1, 207},
{173, 1, 208},
{173, 1, 209},
{172, 1, 209},
{171, 1, 210},
{170, 2, 211},
{170, 2, 211},
{169, 2, 212},
{168, 2, 212},
{167, 2, 213},
{167, 2, 213},
{166, 3, 214},
{165, 3, 215},
{164, 3, 215},
{164, 3, 216},
{163, 3, 216},
{162, 3, 217},
{161, 4, 217},
{161, 4, 218},
{160, 4, 219},
{159, 4, 219},
{158, 5, 220},
{158, 5, 220},
{157, 5, 221},
{156, 5, 221},
{155, 5, 222},
{154, 6, 222},
{154, 6, 223},
{153, 6, 223},
{152, 6, 224},
{151, 7, 224},
{151, 7, 225},
{150, 7, 225},
{149, 7, 226},
{148, 8, 226},
{148, 8, 227},
{147, 8, 227},
{146, 9, 228},
{145, 9, 228},
{144, 9, 229},
{144, 9, 229},
{143, 10, 230},
{142, 10, 230},
{141, 10, 231},
{140, 11, 231},
{140, 11, 232},
{139, 11, 232},
{138, 12, 233},
{137, 12, 233},
{137, 12, 234},
{136, 13, 234},
{135, 13, 234},
{134, 13, 235},
{133, 14, 235},
{133, 14, 236},
{132, 15, 236},
{131, 15, 237},
{130, 15, 237},
{129, 16, 237},
{129, 16, 238},
{128, 16, 238},
{127, 17, 239},
{126, 17, 239},
{126, 18, 239},
{125, 18, 240},
{124, 18, 240},
{123, 19, 240},
{122, 19, 241},
{122, 20, 241},
{121, 20, 242},
{120, 21, 242},
{119, 21, 242},
{118, 21, 243},
{118, 22, 243},
{117, 22, 243},
{116, 23, 244},
{115, 23, 244},
{115, 24, 244},
{114, 24, 245},
{113, 25, 245},
{112, 25, 245},
{111, 26, 246},
{111, 26, 246},
{110, 27, 246},
{109, 27, 246},
{108, 28, 247},
{107, 28, 247},
{107, 29, 247},
{106, 29, 248},
{105, 30, 248},
{104, 30, 248},
{104, 31, 248},
{103, 31, 249},
{102, 32, 249},
{101, 32, 249},
{101, 33, 249},
{100, 33, 250},
{99, 34, 250},
{98, 34, 250},
{97, 35, 250},
{97, 35, 250},
{96, 36, 251},
{95, 36, 251},
{94, 37, 251},
{94, 38, 251},
{93, 38, 252},
{92, 39, 252},
{91, 39, 252},
{91, 40, 252},
{90, 40, 252},
{89, 41, 252},
{88, 42, 253},
{88, 42, 253},
{87, 43, 253},
{86, 43, 253},
{85, 44, 253},
{85, 44, 253},
{84, 45, 254},
{83, 46, 254},
{82, 46, 254},
{82, 47, 254},
{81, 48, 254},
{80, 48, 254},
{79, 49, 254},
{79, 49, 254},
{78, 50, 254},
{77, 51, 255},
{77, 51, 255},
{76, 52, 255},
{75, 53, 255},
{74, 53, 255},
{74, 54, 255},
{73, 54, 255},
{72, 55, 255},
{72, 56, 255},
{71, 56, 255},
{70, 57, 255},
{69, 58, 255},
{69, 58, 255},
{68, 59, 255},
{67, 60, 255},
{67, 60, 255},
{66, 61, 255},
{65, 62, 255},
{65, 62, 255},
{64, 63, 255},
{63, 64, 255},
{63, 64, 255},
{62, 65, 255},
{61, 66, 255},
{61, 67, 255},
{60, 67, 255},
{59, 68, 255},
{59, 69, 255},
{58, 69, 255},
{57, 70, 255},
{57, 71, 255},
{56, 71, 255},
{55, 72, 255},
{55, 73, 255},
{54, 74, 255},
{53, 74, 255},
{53, 75, 255},
{52, 76, 255},
{51, 76, 255},
{51, 77, 255},
{50, 78, 254},
{49, 79, 254},
{49, 79, 254},
{48, 80, 254},
{48, 81, 254},
{47, 82, 254},
{46, 82, 254},
{46, 83, 254},
{45, 84, 254},
{45, 85, 253},
{44, 85, 253},
{43, 86, 253},
{43, 87, 253},
{42, 87, 253},
{42, 88, 253},
{41, 89, 252},
{40, 90, 252},
{40, 90, 252},
{39, 91, 252},
{39, 92, 252},
{38, 93, 252},
{38, 94, 251},
{37, 94, 251},
{37, 95, 251},
{36, 96, 251},
{35, 97, 251},
{35, 97, 250},
{34, 98, 250},
{34, 99, 250},
{33, 100, 250},
{33, 100, 249},
{32, 101, 249},
{32, 102, 249},
{31, 103, 249},
{31, 103, 248},
{30, 104, 248},
{30, 105, 248},
{29, 106, 248},
{29, 107, 247},
{28, 107, 247},
{28, 108, 247},
{27, 109, 246},
{27, 110, 246},
{26, 110, 246},
{26, 111, 246},
{25, 112, 245},
{25, 113, 245},
{24, 114, 245},
{24, 114, 244},
{23, 115, 244},
{23, 116, 244},
{22, 117, 243},
{22, 118, 243},
{22, 118, 243},
{21, 119, 242},
{21, 120, 242},
{20, 121, 242},
{20, 121, 241},
{19, 122, 241},
{19, 123, 241},
{19, 124, 240},
{18, 125, 240},
{18, 125, 239},
{17, 126, 239},
{17, 127, 239},
{17, 128, 238},
{16, 129, 238},
{16, 129, 237},
{15, 130, 237},
{15, 131, 237},
{15, 132, 236},
{14, 132, 236},
{14, 133, 235},
{14, 134, 235},
{13, 135, 234},
{13, 136, 234},
{12, 136, 234},
{12, 137, 233},
{12, 138, 233},
{11, 139, 232},
{11, 140, 232},
{11, 140, 231},
{10, 141, 231},
{10, 142, 230},
{10, 143, 230},
{10, 143, 229},
{9, 144, 229},
{9, 145, 229},
{9, 146, 228},
{8, 147, 228},
{8, 147, 227},
{8, 148, 227},
{7, 149, 226},
{7, 150, 226},
{7, 150, 225},
{7, 151, 225},
{6, 152, 224},
{6, 153, 224},
{6, 154, 223},
{6, 154, 222},
{5, 155, 222},
{5, 156, 221},
{5, 157, 221},
{5, 157, 220},
{5, 158, 220},
{4, 159, 219},
{4, 160, 219},
{4, 160, 218},
{4, 161, 218},
{4, 162, 217},
{3, 163, 216},
{3, 164, 216},
{3, 164, 215},
{3, 165, 215},
{3, 166, 214},
{2, 167, 214},
{2, 167, 213},
{2, 168, 212},
{2, 169, 212},
{2, 170, 211},
{2, 170, 211},
{1, 171, 210},
{1, 172, 209},
{1, 172, 209},
{1, 173, 208},
{1, 174, 208},
{1, 175, 207},
{1, 175, 206},
{1, 176, 206},
{1, 177, 205},
{0, 178, 204},
{0, 178, 204},
{0, 179, 203},
{0, 180, 203},
{0, 180, 202},
{0, 181, 201},
{0, 182, 201},
{0, 183, 200},
{0, 183, 199},
{0, 184, 199},
{0, 185, 198},
{0, 185, 197},
{0, 186, 197},
{0, 187, 196},
{0, 188, 195},
{0, 188, 195},
{0, 189, 194},
{0, 190, 193},
{0, 190, 193},
{0, 191, 192},
{0, 192, 191},
{0, 192, 191},
{0, 193, 190},
{0, 194, 189},
{0, 194, 189},
{0, 195, 188},
{0, 196, 187},
{0, 196, 186},
{0, 197, 186},
{0, 198, 185},
{0, 198, 184},
{0, 199, 184},
{0, 200, 183},
{0, 200, 182},
{0, 201, 182},
{0, 202, 181},
{0, 202, 180},
{0, 203, 179},
{0, 204, 179},
{0, 204, 178},
{0, 205, 177},
{1, 205, 176},
{1, 206, 176},
{1, 207, 175},
{1, 207, 174},
{1, 208, 174},
{1, 208, 173},
{1, 209, 172},
{1, 210, 171},
{2, 210, 171},
{2, 211, 170},
{2, 212, 169},
{2, 212, 168},
{2, 213, 168},
{2, 213, 167},
{2, 214, 166},
{3, 214, 165},
{3, 215, 165},
{3, 216, 164},
{3, 216, 163},
{3, 217, 162},
{4, 217, 162},
{4, 218, 161},
{4, 218, 160},
{4, 219, 159},
{4, 220, 159},
{5, 220, 158},
{5, 221, 157},
{5, 221, 156},
{5, 222, 155},
{6, 222, 155},
{6, 223, 154},
{6, 223, 153},
{6, 224, 152},
{7, 224, 152},
{7, 225, 151},
{7, 225, 150},
{7, 226, 149},
{8, 226, 149},
{8, 227, 148},
{8, 227, 147},
{8, 228, 146},
{9, 228, 145},
{9, 229, 145},
{9, 229, 144},
{10, 230, 143},
{10, 230, 142},
{10, 231, 142},
{11, 231, 141},
{11, 232, 140},
{11, 232, 139},
{12, 233, 138},
{12, 233, 138},
{12, 233, 137},
{13, 234, 136},
{13, 234, 135},
{13, 235, 134},
{14, 235, 134},
{14, 236, 133},
{14, 236, 132},
{15, 236, 131},
{15, 237, 131},
{16, 237, 130},
{16, 238, 129},
{16, 238, 128},
{17, 238, 127},
{17, 239, 127},
{18, 239, 126},
{18, 240, 125},
{18, 240, 124},
{19, 240, 123},
{19, 241, 123},
{20, 241, 122},
{20, 241, 121},
{20, 242, 120},
{21, 242, 119},
{21, 242, 119},
{22, 243, 118},
{22, 243, 117},
{23, 244, 116},
{23, 244, 116},
{24, 244, 115},
{24, 244, 114},
{24, 245, 113},
{25, 245, 112},
{25, 245, 112},
{26, 246, 111},
{26, 246, 110},
{27, 246, 109},
{27, 247, 109},
{28, 247, 108},
{28, 247, 107},
{29, 247, 106},
{29, 248, 105},
{30, 248, 105},
{30, 248, 104},
{31, 249, 103},
{31, 249, 102},
{32, 249, 102},
{32, 249, 101},
{33, 250, 100},
{34, 250, 99},
{34, 250, 98},
{35, 250, 98},
{35, 250, 97},
{36, 251, 96},
{36, 251, 95},
{37, 251, 95},
{37, 251, 94},
{38, 251, 93},
{38, 252, 92},
{39, 252, 92},
{40, 252, 91},
{40, 252, 90},
{41, 252, 89},
{41, 253, 89},
{42, 253, 88},
{43, 253, 87},
{43, 253, 86},
{44, 253, 86},
{44, 253, 85},
{45, 253, 84},
{45, 254, 83},
{46, 254, 83},
{47, 254, 82},
{47, 254, 81},
{48, 254, 80},
{49, 254, 80},
{49, 254, 79},
{50, 254, 78},
{50, 255, 78},
{51, 255, 77},
{52, 255, 76},
{52, 255, 75},
{53, 255, 75},
{54, 255, 74},
{54, 255, 73},
{55, 255, 73},
{56, 255, 72},
{56, 255, 71},
{57, 255, 70},
{58, 255, 70},
{58, 255, 69},
{59, 255, 68},
{60, 255, 68},
{60, 255, 67},
{61, 255, 66},
{62, 255, 65},
{62, 255, 65},
{63, 255, 64},
{64, 255, 63},
{64, 255, 63},
{65, 255, 62},
{66, 255, 61},
{66, 255, 61},
{67, 255, 60},
{68, 255, 59},
{68, 255, 59},
{69, 255, 58},
{70, 255, 57},
{70, 255, 57},
{71, 255, 56},
{72, 255, 55},
{73, 255, 55},
{73, 255, 54},
{74, 255, 54},
{75, 255, 53},
{75, 255, 52},
{76, 255, 52},
{77, 255, 51},
{78, 255, 50},
{78, 254, 50},
{79, 254, 49},
{80, 254, 48},
{81, 254, 48},
{81, 254, 47},
{82, 254, 47},
{83, 254, 46},
{84, 254, 45},
{84, 253, 45},
{85, 253, 44},
{86, 253, 44},
{86, 253, 43},
{87, 253, 42},
{88, 253, 42},
{89, 253, 41},
{89, 252, 41},
{90, 252, 40},
{91, 252, 40},
{92, 252, 39},
{93, 252, 38},
{93, 251, 38},
{94, 251, 37},
{95, 251, 37},
{96, 251, 36},
{96, 251, 36},
{97, 250, 35},
{98, 250, 34},
{99, 250, 34},
{99, 250, 33},
{100, 249, 33},
{101, 249, 32},
{102, 249, 32},
{102, 249, 31},
{103, 248, 31},
{104, 248, 30},
{105, 248, 30},
{106, 248, 29},
{106, 247, 29},
{107, 247, 28},
{108, 247, 28},
{109, 247, 27},
{109, 246, 27},
{110, 246, 26},
{111, 246, 26},
{112, 245, 25},
{113, 245, 25},
{113, 245, 24},
{114, 244, 24},
{115, 244, 23},
{116, 244, 23},
{116, 243, 23},
{117, 243, 22},
{118, 243, 22},
{119, 242, 21},
{120, 242, 21},
{120, 242, 20},
{121, 241, 20},
{122, 241, 20},
{123, 241, 19},
{124, 240, 19},
{124, 240, 18},
{125, 240, 18},
{126, 239, 17},
{127, 239, 17}
};

static const int RedTempCount = 256;
static const QString RedTempName = "Red Temperature";

static unsigned char RedTemp[257][3] = {
  {0, 0, 0},
  {0, 0, 0},
  {1, 0, 0},
  {2, 0, 0},
  {4, 0, 0},
  {5, 0, 0},
  {7, 0, 0},
  {8, 0, 0},
  {10, 0, 0},
  {11, 0, 0},
  {13, 0, 0},
  {14, 0, 0},
  {15, 0, 0},
  {17, 0, 0},
  {18, 0, 0},
  {20, 0, 0},
  {21, 0, 0},
  {23, 0, 0},
  {24, 0, 0},
  {26, 0, 0},
  {27, 0, 0},
  {28, 0, 0},
  {30, 0, 0},
  {31, 0, 0},
  {33, 0, 0},
  {34, 0, 0},
  {36, 0, 0},
  {37, 0, 0},
  {39, 0, 0},
  {40, 0, 0},
  {42, 0, 0},
  {43, 0, 0},
  {44, 0, 0},
  {46, 0, 0},
  {47, 0, 0},
  {49, 0, 0},
  {50, 0, 0},
  {52, 0, 0},
  {53, 0, 0},
  {55, 0, 0},
  {56, 0, 0},
  {57, 0, 0},
  {59, 0, 0},
  {60, 0, 0},
  {62, 0, 0},
  {63, 0, 0},
  {65, 0, 0},
  {66, 0, 0},
  {68, 0, 0},
  {69, 0, 0},
  {70, 0, 0},
  {72, 0, 0},
  {73, 0, 0},
  {75, 0, 0},
  {76, 0, 0},
  {78, 0, 0},
  {79, 0, 0},
  {81, 0, 0},
  {82, 0, 0},
  {84, 0, 0},
  {85, 0, 0},
  {86, 0, 0},
  {88, 0, 0},
  {89, 0, 0},
  {91, 0, 0},
  {92, 0, 0},
  {94, 0, 0},
  {95, 0, 0},
  {97, 0, 0},
  {98, 0, 0},
  {99, 0, 0},
  {101, 0, 0},
  {102, 0, 0},
  {104, 0, 0},
  {105, 0, 0},
  {107, 0, 0},
  {108, 0, 0},
  {110, 0, 0},
  {111, 0, 0},
  {113, 0, 0},
  {114, 0, 0},
  {115, 0, 0},
  {117, 0, 0},
  {118, 0, 0},
  {120, 0, 0},
  {121, 0, 0},
  {123, 0, 0},
  {124, 0, 0},
  {126, 0, 0},
  {127, 0, 0},
  {128, 0, 0},
  {130, 0, 0},
  {131, 0, 0},
  {133, 0, 0},
  {134, 0, 0},
  {136, 0, 0},
  {137, 0, 0},
  {139, 0, 0},
  {140, 0, 0},
  {141, 0, 0},
  {143, 0, 0},
  {144, 0, 0},
  {146, 0, 0},
  {147, 0, 0},
  {149, 0, 0},
  {150, 0, 0},
  {152, 0, 0},
  {153, 0, 0},
  {155, 0, 0},
  {156, 0, 0},
  {157, 0, 0},
  {159, 0, 0},
  {160, 0, 0},
  {162, 0, 0},
  {163, 0, 0},
  {165, 0, 0},
  {166, 0, 0},
  {168, 0, 0},
  {169, 0, 0},
  {170, 0, 0},
  {172, 0, 0},
  {173, 0, 0},
  {175, 1, 0},
  {176, 3, 0},
  {178, 5, 0},
  {179, 7, 0},
  {181, 9, 0},
  {182, 11, 0},
  {184, 13, 0},
  {185, 15, 0},
  {186, 17, 0},
  {188, 18, 0},
  {189, 20, 0},
  {191, 22, 0},
  {192, 24, 0},
  {194, 26, 0},
  {195, 28, 0},
  {197, 30, 0},
  {198, 32, 0},
  {199, 34, 0},
  {201, 35, 0},
  {202, 37, 0},
  {204, 39, 0},
  {205, 41, 0},
  {207, 43, 0},
  {208, 45, 0},
  {210, 47, 0},
  {211, 49, 0},
  {212, 51, 0},
  {214, 52, 0},
  {215, 54, 0},
  {217, 56, 0},
  {218, 58, 0},
  {220, 60, 0},
  {221, 62, 0},
  {223, 64, 0},
  {224, 66, 0},
  {226, 68, 0},
  {227, 69, 0},
  {228, 71, 0},
  {230, 73, 0},
  {231, 75, 0},
  {233, 77, 0},
  {234, 79, 0},
  {236, 81, 0},
  {237, 83, 0},
  {239, 85, 0},
  {240, 86, 0},
  {241, 88, 0},
  {243, 90, 0},
  {244, 92, 0},
  {246, 94, 0},
  {247, 96, 0},
  {249, 98, 0},
  {250, 100, 0},
  {252, 102, 0},
  {253, 103, 0},
  {255, 105, 0},
  {255, 107, 0},
  {255, 109, 0},
  {255, 111, 0},
  {255, 113, 0},
  {255, 115, 0},
  {255, 117, 0},
  {255, 119, 0},
  {255, 120, 0},
  {255, 122, 0},
  {255, 124, 0},
  {255, 126, 0},
  {255, 128, 0},
  {255, 130, 0},
  {255, 132, 0},
  {255, 134, 3},
  {255, 136, 7},
  {255, 137, 11},
  {255, 139, 15},
  {255, 141, 19},
  {255, 143, 23},
  {255, 145, 27},
  {255, 147, 31},
  {255, 149, 35},
  {255, 151, 39},
  {255, 153, 43},
  {255, 154, 47},
  {255, 156, 51},
  {255, 158, 54},
  {255, 160, 58},
  {255, 162, 62},
  {255, 164, 66},
  {255, 166, 70},
  {255, 168, 74},
  {255, 170, 78},
  {255, 171, 82},
  {255, 173, 86},
  {255, 175, 90},
  {255, 177, 94},
  {255, 179, 98},
  {255, 181, 102},
  {255, 183, 105},
  {255, 185, 109},
  {255, 187, 113},
  {255, 188, 117},
  {255, 190, 121},
  {255, 192, 125},
  {255, 194, 129},
  {255, 196, 133},
  {255, 198, 137},
  {255, 200, 141},
  {255, 202, 145},
  {255, 204, 149},
  {255, 205, 153},
  {255, 207, 156},
  {255, 209, 160},
  {255, 211, 164},
  {255, 213, 168},
  {255, 215, 172},
  {255, 217, 176},
  {255, 219, 180},
  {255, 221, 184},
  {255, 222, 188},
  {255, 224, 192},
  {255, 226, 196},
  {255, 228, 200},
  {255, 230, 204},
  {255, 232, 207},
  {255, 234, 211},
  {255, 236, 215},
  {255, 238, 219},
  {255, 239, 223},
  {255, 241, 227},
  {255, 243, 231},
  {255, 245, 235},
  {255, 247, 239},
  {255, 249, 243},
  {255, 251, 247},
  {255, 253, 251},
  {255, 255, 255}
};

static const int HotColdCount = 514;
static const QString HotColdName = "Hot Cold";

static unsigned char HotCold[514][3] = {
  {255, 255, 255},
  {251, 253, 255},
  {247, 251, 255},
  {243, 249, 255},
  {239, 247, 255},
  {235, 245, 255},
  {231, 243, 255},
  {227, 241, 255},
  {223, 239, 255},
  {219, 238, 255},
  {215, 236, 255},
  {211, 234, 255},
  {207, 232, 255},
  {204, 230, 255},
  {200, 228, 255},
  {196, 226, 255},
  {192, 224, 255},
  {188, 222, 255},
  {184, 221, 255},
  {180, 219, 255},
  {176, 217, 255},
  {172, 215, 255},
  {168, 213, 255},
  {164, 211, 255},
  {160, 209, 255},
  {156, 207, 255},
  {153, 205, 255},
  {149, 204, 255},
  {145, 202, 255},
  {141, 200, 255},
  {137, 198, 255},
  {133, 196, 255},
  {129, 194, 255},
  {125, 192, 255},
  {121, 190, 255},
  {117, 188, 255},
  {113, 187, 255},
  {109, 185, 255},
  {105, 183, 255},
  {102, 181, 255},
  {98, 179, 255},
  {94, 177, 255},
  {90, 175, 255},
  {86, 173, 255},
  {82, 171, 255},
  {78, 170, 255},
  {74, 168, 255},
  {70, 166, 255},
  {66, 164, 255},
  {62, 162, 255},
  {58, 160, 255},
  {54, 158, 255},
  {51, 156, 255},
  {47, 154, 255},
  {43, 153, 255},
  {39, 151, 255},
  {35, 149, 255},
  {31, 147, 255},
  {27, 145, 255},
  {23, 143, 255},
  {19, 141, 255},
  {15, 139, 255},
  {11, 137, 255},
  {7, 136, 255},
  {3, 134, 255},
  {0, 132, 255},
  {0, 130, 255},
  {0, 128, 255},
  {0, 126, 255},
  {0, 124, 255},
  {0, 122, 255},
  {0, 120, 255},
  {0, 119, 255},
  {0, 117, 255},
  {0, 115, 255},
  {0, 113, 255},
  {0, 111, 255},
  {0, 109, 255},
  {0, 107, 255},
  {0, 105, 255},
  {0, 103, 253},
  {0, 102, 252},
  {0, 100, 250},
  {0, 98, 249},
  {0, 96, 247},
  {0, 94, 246},
  {0, 92, 244},
  {0, 90, 243},
  {0, 88, 241},
  {0, 86, 240},
  {0, 85, 239},
  {0, 83, 237},
  {0, 81, 236},
  {0, 79, 234},
  {0, 77, 233},
  {0, 75, 231},
  {0, 73, 230},
  {0, 71, 228},
  {0, 69, 227},
  {0, 68, 226},
  {0, 66, 224},
  {0, 64, 223},
  {0, 62, 221},
  {0, 60, 220},
  {0, 58, 218},
  {0, 56, 217},
  {0, 54, 215},
  {0, 52, 214},
  {0, 51, 212},
  {0, 49, 211},
  {0, 47, 210},
  {0, 45, 208},
  {0, 43, 207},
  {0, 41, 205},
  {0, 39, 204},
  {0, 37, 202},
  {0, 35, 201},
  {0, 34, 199},
  {0, 32, 198},
  {0, 30, 197},
  {0, 28, 195},
  {0, 26, 194},
  {0, 24, 192},
  {0, 22, 191},
  {0, 20, 189},
  {0, 18, 188},
  {0, 17, 186},
  {0, 15, 185},
  {0, 13, 184},
  {0, 11, 182},
  {0, 9, 181},
  {0, 7, 179},
  {0, 5, 178},
  {0, 3, 176},
  {0, 1, 175},
  {0, 0, 173},
  {0, 0, 172},
  {0, 0, 170},
  {0, 0, 169},
  {0, 0, 168},
  {0, 0, 166},
  {0, 0, 165},
  {0, 0, 163},
  {0, 0, 162},
  {0, 0, 160},
  {0, 0, 159},
  {0, 0, 157},
  {0, 0, 156},
  {0, 0, 155},
  {0, 0, 153},
  {0, 0, 152},
  {0, 0, 150},
  {0, 0, 149},
  {0, 0, 147},
  {0, 0, 146},
  {0, 0, 144},
  {0, 0, 143},
  {0, 0, 141},
  {0, 0, 140},
  {0, 0, 139},
  {0, 0, 137},
  {0, 0, 136},
  {0, 0, 134},
  {0, 0, 133},
  {0, 0, 131},
  {0, 0, 130},
  {0, 0, 128},
  {0, 0, 127},
  {0, 0, 126},
  {0, 0, 124},
  {0, 0, 123},
  {0, 0, 121},
  {0, 0, 120},
  {0, 0, 118},
  {0, 0, 117},
  {0, 0, 115},
  {0, 0, 114},
  {0, 0, 113},
  {0, 0, 111},
  {0, 0, 110},
  {0, 0, 108},
  {0, 0, 107},
  {0, 0, 105},
  {0, 0, 104},
  {0, 0, 102},
  {0, 0, 101},
  {0, 0, 99},
  {0, 0, 98},
  {0, 0, 97},
  {0, 0, 95},
  {0, 0, 94},
  {0, 0, 92},
  {0, 0, 91},
  {0, 0, 89},
  {0, 0, 88},
  {0, 0, 86},
  {0, 0, 85},
  {0, 0, 84},
  {0, 0, 82},
  {0, 0, 81},
  {0, 0, 79},
  {0, 0, 78},
  {0, 0, 76},
  {0, 0, 75},
  {0, 0, 73},
  {0, 0, 72},
  {0, 0, 70},
  {0, 0, 69},
  {0, 0, 68},
  {0, 0, 66},
  {0, 0, 65},
  {0, 0, 63},
  {0, 0, 62},
  {0, 0, 60},
  {0, 0, 59},
  {0, 0, 57},
  {0, 0, 56},
  {0, 0, 55},
  {0, 0, 53},
  {0, 0, 52},
  {0, 0, 50},
  {0, 0, 49},
  {0, 0, 47},
  {0, 0, 46},
  {0, 0, 44},
  {0, 0, 43},
  {0, 0, 42},
  {0, 0, 40},
  {0, 0, 39},
  {0, 0, 37},
  {0, 0, 36},
  {0, 0, 34},
  {0, 0, 33},
  {0, 0, 31},
  {0, 0, 30},
  {0, 0, 28},
  {0, 0, 27},
  {0, 0, 26},
  {0, 0, 24},
  {0, 0, 23},
  {0, 0, 21},
  {0, 0, 20},
  {0, 0, 18},
  {0, 0, 17},
  {0, 0, 15},
  {0, 0, 14},
  {0, 0, 13},
  {0, 0, 11},
  {0, 0, 10},
  {0, 0, 8},
  {0, 0, 7},
  {0, 0, 5},
  {0, 0, 4},
  {0, 0, 2},
  {0, 0, 1},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {1, 0, 0},
  {2, 0, 0},
  {4, 0, 0},
  {5, 0, 0},
  {7, 0, 0},
  {8, 0, 0},
  {10, 0, 0},
  {11, 0, 0},
  {13, 0, 0},
  {14, 0, 0},
  {15, 0, 0},
  {17, 0, 0},
  {18, 0, 0},
  {20, 0, 0},
  {21, 0, 0},
  {23, 0, 0},
  {24, 0, 0},
  {26, 0, 0},
  {27, 0, 0},
  {28, 0, 0},
  {30, 0, 0},
  {31, 0, 0},
  {33, 0, 0},
  {34, 0, 0},
  {36, 0, 0},
  {37, 0, 0},
  {39, 0, 0},
  {40, 0, 0},
  {42, 0, 0},
  {43, 0, 0},
  {44, 0, 0},
  {46, 0, 0},
  {47, 0, 0},
  {49, 0, 0},
  {50, 0, 0},
  {52, 0, 0},
  {53, 0, 0},
  {55, 0, 0},
  {56, 0, 0},
  {57, 0, 0},
  {59, 0, 0},
  {60, 0, 0},
  {62, 0, 0},
  {63, 0, 0},
  {65, 0, 0},
  {66, 0, 0},
  {68, 0, 0},
  {69, 0, 0},
  {70, 0, 0},
  {72, 0, 0},
  {73, 0, 0},
  {75, 0, 0},
  {76, 0, 0},
  {78, 0, 0},
  {79, 0, 0},
  {81, 0, 0},
  {82, 0, 0},
  {84, 0, 0},
  {85, 0, 0},
  {86, 0, 0},
  {88, 0, 0},
  {89, 0, 0},
  {91, 0, 0},
  {92, 0, 0},
  {94, 0, 0},
  {95, 0, 0},
  {97, 0, 0},
  {98, 0, 0},
  {99, 0, 0},
  {101, 0, 0},
  {102, 0, 0},
  {104, 0, 0},
  {105, 0, 0},
  {107, 0, 0},
  {108, 0, 0},
  {110, 0, 0},
  {111, 0, 0},
  {113, 0, 0},
  {114, 0, 0},
  {115, 0, 0},
  {117, 0, 0},
  {118, 0, 0},
  {120, 0, 0},
  {121, 0, 0},
  {123, 0, 0},
  {124, 0, 0},
  {126, 0, 0},
  {127, 0, 0},
  {128, 0, 0},
  {130, 0, 0},
  {131, 0, 0},
  {133, 0, 0},
  {134, 0, 0},
  {136, 0, 0},
  {137, 0, 0},
  {139, 0, 0},
  {140, 0, 0},
  {141, 0, 0},
  {143, 0, 0},
  {144, 0, 0},
  {146, 0, 0},
  {147, 0, 0},
  {149, 0, 0},
  {150, 0, 0},
  {152, 0, 0},
  {153, 0, 0},
  {155, 0, 0},
  {156, 0, 0},
  {157, 0, 0},
  {159, 0, 0},
  {160, 0, 0},
  {162, 0, 0},
  {163, 0, 0},
  {165, 0, 0},
  {166, 0, 0},
  {168, 0, 0},
  {169, 0, 0},
  {170, 0, 0},
  {172, 0, 0},
  {173, 0, 0},
  {175, 1, 0},
  {176, 3, 0},
  {178, 5, 0},
  {179, 7, 0},
  {181, 9, 0},
  {182, 11, 0},
  {184, 13, 0},
  {185, 15, 0},
  {186, 17, 0},
  {188, 18, 0},
  {189, 20, 0},
  {191, 22, 0},
  {192, 24, 0},
  {194, 26, 0},
  {195, 28, 0},
  {197, 30, 0},
  {198, 32, 0},
  {199, 34, 0},
  {201, 35, 0},
  {202, 37, 0},
  {204, 39, 0},
  {205, 41, 0},
  {207, 43, 0},
  {208, 45, 0},
  {210, 47, 0},
  {211, 49, 0},
  {212, 51, 0},
  {214, 52, 0},
  {215, 54, 0},
  {217, 56, 0},
  {218, 58, 0},
  {220, 60, 0},
  {221, 62, 0},
  {223, 64, 0},
  {224, 66, 0},
  {226, 68, 0},
  {227, 69, 0},
  {228, 71, 0},
  {230, 73, 0},
  {231, 75, 0},
  {233, 77, 0},
  {234, 79, 0},
  {236, 81, 0},
  {237, 83, 0},
  {239, 85, 0},
  {240, 86, 0},
  {241, 88, 0},
  {243, 90, 0},
  {244, 92, 0},
  {246, 94, 0},
  {247, 96, 0},
  {249, 98, 0},
  {250, 100, 0},
  {252, 102, 0},
  {253, 103, 0},
  {255, 105, 0},
  {255, 107, 0},
  {255, 109, 0},
  {255, 111, 0},
  {255, 113, 0},
  {255, 115, 0},
  {255, 117, 0},
  {255, 119, 0},
  {255, 120, 0},
  {255, 122, 0},
  {255, 124, 0},
  {255, 126, 0},
  {255, 128, 0},
  {255, 130, 0},
  {255, 132, 0},
  {255, 134, 3},
  {255, 136, 7},
  {255, 137, 11},
  {255, 139, 15},
  {255, 141, 19},
  {255, 143, 23},
  {255, 145, 27},
  {255, 147, 31},
  {255, 149, 35},
  {255, 151, 39},
  {255, 153, 43},
  {255, 154, 47},
  {255, 156, 51},
  {255, 158, 54},
  {255, 160, 58},
  {255, 162, 62},
  {255, 164, 66},
  {255, 166, 70},
  {255, 168, 74},
  {255, 170, 78},
  {255, 171, 82},
  {255, 173, 86},
  {255, 175, 90},
  {255, 177, 94},
  {255, 179, 98},
  {255, 181, 102},
  {255, 183, 105},
  {255, 185, 109},
  {255, 187, 113},
  {255, 188, 117},
  {255, 190, 121},
  {255, 192, 125},
  {255, 194, 129},
  {255, 196, 133},
  {255, 198, 137},
  {255, 200, 141},
  {255, 202, 145},
  {255, 204, 149},
  {255, 205, 153},
  {255, 207, 156},
  {255, 209, 160},
  {255, 211, 164},
  {255, 213, 168},
  {255, 215, 172},
  {255, 217, 176},
  {255, 219, 180},
  {255, 221, 184},
  {255, 222, 188},
  {255, 224, 192},
  {255, 226, 196},
  {255, 228, 200},
  {255, 230, 204},
  {255, 232, 207},
  {255, 234, 211},
  {255, 236, 215},
  {255, 238, 219},
  {255, 239, 223},
  {255, 241, 227},
  {255, 243, 231},
  {255, 245, 235},
  {255, 247, 239},
  {255, 249, 243},
  {255, 251, 247},
  {255, 253, 251},
  {255, 255, 255}
};

static const int SpectrumCount = 1021;
static const QString SpectrumName = "Spectrum";
static unsigned char Spectrum[1022][3] = {
  {0, 0, 0},
  {0, 0, 255},
  {0, 1, 255},
  {0, 2, 255},
  {0, 3, 255},
  {0, 4, 255},
  {0, 5, 255},
  {0, 6, 255},
  {0, 7, 255},
  {0, 8, 255},
  {0, 9, 255},
  {0, 10, 255},
  {0, 11, 255},
  {0, 12, 255},
  {0, 13, 255},
  {0, 14, 255},
  {0, 15, 255},
  {0, 16, 255},
  {0, 17, 255},
  {0, 18, 255},
  {0, 19, 255},
  {0, 20, 255},
  {0, 21, 255},
  {0, 22, 255},
  {0, 23, 255},
  {0, 24, 255},
  {0, 25, 255},
  {0, 26, 255},
  {0, 27, 255},
  {0, 28, 255},
  {0, 29, 255},
  {0, 30, 255},
  {0, 31, 255},
  {0, 32, 255},
  {0, 33, 255},
  {0, 34, 255},
  {0, 35, 255},
  {0, 36, 255},
  {0, 37, 255},
  {0, 38, 255},
  {0, 39, 255},
  {0, 40, 255},
  {0, 41, 255},
  {0, 42, 255},
  {0, 43, 255},
  {0, 44, 255},
  {0, 45, 255},
  {0, 46, 255},
  {0, 47, 255},
  {0, 48, 255},
  {0, 49, 255},
  {0, 50, 255},
  {0, 51, 255},
  {0, 52, 255},
  {0, 53, 255},
  {0, 54, 255},
  {0, 55, 255},
  {0, 56, 255},
  {0, 57, 255},
  {0, 58, 255},
  {0, 59, 255},
  {0, 60, 255},
  {0, 61, 255},
  {0, 62, 255},
  {0, 63, 255},
  {0, 64, 255},
  {0, 65, 255},
  {0, 66, 255},
  {0, 67, 255},
  {0, 68, 255},
  {0, 69, 255},
  {0, 70, 255},
  {0, 71, 255},
  {0, 72, 255},
  {0, 73, 255},
  {0, 74, 255},
  {0, 75, 255},
  {0, 76, 255},
  {0, 77, 255},
  {0, 78, 255},
  {0, 79, 255},
  {0, 80, 255},
  {0, 81, 255},
  {0, 82, 255},
  {0, 83, 255},
  {0, 84, 255},
  {0, 85, 255},
  {0, 86, 255},
  {0, 87, 255},
  {0, 88, 255},
  {0, 89, 255},
  {0, 90, 255},
  {0, 91, 255},
  {0, 92, 255},
  {0, 93, 255},
  {0, 94, 255},
  {0, 95, 255},
  {0, 96, 255},
  {0, 97, 255},
  {0, 98, 255},
  {0, 99, 255},
  {0, 100, 255},
  {0, 101, 255},
  {0, 102, 255},
  {0, 103, 255},
  {0, 104, 255},
  {0, 105, 255},
  {0, 106, 255},
  {0, 107, 255},
  {0, 108, 255},
  {0, 109, 255},
  {0, 110, 255},
  {0, 111, 255},
  {0, 112, 255},
  {0, 113, 255},
  {0, 114, 255},
  {0, 115, 255},
  {0, 116, 255},
  {0, 117, 255},
  {0, 118, 255},
  {0, 119, 255},
  {0, 120, 255},
  {0, 121, 255},
  {0, 122, 255},
  {0, 123, 255},
  {0, 124, 255},
  {0, 125, 255},
  {0, 126, 255},
  {0, 127, 255},
  {0, 128, 255},
  {0, 129, 255},
  {0, 130, 255},
  {0, 131, 255},
  {0, 132, 255},
  {0, 133, 255},
  {0, 134, 255},
  {0, 135, 255},
  {0, 136, 255},
  {0, 137, 255},
  {0, 138, 255},
  {0, 139, 255},
  {0, 140, 255},
  {0, 141, 255},
  {0, 142, 255},
  {0, 143, 255},
  {0, 144, 255},
  {0, 145, 255},
  {0, 146, 255},
  {0, 147, 255},
  {0, 148, 255},
  {0, 149, 255},
  {0, 150, 255},
  {0, 151, 255},
  {0, 152, 255},
  {0, 153, 255},
  {0, 154, 255},
  {0, 155, 255},
  {0, 156, 255},
  {0, 157, 255},
  {0, 158, 255},
  {0, 159, 255},
  {0, 160, 255},
  {0, 161, 255},
  {0, 162, 255},
  {0, 163, 255},
  {0, 164, 255},
  {0, 165, 255},
  {0, 166, 255},
  {0, 167, 255},
  {0, 168, 255},
  {0, 169, 255},
  {0, 170, 255},
  {0, 171, 255},
  {0, 172, 255},
  {0, 173, 255},
  {0, 174, 255},
  {0, 175, 255},
  {0, 176, 255},
  {0, 177, 255},
  {0, 178, 255},
  {0, 179, 255},
  {0, 180, 255},
  {0, 181, 255},
  {0, 182, 255},
  {0, 183, 255},
  {0, 184, 255},
  {0, 185, 255},
  {0, 186, 255},
  {0, 187, 255},
  {0, 188, 255},
  {0, 189, 255},
  {0, 190, 255},
  {0, 191, 255},
  {0, 192, 255},
  {0, 193, 255},
  {0, 194, 255},
  {0, 195, 255},
  {0, 196, 255},
  {0, 197, 255},
  {0, 198, 255},
  {0, 199, 255},
  {0, 200, 255},
  {0, 201, 255},
  {0, 202, 255},
  {0, 203, 255},
  {0, 204, 255},
  {0, 205, 255},
  {0, 206, 255},
  {0, 207, 255},
  {0, 208, 255},
  {0, 209, 255},
  {0, 210, 255},
  {0, 211, 255},
  {0, 212, 255},
  {0, 213, 255},
  {0, 214, 255},
  {0, 215, 255},
  {0, 216, 255},
  {0, 217, 255},
  {0, 218, 255},
  {0, 219, 255},
  {0, 220, 255},
  {0, 221, 255},
  {0, 222, 255},
  {0, 223, 255},
  {0, 224, 255},
  {0, 225, 255},
  {0, 226, 255},
  {0, 227, 255},
  {0, 228, 255},
  {0, 229, 255},
  {0, 230, 255},
  {0, 231, 255},
  {0, 232, 255},
  {0, 233, 255},
  {0, 234, 255},
  {0, 235, 255},
  {0, 236, 255},
  {0, 237, 255},
  {0, 238, 255},
  {0, 239, 255},
  {0, 240, 255},
  {0, 241, 255},
  {0, 242, 255},
  {0, 243, 255},
  {0, 244, 255},
  {0, 245, 255},
  {0, 246, 255},
  {0, 247, 255},
  {0, 248, 255},
  {0, 249, 255},
  {0, 250, 255},
  {0, 251, 255},
  {0, 252, 255},
  {0, 253, 255},
  {0, 254, 255},
  {0, 255, 255},
  {0, 255, 254},
  {0, 255, 253},
  {0, 255, 252},
  {0, 255, 251},
  {0, 255, 250},
  {0, 255, 249},
  {0, 255, 248},
  {0, 255, 247},
  {0, 255, 246},
  {0, 255, 245},
  {0, 255, 244},
  {0, 255, 243},
  {0, 255, 242},
  {0, 255, 241},
  {0, 255, 240},
  {0, 255, 239},
  {0, 255, 238},
  {0, 255, 237},
  {0, 255, 236},
  {0, 255, 235},
  {0, 255, 234},
  {0, 255, 233},
  {0, 255, 232},
  {0, 255, 231},
  {0, 255, 230},
  {0, 255, 229},
  {0, 255, 228},
  {0, 255, 227},
  {0, 255, 226},
  {0, 255, 225},
  {0, 255, 224},
  {0, 255, 223},
  {0, 255, 222},
  {0, 255, 221},
  {0, 255, 220},
  {0, 255, 219},
  {0, 255, 218},
  {0, 255, 217},
  {0, 255, 216},
  {0, 255, 215},
  {0, 255, 214},
  {0, 255, 213},
  {0, 255, 212},
  {0, 255, 211},
  {0, 255, 210},
  {0, 255, 209},
  {0, 255, 208},
  {0, 255, 207},
  {0, 255, 206},
  {0, 255, 205},
  {0, 255, 204},
  {0, 255, 203},
  {0, 255, 202},
  {0, 255, 201},
  {0, 255, 200},
  {0, 255, 199},
  {0, 255, 198},
  {0, 255, 197},
  {0, 255, 196},
  {0, 255, 195},
  {0, 255, 194},
  {0, 255, 193},
  {0, 255, 192},
  {0, 255, 191},
  {0, 255, 190},
  {0, 255, 189},
  {0, 255, 188},
  {0, 255, 187},
  {0, 255, 186},
  {0, 255, 185},
  {0, 255, 184},
  {0, 255, 183},
  {0, 255, 182},
  {0, 255, 181},
  {0, 255, 180},
  {0, 255, 179},
  {0, 255, 178},
  {0, 255, 177},
  {0, 255, 176},
  {0, 255, 175},
  {0, 255, 174},
  {0, 255, 173},
  {0, 255, 172},
  {0, 255, 171},
  {0, 255, 170},
  {0, 255, 169},
  {0, 255, 168},
  {0, 255, 167},
  {0, 255, 166},
  {0, 255, 165},
  {0, 255, 164},
  {0, 255, 163},
  {0, 255, 162},
  {0, 255, 161},
  {0, 255, 160},
  {0, 255, 159},
  {0, 255, 158},
  {0, 255, 157},
  {0, 255, 156},
  {0, 255, 155},
  {0, 255, 154},
  {0, 255, 153},
  {0, 255, 152},
  {0, 255, 151},
  {0, 255, 150},
  {0, 255, 149},
  {0, 255, 148},
  {0, 255, 147},
  {0, 255, 146},
  {0, 255, 145},
  {0, 255, 144},
  {0, 255, 143},
  {0, 255, 142},
  {0, 255, 141},
  {0, 255, 140},
  {0, 255, 139},
  {0, 255, 138},
  {0, 255, 137},
  {0, 255, 136},
  {0, 255, 135},
  {0, 255, 134},
  {0, 255, 133},
  {0, 255, 132},
  {0, 255, 131},
  {0, 255, 130},
  {0, 255, 129},
  {0, 255, 128},
  {0, 255, 127},
  {0, 255, 126},
  {0, 255, 125},
  {0, 255, 124},
  {0, 255, 123},
  {0, 255, 122},
  {0, 255, 121},
  {0, 255, 120},
  {0, 255, 119},
  {0, 255, 118},
  {0, 255, 117},
  {0, 255, 116},
  {0, 255, 115},
  {0, 255, 114},
  {0, 255, 113},
  {0, 255, 112},
  {0, 255, 111},
  {0, 255, 110},
  {0, 255, 109},
  {0, 255, 108},
  {0, 255, 107},
  {0, 255, 106},
  {0, 255, 105},
  {0, 255, 104},
  {0, 255, 103},
  {0, 255, 102},
  {0, 255, 101},
  {0, 255, 100},
  {0, 255, 99},
  {0, 255, 98},
  {0, 255, 97},
  {0, 255, 96},
  {0, 255, 95},
  {0, 255, 94},
  {0, 255, 93},
  {0, 255, 92},
  {0, 255, 91},
  {0, 255, 90},
  {0, 255, 89},
  {0, 255, 88},
  {0, 255, 87},
  {0, 255, 86},
  {0, 255, 85},
  {0, 255, 84},
  {0, 255, 83},
  {0, 255, 82},
  {0, 255, 81},
  {0, 255, 80},
  {0, 255, 79},
  {0, 255, 78},
  {0, 255, 77},
  {0, 255, 76},
  {0, 255, 75},
  {0, 255, 74},
  {0, 255, 73},
  {0, 255, 72},
  {0, 255, 71},
  {0, 255, 70},
  {0, 255, 69},
  {0, 255, 68},
  {0, 255, 67},
  {0, 255, 66},
  {0, 255, 65},
  {0, 255, 64},
  {0, 255, 63},
  {0, 255, 62},
  {0, 255, 61},
  {0, 255, 60},
  {0, 255, 59},
  {0, 255, 58},
  {0, 255, 57},
  {0, 255, 56},
  {0, 255, 55},
  {0, 255, 54},
  {0, 255, 53},
  {0, 255, 52},
  {0, 255, 51},
  {0, 255, 50},
  {0, 255, 49},
  {0, 255, 48},
  {0, 255, 47},
  {0, 255, 46},
  {0, 255, 45},
  {0, 255, 44},
  {0, 255, 43},
  {0, 255, 42},
  {0, 255, 41},
  {0, 255, 40},
  {0, 255, 39},
  {0, 255, 38},
  {0, 255, 37},
  {0, 255, 36},
  {0, 255, 35},
  {0, 255, 34},
  {0, 255, 33},
  {0, 255, 32},
  {0, 255, 31},
  {0, 255, 30},
  {0, 255, 29},
  {0, 255, 28},
  {0, 255, 27},
  {0, 255, 26},
  {0, 255, 25},
  {0, 255, 24},
  {0, 255, 23},
  {0, 255, 22},
  {0, 255, 21},
  {0, 255, 20},
  {0, 255, 19},
  {0, 255, 18},
  {0, 255, 17},
  {0, 255, 16},
  {0, 255, 15},
  {0, 255, 14},
  {0, 255, 13},
  {0, 255, 12},
  {0, 255, 11},
  {0, 255, 10},
  {0, 255, 9},
  {0, 255, 8},
  {0, 255, 7},
  {0, 255, 6},
  {0, 255, 5},
  {0, 255, 4},
  {0, 255, 3},
  {0, 255, 2},
  {0, 255, 1},
  {0, 255, 0},
  {1, 255, 0},
  {2, 255, 0},
  {3, 255, 0},
  {4, 255, 0},
  {5, 255, 0},
  {6, 255, 0},
  {7, 255, 0},
  {8, 255, 0},
  {9, 255, 0},
  {10, 255, 0},
  {11, 255, 0},
  {12, 255, 0},
  {13, 255, 0},
  {14, 255, 0},
  {15, 255, 0},
  {16, 255, 0},
  {17, 255, 0},
  {18, 255, 0},
  {19, 255, 0},
  {20, 255, 0},
  {21, 255, 0},
  {22, 255, 0},
  {23, 255, 0},
  {24, 255, 0},
  {25, 255, 0},
  {26, 255, 0},
  {27, 255, 0},
  {28, 255, 0},
  {29, 255, 0},
  {30, 255, 0},
  {31, 255, 0},
  {32, 255, 0},
  {33, 255, 0},
  {34, 255, 0},
  {35, 255, 0},
  {36, 255, 0},
  {37, 255, 0},
  {38, 255, 0},
  {39, 255, 0},
  {40, 255, 0},
  {41, 255, 0},
  {42, 255, 0},
  {43, 255, 0},
  {44, 255, 0},
  {45, 255, 0},
  {46, 255, 0},
  {47, 255, 0},
  {48, 255, 0},
  {49, 255, 0},
  {50, 255, 0},
  {51, 255, 0},
  {52, 255, 0},
  {53, 255, 0},
  {54, 255, 0},
  {55, 255, 0},
  {56, 255, 0},
  {57, 255, 0},
  {58, 255, 0},
  {59, 255, 0},
  {60, 255, 0},
  {61, 255, 0},
  {62, 255, 0},
  {63, 255, 0},
  {64, 255, 0},
  {65, 255, 0},
  {66, 255, 0},
  {67, 255, 0},
  {68, 255, 0},
  {69, 255, 0},
  {70, 255, 0},
  {71, 255, 0},
  {72, 255, 0},
  {73, 255, 0},
  {74, 255, 0},
  {75, 255, 0},
  {76, 255, 0},
  {77, 255, 0},
  {78, 255, 0},
  {79, 255, 0},
  {80, 255, 0},
  {81, 255, 0},
  {82, 255, 0},
  {83, 255, 0},
  {84, 255, 0},
  {85, 255, 0},
  {86, 255, 0},
  {87, 255, 0},
  {88, 255, 0},
  {89, 255, 0},
  {90, 255, 0},
  {91, 255, 0},
  {92, 255, 0},
  {93, 255, 0},
  {94, 255, 0},
  {95, 255, 0},
  {96, 255, 0},
  {97, 255, 0},
  {98, 255, 0},
  {99, 255, 0},
  {100, 255, 0},
  {101, 255, 0},
  {102, 255, 0},
  {103, 255, 0},
  {104, 255, 0},
  {105, 255, 0},
  {106, 255, 0},
  {107, 255, 0},
  {108, 255, 0},
  {109, 255, 0},
  {110, 255, 0},
  {111, 255, 0},
  {112, 255, 0},
  {113, 255, 0},
  {114, 255, 0},
  {115, 255, 0},
  {116, 255, 0},
  {117, 255, 0},
  {118, 255, 0},
  {119, 255, 0},
  {120, 255, 0},
  {121, 255, 0},
  {122, 255, 0},
  {123, 255, 0},
  {124, 255, 0},
  {125, 255, 0},
  {126, 255, 0},
  {127, 255, 0},
  {128, 255, 0},
  {129, 255, 0},
  {130, 255, 0},
  {131, 255, 0},
  {132, 255, 0},
  {133, 255, 0},
  {134, 255, 0},
  {135, 255, 0},
  {136, 255, 0},
  {137, 255, 0},
  {138, 255, 0},
  {139, 255, 0},
  {140, 255, 0},
  {141, 255, 0},
  {142, 255, 0},
  {143, 255, 0},
  {144, 255, 0},
  {145, 255, 0},
  {146, 255, 0},
  {147, 255, 0},
  {148, 255, 0},
  {149, 255, 0},
  {150, 255, 0},
  {151, 255, 0},
  {152, 255, 0},
  {153, 255, 0},
  {154, 255, 0},
  {155, 255, 0},
  {156, 255, 0},
  {157, 255, 0},
  {158, 255, 0},
  {159, 255, 0},
  {160, 255, 0},
  {161, 255, 0},
  {162, 255, 0},
  {163, 255, 0},
  {164, 255, 0},
  {165, 255, 0},
  {166, 255, 0},
  {167, 255, 0},
  {168, 255, 0},
  {169, 255, 0},
  {170, 255, 0},
  {171, 255, 0},
  {172, 255, 0},
  {173, 255, 0},
  {174, 255, 0},
  {175, 255, 0},
  {176, 255, 0},
  {177, 255, 0},
  {178, 255, 0},
  {179, 255, 0},
  {180, 255, 0},
  {181, 255, 0},
  {182, 255, 0},
  {183, 255, 0},
  {184, 255, 0},
  {185, 255, 0},
  {186, 255, 0},
  {187, 255, 0},
  {188, 255, 0},
  {189, 255, 0},
  {190, 255, 0},
  {191, 255, 0},
  {192, 255, 0},
  {193, 255, 0},
  {194, 255, 0},
  {195, 255, 0},
  {196, 255, 0},
  {197, 255, 0},
  {198, 255, 0},
  {199, 255, 0},
  {200, 255, 0},
  {201, 255, 0},
  {202, 255, 0},
  {203, 255, 0},
  {204, 255, 0},
  {205, 255, 0},
  {206, 255, 0},
  {207, 255, 0},
  {208, 255, 0},
  {209, 255, 0},
  {210, 255, 0},
  {211, 255, 0},
  {212, 255, 0},
  {213, 255, 0},
  {214, 255, 0},
  {215, 255, 0},
  {216, 255, 0},
  {217, 255, 0},
  {218, 255, 0},
  {219, 255, 0},
  {220, 255, 0},
  {221, 255, 0},
  {222, 255, 0},
  {223, 255, 0},
  {224, 255, 0},
  {225, 255, 0},
  {226, 255, 0},
  {227, 255, 0},
  {228, 255, 0},
  {229, 255, 0},
  {230, 255, 0},
  {231, 255, 0},
  {232, 255, 0},
  {233, 255, 0},
  {234, 255, 0},
  {235, 255, 0},
  {236, 255, 0},
  {237, 255, 0},
  {238, 255, 0},
  {239, 255, 0},
  {240, 255, 0},
  {241, 255, 0},
  {242, 255, 0},
  {243, 255, 0},
  {244, 255, 0},
  {245, 255, 0},
  {246, 255, 0},
  {247, 255, 0},
  {248, 255, 0},
  {249, 255, 0},
  {250, 255, 0},
  {251, 255, 0},
  {252, 255, 0},
  {253, 255, 0},
  {254, 255, 0},
  {255, 255, 0},
  {255, 254, 0},
  {255, 253, 0},
  {255, 252, 0},
  {255, 251, 0},
  {255, 250, 0},
  {255, 249, 0},
  {255, 248, 0},
  {255, 247, 0},
  {255, 246, 0},
  {255, 245, 0},
  {255, 244, 0},
  {255, 243, 0},
  {255, 242, 0},
  {255, 241, 0},
  {255, 240, 0},
  {255, 239, 0},
  {255, 238, 0},
  {255, 237, 0},
  {255, 236, 0},
  {255, 235, 0},
  {255, 234, 0},
  {255, 233, 0},
  {255, 232, 0},
  {255, 231, 0},
  {255, 230, 0},
  {255, 229, 0},
  {255, 228, 0},
  {255, 227, 0},
  {255, 226, 0},
  {255, 225, 0},
  {255, 224, 0},
  {255, 223, 0},
  {255, 222, 0},
  {255, 221, 0},
  {255, 220, 0},
  {255, 219, 0},
  {255, 218, 0},
  {255, 217, 0},
  {255, 216, 0},
  {255, 215, 0},
  {255, 214, 0},
  {255, 213, 0},
  {255, 212, 0},
  {255, 211, 0},
  {255, 210, 0},
  {255, 209, 0},
  {255, 208, 0},
  {255, 207, 0},
  {255, 206, 0},
  {255, 205, 0},
  {255, 204, 0},
  {255, 203, 0},
  {255, 202, 0},
  {255, 201, 0},
  {255, 200, 0},
  {255, 199, 0},
  {255, 198, 0},
  {255, 197, 0},
  {255, 196, 0},
  {255, 195, 0},
  {255, 194, 0},
  {255, 193, 0},
  {255, 192, 0},
  {255, 191, 0},
  {255, 190, 0},
  {255, 189, 0},
  {255, 188, 0},
  {255, 187, 0},
  {255, 186, 0},
  {255, 185, 0},
  {255, 184, 0},
  {255, 183, 0},
  {255, 182, 0},
  {255, 181, 0},
  {255, 180, 0},
  {255, 179, 0},
  {255, 178, 0},
  {255, 177, 0},
  {255, 176, 0},
  {255, 175, 0},
  {255, 174, 0},
  {255, 173, 0},
  {255, 172, 0},
  {255, 171, 0},
  {255, 170, 0},
  {255, 169, 0},
  {255, 168, 0},
  {255, 167, 0},
  {255, 166, 0},
  {255, 165, 0},
  {255, 164, 0},
  {255, 163, 0},
  {255, 162, 0},
  {255, 161, 0},
  {255, 160, 0},
  {255, 159, 0},
  {255, 158, 0},
  {255, 157, 0},
  {255, 156, 0},
  {255, 155, 0},
  {255, 154, 0},
  {255, 153, 0},
  {255, 152, 0},
  {255, 151, 0},
  {255, 150, 0},
  {255, 149, 0},
  {255, 148, 0},
  {255, 147, 0},
  {255, 146, 0},
  {255, 145, 0},
  {255, 144, 0},
  {255, 143, 0},
  {255, 142, 0},
  {255, 141, 0},
  {255, 140, 0},
  {255, 139, 0},
  {255, 138, 0},
  {255, 137, 0},
  {255, 136, 0},
  {255, 135, 0},
  {255, 134, 0},
  {255, 133, 0},
  {255, 132, 0},
  {255, 131, 0},
  {255, 130, 0},
  {255, 129, 0},
  {255, 128, 0},
  {255, 127, 0},
  {255, 126, 0},
  {255, 125, 0},
  {255, 124, 0},
  {255, 123, 0},
  {255, 122, 0},
  {255, 121, 0},
  {255, 120, 0},
  {255, 119, 0},
  {255, 118, 0},
  {255, 117, 0},
  {255, 116, 0},
  {255, 115, 0},
  {255, 114, 0},
  {255, 113, 0},
  {255, 112, 0},
  {255, 111, 0},
  {255, 110, 0},
  {255, 109, 0},
  {255, 108, 0},
  {255, 107, 0},
  {255, 106, 0},
  {255, 105, 0},
  {255, 104, 0},
  {255, 103, 0},
  {255, 102, 0},
  {255, 101, 0},
  {255, 100, 0},
  {255, 99, 0},
  {255, 98, 0},
  {255, 97, 0},
  {255, 96, 0},
  {255, 95, 0},
  {255, 94, 0},
  {255, 93, 0},
  {255, 92, 0},
  {255, 91, 0},
  {255, 90, 0},
  {255, 89, 0},
  {255, 88, 0},
  {255, 87, 0},
  {255, 86, 0},
  {255, 85, 0},
  {255, 84, 0},
  {255, 83, 0},
  {255, 82, 0},
  {255, 81, 0},
  {255, 80, 0},
  {255, 79, 0},
  {255, 78, 0},
  {255, 77, 0},
  {255, 76, 0},
  {255, 75, 0},
  {255, 74, 0},
  {255, 73, 0},
  {255, 72, 0},
  {255, 71, 0},
  {255, 70, 0},
  {255, 69, 0},
  {255, 68, 0},
  {255, 67, 0},
  {255, 66, 0},
  {255, 65, 0},
  {255, 64, 0},
  {255, 63, 0},
  {255, 62, 0},
  {255, 61, 0},
  {255, 60, 0},
  {255, 59, 0},
  {255, 58, 0},
  {255, 57, 0},
  {255, 56, 0},
  {255, 55, 0},
  {255, 54, 0},
  {255, 53, 0},
  {255, 52, 0},
  {255, 51, 0},
  {255, 50, 0},
  {255, 49, 0},
  {255, 48, 0},
  {255, 47, 0},
  {255, 46, 0},
  {255, 45, 0},
  {255, 44, 0},
  {255, 43, 0},
  {255, 42, 0},
  {255, 41, 0},
  {255, 40, 0},
  {255, 39, 0},
  {255, 38, 0},
  {255, 37, 0},
  {255, 36, 0},
  {255, 35, 0},
  {255, 34, 0},
  {255, 33, 0},
  {255, 32, 0},
  {255, 31, 0},
  {255, 30, 0},
  {255, 29, 0},
  {255, 28, 0},
  {255, 27, 0},
  {255, 26, 0},
  {255, 25, 0},
  {255, 24, 0},
  {255, 23, 0},
  {255, 22, 0},
  {255, 21, 0},
  {255, 20, 0},
  {255, 19, 0},
  {255, 18, 0},
  {255, 17, 0},
  {255, 16, 0},
  {255, 15, 0},
  {255, 14, 0},
  {255, 13, 0},
  {255, 12, 0},
  {255, 11, 0},
  {255, 10, 0},
  {255, 9, 0},
  {255, 8, 0},
  {255, 7, 0},
  {255, 6, 0},
  {255, 5, 0},
  {255, 4, 0},
  {255, 3, 0},
  {255, 2, 0},
  {255, 1, 0},
  {255, 0, 0}
};

static const int EosACount = 256;
static const QString EosAName = "EOS-A";
static unsigned char EosA[257][3] = {
  {0, 0, 0},
  {0, 0, 0},
  {0, 0, 0},
  {127, 127, 127},
  {123, 0, 193},
  {119, 0, 195},
  {114, 0, 197},
  {110, 0, 199},
  {106, 0, 201},
  {102, 0, 204},
  {97, 0, 206},
  {84, 0, 187},
  {80, 0, 189},
  {76, 0, 191},
  {80, 0, 214},
  {76, 0, 216},
  {72, 0, 218},
  {67, 0, 221},
  {63, 0, 223},
  {59, 0, 225},
  {55, 0, 227},
  {45, 0, 206},
  {42, 0, 208},
  {38, 0, 210},
  {38, 0, 235},
  {33, 0, 238},
  {29, 0, 240},
  {25, 0, 242},
  {21, 0, 244},
  {16, 0, 246},
  {12, 0, 248},
  {7, 0, 225},
  {3, 0, 227},
  {0, 0, 229},
  {0, 17, 255},
  {0, 34, 255},
  {0, 51, 255},
  {0, 68, 255},
  {0, 85, 255},
  {0, 102, 255},
  {0, 119, 255},
  {0, 122, 229},
  {0, 137, 229},
  {0, 153, 229},
  {0, 187, 255},
  {0, 204, 255},
  {0, 221, 255},
  {0, 238, 255},
  {0, 255, 255},
  {0, 255, 238},
  {0, 255, 221},
  {0, 229, 183},
  {0, 229, 168},
  {0, 229, 152},
  {0, 255, 153},
  {0, 255, 135},
  {0, 255, 118},
  {0, 255, 101},
  {0, 255, 84},
  {0, 255, 67},
  {0, 255, 50},
  {0, 229, 30},
  {0, 229, 15},
  {0, 229, 0},
  {8, 255, 0},
  {17, 255, 0},
  {25, 255, 0},
  {34, 255, 0},
  {42, 255, 0},
  {51, 255, 0},
  {59, 255, 0},
  {61, 229, 0},
  {68, 229, 0},
  {76, 229, 0},
  {93, 255, 0},
  {102, 255, 0},
  {110, 255, 0},
  {119, 255, 0},
  {127, 255, 0},
  {136, 255, 0},
  {144, 255, 0},
  {137, 229, 0},
  {145, 229, 0},
  {153, 229, 0},
  {178, 255, 0},
  {187, 255, 0},
  {195, 255, 0},
  {204, 255, 0},
  {212, 255, 0},
  {221, 255, 0},
  {229, 255, 0},
  {214, 229, 0},
  {221, 229, 0},
  {229, 229, 0},
  {255, 250, 0},
  {255, 246, 0},
  {255, 242, 0},
  {255, 238, 0},
  {255, 233, 0},
  {255, 229, 0},
  {255, 225, 0},
  {229, 198, 0},
  {229, 195, 0},
  {229, 191, 0},
  {255, 208, 0},
  {255, 204, 0},
  {255, 199, 0},
  {255, 195, 0},
  {255, 191, 0},
  {255, 187, 0},
  {255, 182, 0},
  {229, 160, 0},
  {229, 156, 0},
  {229, 152, 0},
  {255, 165, 0},
  {255, 161, 0},
  {255, 157, 0},
  {255, 153, 0},
  {255, 148, 0},
  {255, 144, 0},
  {255, 140, 0},
  {229, 122, 0},
  {229, 118, 0},
  {229, 114, 0},
  {255, 125, 0},
  {255, 123, 0},
  {255, 121, 0},
  {255, 119, 0},
  {255, 116, 0},
  {255, 114, 0},
  {255, 112, 0},
  {229, 99, 0},
  {229, 97, 0},
  {229, 95, 0},
  {255, 104, 0},
  {255, 102, 0},
  {255, 99, 0},
  {255, 97, 0},
  {255, 95, 0},
  {255, 93, 0},
  {255, 91, 0},
  {229, 80, 0},
  {229, 78, 0},
  {229, 76, 0},
  {255, 82, 0},
  {255, 80, 0},
  {255, 78, 0},
  {255, 76, 0},
  {255, 74, 0},
  {255, 72, 0},
  {255, 70, 0},
  {229, 61, 0},
  {229, 59, 0},
  {229, 57, 0},
  {255, 61, 0},
  {255, 59, 0},
  {255, 57, 0},
  {255, 55, 0},
  {255, 53, 0},
  {255, 50, 0},
  {255, 48, 0},
  {229, 42, 0},
  {229, 40, 0},
  {229, 38, 0},
  {255, 40, 0},
  {255, 38, 0},
  {255, 36, 0},
  {255, 33, 0},
  {255, 31, 0},
  {255, 29, 0},
  {255, 27, 0},
  {229, 22, 0},
  {229, 21, 0},
  {229, 19, 0},
  {255, 19, 0},
  {255, 16, 0},
  {255, 14, 0},
  {255, 12, 0},
  {255, 13, 0},
  {255, 8, 0},
  {255, 6, 0},
  {229, 3, 0},
  {229, 1, 0},
  {229, 0, 0},
  {253, 0, 0},
  {251, 0, 0},
  {249, 0, 0},
  {248, 0, 0},
  {246, 0, 0},
  {244, 0, 0},
  {242, 0, 0},
  {217, 0, 0},
  {215, 0, 0},
  {213, 0, 0},
  {236, 0, 0},
  {234, 0, 0},
  {232, 0, 0},
  {230, 0, 0},
  {229, 0, 0},
  {227, 0, 0},
  {225, 0, 0},
  {201, 0, 0},
  {200, 0, 0},
  {198, 0, 0},
  {218, 0, 0},
  {217, 0, 0},
  {215, 0, 0},
  {213, 0, 0},
  {211, 0, 0},
  {210, 0, 0},
  {208, 0, 0},
  {186, 0, 0},
  {184, 0, 0},
  {182, 0, 0},
  {201, 0, 0},
  {199, 0, 0},
  {198, 0, 0},
  {196, 0, 0},
  {194, 0, 0},
  {192, 0, 0},
  {191, 0, 0},
  {170, 0, 0},
  {169, 0, 0},
  {167, 0, 0},
  {184, 0, 0},
  {182, 0, 0},
  {180, 0, 0},
  {179, 0, 0},
  {177, 0, 0},
  {175, 0, 0},
  {174, 0, 0},
  {155, 0, 0},
  {153, 0, 0},
  {151, 0, 0},
  {167, 0, 0},
  {165, 0, 0},
  {163, 0, 0},
  {161, 0, 0},
  {160, 0, 0},
  {158, 0, 0},
  {156, 0, 0},
  {139, 0, 0},
  {138, 0, 0},
  {136, 0, 0},
  {149, 0, 0},
  {148, 0, 0},
  {146, 0, 0},
  {144, 0, 0},
  {143, 0, 0},
  {141, 0, 0},
  {139, 0, 0},
  {124, 0, 0},
  {122, 0, 0},
  {120, 0, 0},
  {132, 0, 0},
  {130, 0, 0},
  {130, 0, 0}
};

static const int EosBCount = 256;
static const QString EosBName = "EOS-B";
static unsigned char EosB[257][3] = {
  {0, 0, 0},
  {255, 255, 255},
  {255, 255, 255},
  {127, 127, 127},
  {0, 0, 131},
  {0, 0, 136},
  {0, 0, 140},
  {0, 0, 144},
  {0, 0, 148},
  {0, 0, 153},
  {0, 0, 157},
  {0, 0, 145},
  {0, 0, 149},
  {0, 0, 170},
  {0, 0, 174},
  {0, 0, 178},
  {0, 0, 182},
  {0, 0, 187},
  {0, 0, 191},
  {0, 0, 195},
  {0, 0, 199},
  {0, 0, 183},
  {0, 0, 187},
  {0, 0, 212},
  {0, 0, 216},
  {0, 0, 221},
  {0, 0, 225},
  {0, 0, 229},
  {0, 0, 233},
  {0, 0, 238},
  {0, 0, 242},
  {0, 0, 221},
  {0, 0, 225},
  {0, 0, 255},
  {0, 7, 247},
  {0, 15, 239},
  {0, 23, 231},
  {0, 31, 223},
  {0, 39, 215},
  {0, 47, 207},
  {0, 55, 199},
  {0, 57, 172},
  {0, 64, 164},
  {0, 79, 175},
  {0, 87, 167},
  {0, 95, 159},
  {0, 103, 151},
  {0, 111, 143},
  {0, 119, 135},
  {0, 127, 127},
  {0, 135, 119},
  {0, 129, 100},
  {0, 136, 93},
  {0, 159, 95},
  {0, 167, 87},
  {0, 175, 79},
  {0, 183, 71},
  {0, 191, 63},
  {0, 199, 55},
  {0, 207, 47},
  {0, 215, 39},
  {0, 200, 28},
  {0, 207, 21},
  {0, 239, 15},
  {0, 247, 7},
  {0, 255, 0},
  {9, 255, 0},
  {18, 255, 0},
  {27, 255, 0},
  {36, 255, 0},
  {45, 255, 0},
  {49, 229, 0},
  {57, 229, 0},
  {72, 255, 0},
  {81, 255, 0},
  {91, 255, 0},
  {100, 255, 0},
  {109, 255, 0},
  {118, 255, 0},
  {127, 255, 0},
  {136, 255, 0},
  {131, 229, 0},
  {139, 229, 0},
  {163, 255, 0},
  {173, 255, 0},
  {182, 255, 0},
  {191, 255, 0},
  {200, 255, 0},
  {209, 255, 0},
  {218, 255, 0},
  {227, 255, 0},
  {213, 229, 0},
  {221, 229, 0},
  {255, 255, 0},
  {255, 250, 0},
  {255, 246, 0},
  {255, 242, 0},
  {255, 238, 0},
  {255, 233, 0},
  {255, 229, 0},
  {255, 225, 0},
  {229, 198, 0},
  {229, 195, 0},
  {255, 212, 0},
  {255, 208, 0},
  {255, 204, 0},
  {255, 199, 0},
  {255, 195, 0},
  {255, 191, 0},
  {255, 187, 0},
  {255, 182, 0},
  {229, 160, 0},
  {229, 156, 0},
  {255, 169, 0},
  {255, 165, 0},
  {255, 161, 0},
  {255, 157, 0},
  {255, 153, 0},
  {255, 148, 0},
  {255, 144, 0},
  {255, 140, 0},
  {229, 122, 0},
  {229, 118, 0},
  {255, 127, 0},
  {255, 125, 0},
  {255, 123, 0},
  {255, 121, 0},
  {255, 119, 0},
  {255, 116, 0},
  {255, 114, 0},
  {255, 112, 0},
  {229, 99, 0},
  {229, 97, 0},
  {255, 106, 0},
  {255, 104, 0},
  {255, 102, 0},
  {255, 99, 0},
  {255, 97, 0},
  {255, 95, 0},
  {255, 93, 0},
  {255, 91, 0},
  {229, 80, 0},
  {229, 78, 0},
  {255, 84, 0},
  {255, 82, 0},
  {255, 80, 0},
  {255, 78, 0},
  {255, 76, 0},
  {255, 74, 0},
  {255, 72, 0},
  {255, 70, 0},
  {229, 61, 0},
  {229, 59, 0},
  {255, 63, 0},
  {255, 61, 0},
  {255, 59, 0},
  {255, 57, 0},
  {255, 55, 0},
  {255, 53, 0},
  {255, 50, 0},
  {255, 48, 0},
  {229, 42, 0},
  {229, 40, 0},
  {255, 42, 0},
  {255, 40, 0},
  {255, 38, 0},
  {255, 36, 0},
  {255, 33, 0},
  {255, 31, 0},
  {255, 29, 0},
  {255, 27, 0},
  {229, 22, 0},
  {229, 21, 0},
  {255, 21, 0},
  {255, 19, 0},
  {255, 16, 0},
  {255, 14, 0},
  {255, 12, 0},
  {255, 13, 0},
  {255, 8, 0},
  {255, 6, 0},
  {229, 3, 0},
  {229, 1, 0},
  {255, 0, 0},
  {253, 0, 0},
  {251, 0, 0},
  {249, 0, 0},
  {247, 0, 0},
  {245, 0, 0},
  {243, 0, 0},
  {241, 0, 0},
  {215, 0, 0},
  {214, 0, 0},
  {235, 0, 0},
  {234, 0, 0},
  {232, 0, 0},
  {230, 0, 0},
  {228, 0, 0},
  {226, 0, 0},
  {224, 0, 0},
  {222, 0, 0},
  {198, 0, 0},
  {196, 0, 0},
  {216, 0, 0},
  {215, 0, 0},
  {213, 0, 0},
  {211, 0, 0},
  {209, 0, 0},
  {207, 0, 0},
  {205, 0, 0},
  {203, 0, 0},
  {181, 0, 0},
  {179, 0, 0},
  {197, 0, 0},
  {196, 0, 0},
  {194, 0, 0},
  {192, 0, 0},
  {190, 0, 0},
  {188, 0, 0},
  {186, 0, 0},
  {184, 0, 0},
  {164, 0, 0},
  {162, 0, 0},
  {178, 0, 0},
  {176, 0, 0},
  {175, 0, 0},
  {173, 0, 0},
  {171, 0, 0},
  {169, 0, 0},
  {167, 0, 0},
  {165, 0, 0},
  {147, 0, 0},
  {145, 0, 0},
  {159, 0, 0},
  {157, 0, 0},
  {156, 0, 0},
  {154, 0, 0},
  {152, 0, 0},
  {150, 0, 0},
  {148, 0, 0},
  {146, 0, 0},
  {130, 0, 0},
  {128, 0, 0},
  {140, 0, 0},
  {138, 0, 0},
  {137, 0, 0},
  {135, 0, 0},
  {133, 0, 0},
  {131, 0, 0},
  {129, 0, 0},
  {127, 0, 0},
  {113, 0, 0},
  {111, 0, 0},
  {121, 0, 0},
  {119, 0, 0},
  {117, 0, 0},
  {117, 0, 0},
};
}
#endif
